/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AddParticipantDlg
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private TranscriptionImpl transcription;
    private JPanel tierPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton startButton;
    private JLabel titleLabel;
    private JTable tierTable;
    private TierExportTableModel model;
    private JRadioButton selectTierStrucRB;
    private JRadioButton selectParticipantRB;
    private JLabel participantLabel;
    private JTextField participantTextField;
    private JLabel prefixSuffixLabel;
    private JRadioButton prefixRB;
    private JRadioButton suffixRB;
    private JLabel oldValueLabel;
    private JTextField oldValueTextField;
    private JLabel newValueLabel;
    private JTextField newValueTextField;

    public AddParticipantDlg(TranscriptionImpl transcription, Frame frame) {
        super(frame);
        this.transcription = transcription;
        this.initComponents();
        this.extractTiers();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AddParticipantDlg.this.closeDialog(evt);
            }
        });
        this.tierPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.titleLabel = new JLabel();
        this.oldValueLabel = new JLabel();
        this.oldValueTextField = new JTextField();
        this.newValueLabel = new JLabel();
        this.newValueTextField = new JTextField();
        this.participantLabel = new JLabel();
        this.participantTextField = new JTextField();
        this.prefixSuffixLabel = new JLabel();
        this.prefixRB = new JRadioButton();
        this.suffixRB = new JRadioButton();
        this.selectTierStrucRB = new JRadioButton();
        this.selectParticipantRB = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.prefixRB);
        group.add(this.suffixRB);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.selectTierStrucRB);
        group1.add(this.selectParticipantRB);
        this.model = new TierExportTableModel();
        this.model.setColumnCount(2);
        this.tierTable = new JTable(this.model);
        DefaultCellEditor cellEd = new DefaultCellEditor(new JCheckBox());
        this.tierTable.getColumnModel().getColumn(0).setCellEditor(cellEd);
        this.tierTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        JScrollPane tierScroll = new JScrollPane(this.tierTable);
        tierScroll.setPreferredSize(new Dimension(100, 100));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.tierPanel.setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 0;
        panel.add((Component)this.selectTierStrucRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 0;
        panel.add((Component)this.selectParticipantRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 22, 2, 6);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.tierPanel.add((Component)panel, gridBagConstraints);
        Dimension tableDim = new Dimension(50, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.tierPanel.add((Component)tierScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        insets.bottom = 3;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 1.0;
        this.optionsPanel.add((Component)this.participantLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.5;
        this.optionsPanel.add((Component)this.participantTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.prefixSuffixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 30, 4, 6);
        this.optionsPanel.add((Component)this.prefixRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 30, 4, 6);
        this.optionsPanel.add((Component)this.suffixRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.oldValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.oldValueTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.newValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.newValueTextField, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.setDefaultOrPreferredSettings();
        this.selectParticipantRB.addChangeListener(this);
        this.selectTierStrucRB.addChangeListener(this);
        this.selectParticipantRB.addActionListener(this);
        this.selectTierStrucRB.addActionListener(this);
        this.updateLocale();
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setDefaultOrPreferredSettings() {
        Object useTyp = Preferences.get("AddParticipantDlg.prefixRB", null);
        if (useTyp != null) {
            this.prefixRB.setSelected((Boolean)useTyp);
        } else {
            this.prefixRB.setSelected(true);
        }
        useTyp = Preferences.get("AddParticipantDlg.selectTierStrucRB", null);
        if (useTyp != null) {
            this.selectTierStrucRB.setSelected((Boolean)useTyp);
        } else {
            this.selectTierStrucRB.setSelected(true);
        }
        this.suffixRB.setSelected(!this.prefixRB.isSelected());
        this.selectParticipantRB.setSelected(!this.selectTierStrucRB.isSelected());
    }

    private void savePreferredSettings() {
        Preferences.set("AddParticipantDlg.prefixRB", this.prefixRB.isSelected(), null);
        Preferences.set("AddParticipantDlg.selectTierStrucRB", this.selectTierStrucRB.isSelected(), null);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("AddParticipantDlg.Title"));
        this.titleLabel.setText(ElanLocale.getString("AddParticipantDlg.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("AddParticipantDlg.Title.TierTable")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("AddParticipantDlg.Title.Options")));
        this.participantLabel.setText(ElanLocale.getString("AddParticipantDlg.Label.Participant"));
        this.prefixSuffixLabel.setText(ElanLocale.getString("AddParticipantDlg.Label.PrefixSuffix"));
        this.prefixRB.setText(ElanLocale.getString("AddParticipantDlg.RB.Prefix"));
        this.suffixRB.setText(ElanLocale.getString("AddParticipantDlg.RB.Suffix"));
        this.oldValueLabel.setText(ElanLocale.getString("AddParticipantDlg.OldValue"));
        this.newValueLabel.setText(ElanLocale.getString("AddParticipantDlg.NewValue"));
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
        this.selectParticipantRB.setText(ElanLocale.getString("AddParticipantDlg.RB.Participant"));
        this.selectTierStrucRB.setText(ElanLocale.getString("AddParticipantDlg.RB.TierStructure"));
    }

    private void extractTiers() {
        if (this.transcription != null) {
            while (this.tierTable.getRowCount() > 0) {
                this.model.removeRow(0);
            }
            this.startButton.setEnabled(true);
            Vector v = this.transcription.getTiers();
            if (this.selectTierStrucRB.isSelected()) {
                for (int i = 0; i < v.size(); ++i) {
                    Vector dependentTiers;
                    TierImpl t = (TierImpl)v.get(i);
                    if (t.hasParentTier() || (dependentTiers = t.getDependentTiers()) == null || dependentTiers.size() == 0) continue;
                    if (i == 0) {
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
                }
            } else {
                int i;
                ArrayList<String> participants = new ArrayList<String>();
                for (i = 0; i < v.size(); ++i) {
                    TierImpl t = (TierImpl)v.get(i);
                    String partici = t.getParticipant();
                    if (partici == null || partici.trim().length() == 0 || participants.contains(partici)) continue;
                    participants.add(partici);
                }
                if (participants.size() > 0) {
                    for (i = 0; i < participants.size(); ++i) {
                        if (i == 0) {
                            this.model.addRow(new Object[]{Boolean.FALSE, participants.get(i)});
                            continue;
                        }
                        this.model.addRow(new Object[]{Boolean.FALSE, participants.get(i)});
                    }
                } else {
                    this.startButton.setEnabled(false);
                }
            }
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            this.startOperation();
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        } else if (source == this.selectTierStrucRB || source == this.selectParticipantRB) {
            this.extractTiers();
        }
    }

    private List getSelectedTiers() {
        ArrayList<Object> tiers = new ArrayList<Object>();
        Object selObj = null;
        Object nameObj = null;
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            selObj = this.tierTable.getValueAt(i, 0);
            if (selObj != Boolean.TRUE || (nameObj = this.tierTable.getValueAt(i, 1)) == null) continue;
            tiers.add(nameObj);
        }
        return tiers;
    }

    private void startOperation() {
        this.savePreferredSettings();
        List tierNames = null;
        tierNames = this.getSelectedTiers();
        if (tierNames.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("AddParticipantDlg.Warning.NoTier"), ElanLocale.getString("Message.Error"), 2);
            return;
        }
        String participantName = this.participantTextField.getText();
        if (participantName == null || participantName.trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("AddParticipantDlg.Warning.NoParticipant"), ElanLocale.getString("Message.Error"), 2);
            return;
        }
        String newValue = this.newValueTextField.getText();
        if (newValue == null || newValue.trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("AddParticipantDlg.Warning.NewValue"), ElanLocale.getString("Message.Error"), 2);
            return;
        }
        Object[] args = new Object[]{tierNames, participantName, this.oldValueTextField.getText(), newValue, this.prefixRB.isSelected(), this.selectTierStrucRB.isSelected()};
        Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AddParticipant");
        command.execute(this.transcription, args);
    }

    public void stateChanged(ChangeEvent e) {
    }
}

