/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.global.MultiFileAnnotationsFromOverlapsCommand;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.MultiFileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsFromOverlapsDialog
implements ClientLogger {
    private TranscriptionImpl transcription;
    private MultiStepPane multiPane;
    private Insets globalInset;
    private Insets singleTabInset;
    private Insets firstSingleTabInset;
    private Insets doubleTabInset;
    private JFrame parentFrame;
    private JDialog stepDialog;
    private boolean atLastStep;
    private List<TranscriptionImpl> openedFileList;
    private FileTierSelectionPanel step1Panel;
    private OverlapsComputationCriteriaPanel step2Panel;
    private DestinationTierPanel step3Panel;
    private DestinationValuePanel step4Panel;
    private JTable step1TierTable;
    private Set<String> tierSet;
    private JRadioButton currentlyOpenedFileRB;
    private JRadioButton selectedFilesFromDiskRB;
    private JRadioButton filesFromDomainRB;
    private JRadioButton overlapRB;
    private JRadioButton valuesTheSameRB;
    private JRadioButton valuesDifferentRB;
    private JRadioButton valuesMatchConstraintsRB;
    private JTable tierValueTable;
    private JTextField newTierNameField;
    private JRadioButton rootTierRB;
    private JRadioButton childTierRB;
    private JComboBox parentTierCB;
    private JTable linguisticTypeTable;
    private JRadioButton durationRadioButton;
    private JRadioButton specificValueRB;
    private JRadioButton tierValueRadioButton;
    private JRadioButton concatValuesRB;
    private JRadioButton sortByTimeRB;
    private JRadioButton sortBySelectionRB;
    private JRadioButton smpteRB;
    private JRadioButton palRB;
    private JRadioButton ntscRB;
    private JRadioButton msecRB;
    private JRadioButton secRB;
    private JRadioButton hrRB;
    private JTextField specificValueTF;
    private JComboBox tierSelectBox;
    public JTable step4SortTierTable;

    public AnnotationsFromOverlapsDialog(JFrame parentFrame, TranscriptionImpl transcription) {
        this.parentFrame = parentFrame;
        this.transcription = transcription;
        this.atLastStep = false;
        this.globalInset = new Insets(5, 10, 5, 10);
        this.singleTabInset = new Insets(0, 30, 0, 10);
        this.doubleTabInset = new Insets(0, 50, 0, 10);
        this.firstSingleTabInset = new Insets(5, 10, 0, 10);
        if (transcription != null) {
            this.tierSet = new TreeSet<String>();
            Vector tiers = transcription.getTiers();
            for (TierImpl tier : tiers) {
                this.tierSet.add(tier.getName());
            }
        }
        this.multiPane = new MultiStepPane();
        this.step1Panel = new FileTierSelectionPanel(this.multiPane);
        this.step2Panel = new OverlapsComputationCriteriaPanel(this.multiPane);
        this.step3Panel = new DestinationTierPanel(this.multiPane);
        this.step4Panel = new DestinationValuePanel(this.multiPane);
        this.multiPane.addStep(this.step1Panel);
        this.multiPane.addStep(this.step2Panel);
        this.multiPane.addStep(this.step3Panel);
        this.multiPane.addStep(this.step4Panel);
        this.stepDialog = this.multiPane.createDialog(this.parentFrame, ElanLocale.getString("OverlapsDialog.Title"), true);
        this.stepDialog.setPreferredSize(new Dimension(600, 600));
        this.stepDialog.pack();
        this.stepDialog.setVisible(true);
    }

    private List<String> showMultiFileChooser() {
        String dirPath = (String)Preferences.get("LastUsedEAFDir", null);
        if (dirPath == null) {
            dirPath = System.getProperty("user.dir");
        }
        MultiFileChooser multiFileChooser = new MultiFileChooser();
        multiFileChooser.setCurrentDirectory(new File(dirPath));
        multiFileChooser.setDialogTitle(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"));
        multiFileChooser.setFileFilter(ElanFileFilter.createFileFilter(3));
        int returnValue = multiFileChooser.showDialog(this.parentFrame, ElanLocale.getString("Button.OK"));
        if (returnValue == 0) {
            int answer;
            Object[] objects = multiFileChooser.getFiles();
            ArrayList<String> filenames = new ArrayList<String>();
            boolean allFilesExist = true;
            for (int i = 0; i < objects.length; ++i) {
                File file = (File)objects[i];
                if (file.exists()) {
                    filenames.add(file.getAbsolutePath());
                    continue;
                }
                allFilesExist = false;
            }
            if (!allFilesExist && (answer = JOptionPane.showConfirmDialog(this.parentFrame, ElanLocale.getString("OverlapsDialog.Message.NotAllFilesExist"), ElanLocale.getString("OverlapsDialog.Message.NotAllFilesExistTitle"), 0)) != 0) {
                return null;
            }
            if (filenames.isEmpty()) {
                return null;
            }
            Preferences.set("LastUsedEAFDir", new File((String)filenames.get(filenames.size() - 1)).getParent(), null);
            return filenames;
        }
        return null;
    }

    private void executeOverlapsCommand() {
        SelectableContentTableModel model = (SelectableContentTableModel)this.step1TierTable.getModel();
        Vector selectedValues = model.getSelectedValues();
        String[] sourceTiers = new String[selectedValues.size()];
        for (int i = 0; i < selectedValues.size(); ++i) {
            sourceTiers[i] = (String)selectedValues.get(i);
        }
        int overlapsCriteria = 0;
        if (this.overlapRB.isSelected()) {
            overlapsCriteria = 0;
        } else if (this.valuesTheSameRB.isSelected()) {
            overlapsCriteria = 1;
        } else if (this.valuesDifferentRB.isSelected()) {
            overlapsCriteria = 2;
        } else if (this.valuesMatchConstraintsRB.isSelected()) {
            overlapsCriteria = 3;
        }
        ArrayList<String[]> tierValuePairs = new ArrayList<String[]>();
        DisplayableContentTableModel m = (DisplayableContentTableModel)this.tierValueTable.getModel();
        for (int i = 0; i < m.getRowCount(); ++i) {
            tierValuePairs.add(new String[]{(String)m.getValueAt(i, 1), (String)m.getValueAt(i, 3)});
        }
        String destTierName = this.newTierNameField.getText().trim();
        int selectedRow = this.linguisticTypeTable.getSelectedRow();
        String linguisticType = (String)this.linguisticTypeTable.getModel().getValueAt(selectedRow, 0);
        LinguisticType destLingType = this.transcription != null ? this.transcription.getLinguisticTypeByName(linguisticType) : this.openedFileList.get(0).getLinguisticTypeByName(linguisticType);
        if (destLingType == null) {
            LOG.severe("Selected linguistic type can not be identified");
        }
        ArrayList<Object> tierOrder = null;
        int annotationValueType = -1;
        if (this.durationRadioButton.isSelected()) {
            annotationValueType = 0;
        } else if (this.specificValueRB.isSelected()) {
            annotationValueType = 1;
        } else if (this.tierValueRadioButton.isSelected()) {
            annotationValueType = 2;
        } else if (this.concatValuesRB.isSelected()) {
            if (this.sortByTimeRB.isSelected()) {
                annotationValueType = 3;
            } else if (this.sortBySelectionRB.isSelected()) {
                annotationValueType = 4;
                tierOrder = new ArrayList<Object>();
                for (int i = 0; i < this.step4SortTierTable.getRowCount(); ++i) {
                    tierOrder.add(this.step4SortTierTable.getValueAt(i, 0));
                }
            }
        }
        Object parentTier = null;
        String parentTierName = "";
        if (this.childTierRB.isSelected()) {
            parentTierName = (String)this.parentTierCB.getSelectedItem();
        }
        String timeFormat = null;
        boolean usePalFormat = true;
        if (this.msecRB.isSelected()) {
            timeFormat = "ms";
        } else if (this.secRB.isSelected()) {
            timeFormat = "ss.ms";
        } else if (this.hrRB.isSelected()) {
            timeFormat = "hh:mm:ss.ms";
        } else if (this.smpteRB.isSelected() && this.palRB.isSelected()) {
            timeFormat = "hh:mm:ss:ff";
            usePalFormat = true;
        } else if (this.smpteRB.isSelected() && this.ntscRB.isSelected()) {
            timeFormat = "hh:mm:ss:ff";
            usePalFormat = false;
        }
        String annWithValue = this.specificValueTF.getText().trim();
        String annFromTier = this.tierSelectBox.getSelectedItem().toString();
        int transcriptionMode = this.currentlyOpenedFileRB.isSelected() ? 0 : 1;
        Object[] filenames = this.openedFileList != null ? this.openedFileList.toArray() : null;
        Object[] args = new Object[]{sourceTiers, destTierName, destLingType, annotationValueType, timeFormat, annWithValue, annFromTier, tierOrder, overlapsCriteria, tierValuePairs, transcriptionMode, filenames, usePalFormat, parentTierName};
        if (this.transcription != null) {
            Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsFromOverlaps");
            com.execute(this.transcription, args);
        } else {
            MultiFileAnnotationsFromOverlapsCommand command = new MultiFileAnnotationsFromOverlapsCommand();
            command.execute(this.transcription, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OpenFilesThread
    extends Thread {
        private List<String> filenames;
        private JTable tierTable;
        private DisplayableContentTableModel model;
        private ActionListener listener;

        public OpenFilesThread(List<String> filenames, JTable tierTable, ActionListener listener) {
            this.filenames = filenames;
            this.tierTable = tierTable;
            this.listener = listener;
            this.model = new DisplayableContentTableModel(new String[]{ElanLocale.getString("OverlapsDialog.Message4.Part1"), "0 " + ElanLocale.getString("OverlapsDialog.Message4.Part2") + " " + filenames.size() + " " + ElanLocale.getString("OverlapsDialog.Message4.Part3") + " (0%)"});
            this.model.connectTable(this.tierTable);
            this.tierTable.setModel(this.model);
        }

        @Override
        public void run() {
            AnnotationsFromOverlapsDialog.this.tierSet = new TreeSet();
            AnnotationsFromOverlapsDialog.this.openedFileList = new ArrayList();
            AnnotationsFromOverlapsDialog.this.multiPane.setButtonEnabled(2, false);
            AnnotationsFromOverlapsDialog.this.multiPane.setButtonEnabled(1, false);
            for (int i = 0; i < this.filenames.size(); ++i) {
                TranscriptionImpl transImpl = new TranscriptionImpl(this.filenames.get(i));
                AnnotationsFromOverlapsDialog.this.openedFileList.add(transImpl);
                Vector tiersInFile = transImpl.getTiers();
                for (TierImpl tier : tiersInFile) {
                    AnnotationsFromOverlapsDialog.this.tierSet.add(tier.getName());
                }
                this.model.updateMessage(1, i + 1 + " " + ElanLocale.getString("OverlapsDialog.Message4.Part2") + " " + this.filenames.size() + " " + ElanLocale.getString("OverlapsDialog.Message4.Part3") + " (" + Math.round((float)(i + 1) / (float)this.filenames.size() * 100.0f) + "%)");
            }
            if (AnnotationsFromOverlapsDialog.this.tierSet.isEmpty()) {
                AnnotationsFromOverlapsDialog.this.openedFileList.clear();
                DisplayableContentTableModel model = (DisplayableContentTableModel)this.tierTable.getModel();
                model.setValueAt(ElanLocale.getString("OverlapsDialog.Message3"), 0, 0);
            } else {
                SelectableContentTableModel model = new SelectableContentTableModel(AnnotationsFromOverlapsDialog.this.tierSet, this.tierTable);
                model.addActionListener(this.listener);
                this.tierTable.setModel(model);
                this.tierTable.getColumnModel().getColumn(0).setHeaderValue(null);
                this.tierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.TierName"));
                this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
                this.tierTable.repaint();
            }
        }
    }

    private class DestinationValuePanel
    extends StepPane
    implements ActionListener,
    KeyListener,
    ListSelectionListener {
        private JLabel newValueLabel;
        private ButtonGroup valueKindRadioGroup;
        private ButtonGroup concatValueRadioGroup;
        private ButtonGroup timeRadioGroup;
        private ButtonGroup smpteRadioGroup;
        private JPanel tierValuePanel;
        private JScrollPane tierTableScrollPane;
        private JButton moveUpButton;
        private JButton moveDownButton;
        private DefaultTableModel model;

        public DestinationValuePanel(MultiStepPane mp) {
            super(mp);
            this.initComponents();
        }

        protected void initComponents() {
            AnnotationsFromOverlapsDialog.this.durationRadioButton = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.DurationValue"), true);
            AnnotationsFromOverlapsDialog.this.specificValueRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.SpecificValue"));
            AnnotationsFromOverlapsDialog.this.tierValueRadioButton = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.SpecificTier"));
            AnnotationsFromOverlapsDialog.this.concatValuesRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ConcatValues"));
            AnnotationsFromOverlapsDialog.this.sortByTimeRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ConcatValues.SortByAnnotationTime"));
            AnnotationsFromOverlapsDialog.this.sortByTimeRB.setEnabled(false);
            AnnotationsFromOverlapsDialog.this.sortBySelectionRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ConcatValues.SortByTierOrderSelection"));
            AnnotationsFromOverlapsDialog.this.sortBySelectionRB.setEnabled(false);
            this.model = new DefaultTableModel();
            AnnotationsFromOverlapsDialog.this.step4SortTierTable = new JTable(this.model);
            this.model.addColumn(ElanLocale.getString("OverlapsDialog.Column.SelectedTiers"));
            AnnotationsFromOverlapsDialog.this.step4SortTierTable.setSelectionMode(0);
            AnnotationsFromOverlapsDialog.this.step4SortTierTable.getSelectionModel().addListSelectionListener(this);
            this.tierTableScrollPane = new JScrollPane(AnnotationsFromOverlapsDialog.this.step4SortTierTable);
            this.tierTableScrollPane.setSize(200, 100);
            this.tierTableScrollPane.setEnabled(false);
            this.moveUpButton = new JButton();
            this.moveDownButton = new JButton();
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            this.moveUpButton.addActionListener(this);
            this.moveDownButton.addActionListener(this);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            try {
                ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
                ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
                this.moveUpButton.setIcon(upIcon);
                this.moveDownButton.setIcon(downIcon);
            }
            catch (Exception ex) {
                this.moveUpButton.setText("Up");
                this.moveDownButton.setText("Down");
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            buttonPanel.add((Component)this.moveUpButton, gbc);
            gbc.gridx = 1;
            buttonPanel.add((Component)this.moveDownButton, gbc);
            this.concatValueRadioGroup = new ButtonGroup();
            this.concatValueRadioGroup.add(AnnotationsFromOverlapsDialog.this.sortByTimeRB);
            this.concatValueRadioGroup.add(AnnotationsFromOverlapsDialog.this.sortBySelectionRB);
            this.valueKindRadioGroup = new ButtonGroup();
            this.valueKindRadioGroup.add(AnnotationsFromOverlapsDialog.this.durationRadioButton);
            this.valueKindRadioGroup.add(AnnotationsFromOverlapsDialog.this.tierValueRadioButton);
            this.valueKindRadioGroup.add(AnnotationsFromOverlapsDialog.this.specificValueRB);
            this.valueKindRadioGroup.add(AnnotationsFromOverlapsDialog.this.concatValuesRB);
            AnnotationsFromOverlapsDialog.this.durationRadioButton.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.specificValueRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.tierValueRadioButton.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.concatValuesRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.sortBySelectionRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.sortByTimeRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.msecRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.MilliSec"), true);
            AnnotationsFromOverlapsDialog.this.secRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.Seconds"));
            AnnotationsFromOverlapsDialog.this.hrRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode"));
            AnnotationsFromOverlapsDialog.this.smpteRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE"));
            AnnotationsFromOverlapsDialog.this.palRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL"), true);
            AnnotationsFromOverlapsDialog.this.ntscRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC"));
            AnnotationsFromOverlapsDialog.this.msecRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.secRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.hrRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.smpteRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.palRB.setEnabled(false);
            AnnotationsFromOverlapsDialog.this.ntscRB.setEnabled(false);
            this.timeRadioGroup = new ButtonGroup();
            this.timeRadioGroup.add(AnnotationsFromOverlapsDialog.this.msecRB);
            this.timeRadioGroup.add(AnnotationsFromOverlapsDialog.this.secRB);
            this.timeRadioGroup.add(AnnotationsFromOverlapsDialog.this.hrRB);
            this.timeRadioGroup.add(AnnotationsFromOverlapsDialog.this.smpteRB);
            this.smpteRadioGroup = new ButtonGroup();
            this.smpteRadioGroup.add(AnnotationsFromOverlapsDialog.this.palRB);
            this.smpteRadioGroup.add(AnnotationsFromOverlapsDialog.this.ntscRB);
            AnnotationsFromOverlapsDialog.this.specificValueTF = new JTextField();
            AnnotationsFromOverlapsDialog.this.specificValueTF.setEnabled(false);
            AnnotationsFromOverlapsDialog.this.specificValueTF.addKeyListener(this);
            AnnotationsFromOverlapsDialog.this.tierSelectBox = new JComboBox();
            AnnotationsFromOverlapsDialog.this.tierSelectBox.setEnabled(false);
            this.tierValuePanel = new JPanel(new GridBagLayout());
            this.tierValuePanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.TierValue")));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = AnnotationsFromOverlapsDialog.this.firstSingleTabInset;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.durationRadioButton, gbc);
            gbc.insets = AnnotationsFromOverlapsDialog.this.singleTabInset;
            gbc.gridy = 1;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.msecRB, gbc);
            gbc.gridy = 2;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.secRB, gbc);
            gbc.gridy = 3;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.hrRB, gbc);
            gbc.gridy = 4;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.smpteRB, gbc);
            gbc.gridy = 5;
            gbc.insets = AnnotationsFromOverlapsDialog.this.doubleTabInset;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.palRB, gbc);
            gbc.gridy = 6;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.ntscRB, gbc);
            gbc.gridy = 7;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.specificValueRB, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.specificValueTF, gbc);
            gbc.gridx = 0;
            gbc.gridy = 8;
            gbc.weightx = 0.0;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.tierValueRadioButton, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.tierSelectBox, gbc);
            gbc.gridx = 0;
            gbc.gridy = 9;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            gbc.gridwidth = 2;
            gbc.weightx = 0.0;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.concatValuesRB, gbc);
            gbc.gridy = 10;
            gbc.insets = AnnotationsFromOverlapsDialog.this.singleTabInset;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.sortByTimeRB, gbc);
            gbc.gridy = 11;
            gbc.insets = AnnotationsFromOverlapsDialog.this.singleTabInset;
            this.tierValuePanel.add((Component)AnnotationsFromOverlapsDialog.this.sortBySelectionRB, gbc);
            gbc.gridx = 0;
            gbc.gridy = 12;
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            gbc.fill = 1;
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(10, 50, 0, 10);
            this.tierValuePanel.add((Component)this.tierTableScrollPane, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 13;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(10, 50, 0, 10);
            this.tierValuePanel.add((Component)buttonPanel, gbc);
            this.setLayout(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 1;
            gbc.anchor = 11;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            this.add((Component)this.tierValuePanel, gbc);
        }

        public String getStepTitle() {
            return ElanLocale.getString("OverlapsDialog.Title.Step4Title");
        }

        public void enterStepForward() {
            this.updateButtonStates();
            AnnotationsFromOverlapsDialog.this.atLastStep = true;
        }

        public boolean doFinish() {
            if (AnnotationsFromOverlapsDialog.this.atLastStep) {
                AnnotationsFromOverlapsDialog.this.executeOverlapsCommand();
            }
            return true;
        }

        public boolean leaveStepBackward() {
            AnnotationsFromOverlapsDialog.this.atLastStep = false;
            this.multiPane.setButtonEnabled(3, false);
            return true;
        }

        public void updateValues() {
            int i;
            SelectableContentTableModel model = (SelectableContentTableModel)AnnotationsFromOverlapsDialog.this.step1TierTable.getModel();
            Vector tierList = model.getSelectedValues();
            AnnotationsFromOverlapsDialog.this.tierSelectBox.removeAllItems();
            for (i = 0; i < tierList.size(); ++i) {
                AnnotationsFromOverlapsDialog.this.tierSelectBox.addItem(tierList.get(i).toString());
            }
            while (this.model.getRowCount() > 0) {
                this.model.removeRow(0);
            }
            if (!AnnotationsFromOverlapsDialog.this.sortBySelectionRB.isSelected()) {
                AnnotationsFromOverlapsDialog.this.step4SortTierTable.setForeground(Color.LIGHT_GRAY);
                AnnotationsFromOverlapsDialog.this.step4SortTierTable.setEnabled(false);
            }
            for (i = 0; i < tierList.size(); ++i) {
                this.model.addRow(new String[]{(String)tierList.get(i)});
            }
        }

        public void updateButtonStates() {
            boolean b = AnnotationsFromOverlapsDialog.this.durationRadioButton.isSelected();
            AnnotationsFromOverlapsDialog.this.msecRB.setEnabled(b);
            AnnotationsFromOverlapsDialog.this.secRB.setEnabled(b);
            AnnotationsFromOverlapsDialog.this.hrRB.setEnabled(b);
            AnnotationsFromOverlapsDialog.this.smpteRB.setEnabled(b);
            AnnotationsFromOverlapsDialog.this.palRB.setEnabled(b && AnnotationsFromOverlapsDialog.this.smpteRB.isSelected());
            AnnotationsFromOverlapsDialog.this.ntscRB.setEnabled(b && AnnotationsFromOverlapsDialog.this.smpteRB.isSelected());
            AnnotationsFromOverlapsDialog.this.tierSelectBox.setEnabled(AnnotationsFromOverlapsDialog.this.tierValueRadioButton.isSelected());
            AnnotationsFromOverlapsDialog.this.specificValueTF.setEnabled(AnnotationsFromOverlapsDialog.this.specificValueRB.isSelected());
            this.multiPane.setButtonEnabled(1, false);
            if (AnnotationsFromOverlapsDialog.this.specificValueRB.isSelected()) {
                this.multiPane.setButtonEnabled(3, AnnotationsFromOverlapsDialog.this.specificValueTF.getText().trim().length() > 0);
            } else {
                this.multiPane.setButtonEnabled(3, true);
            }
            this.multiPane.setButtonEnabled(2, true);
        }

        protected void moveDown() {
            if (AnnotationsFromOverlapsDialog.this.step4SortTierTable == null || this.model == null) {
                return;
            }
            int row = AnnotationsFromOverlapsDialog.this.step4SortTierTable.getSelectedRow();
            this.model.moveRow(row, row, row + 1);
            AnnotationsFromOverlapsDialog.this.step4SortTierTable.changeSelection(row + 1, 0, false, false);
        }

        protected void moveUp() {
            if (AnnotationsFromOverlapsDialog.this.step4SortTierTable == null || this.model == null) {
                return;
            }
            int row = AnnotationsFromOverlapsDialog.this.step4SortTierTable.getSelectedRow();
            this.model.moveRow(row, row, row - 1);
            AnnotationsFromOverlapsDialog.this.step4SortTierTable.changeSelection(row - 1, 0, false, false);
        }

        public void actionPerformed(ActionEvent e) {
            this.updateButtonStates();
            if (e.getSource() == this.moveUpButton) {
                this.moveUp();
            } else if (e.getSource() == this.moveDownButton) {
                this.moveDown();
            } else if (e.getSource() == AnnotationsFromOverlapsDialog.this.concatValuesRB) {
                AnnotationsFromOverlapsDialog.this.sortByTimeRB.setEnabled(true);
                AnnotationsFromOverlapsDialog.this.sortByTimeRB.setSelected(true);
                AnnotationsFromOverlapsDialog.this.sortBySelectionRB.setEnabled(true);
            } else if (e.getSource() == AnnotationsFromOverlapsDialog.this.sortBySelectionRB) {
                AnnotationsFromOverlapsDialog.this.step4SortTierTable.setForeground(Color.BLACK);
                AnnotationsFromOverlapsDialog.this.step4SortTierTable.setEnabled(true);
            } else {
                if (!AnnotationsFromOverlapsDialog.this.concatValuesRB.isSelected()) {
                    AnnotationsFromOverlapsDialog.this.sortByTimeRB.setEnabled(false);
                    AnnotationsFromOverlapsDialog.this.sortBySelectionRB.setEnabled(false);
                }
                AnnotationsFromOverlapsDialog.this.step4SortTierTable.setEnabled(false);
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            this.updateButtonStates();
        }

        public void keyTyped(KeyEvent e) {
            this.updateButtonStates();
        }

        public void valueChanged(ListSelectionEvent e) {
            if (AnnotationsFromOverlapsDialog.this.step4SortTierTable.getSelectedRow() == 0) {
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(true);
            } else if (AnnotationsFromOverlapsDialog.this.step4SortTierTable.getSelectedRow() == AnnotationsFromOverlapsDialog.this.step4SortTierTable.getRowCount() - 1) {
                this.moveUpButton.setEnabled(true);
                this.moveDownButton.setEnabled(false);
            } else if (AnnotationsFromOverlapsDialog.this.step4SortTierTable.getSelectedRow() > 0) {
                this.moveUpButton.setEnabled(true);
                this.moveDownButton.setEnabled(true);
            } else {
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DestinationTierPanel
    extends StepPane
    implements ListSelectionListener,
    ActionListener,
    KeyListener {
        private JLabel newTierNameLabel;
        private JLabel decideRootOrChildLabel;
        private JLabel lingTypeLabel;
        private JScrollPane lingTypeTableScrollPane;
        private JPanel destinationTierConfigurationPanel;
        private ButtonGroup rootChildButtonGroup;

        public DestinationTierPanel(MultiStepPane mp) {
            super(mp);
            this.initComponents();
        }

        @Override
        protected void initComponents() {
            this.newTierNameLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.newTierNameLabel"));
            this.lingTypeLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.lingTypeLabel"));
            AnnotationsFromOverlapsDialog.this.newTierNameField = new JTextField();
            AnnotationsFromOverlapsDialog.this.newTierNameField.addKeyListener(this);
            this.decideRootOrChildLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.RootChildLabel"));
            AnnotationsFromOverlapsDialog.this.rootTierRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.RootTier"), true);
            AnnotationsFromOverlapsDialog.this.rootTierRB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.childTierRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ChildTier"));
            AnnotationsFromOverlapsDialog.this.childTierRB.addActionListener(this);
            this.rootChildButtonGroup = new ButtonGroup();
            this.rootChildButtonGroup.add(AnnotationsFromOverlapsDialog.this.rootTierRB);
            this.rootChildButtonGroup.add(AnnotationsFromOverlapsDialog.this.childTierRB);
            AnnotationsFromOverlapsDialog.this.parentTierCB = new JComboBox();
            AnnotationsFromOverlapsDialog.this.parentTierCB.addActionListener(this);
            AnnotationsFromOverlapsDialog.this.parentTierCB.setEnabled(false);
            AnnotationsFromOverlapsDialog.this.linguisticTypeTable = new JTable();
            AnnotationsFromOverlapsDialog.this.linguisticTypeTable.setSelectionMode(0);
            AnnotationsFromOverlapsDialog.this.linguisticTypeTable.setModel(new LinguisticTypeTableModel());
            AnnotationsFromOverlapsDialog.this.linguisticTypeTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.LinguisticType"));
            AnnotationsFromOverlapsDialog.this.linguisticTypeTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Stereotype"));
            AnnotationsFromOverlapsDialog.this.linguisticTypeTable.getSelectionModel().addListSelectionListener(this);
            this.lingTypeTableScrollPane = new JScrollPane(AnnotationsFromOverlapsDialog.this.linguisticTypeTable);
            this.destinationTierConfigurationPanel = new JPanel(new GridBagLayout());
            this.destinationTierConfigurationPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.DestTierConfiguration")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            this.destinationTierConfigurationPanel.add((Component)this.newTierNameLabel, gbc);
            gbc.gridy = 1;
            this.destinationTierConfigurationPanel.add((Component)AnnotationsFromOverlapsDialog.this.newTierNameField, gbc);
            gbc.gridy = 2;
            this.destinationTierConfigurationPanel.add((Component)this.decideRootOrChildLabel, gbc);
            gbc.gridy = 3;
            gbc.insets = AnnotationsFromOverlapsDialog.this.singleTabInset;
            this.destinationTierConfigurationPanel.add((Component)AnnotationsFromOverlapsDialog.this.rootTierRB, gbc);
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            this.destinationTierConfigurationPanel.add((Component)AnnotationsFromOverlapsDialog.this.childTierRB, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            this.destinationTierConfigurationPanel.add((Component)AnnotationsFromOverlapsDialog.this.parentTierCB, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 2;
            this.destinationTierConfigurationPanel.add((Component)this.lingTypeLabel, gbc);
            gbc.gridy = 6;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.destinationTierConfigurationPanel.add((Component)this.lingTypeTableScrollPane, gbc);
            this.setLayout(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            this.add((Component)this.destinationTierConfigurationPanel, gbc);
        }

        public void updateTierValues() {
            SelectableContentTableModel model = (SelectableContentTableModel)AnnotationsFromOverlapsDialog.this.step1TierTable.getModel();
            Vector tierList = model.getSelectedValues();
            AnnotationsFromOverlapsDialog.this.parentTierCB.removeAllItems();
            for (int i = 0; i < tierList.size(); ++i) {
                AnnotationsFromOverlapsDialog.this.parentTierCB.addItem((String)tierList.get(i));
            }
        }

        private boolean isValidParentTier(List<TranscriptionImpl> transImpls, String tierName) {
            for (TranscriptionImpl t : transImpls) {
                TierImpl tier = (TierImpl)t.getTierWithId(tierName);
                if (tier != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getStepTitle() {
            return ElanLocale.getString("OverlapsDialog.Title.Step3Title");
        }

        @Override
        public void enterStepForward() {
            this.updateButtonStates();
        }

        @Override
        public void enterStepBackward() {
            this.updateButtonStates();
        }

        @Override
        public boolean leaveStepForward() {
            String newTierName = AnnotationsFromOverlapsDialog.this.newTierNameField.getText().trim();
            if (AnnotationsFromOverlapsDialog.this.tierSet.contains(newTierName)) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("OverlapsDialog.Message1.Part1") + newTierName + ElanLocale.getString("OverlapsDialog.Message1.Part2"), ElanLocale.getString("OverlapsDialog.Message.Title"), 0);
            } else if (newTierName.length() <= 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("OverlapsDialog.Message2"), ElanLocale.getString("OverlapsDialog.Message.Title"), 0);
            }
            return true;
        }

        public void updateButtonStates() {
            this.multiPane.setButtonText(1, ElanLocale.getString("Button.Next"));
            String newTierName = AnnotationsFromOverlapsDialog.this.newTierNameField.getText().trim();
            this.multiPane.setButtonEnabled(1, newTierName.length() > 0 && !AnnotationsFromOverlapsDialog.this.tierSet.contains(newTierName) && AnnotationsFromOverlapsDialog.this.linguisticTypeTable.getSelectedRowCount() > 0);
            this.multiPane.setButtonEnabled(2, true);
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            this.updateButtonStates();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.updateButtonStates();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.updateButtonStates();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnnotationsFromOverlapsDialog.this.parentTierCB.setEnabled(AnnotationsFromOverlapsDialog.this.childTierRB.isSelected());
            String parentTierName = null;
            LinguisticTypeTableModel model = (LinguisticTypeTableModel)AnnotationsFromOverlapsDialog.this.linguisticTypeTable.getModel();
            if (AnnotationsFromOverlapsDialog.this.childTierRB.isSelected()) {
                parentTierName = (String)AnnotationsFromOverlapsDialog.this.parentTierCB.getSelectedItem();
            }
            model.updateLinguisticTypes(parentTierName);
            this.updateButtonStates();
        }

        private class LinguisticTypeTableModel
        extends AbstractTableModel {
            private String[] columnNames = new String[2];
            private String[][] rowData;
            private boolean multipleFileMode;

            public LinguisticTypeTableModel() {
                this.columnNames[0] = new String(ElanLocale.getString("OverlapsDialog.Column.LinguisticType"));
                this.columnNames[1] = new String(ElanLocale.getString("OverlapsDialog.Column.Stereotype"));
                this.multipleFileMode = AnnotationsFromOverlapsDialog.this.transcription == null;
                this.updateLinguisticTypes(null);
            }

            private Vector getLinguisticTypeList() {
                Vector<LinguisticType> lingTypes = new Vector<LinguisticType>();
                if (!this.multipleFileMode) {
                    lingTypes.addAll(AnnotationsFromOverlapsDialog.this.transcription.getLinguisticTypes());
                } else {
                    if (AnnotationsFromOverlapsDialog.this.openedFileList == null) {
                        return lingTypes;
                    }
                    Vector<LinguisticType> removeList = new Vector<LinguisticType>();
                    for (int i = 0; i < AnnotationsFromOverlapsDialog.this.openedFileList.size(); ++i) {
                        TranscriptionImpl t = (TranscriptionImpl)AnnotationsFromOverlapsDialog.this.openedFileList.get(i);
                        if (i <= 0) {
                            lingTypes.addAll(t.getLinguisticTypes());
                            continue;
                        }
                        Vector v = ((TranscriptionImpl)AnnotationsFromOverlapsDialog.this.openedFileList.get(i)).getLinguisticTypes();
                        for (int j = 0; j < v.size(); ++j) {
                            LinguisticType newLt = (LinguisticType)v.get(j);
                            if (!lingTypes.contains(newLt) && !removeList.contains(newLt)) {
                                lingTypes.add(newLt);
                                continue;
                            }
                            LinguisticType oldLt = (LinguisticType)lingTypes.get(lingTypes.indexOf(newLt));
                            if (oldLt.isUsingControlledVocabulary() == newLt.isUsingControlledVocabulary() && oldLt.hasConstraints() == newLt.hasConstraints() && (!oldLt.hasConstraints() || !newLt.hasConstraints() || oldLt.getConstraints().getStereoType() == newLt.getConstraints().getStereoType())) continue;
                            lingTypes.remove(oldLt);
                            removeList.add(oldLt);
                        }
                    }
                }
                return lingTypes;
            }

            public void updateLinguisticTypes(String parentTierName) {
                ArrayList<String> linguisticTypeNames = new ArrayList<String>();
                ArrayList<String> stereotypeNames = new ArrayList<String>();
                Vector linguisticTypeList = this.getLinguisticTypeList();
                if (!this.multipleFileMode) {
                    if (parentTierName == null) {
                        for (LinguisticType lt : linguisticTypeList) {
                            if (lt.hasConstraints() || lt.isUsingControlledVocabulary()) continue;
                            linguisticTypeNames.add(lt.getLinguisticTypeName());
                            stereotypeNames.add("");
                        }
                    } else {
                        TierImpl parentTier = (TierImpl)AnnotationsFromOverlapsDialog.this.transcription.getTierWithId(parentTierName);
                        for (LinguisticType lt : linguisticTypeList) {
                            if (lt.isUsingControlledVocabulary() || !lt.hasConstraints() || lt.getConstraints().getStereoType() != 1) continue;
                            linguisticTypeNames.add(lt.getLinguisticTypeName());
                            stereotypeNames.add(Constraint.stereoTypes[lt.getConstraints().getStereoType()]);
                        }
                    }
                } else if (parentTierName == null) {
                    for (LinguisticType lt : linguisticTypeList) {
                        if (lt.hasConstraints() || lt.isUsingControlledVocabulary()) continue;
                        linguisticTypeNames.add(lt.getLinguisticTypeName());
                        stereotypeNames.add("");
                    }
                } else {
                    boolean allTiersAreRoot = true;
                    for (TranscriptionImpl t : AnnotationsFromOverlapsDialog.this.openedFileList) {
                        TierImpl parentTier = (TierImpl)t.getTierWithId(parentTierName);
                        if (parentTier == null || !parentTier.getLinguisticType().hasConstraints()) continue;
                        allTiersAreRoot = false;
                        break;
                    }
                    for (LinguisticType lt : linguisticTypeList) {
                        if (lt.isUsingControlledVocabulary() || !lt.hasConstraints() || lt.getConstraints().getStereoType() != 1) continue;
                        linguisticTypeNames.add(lt.getLinguisticTypeName());
                        stereotypeNames.add(Constraint.stereoTypes[lt.getConstraints().getStereoType()]);
                    }
                }
                int SIZE = linguisticTypeNames.size();
                this.rowData = new String[SIZE][];
                for (int i = 0; i < SIZE; ++i) {
                    this.rowData[i] = new String[]{(String)linguisticTypeNames.get(i), (String)stereotypeNames.get(i)};
                }
                this.fireTableDataChanged();
            }

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                if (this.rowData != null) {
                    return this.rowData.length;
                }
                return 0;
            }

            public Object getValueAt(int row, int col) {
                return this.rowData[row][col];
            }
        }
    }

    private class OverlapsComputationCriteriaPanel
    extends StepPane {
        ButtonGroup criteriaButtonGroup;
        JLabel createAnnotationLabel;
        JButton valuesMatchConstraintsBtn;
        JPanel criteriaPanel;
        JComboBox tierNameCB;
        JTextField annotationValueTF;
        JScrollPane scrollPane;
        DisplayableContentTableModel tableModel;

        public OverlapsComputationCriteriaPanel(MultiStepPane mp) {
            super(mp);
            this.initComponents();
        }

        protected void initComponents() {
            this.createAnnotationLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.CreateAnnotation"));
            this.tierNameCB = new JComboBox();
            this.tableModel = new DisplayableContentTableModel(4);
            AnnotationsFromOverlapsDialog.this.tierValueTable = new JTable(this.tableModel);
            AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(0).setMaxWidth(35);
            AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(2).setMaxWidth(60);
            RadioButtonListener radioButtonListener = new RadioButtonListener();
            AnnotationsFromOverlapsDialog.this.overlapRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.Overlap"), true);
            AnnotationsFromOverlapsDialog.this.overlapRB.addActionListener(radioButtonListener);
            AnnotationsFromOverlapsDialog.this.valuesTheSameRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ValuesTheSame"));
            AnnotationsFromOverlapsDialog.this.valuesTheSameRB.addActionListener(radioButtonListener);
            AnnotationsFromOverlapsDialog.this.valuesDifferentRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ValuesDifferent"));
            AnnotationsFromOverlapsDialog.this.valuesDifferentRB.addActionListener(radioButtonListener);
            AnnotationsFromOverlapsDialog.this.valuesMatchConstraintsRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ValuesMatchConstraints"));
            AnnotationsFromOverlapsDialog.this.valuesMatchConstraintsRB.addActionListener(radioButtonListener);
            this.valuesMatchConstraintsBtn = new JButton(ElanLocale.getString("OverlapsDialog.Button.Constraints"));
            this.valuesMatchConstraintsBtn.addActionListener(new ButtonListener());
            this.valuesMatchConstraintsBtn.setEnabled(false);
            this.criteriaButtonGroup = new ButtonGroup();
            this.criteriaButtonGroup.add(AnnotationsFromOverlapsDialog.this.overlapRB);
            this.criteriaButtonGroup.add(AnnotationsFromOverlapsDialog.this.valuesTheSameRB);
            this.criteriaButtonGroup.add(AnnotationsFromOverlapsDialog.this.valuesDifferentRB);
            this.criteriaButtonGroup.add(AnnotationsFromOverlapsDialog.this.valuesMatchConstraintsRB);
            this.criteriaPanel = new JPanel(new GridBagLayout());
            this.criteriaPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.Criteria")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            this.criteriaPanel.add((Component)this.createAnnotationLabel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = AnnotationsFromOverlapsDialog.this.singleTabInset;
            this.criteriaPanel.add((Component)AnnotationsFromOverlapsDialog.this.overlapRB, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = AnnotationsFromOverlapsDialog.this.singleTabInset;
            this.criteriaPanel.add((Component)AnnotationsFromOverlapsDialog.this.valuesTheSameRB, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            this.criteriaPanel.add((Component)AnnotationsFromOverlapsDialog.this.valuesDifferentRB, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            this.criteriaPanel.add((Component)AnnotationsFromOverlapsDialog.this.valuesMatchConstraintsRB, gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            gbc.fill = 0;
            this.criteriaPanel.add((Component)this.valuesMatchConstraintsBtn, gbc);
            this.setLayout(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            gbc.fill = 2;
            this.add((Component)this.criteriaPanel, gbc);
        }

        public String getStepTitle() {
            return ElanLocale.getString("OverlapsDialog.Title.Step2Title");
        }

        public void enterStepForward() {
            this.updateButtonStates();
        }

        public void enterStepBackward() {
            this.updateButtonStates();
        }

        public void updateTierValues() {
            SelectableContentTableModel model = (SelectableContentTableModel)AnnotationsFromOverlapsDialog.this.step1TierTable.getModel();
            Vector tierList = model.getSelectedValues();
            this.tierNameCB.removeAllItems();
            for (int i = 0; i < tierList.size(); ++i) {
                this.tierNameCB.addItem(tierList.get(i).toString());
            }
            for (int r = this.tableModel.getRowCount() - 1; r >= 0; --r) {
                if (tierList.contains(this.tableModel.getValueAt(r, 1))) continue;
                this.tableModel.removeRow(r);
            }
        }

        public void updateButtonStates() {
            this.multiPane.setButtonEnabled(1, true);
            this.multiPane.setButtonEnabled(2, true);
        }

        private class ConstraintDialog
        extends ClosableDialog
        implements ActionListener,
        ItemListener {
            private JPanel constraintPanel;
            private JPanel buttonPanel;
            private JButton removeButton;
            private JButton removeAllButton;
            private JButton addButton;
            private JButton okButton;
            private JLabel containsLabel;
            private JPanel specifyConstraintPanel;
            private JPanel constraintOverviewPanel;

            public ConstraintDialog() {
                super((Frame)AnnotationsFromOverlapsDialog.this.parentFrame, true);
                this.setTitle(ElanLocale.getString("OverlapsDialog.Dialog.ConstraintDialog.Title"));
                this.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                this.initConstraintPanel();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                gbc.anchor = 18;
                gbc.insets = new Insets(4, 5, 4, 4);
                this.add((Component)this.constraintPanel, gbc);
            }

            private void initConstraintPanel() {
                Insets insets;
                OverlapsComputationCriteriaPanel.this.tierNameCB.addItemListener(this);
                this.constraintPanel = new JPanel(new GridBagLayout());
                this.specifyConstraintPanel = new JPanel(new GridBagLayout());
                this.specifyConstraintPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.SpecifyConstraint")));
                this.constraintOverviewPanel = new JPanel(new GridBagLayout());
                this.constraintOverviewPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.ConstraintsOverview")));
                OverlapsComputationCriteriaPanel.this.annotationValueTF = new JTextField();
                this.containsLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Combo.Contains"));
                this.addButton = new JButton(ElanLocale.getString("Button.Add"));
                this.addButton.addActionListener(this);
                AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(0).setHeaderValue("");
                AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(0).setWidth(10);
                AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Header.Tier"));
                AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(2).setHeaderValue("");
                AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(2).setWidth(30);
                AnnotationsFromOverlapsDialog.this.tierValueTable.getColumnModel().getColumn(3).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Header.Value"));
                OverlapsComputationCriteriaPanel.this.tableModel.connectTable(AnnotationsFromOverlapsDialog.this.tierValueTable);
                OverlapsComputationCriteriaPanel.this.scrollPane = new JScrollPane(AnnotationsFromOverlapsDialog.this.tierValueTable);
                this.removeButton = new JButton(ElanLocale.getString("OverlapsDialog.Button.Remove"));
                this.removeButton.addActionListener(this);
                this.removeAllButton = new JButton(ElanLocale.getString("OverlapsDialog.Button.RemoveAll"));
                this.removeAllButton.addActionListener(this);
                this.okButton = new JButton(ElanLocale.getString("Button.OK"));
                this.okButton.addActionListener(this);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.weightx = 0.5;
                gbc.insets = new Insets(5, 10, 5, 0);
                gbc.anchor = 10;
                gbc.fill = 2;
                this.specifyConstraintPanel.add((Component)OverlapsComputationCriteriaPanel.this.tierNameCB, gbc);
                gbc.gridy = 0;
                gbc.gridx = 1;
                gbc.fill = 1;
                gbc.weightx = 0.0;
                this.specifyConstraintPanel.add((Component)this.containsLabel, gbc);
                gbc.gridx = 2;
                gbc.weightx = 0.5;
                gbc.fill = 1;
                this.specifyConstraintPanel.add((Component)OverlapsComputationCriteriaPanel.this.annotationValueTF, gbc);
                gbc.gridx = 3;
                gbc.weightx = 0.0;
                gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
                gbc.anchor = 17;
                gbc.fill = 0;
                this.specifyConstraintPanel.add((Component)this.addButton, gbc);
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.fill = 1;
                gbc.anchor = 10;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
                this.constraintOverviewPanel.add((Component)OverlapsComputationCriteriaPanel.this.scrollPane, gbc);
                this.buttonPanel = new JPanel(new FlowLayout());
                this.buttonPanel.add(this.removeButton);
                this.buttonPanel.add(this.removeAllButton);
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.gridwidth = 1;
                gbc.insets = insets = new Insets(0, ((AnnotationsFromOverlapsDialog)AnnotationsFromOverlapsDialog.this).globalInset.left, ((AnnotationsFromOverlapsDialog)AnnotationsFromOverlapsDialog.this).globalInset.bottom, ((AnnotationsFromOverlapsDialog)AnnotationsFromOverlapsDialog.this).globalInset.right);
                gbc.anchor = 17;
                gbc.fill = 0;
                this.constraintOverviewPanel.add((Component)this.buttonPanel, gbc);
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.anchor = 10;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.insets = new Insets(0, 0, 0, 0);
                this.constraintPanel.add((Component)this.specifyConstraintPanel, gbc);
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.fill = 1;
                gbc.weighty = 1.0;
                this.constraintPanel.add((Component)this.constraintOverviewPanel, gbc);
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
                this.constraintPanel.add((Component)this.okButton, gbc);
            }

            public void actionPerformed(ActionEvent e) {
                JButton btn = (JButton)e.getSource();
                if (btn == this.addButton) {
                    this.addButton.setEnabled(false);
                    int selectedIndex = OverlapsComputationCriteriaPanel.this.tierNameCB.getSelectedIndex();
                    String[] value = new String[]{"", OverlapsComputationCriteriaPanel.this.tierNameCB.getItemAt(selectedIndex).toString(), ElanLocale.getString("OverlapsDialog.Combo.Contains"), OverlapsComputationCriteriaPanel.this.annotationValueTF.getText()};
                    int rowIndex = this.findIndexToAdd(value[1], value[3]);
                    if (OverlapsComputationCriteriaPanel.this.tableModel.contains(value[1], 1)) {
                        return;
                    }
                    if (rowIndex > 0) {
                        value[0] = ElanLocale.getString("OverlapsDialog.Message.And");
                        OverlapsComputationCriteriaPanel.this.tableModel.addRowAt(value, rowIndex);
                    } else {
                        OverlapsComputationCriteriaPanel.this.tableModel.addRowAt(value, rowIndex);
                        if (OverlapsComputationCriteriaPanel.this.tableModel.getRowCount() >= 2) {
                            OverlapsComputationCriteriaPanel.this.tableModel.setValueAt(ElanLocale.getString("OverlapsDialog.Message.And"), 1, 0);
                        }
                    }
                    OverlapsComputationCriteriaPanel.this.tableModel.updateTables();
                } else if (btn == this.removeButton) {
                    int i;
                    int[] selectedRows = AnnotationsFromOverlapsDialog.this.tierValueTable.getSelectedRows();
                    for (i = selectedRows.length - 1; i >= 0; --i) {
                        OverlapsComputationCriteriaPanel.this.tableModel.removeRow(selectedRows[i]);
                    }
                    for (i = 0; i < OverlapsComputationCriteriaPanel.this.tableModel.getRowCount(); ++i) {
                        if (i == 0) {
                            OverlapsComputationCriteriaPanel.this.tableModel.setValueAt("", 0, 0);
                            continue;
                        }
                        OverlapsComputationCriteriaPanel.this.tableModel.setValueAt(ElanLocale.getString("OverlapsDialog.Message.And"), i, 0);
                    }
                    AnnotationsFromOverlapsDialog.this.tierValueTable.getSelectionModel().clearSelection();
                    String tierName = (String)OverlapsComputationCriteriaPanel.this.tierNameCB.getSelectedItem();
                    this.addButton.setEnabled(!OverlapsComputationCriteriaPanel.this.tableModel.contains(tierName, 1));
                    this.updateAddButtonState();
                } else if (btn == this.removeAllButton) {
                    for (int i = OverlapsComputationCriteriaPanel.this.tableModel.getRowCount() - 1; i >= 0; --i) {
                        OverlapsComputationCriteriaPanel.this.tableModel.removeRow(i);
                    }
                    AnnotationsFromOverlapsDialog.this.tierValueTable.getSelectionModel().clearSelection();
                    this.updateAddButtonState();
                } else if (btn == this.okButton) {
                    this.setVisible(false);
                    this.dispose();
                }
            }

            private int findIndexToAdd(String tiername, String value) {
                Collator collator = Collator.getInstance();
                for (int r = 0; r < OverlapsComputationCriteriaPanel.this.tableModel.getRowCount(); ++r) {
                    int res = collator.compare((Object)tiername, OverlapsComputationCriteriaPanel.this.tableModel.getValueAt(r, 1));
                    if (res == -1) {
                        return r;
                    }
                    if (res != 0 || collator.compare((Object)value, OverlapsComputationCriteriaPanel.this.tableModel.getValueAt(r, 3)) >= 0) continue;
                    return r;
                }
                return OverlapsComputationCriteriaPanel.this.tableModel.getRowCount();
            }

            public void itemStateChanged(ItemEvent e) {
                this.updateAddButtonState();
            }

            private void updateAddButtonState() {
                String tierName = (String)OverlapsComputationCriteriaPanel.this.tierNameCB.getSelectedItem();
                this.addButton.setEnabled(!OverlapsComputationCriteriaPanel.this.tableModel.contains(tierName, 1));
            }
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                JButton btn = (JButton)e.getSource();
                if (btn == OverlapsComputationCriteriaPanel.this.valuesMatchConstraintsBtn) {
                    ConstraintDialog dialog = new ConstraintDialog();
                    dialog.setSize(400, 500);
                    dialog.setVisible(true);
                }
            }
        }

        private class RadioButtonListener
        implements ActionListener {
            private RadioButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                boolean b = AnnotationsFromOverlapsDialog.this.valuesMatchConstraintsRB.isSelected();
                OverlapsComputationCriteriaPanel.this.valuesMatchConstraintsBtn.setEnabled(b);
            }
        }
    }

    private class FileTierSelectionPanel
    extends StepPane {
        JPanel fileSelectionPanel;
        ButtonGroup buttonGroup;
        JButton selectFilesBtn;
        JButton selectDomainBtn;
        JPanel tierSelectionPanel;
        JPanel buttonPanel;
        JButton selectAllButton;
        JButton selectNoneButton;
        JScrollPane tierTableScrollPane;

        public FileTierSelectionPanel(MultiStepPane mp) {
            super(mp);
            this.initComponents();
        }

        protected void initComponents() {
            this.initFileSelectionPanel();
            this.initTierSelectionPanel();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            this.add((Component)this.fileSelectionPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            this.add((Component)this.tierSelectionPanel, gbc);
        }

        public String getStepTitle() {
            return ElanLocale.getString("OverlapsDialog.Title.Step1Title");
        }

        public void enterStepForward() {
            this.updateButtonStates();
        }

        public void enterStepBackward() {
            this.updateButtonStates();
        }

        public boolean leaveStepForward() {
            AnnotationsFromOverlapsDialog.this.step2Panel.updateTierValues();
            AnnotationsFromOverlapsDialog.this.step3Panel.updateTierValues();
            AnnotationsFromOverlapsDialog.this.step4Panel.updateValues();
            return true;
        }

        private void initFileSelectionPanel() {
            this.fileSelectionPanel = new JPanel(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.FileSelection")));
            RadioButtonHandler radioButtonListener = new RadioButtonHandler();
            AnnotationsFromOverlapsDialog.this.currentlyOpenedFileRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.CurrentlyOpenedFile"));
            AnnotationsFromOverlapsDialog.this.currentlyOpenedFileRB.addActionListener(radioButtonListener);
            AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.FilesFromFileBrowser"));
            AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB.addActionListener(radioButtonListener);
            AnnotationsFromOverlapsDialog.this.filesFromDomainRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.FilesFromDomain"));
            AnnotationsFromOverlapsDialog.this.filesFromDomainRB.addActionListener(radioButtonListener);
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(AnnotationsFromOverlapsDialog.this.currentlyOpenedFileRB);
            this.buttonGroup.add(AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB);
            this.buttonGroup.add(AnnotationsFromOverlapsDialog.this.filesFromDomainRB);
            ButtonHandler buttonHandler = new ButtonHandler();
            this.selectFilesBtn = new JButton(ElanLocale.getString("Button.Browse"));
            this.selectFilesBtn.addActionListener(buttonHandler);
            this.selectDomainBtn = new JButton(ElanLocale.getString("OverlapsDialog.Button.Domain"));
            this.selectDomainBtn.addActionListener(buttonHandler);
            this.selectDomainBtn.setEnabled(false);
            if (AnnotationsFromOverlapsDialog.this.transcription == null) {
                AnnotationsFromOverlapsDialog.this.currentlyOpenedFileRB.setEnabled(false);
                AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB.setEnabled(true);
                AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB.setSelected(true);
                this.selectFilesBtn.setEnabled(true);
            } else {
                AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB.setEnabled(false);
                AnnotationsFromOverlapsDialog.this.filesFromDomainRB.setEnabled(false);
                this.selectFilesBtn.setEnabled(false);
                this.selectDomainBtn.setEnabled(false);
                AnnotationsFromOverlapsDialog.this.currentlyOpenedFileRB.setSelected(true);
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = AnnotationsFromOverlapsDialog.this.singleTabInset;
            this.fileSelectionPanel.add((Component)AnnotationsFromOverlapsDialog.this.currentlyOpenedFileRB, gbc);
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            this.fileSelectionPanel.add((Component)AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            this.fileSelectionPanel.add((Component)this.selectFilesBtn, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            this.fileSelectionPanel.add((Component)AnnotationsFromOverlapsDialog.this.filesFromDomainRB, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            this.fileSelectionPanel.add((Component)this.selectDomainBtn, gbc);
        }

        private void initTierSelectionPanel() {
            Insets insets;
            this.buttonPanel = new JPanel(new FlowLayout(0));
            this.tierSelectionPanel = new JPanel(new GridBagLayout());
            this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.TierSelection")));
            this.selectAllButton = new JButton(ElanLocale.getString("Button.SelectAll"));
            this.selectNoneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
            ButtonHandler buttonHandler = new ButtonHandler();
            this.selectAllButton.addActionListener(buttonHandler);
            this.selectNoneButton.addActionListener(buttonHandler);
            AnnotationsFromOverlapsDialog.this.step1TierTable = new JTable();
            AnnotationsFromOverlapsDialog.this.step1TierTable.setSelectionMode(0);
            AnnotationsFromOverlapsDialog.this.step1TierTable.setShowVerticalLines(true);
            if (AnnotationsFromOverlapsDialog.this.transcription != null) {
                Object[] tierArray = AnnotationsFromOverlapsDialog.this.tierSet.toArray();
                String[] stereotypeArray = new String[tierArray.length];
                String[] linguisticArray = new String[tierArray.length];
                for (int i = 0; i < tierArray.length; ++i) {
                    TierImpl tier = (TierImpl)AnnotationsFromOverlapsDialog.this.transcription.getTierWithId((String)tierArray[i]);
                    linguisticArray[i] = tier.getLinguisticType().getLinguisticTypeName();
                    stereotypeArray[i] = "";
                    if (!tier.getLinguisticType().hasConstraints()) continue;
                    stereotypeArray[i] = Constraint.stereoTypes[tier.getLinguisticType().getConstraints().getStereoType()];
                }
                SelectableContentTableModel model = new SelectableContentTableModel(AnnotationsFromOverlapsDialog.this.step1TierTable, tierArray, linguisticArray, stereotypeArray);
                model.addActionListener(new ModelClickedHandler());
                AnnotationsFromOverlapsDialog.this.step1TierTable.setModel(model);
                AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(0).setHeaderValue(null);
                AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.TierName"));
                AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(2).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.LinguisticType"));
                AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(3).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Stereotype"));
                AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(0).setMaxWidth(30);
            } else {
                DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("OverlapsDialog.Message3"));
                AnnotationsFromOverlapsDialog.this.step1TierTable.setModel(model);
                AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Header.Message"));
                this.selectFilesBtn.setEnabled(true);
                this.selectDomainBtn.setEnabled(false);
            }
            this.tierTableScrollPane = new JScrollPane(AnnotationsFromOverlapsDialog.this.step1TierTable);
            this.tierTableScrollPane.setColumnHeaderView(null);
            this.buttonPanel.add(this.selectAllButton);
            this.buttonPanel.add(this.selectNoneButton);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 1;
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = AnnotationsFromOverlapsDialog.this.globalInset;
            this.tierSelectionPanel.add((Component)this.tierTableScrollPane, gbc);
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.insets = insets = new Insets(0, ((AnnotationsFromOverlapsDialog)AnnotationsFromOverlapsDialog.this).globalInset.left, 0, ((AnnotationsFromOverlapsDialog)AnnotationsFromOverlapsDialog.this).globalInset.right);
            this.tierSelectionPanel.add((Component)this.buttonPanel, gbc);
        }

        public void updateButtonStates() {
            try {
                SelectableContentTableModel model = (SelectableContentTableModel)AnnotationsFromOverlapsDialog.this.step1TierTable.getModel();
                this.multiPane.setButtonEnabled(1, model.getSelectedValues().size() > 1);
                this.multiPane.setButtonEnabled(2, false);
            }
            catch (ClassCastException e) {
                this.multiPane.setButtonEnabled(1, false);
            }
        }

        private class RadioButtonHandler
        implements ActionListener {
            private JRadioButton previouslySelectedRadioButton;

            private RadioButtonHandler() {
            }

            public void actionPerformed(ActionEvent e) {
                JRadioButton rb = (JRadioButton)e.getSource();
                if (rb == AnnotationsFromOverlapsDialog.this.currentlyOpenedFileRB) {
                    if (this.previouslySelectedRadioButton != rb) {
                        AnnotationsFromOverlapsDialog.this.openedFileList = null;
                        this.previouslySelectedRadioButton = rb;
                    }
                    FileTierSelectionPanel.this.selectFilesBtn.setEnabled(false);
                    FileTierSelectionPanel.this.selectDomainBtn.setEnabled(false);
                    Object[] tierArray = AnnotationsFromOverlapsDialog.this.tierSet.toArray();
                    String[] stereotypeArray = new String[tierArray.length];
                    String[] linguisticArray = new String[tierArray.length];
                    for (int i = 0; i < tierArray.length; ++i) {
                        TierImpl tier = (TierImpl)AnnotationsFromOverlapsDialog.this.transcription.getTierWithId((String)tierArray[i]);
                        linguisticArray[i] = tier.getLinguisticType().getLinguisticTypeName();
                        stereotypeArray[i] = "";
                        if (!tier.getLinguisticType().hasConstraints()) continue;
                        stereotypeArray[i] = Constraint.stereoTypes[tier.getLinguisticType().getConstraints().getStereoType()];
                    }
                    SelectableContentTableModel model = new SelectableContentTableModel(AnnotationsFromOverlapsDialog.this.step1TierTable, tierArray, linguisticArray, stereotypeArray);
                    model.addActionListener(new ModelClickedHandler());
                    AnnotationsFromOverlapsDialog.this.step1TierTable.setModel(model);
                    AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(0).setHeaderValue(null);
                    AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.TierName"));
                    AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(2).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.LinguisticType"));
                    AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(3).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Stereotype"));
                    AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(0).setMaxWidth(30);
                } else if (rb == AnnotationsFromOverlapsDialog.this.selectedFilesFromDiskRB) {
                    if (this.previouslySelectedRadioButton != rb) {
                        AnnotationsFromOverlapsDialog.this.openedFileList = null;
                        this.previouslySelectedRadioButton = rb;
                    }
                    DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("OverlapsDialog.Message3"));
                    AnnotationsFromOverlapsDialog.this.step1TierTable.setModel(model);
                    AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Header.Message"));
                    FileTierSelectionPanel.this.selectFilesBtn.setEnabled(true);
                    FileTierSelectionPanel.this.selectDomainBtn.setEnabled(false);
                } else if (rb == AnnotationsFromOverlapsDialog.this.filesFromDomainRB) {
                    if (this.previouslySelectedRadioButton != rb) {
                        AnnotationsFromOverlapsDialog.this.openedFileList = null;
                        this.previouslySelectedRadioButton = rb;
                    }
                    DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("OverlapsDialog.Message3"));
                    AnnotationsFromOverlapsDialog.this.step1TierTable.setModel(model);
                    AnnotationsFromOverlapsDialog.this.step1TierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Header.Message"));
                    FileTierSelectionPanel.this.selectFilesBtn.setEnabled(false);
                    FileTierSelectionPanel.this.selectDomainBtn.setEnabled(true);
                }
                FileTierSelectionPanel.this.updateButtonStates();
            }
        }

        private class ModelClickedHandler
        implements ActionListener {
            private ModelClickedHandler() {
            }

            public void actionPerformed(ActionEvent e) {
                FileTierSelectionPanel.this.updateButtonStates();
            }
        }

        private class ButtonHandler
        implements ActionListener {
            private ButtonHandler() {
            }

            public void actionPerformed(ActionEvent e) {
                FileTierSelectionPanel.this.updateButtonStates();
                if (e != null) {
                    JButton button = (JButton)e.getSource();
                    if (button == FileTierSelectionPanel.this.selectFilesBtn) {
                        List filenames = AnnotationsFromOverlapsDialog.this.showMultiFileChooser();
                        if (filenames != null && !filenames.isEmpty()) {
                            OpenFilesThread t = new OpenFilesThread(filenames, AnnotationsFromOverlapsDialog.this.step1TierTable, new ModelClickedHandler());
                            t.start();
                        }
                    } else if (button == FileTierSelectionPanel.this.selectDomainBtn) {
                        MFDomainDialog domainDialog = new MFDomainDialog((Frame)AnnotationsFromOverlapsDialog.this.parentFrame, true);
                        domainDialog.setVisible(true);
                        List<String> searchPaths = domainDialog.getSearchPaths();
                        if (!searchPaths.isEmpty()) {
                            OpenFilesThread t = new OpenFilesThread(searchPaths, AnnotationsFromOverlapsDialog.this.step1TierTable, new ModelClickedHandler());
                            t.start();
                        }
                    } else if (button == FileTierSelectionPanel.this.selectAllButton) {
                        try {
                            SelectableContentTableModel model = (SelectableContentTableModel)AnnotationsFromOverlapsDialog.this.step1TierTable.getModel();
                            model.selectAll();
                            FileTierSelectionPanel.this.updateButtonStates();
                        }
                        catch (ClassCastException exception) {}
                    } else if (button == FileTierSelectionPanel.this.selectNoneButton) {
                        try {
                            SelectableContentTableModel model = (SelectableContentTableModel)AnnotationsFromOverlapsDialog.this.step1TierTable.getModel();
                            model.selectNone();
                            FileTierSelectionPanel.this.updateButtonStates();
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

