/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.CopyTierCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.EditTypeDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.type.LinguisticTypeTableModel;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class CopyTierStep3
extends ProgressStepPane
implements ListSelectionListener,
ActionListener,
ProgressListener {
    private TranscriptionImpl transcription;
    private JLabel tierOverview;
    private JTable typeTable;
    private JScrollPane scrollPane;
    private String tierName;
    private String newParentName;
    private TierImpl selTier;
    private TierImpl newParent;
    private LinguisticType curType;
    private String selTypeName;
    private LinguisticTypeTableModel model;
    private String[] columns;
    private Vector types;
    private JButton typButton;
    private GridBagLayout layout;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private CopyTierCommand com;
    private boolean copyMode = false;

    public CopyTierStep3(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.types = this.transcription.getLinguisticTypes();
        if (multiPane.getStepProperty("CopyMode") != null) {
            this.copyMode = true;
        }
        this.initComponents();
    }

    public void initComponents() {
        super.initComponents();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.tierOverview = new JLabel();
        ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Tick16.gif"));
        ImageIcon untickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Untick16.gif"));
        CheckBoxTableCellRenderer cbRenderer = new CheckBoxTableCellRenderer();
        cbRenderer.setIcon(untickIcon);
        cbRenderer.setSelectedIcon(tickIcon);
        cbRenderer.setHorizontalAlignment(0);
        if (this.types != null) {
            this.columns = new String[]{"Type", "Stereotype", "CV", "TimeAlignable", "Graphics"};
            this.model = new LinguisticTypeTableModel(this.types, this.columns);
        } else {
            this.model = new LinguisticTypeTableModel();
        }
        this.typeTable = new JTable(this.model);
        this.typeTable.getSelectionModel().setSelectionMode(0);
        this.typeTable.getSelectionModel().addListSelectionListener(this);
        for (int i = 0; i < this.typeTable.getColumnCount(); ++i) {
            if (this.typeTable.getModel().getColumnClass(i) != String.class) {
                this.typeTable.getColumn(this.typeTable.getModel().getColumnName(i)).setPreferredWidth(35);
            }
            if (this.typeTable.getModel().getColumnClass(i) != Boolean.class) continue;
            this.typeTable.getColumn(this.typeTable.getModel().getColumnName(i)).setCellRenderer(cbRenderer);
        }
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.typeTable);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)this.tierOverview, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.scrollPane, gbc);
        this.typButton = new JButton(ElanLocale.getString("Menu.Type.AddNewType"));
        this.typButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        gbc.weightx = 0.0;
        this.add((Component)this.typButton, gbc);
    }

    private void adjustComponents() {
        JPanel progressPanel = new JPanel(new GridBagLayout());
        JPanel filler = new JPanel();
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        progressPanel.add((Component)filler, gbc);
        this.progressLabel = new JLabel("...");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        progressPanel.add((Component)this.progressLabel, gbc);
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setValue(0);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        progressPanel.add((Component)this.progressBar, gbc);
        this.remove(this.scrollPane);
        this.remove(this.typButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)progressPanel, gbc);
        this.revalidate();
    }

    public String getStepTitle() {
        return ElanLocale.getString("MultiStep.Reparent.SelectType");
    }

    public void enterStepForward() {
        Object par;
        this.tierName = (String)this.multiPane.getStepProperty("SelTier");
        this.selTier = (TierImpl)this.transcription.getTierWithId(this.tierName);
        if (this.selTier != null) {
            this.curType = this.selTier.getLinguisticType();
        }
        if ((par = this.multiPane.getStepProperty("SelNewParent")) != null) {
            this.newParentName = (String)par;
            this.newParent = (TierImpl)this.transcription.getTierWithId(this.newParentName);
        } else {
            this.newParentName = "-";
        }
        this.tierOverview.setText("<html><table><tr><td>" + ElanLocale.getString("MultiStep.Reparent.SelectedTier") + " " + "</td><td>" + this.tierName + "</td></tr>" + "<tr><td>" + ElanLocale.getString("MultiStep.Reparent.SelectedParent") + " " + "</td><td>" + this.newParentName + "</td></tr>");
        Constraint con = null;
        if (this.newParent != null) {
            con = this.newParent.getLinguisticType().getConstraints();
        }
        if (this.newParent == null) {
            this.model.showOnlyStereoTypes(new int[]{-1});
        } else if (con == null || con.getStereoType() == 0 || con.getStereoType() == 1) {
            this.model.showOnlyStereoTypes(new int[]{0, 1, 3, 4});
        } else {
            this.model.showOnlyStereoTypes(new int[]{3, 4});
        }
        int col = this.model.findColumn("Type");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object o = this.model.getValueAt(i, col);
            if (!(o instanceof String) || !this.curType.getLinguisticTypeName().equals((String)o)) continue;
            this.selTypeName = (String)o;
            this.typeTable.setRowSelectionInterval(i, i);
            this.multiPane.setButtonEnabled(3, true);
            break;
        }
    }

    public void enterStepBackward() {
    }

    public boolean leaveStepForward() {
        return false;
    }

    public boolean leaveStepBackward() {
        this.multiPane.setButtonEnabled(3, false);
        return true;
    }

    public void cancelled() {
    }

    public void finished() {
    }

    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        this.adjustComponents();
        if (this.tierName != null && this.newParentName != null && this.selTypeName != null) {
            Boolean includeDepTiers = Boolean.TRUE;
            if (this.copyMode) {
                this.com = (CopyTierCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.CopyTier");
                Object include = this.multiPane.getStepProperty("IncludeDepTiers");
                if (include instanceof Boolean) {
                    includeDepTiers = (Boolean)include;
                }
            } else {
                this.com = (CopyTierCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ReparentTier");
            }
            this.com.addProgressListener(this);
            this.com.execute(this.transcription, new Object[]{this.tierName, this.newParentName, this.selTypeName, includeDepTiers});
            return false;
        }
        this.progressLabel.setText("Illegal selection");
        this.multiPane.setButtonEnabled(4, true);
        this.multiPane.setButtonEnabled(2, true);
        return false;
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int row = this.typeTable.getSelectedRow();
            if (row > -1) {
                int col = this.model.findColumn("Type");
                String typeName = (String)this.model.getValueAt(row, col);
                for (int i = 0; i < this.types.size(); ++i) {
                    LinguisticType t = (LinguisticType)this.types.get(i);
                    if (!t.getLinguisticTypeName().equals(typeName)) continue;
                    this.selTypeName = typeName;
                    break;
                }
                this.multiPane.setButtonEnabled(3, true);
            } else {
                this.multiPane.setButtonEnabled(3, false);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        int row;
        String typeName = null;
        if (this.typeTable.getRowCount() > 0 && (row = this.typeTable.getSelectedRow()) > -1) {
            int col = this.model.findColumn("Type");
            typeName = (String)this.model.getValueAt(row, col);
        }
        new EditTypeDialog(null, true, this.transcription, 0).setVisible(true);
        for (int i = 0; i < this.types.size(); ++i) {
            this.model.addLinguisticType((LinguisticType)this.types.get(i));
        }
        if (typeName != null) {
            int col = this.model.findColumn("Type");
            String name = null;
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                name = (String)this.model.getValueAt(i, col);
                if (!typeName.equals(name)) continue;
                this.typeTable.setRowSelectionInterval(i, i);
                this.multiPane.setButtonEnabled(3, true);
                break;
            }
        }
    }

    protected void endOfProcess() {
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        this.multiPane.close();
    }
}

