/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayableContentTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private String[][] rowData;
    private List<JTable> connectedTables = new ArrayList<JTable>();

    private DisplayableContentTableModel() {
    }

    public DisplayableContentTableModel(int nrColumns) {
        this();
        this.columnNames = new String[nrColumns];
        this.rowData = null;
    }

    public DisplayableContentTableModel(String message) {
        this();
        this.columnNames = new String[1];
        this.rowData = new String[1][1];
        this.rowData[0][0] = message;
    }

    public DisplayableContentTableModel(String message, JTable table) {
        this(message);
        this.connectedTables.add(table);
    }

    public DisplayableContentTableModel(String[] messages) {
        this();
        this.columnNames = new String[1];
        this.rowData = new String[messages.length][1];
        for (int i = 0; i < messages.length; ++i) {
            this.rowData[i][0] = messages[i];
        }
    }

    public DisplayableContentTableModel(String[] colValues, Collection<String> rowValues) {
        this();
        this.columnNames = new String[colValues.length];
        this.rowData = new String[rowValues.size()][colValues.length];
        for (int c = 0; c < colValues.length; ++c) {
            this.columnNames[c] = colValues[c];
        }
        Object[] o = rowValues.toArray();
        for (int r = 0; r < rowValues.size(); ++r) {
            this.rowData[r][0] = o[r].toString();
        }
    }

    public DisplayableContentTableModel(String[] messages, JTable table) {
        this(messages);
        this.connectedTables.add(table);
    }

    public DisplayableContentTableModel(String[] values, int nRows) {
        this();
        int nColumns = values.length;
        this.columnNames = new String[nColumns];
        this.rowData = new String[nRows][nColumns];
        for (int c = 0; c < nColumns; ++c) {
            this.columnNames[c] = values[c];
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public void addRow(String[] data) {
        int nrRows = this.getRowCount();
        int nrCols = this.getColumnCount();
        String[][] oldRowData = this.rowData;
        this.rowData = new String[nrRows + 1][nrCols];
        for (int r = 0; r < nrRows; ++r) {
            for (int c = 0; c < nrCols; ++c) {
                this.rowData[r][c] = oldRowData[r][c];
            }
        }
        for (int c = 0; c < data.length; ++c) {
            this.rowData[nrRows][c] = data[c];
        }
        this.updateTables();
    }

    public void removeRow(int rowNr) {
        int nrRows = this.getRowCount();
        int nrCols = this.getColumnCount();
        String[][] oldRowData = this.rowData;
        this.rowData = new String[nrRows - 1][nrCols];
        for (int r = 0; r < nrRows - 1; ++r) {
            for (int c = 0; c < nrCols; ++c) {
                this.rowData[r][c] = r >= rowNr ? oldRowData[r + 1][c] : oldRowData[r][c];
            }
        }
        this.updateTables();
    }

    public void updateMessage(int row, String newMessage) {
        this.rowData[row][0] = newMessage;
        this.updateTables();
    }

    @Override
    public int getRowCount() {
        if (this.rowData == null) {
            return 0;
        }
        return this.rowData.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.rowData[row][column];
    }

    public void setValueAt(String value, int rowIndex, int colIndex) {
        this.rowData[rowIndex][colIndex] = value;
    }

    public void setValues(String[] values, int columnNr) {
        for (int r = 0; r < values.length; ++r) {
            this.rowData[r][columnNr] = values[r];
        }
    }

    public void updateTables() {
        for (JTable t : this.connectedTables) {
            t.repaint();
            t.revalidate();
        }
    }

    public void connectTable(JTable table) {
        this.connectedTables.add(table);
    }

    public void addRowAt(String[] data, int rowIndex) {
        int nrRows = this.getRowCount();
        int nrCols = this.getColumnCount();
        String[][] oldRowData = this.rowData;
        this.rowData = new String[nrRows + 1][nrCols];
        for (int r = 0; r < nrRows; ++r) {
            for (int c = 0; c < nrCols; ++c) {
                if (r >= rowIndex) {
                    this.rowData[r + 1][c] = oldRowData[r][c];
                    continue;
                }
                this.rowData[r][c] = oldRowData[r][c];
            }
        }
        for (int c = 0; c < data.length; ++c) {
            this.rowData[rowIndex][c] = data[c];
        }
        this.updateTables();
    }

    public boolean contains(String tierName, int column) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, column)).equals(tierName)) continue;
            return true;
        }
        return false;
    }
}

