/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportOverlapsStep1
extends StepPane
implements ListSelectionListener {
    private ArrayList<String> tierNames;
    protected TierExportTableModel model1;
    protected TierExportTableModel model2;
    protected JTable table1;
    protected JTable table2;
    protected JLabel firstLabel;
    protected JLabel secLabel;
    protected final String SELECT_COLUMN = "select";
    protected final String TIER_NAME_COLUMN = "tier";

    public ExportOverlapsStep1(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
        SwingUtilities.invokeLater(new LoadThread());
    }

    @Override
    protected void initComponents() {
        this.model1 = new TierExportTableModel();
        this.model2 = new TierExportTableModel();
        this.model1.setColumnIdentifiers(new String[]{"tier"});
        this.model2.setColumnIdentifiers(new String[]{"select", "tier"});
        this.table1 = new JTable(this.model1);
        this.table1.getSelectionModel().setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(this);
        this.table1.setTableHeader(null);
        this.table1.getSelectionModel().addListSelectionListener(this);
        this.table2 = new JTable(this.model2);
        this.table2.getSelectionModel().setSelectionMode(2);
        this.table2.getSelectionModel().addListSelectionListener(this);
        this.table2.getColumn("select").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.table2.getColumn("select").setCellRenderer(new CheckBoxTableCellRenderer());
        this.table2.getColumn("select").setMaxWidth(30);
        this.table2.setShowVerticalLines(false);
        this.table2.setTableHeader(null);
        this.model1.addRow(new Object[]{"Loading tiers..."});
        Dimension prdim = new Dimension(120, 80);
        JScrollPane p1 = new JScrollPane(this.table1);
        p1.setPreferredSize(prdim);
        JScrollPane p2 = new JScrollPane(this.table2);
        p2.setPreferredSize(prdim);
        this.firstLabel = new JLabel(ElanLocale.getString("ExportOverlapsDialog.Label.RefTier"));
        this.secLabel = new JLabel(ElanLocale.getString("ExportOverlapsDialog.Label.OtherTiers"));
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)this.firstLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)p1, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add((Component)this.secLabel, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)p2, gbc);
    }

    private void extractTierNames() {
        ArrayList files = (ArrayList)this.multiPane.getStepProperty("files");
        this.tierNames = new ArrayList();
        if (files == null || files.size() == 0) {
            return;
        }
        for (File f : files) {
            if (f == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(f.getAbsolutePath());
                Vector tiers = trans.getTiers();
                for (int i = 0; i < tiers.size(); ++i) {
                    Tier tier = (Tier)tiers.get(i);
                    String name = tier.getName();
                    if (this.tierNames.contains(name)) continue;
                    this.tierNames.add(name);
                }
            }
            catch (Exception ex) {
            }
        }
        Collections.sort(this.tierNames);
        this.model1.removeRow(0);
        for (String tname : this.tierNames) {
            this.model1.addRow(new Object[]{tname});
            this.model2.addRow(new Object[]{Boolean.FALSE, tname});
        }
    }

    private List<String> getSelectedTiers2() {
        int includeCol = this.model2.findColumn("select");
        int nameCol = this.model2.findColumn("tier");
        ArrayList<String> selectedTiers = new ArrayList<String>();
        for (int i = 0; i < this.model2.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model2.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            selectedTiers.add((String)this.model2.getValueAt(i, nameCol));
        }
        return selectedTiers;
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportOverlapsDialog.SelectTiers");
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    @Override
    public boolean leaveStepForward() {
        int row1 = this.table1.getSelectedRow();
        if (row1 < 0) {
            return false;
        }
        String refTier = (String)this.table1.getValueAt(row1, 0);
        List<String> selTiers2 = this.getSelectedTiers2();
        selTiers2.remove(refTier);
        if (selTiers2.size() > 0) {
            this.multiPane.putStepProperty("Tier-1", refTier);
            this.multiPane.putStepProperty("Tiers-2", selTiers2);
            return true;
        }
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        int i;
        if (lse.getSource() == this.table2.getSelectionModel() && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model2.findColumn("select");
            for (i = b; i <= e; ++i) {
                if (!this.table2.isRowSelected(i)) continue;
                this.model2.setValueAt(Boolean.TRUE, i, col);
            }
        }
        int row1 = this.table1.getSelectedRow();
        int includeCol = this.model2.findColumn("select");
        ArrayList<Integer> selectedTiers = new ArrayList<Integer>();
        for (i = 0; i < this.model2.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model2.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            selectedTiers.add(i);
        }
        int[] rows2 = new int[selectedTiers.size()];
        for (int i2 = 0; i2 < selectedTiers.size(); ++i2) {
            rows2[i2] = (Integer)selectedTiers.get(i2);
        }
        if (row1 > -1 && rows2.length > 0) {
            if (rows2.length == 1 && rows2[0] == row1) {
                this.multiPane.setButtonEnabled(1, false);
            } else {
                this.multiPane.setButtonEnabled(1, true);
            }
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }

    class LoadThread
    extends Thread {
        LoadThread() {
        }

        public void run() {
            ExportOverlapsStep1.this.extractTierNames();
        }
    }
}

