/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ExportOverlapsMultiCommand;
import mpi.eudico.client.annotator.gui.FileAndEncodingChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;

public class ExportOverlapsStep2
extends ProgressStepPane {
    protected String encoding = "UTF-8";

    public ExportOverlapsStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    public void enterStepForward() {
        this.doFinish();
    }

    public boolean doFinish() {
        this.completed = false;
        this.multiPane.setButtonEnabled(8, false);
        File f = this.promptForFile(ElanLocale.getString("ExportTabDialog.Title"), FileExtension.TEXT_EXT, ElanFileFilter.createFileFilter(11), true, null);
        if (f != null) {
            String refTier = (String)this.multiPane.getStepProperty("Tier-1");
            List selTiers2 = (List)this.multiPane.getStepProperty("Tiers-2");
            ArrayList files = (ArrayList)this.multiPane.getStepProperty("files");
            ArrayList<String> filePaths = new ArrayList<String>(files.size());
            for (File ff : files) {
                filePaths.add(ff.getAbsolutePath());
            }
            ExportOverlapsMultiCommand expCom = new ExportOverlapsMultiCommand("ExportOverlapMulti");
            expCom.addProgressListener(this);
            expCom.execute(null, new Object[]{filePaths, refTier, selTiers2, f.getAbsolutePath(), this.encoding});
        } else {
            this.multiPane.setButtonEnabled(4, true);
            this.multiPane.previousStep();
        }
        return false;
    }

    public String getStepTitle() {
        return ElanLocale.getString("ExportOverlapsDialog.Exporting");
    }

    protected File promptForFile(String chooserTitle, String[] extensions, FileFilter filter, boolean showEncodingBox, String[] encodings) {
        JFileChooser chooser = null;
        if (showEncodingBox) {
            chooser = new FileAndEncodingChooser();
            if (encodings != null) {
                ((FileAndEncodingChooser)chooser).setEncodings(encodings);
                for (int i = encodings.length - 1; i >= 0; --i) {
                    if ("UTF-8".equals(encodings[i])) {
                        ((FileAndEncodingChooser)chooser).setSelectedEncoding(encodings[i]);
                        break;
                    }
                    if (i != 0) continue;
                    ((FileAndEncodingChooser)chooser).setSelectedEncoding(encodings[0]);
                }
            } else {
                ((FileAndEncodingChooser)chooser).setSelectedEncoding("UTF-8");
            }
        } else {
            chooser = new JFileChooser();
        }
        String exportDir = (String)Preferences.get("LastUsedExportDir", null);
        if (exportDir != null) {
            chooser.setCurrentDirectory(new File(exportDir));
        }
        chooser.setDialogTitle(chooserTitle);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(this) == 0) {
            int answer;
            Preferences.set("LastUsedExportDir", chooser.getCurrentDirectory().getAbsolutePath(), null);
            File exportFile = chooser.getSelectedFile();
            if (showEncodingBox) {
                this.encoding = ((FileAndEncodingChooser)chooser).getSelectedEncoding();
            }
            String name = exportFile.getAbsolutePath();
            String lowerPathName = name.toLowerCase();
            boolean validExt = false;
            for (int i = 0; i < extensions.length; ++i) {
                if (!lowerPathName.endsWith("." + extensions[i].toLowerCase())) continue;
                validExt = true;
                break;
            }
            if (!validExt) {
                name = name + "." + extensions[0];
                exportFile = new File(name);
            }
            if (exportFile.exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                return this.promptForFile(chooserTitle, extensions, filter, showEncodingBox, encodings);
            }
            return exportFile;
        }
        return null;
    }
}

