/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.event.ActionListener;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SelectableContentTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private Object[][] rowData;
    private JTable tableWithThisModel;
    private ActionListener actionListener;

    public SelectableContentTableModel(Set content, JTable table) {
        this.columnNames = new String[2];
        this.rowData = new Object[content.size()][2];
        this.tableWithThisModel = table;
        this.actionListener = null;
        Object[] contentArray = content.toArray();
        for (int i = 0; i < contentArray.length; ++i) {
            this.rowData[i][0] = new Boolean(false);
            this.rowData[i][1] = contentArray[i];
        }
    }

    public SelectableContentTableModel(JTable table, Object[] ... columnData) {
        int nrArguments = columnData.length;
        this.columnNames = new String[nrArguments + 1];
        this.rowData = new Object[columnData[0].length][nrArguments + 1];
        this.tableWithThisModel = table;
        this.actionListener = null;
        for (int i = 0; i < columnData[0].length; ++i) {
            this.rowData[i][0] = new Boolean(false);
            for (int j = 0; j < nrArguments; ++j) {
                this.rowData[i][j + 1] = columnData[j][i];
            }
        }
    }

    public int getRowCount() {
        return this.rowData.length;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Object getValueAt(int row, int column) {
        return this.rowData[row][column];
    }

    public void addActionListener(ActionListener a) {
        this.actionListener = a;
    }

    public void setValueAt(Object object, int row, int column) {
        if (this.getColumnCount() > column && this.getRowCount() > row) {
            this.rowData[row][column] = object;
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(null);
        }
    }

    public void selectAll() {
        if (this.getColumnCount() > 0) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(true, i, 0);
            }
        }
        this.tableWithThisModel.repaint();
    }

    public Vector getSelectedValues() {
        Vector<Object> selectedValues = new Vector<Object>();
        for (int i = 0; i < this.rowData.length; ++i) {
            if (!((Boolean)this.rowData[i][0]).booleanValue()) continue;
            selectedValues.add(this.rowData[i][1]);
        }
        return selectedValues;
    }

    public void selectNone() {
        if (this.getColumnCount() > 0) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(false, i, 0);
            }
        }
        this.tableWithThisModel.repaint();
    }

    public boolean nothingSelected() {
        for (int r = 0; r < this.getRowCount(); ++r) {
            if (!((Boolean)this.getValueAt(r, 0)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isCellEditable(int row, int col) {
        return col <= 0;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }
}

