/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;

public class ContinuousRateTSTrack
extends AbstractTSTrack {
    private float sampleRate;
    private float msPerSample;
    private float[] data;

    public void setSampleRate(float rate) {
        this.sampleRate = rate;
        this.msPerSample = 1000.0f / this.sampleRate;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        if (!(data instanceof float[])) {
            throw new IllegalArgumentException("This track only accepts an array of floats");
        }
        this.data = (float[])data;
    }

    public int getIndexForTime(long time) {
        int index = -1;
        if (time + (long)this.timeOffset >= 0L) {
            index = this.msPerSample >= 1.0f ? (int)((float)(time + (long)this.timeOffset) / this.msPerSample) : (int)Math.ceil((float)(time + (long)this.timeOffset) / this.msPerSample);
        }
        return index;
    }

    public long getTimeForIndex(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index should be greater than or equal to 0");
        }
        long time = 0L;
        if (this.data != null) {
            if (index >= this.data.length) {
                throw new ArrayIndexOutOfBoundsException("Index (" + index + ") is greater than " + (this.data.length - 1));
            }
            time = (long)((float)index * this.msPerSample);
        }
        return time - (long)this.timeOffset;
    }

    public float getAverage(long begin, long end) {
        if (this.data == null || this.data.length == 0) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        if (bi > this.data.length - 1) {
            return Float.NaN;
        }
        if (ei > this.data.length - 1) {
            ei = this.data.length - 1;
        }
        if (bi == ei) {
            long time = this.getTimeForIndex(bi);
            if (begin <= time - (long)this.timeOffset && end >= time - (long)this.timeOffset) {
                return this.data[bi];
            }
            if (time - (long)this.timeOffset < begin) {
                if (bi < this.data.length - 1) {
                    if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi + 1])) {
                        return (this.data[bi] + this.data[bi + 1]) / 2.0f;
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (bi > 0) {
                if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi - 1])) {
                    return (this.data[bi] + this.data[bi - 1]) / 2.0f;
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        int count = 0;
        float total = 0.0f;
        for (int i = bi; i <= ei && i < this.data.length; ++i) {
            if (Float.isNaN(this.data[i])) continue;
            total += this.data[i];
            ++count;
        }
        if (count == 0) {
            return Float.NaN;
        }
        return total / (float)count;
    }

    public float getMaximum(long begin, long end) {
        if (this.data == null || this.data.length == 0) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        if (bi > this.data.length - 1) {
            return Float.NaN;
        }
        if (ei > this.data.length - 1) {
            ei = this.data.length - 1;
        }
        if (bi == ei) {
            long time = this.getTimeForIndex(bi);
            if (begin <= time - (long)this.timeOffset && end >= time - (long)this.timeOffset) {
                return this.data[bi];
            }
            if (time - (long)this.timeOffset < begin) {
                if (bi < this.data.length - 1) {
                    if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi + 1])) {
                        return this.data[bi] > this.data[bi + 1] ? this.data[bi] : this.data[bi + 1];
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (bi > 0) {
                if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi - 1])) {
                    return this.data[bi] > this.data[bi - 1] ? this.data[bi] : this.data[bi - 1];
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        float max = -2.1474836E9f;
        int count = 0;
        for (int i = bi; i <= ei && i < this.data.length; ++i) {
            if (Float.isNaN(this.data[i])) continue;
            if (this.data[i] > max) {
                max = this.data[i];
            }
            ++count;
        }
        if (count > 0) {
            return max;
        }
        return Float.NaN;
    }

    public float getMinimum(long begin, long end) {
        if (this.data == null || this.data.length == 0) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        if (bi > this.data.length - 1) {
            return Float.NaN;
        }
        if (ei > this.data.length - 1) {
            ei = this.data.length - 1;
        }
        if (bi == ei) {
            long time = this.getTimeForIndex(bi);
            if (begin <= time - (long)this.timeOffset && end >= time - (long)this.timeOffset) {
                return this.data[bi];
            }
            if (time - (long)this.timeOffset < begin) {
                if (bi < this.data.length - 1) {
                    if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi + 1])) {
                        return this.data[bi] < this.data[bi + 1] ? this.data[bi] : this.data[bi + 1];
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (bi > 0) {
                if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi - 1])) {
                    return this.data[bi] < this.data[bi - 1] ? this.data[bi] : this.data[bi - 1];
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        float min = 2.1474836E9f;
        int count = 0;
        for (int i = bi; i <= ei && i < this.data.length; ++i) {
            if (Float.isNaN(this.data[i])) continue;
            if (this.data[i] < min) {
                min = this.data[i];
            }
            ++count;
        }
        if (count > 0) {
            return min;
        }
        return Float.NaN;
    }

    public float getSum(long begin, long end) {
        if (this.data == null || this.data.length == 0) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        if (bi > this.data.length - 1) {
            return Float.NaN;
        }
        if (ei > this.data.length - 1) {
            ei = this.data.length - 1;
        }
        if (bi == ei) {
            long time = this.getTimeForIndex(bi);
            if (begin <= time - (long)this.timeOffset && end >= time - (long)this.timeOffset) {
                return this.data[bi];
            }
            if (time - (long)this.timeOffset < begin) {
                if (bi < this.data.length - 1) {
                    if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi + 1])) {
                        return this.data[bi] + this.data[bi + 1];
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (bi > 0) {
                if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi - 1])) {
                    return this.data[bi] + this.data[bi - 1];
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        float sum = 0.0f;
        int count = 0;
        for (int i = bi; i <= ei && i < this.data.length; ++i) {
            if (Float.isNaN(this.data[i])) continue;
            sum += this.data[i];
            ++count;
        }
        if (count > 0) {
            return sum;
        }
        return Float.NaN;
    }

    public float getValueAtBegin(long begin, long end) {
        if (this.data == null || this.data.length == 0) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        if (bi > this.data.length - 1) {
            return Float.NaN;
        }
        if (ei > this.data.length - 1) {
            ei = this.data.length - 1;
        }
        if (bi == ei) {
            long time = this.getTimeForIndex(bi);
            if (begin <= time - (long)this.timeOffset && end >= time - (long)this.timeOffset) {
                return this.data[bi];
            }
            if (time - (long)this.timeOffset < begin) {
                if (bi < this.data.length - 1) {
                    if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi + 1])) {
                        return this.data[bi];
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (bi > 0) {
                if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi - 1])) {
                    return this.data[bi - 1];
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        return this.data[bi];
    }

    public float getValueAtEnd(long begin, long end) {
        if (this.data == null || this.data.length == 0) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        if (bi > this.data.length - 1) {
            return Float.NaN;
        }
        if (ei > this.data.length - 1) {
            ei = this.data.length - 1;
        }
        if (bi == ei) {
            long time = this.getTimeForIndex(bi);
            if (begin <= time - (long)this.timeOffset && end >= time - (long)this.timeOffset) {
                return this.data[bi];
            }
            if (time - (long)this.timeOffset < begin) {
                if (bi < this.data.length - 1) {
                    if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi + 1])) {
                        return this.data[bi + 1];
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (bi > 0) {
                if (!Float.isNaN(this.data[bi]) && !Float.isNaN(this.data[bi - 1])) {
                    return this.data[bi];
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        return this.data[ei];
    }
}

