/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.csv.CSVWriter;
import mpi.eudico.client.annotator.timeseries.xml.XMLWriter;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;

public class ExportTrack {
    public void exportTrack(AbstractTSTrack track) {
        this.exportTrack(null, track);
    }

    public void exportTrack(Component parent, AbstractTSTrack track) {
        if (track == null) {
            return;
        }
        String savePath = this.promptForTierFile(parent, track.getSource());
        if (savePath != null) {
            File tf = new File(savePath);
            try {
                int answer;
                if (tf.exists() && (answer = JOptionPane.showConfirmDialog(parent, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) == 1) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            String lower = savePath.toLowerCase();
            if (lower.endsWith("csv")) {
                try {
                    new CSVWriter().writeTrackToCSV(tf, track);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(parent, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                }
            } else {
                try {
                    new XMLWriter().writeTrackToXML(tf, track);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(parent, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                }
            }
        }
    }

    private String promptForTierFile(Component parent, String source) {
        Object val;
        int index;
        String prefPath = null;
        if (source != null && (index = (source = source.replaceAll("\\", "/")).lastIndexOf(47)) > -1) {
            prefPath = source.substring(index);
        }
        if (prefPath == null && (val = Preferences.get("LinkedFileDir", null)) instanceof String) {
            prefPath = (String)val;
        }
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = ElanFileFilter.createFileFilter(20);
        FileFilter ff2 = ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.addChoosableFileFilter(ff2);
        chooser.setFileFilter(ff2);
        if (chooser.showSaveDialog(parent) == 0) {
            File f = chooser.getSelectedFile();
            File par = f.getParentFile();
            if (par != null && par.isDirectory()) {
                Preferences.set("LinkedFileDir", par.getAbsolutePath(), null);
            }
            if (chooser.getFileFilter() == ff) {
                String lower = f.getAbsolutePath().toLowerCase();
                boolean valid = false;
                for (int i = 0; i < FileExtension.CSV_EXT.length; ++i) {
                    if (!lower.endsWith(FileExtension.CSV_EXT[i])) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    f = new File(f.getAbsolutePath() + "." + FileExtension.CSV_EXT[0]);
                }
            } else if (!f.getAbsolutePath().toLowerCase().endsWith("xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            return f.getAbsolutePath();
        }
        return null;
    }
}

