/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.util.Collections;
import java.util.List;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TimeValue;
import mpi.eudico.client.annotator.timeseries.TimeValueStart;

public class NonContinuousRateTSTrack
extends AbstractTSTrack {
    private List data;

    public NonContinuousRateTSTrack() {
        this.setType(11);
    }

    public NonContinuousRateTSTrack(String name, String description) {
        super(name, description, 11);
    }

    public int getIndexForTime(long time) {
        TimeValue key;
        if (time < 0L) {
            throw new IllegalArgumentException("Time should be greater than or equal to 0: " + time);
        }
        if (this.data == null || this.data.isEmpty()) {
            return -1;
        }
        int index = -1;
        if (time + (long)this.timeOffset >= 0L && (index = Collections.binarySearch(this.data, key = new TimeValue(time + (long)this.timeOffset, 0.0f))) < 0 && (index = -(index + 1)) > 0) {
            --index;
        }
        return index;
    }

    public long getTimeForIndex(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index should be greater than or equal to 0");
        }
        long time = 0L;
        if (this.data != null) {
            if (index >= this.data.size()) {
                throw new ArrayIndexOutOfBoundsException("Index (" + index + ") is greater than " + (this.data.size() - 1));
            }
            time = ((TimeValue)this.data.get((int)index)).time;
        }
        return time - (long)this.timeOffset;
    }

    public void setSampleRate(float rate) {
    }

    public float getSampleRate() {
        return 0.0f;
    }

    public int getSampleCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        if (!(data instanceof List)) {
            throw new IllegalArgumentException("This track only accepts a List of TimeValue objects");
        }
        this.data = (List)data;
    }

    public float getMinimum(long begin, long end) {
        int ei;
        if (this.data == null || this.data.isEmpty()) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        if (bi == (ei = this.getIndexForTime(end))) {
            TimeValue tv = (TimeValue)this.data.get(bi);
            if (begin <= tv.time - (long)this.timeOffset && tv.time - (long)this.timeOffset <= end) {
                return tv.value;
            }
            if (tv.time - (long)this.timeOffset < begin) {
                if (bi < this.data.size() - 1) {
                    TimeValue tv2 = (TimeValue)this.data.get(bi + 1);
                    if (!(tv2 instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                        return tv2.value < tv.value ? tv2.value : tv.value;
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (ei > 0) {
                TimeValue tv2 = (TimeValue)this.data.get(ei - 1);
                if (!(tv instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                    return tv2.value < tv.value ? tv2.value : tv.value;
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        float min = 2.1474836E9f;
        for (int i = bi; i <= ei && i < this.data.size(); ++i) {
            float val = ((TimeValue)this.data.get((int)i)).value;
            if (Float.isNaN(val) || !(val < min)) continue;
            min = val;
        }
        if (min == 2.1474836E9f) {
            return Float.NaN;
        }
        return min;
    }

    public float getMaximum(long begin, long end) {
        int ei;
        if (this.data == null || this.data.isEmpty()) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        if (bi == (ei = this.getIndexForTime(end))) {
            TimeValue tv = (TimeValue)this.data.get(bi);
            if (begin <= tv.time - (long)this.timeOffset && tv.time - (long)this.timeOffset <= end) {
                return tv.value;
            }
            if (tv.time - (long)this.timeOffset < begin) {
                if (bi < this.data.size() - 1) {
                    TimeValue tv2 = (TimeValue)this.data.get(bi + 1);
                    if (!(tv2 instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                        return tv2.value > tv.value ? tv2.value : tv.value;
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (ei > 0) {
                TimeValue tv2 = (TimeValue)this.data.get(ei - 1);
                if (!(tv instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                    return tv2.value > tv.value ? tv2.value : tv.value;
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        float max = -2.1474836E9f;
        for (int i = bi; i <= ei && i < this.data.size(); ++i) {
            float val = ((TimeValue)this.data.get((int)i)).value;
            if (!(!Float.isNaN(val) & val > max)) continue;
            max = val;
        }
        if (max == -2.1474836E9f) {
            return Float.NaN;
        }
        return max;
    }

    public float getAverage(long begin, long end) {
        int ei;
        if (this.data == null || this.data.isEmpty()) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        if (bi == (ei = this.getIndexForTime(end))) {
            TimeValue tv = (TimeValue)this.data.get(bi);
            if (begin <= tv.time - (long)this.timeOffset && tv.time - (long)this.timeOffset <= end) {
                return tv.value;
            }
            if (tv.time - (long)this.timeOffset < begin) {
                if (bi < this.data.size() - 1) {
                    TimeValue tv2 = (TimeValue)this.data.get(bi + 1);
                    if (!(tv2 instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                        return (tv2.value + tv.value) / 2.0f;
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (ei > 0) {
                TimeValue tv2 = (TimeValue)this.data.get(ei - 1);
                if (!(tv instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                    return (tv2.value + tv.value) / 2.0f;
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        int count = 0;
        float total = 0.0f;
        for (int i = bi; i <= ei && i < this.data.size(); ++i) {
            TimeValue tv = (TimeValue)this.data.get(i);
            if (Float.isNaN(tv.value)) continue;
            total += tv.value;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total / (float)count;
    }

    public float getSum(long begin, long end) {
        int ei;
        if (this.data == null || this.data.isEmpty()) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        if (bi == (ei = this.getIndexForTime(end))) {
            TimeValue tv = (TimeValue)this.data.get(bi);
            if (begin <= tv.time - (long)this.timeOffset && tv.time - (long)this.timeOffset <= end) {
                return tv.value;
            }
            if (tv.time - (long)this.timeOffset < begin) {
                if (bi < this.data.size() - 1) {
                    TimeValue tv2 = (TimeValue)this.data.get(bi + 1);
                    if (!(tv2 instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                        return tv2.value + tv.value;
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (ei > 0) {
                TimeValue tv2 = (TimeValue)this.data.get(ei - 1);
                if (!(tv instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                    return tv2.value + tv.value;
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        int count = 0;
        float total = 0.0f;
        for (int i = bi; i <= ei && i < this.data.size(); ++i) {
            TimeValue tv = (TimeValue)this.data.get(i);
            if (Float.isNaN(tv.value)) continue;
            total += tv.value;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total;
    }

    public float getValueAtBegin(long begin, long end) {
        int ei;
        if (this.data == null || this.data.isEmpty()) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        if (bi == (ei = this.getIndexForTime(end))) {
            TimeValue tv = (TimeValue)this.data.get(bi);
            if (begin <= tv.time - (long)this.timeOffset && tv.time - (long)this.timeOffset <= end) {
                return tv.value;
            }
            if (tv.time - (long)this.timeOffset < begin) {
                if (bi < this.data.size() - 1) {
                    TimeValue tv2 = (TimeValue)this.data.get(bi + 1);
                    if (!(tv2 instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                        return tv.value;
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (ei > 0) {
                TimeValue tv2 = (TimeValue)this.data.get(ei - 1);
                if (!(tv instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                    return tv.value;
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        return ((TimeValue)this.data.get((int)bi)).value;
    }

    public float getValueAtEnd(long begin, long end) {
        int ei;
        if (this.data == null || this.data.isEmpty()) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        int bi = this.getIndexForTime(begin);
        if (bi == (ei = this.getIndexForTime(end))) {
            TimeValue tv = (TimeValue)this.data.get(bi);
            if (begin <= tv.time - (long)this.timeOffset && tv.time - (long)this.timeOffset <= end) {
                return tv.value;
            }
            if (tv.time - (long)this.timeOffset < begin) {
                if (bi < this.data.size() - 1) {
                    TimeValue tv2 = (TimeValue)this.data.get(bi + 1);
                    if (!(tv2 instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                        return tv2.value;
                    }
                    return Float.NaN;
                }
                return Float.NaN;
            }
            if (ei > 0) {
                TimeValue tv2 = (TimeValue)this.data.get(ei - 1);
                if (!(tv instanceof TimeValueStart || Float.isNaN(tv.value) || Float.isNaN(tv2.value))) {
                    return tv2.value;
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        return ((TimeValue)this.data.get((int)ei)).value;
    }
}

