/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JFrame;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.timeseries.ContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.NonContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.TSRulerImpl;
import mpi.eudico.client.annotator.timeseries.TSTrackPanelImpl;
import mpi.eudico.client.annotator.timeseries.TimeValue;
import mpi.eudico.client.annotator.timeseries.TimeValueStart;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;

public class TSTestFrame
extends JFrame {
    public TSTestFrame() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Track viewer");
        this.initComponents();
        this.setSize(500, 400);
    }

    private void initComponents() {
        float[] range = new float[]{2.0f, 10.0f};
        float[] range2 = new float[]{-20.0f, 60.0f};
        ContinuousRateTSTrack track = this.createDummyTrack(range, 25.0f);
        ContinuousRateTSTrack track2 = this.createDummyTrack(range, 150.0f);
        NonContinuousRateTSTrack track3 = this.createNCRTrack(range2);
        track2.setColor(Color.ORANGE);
        TSTrackPanelImpl panel = new TSTrackPanelImpl();
        panel.setMargin(new Insets(3, 3, 3, 0));
        panel.setHeight(300);
        panel.setWidth(450);
        TSRulerImpl ruler = new TSRulerImpl(range, 30, 200);
        ruler.setFont(Constants.SMALLFONT);
        ruler.setUnitString("m/s2");
        panel.setRuler(ruler);
        panel.addTrack(track2);
        panel.addTrack(track);
        TSTrackPanelImpl panel2 = new TSTrackPanelImpl();
        panel2.setMargin(new Insets(3, 3, 3, 0));
        panel2.setHeight(300);
        panel2.setWidth(450);
        TSRulerImpl ruler2 = new TSRulerImpl(new float[]{0.0f, 60.0f}, 30, 200);
        ruler2.setFont(Constants.SMALLFONT);
        ruler2.setUnitString("m/s");
        panel2.setRuler(ruler2);
        TSTrackPanelImpl panel3 = new TSTrackPanelImpl();
        panel3.setMargin(new Insets(3, 3, 3, 0));
        panel3.setHeight(300);
        panel3.setWidth(450);
        TSRulerImpl ruler3 = new TSRulerImpl(range2, 30, 200);
        ruler3.setFont(Constants.SMALLFONT);
        ruler3.setUnitString("xxx");
        panel3.setRuler(ruler3);
        panel3.addTrack(track3);
        TimeSeriesViewer viewer = new TimeSeriesViewer();
        viewer.addTSTrackPanel(panel);
        viewer.addTSTrackPanel(panel3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(viewer);
    }

    private ContinuousRateTSTrack createDummyTrack(float[] range, float rate) {
        ContinuousRateTSTrack track = new ContinuousRateTSTrack();
        track.setType(1);
        track.setRange(range);
        track.setColor(Color.MAGENTA);
        track.setSampleRate(rate);
        float[] data = new float[(int)(rate * 10.0f)];
        float val = (range[1] - range[0]) / 2.0f;
        float dif = (range[1] - range[0]) / 10.0f;
        for (int i = 0; i < data.length; ++i) {
            data[i] = val;
            if (dif > 0.0f) {
                if (val + dif > range[1]) {
                    dif = -dif;
                }
            } else if (val + dif < range[0]) {
                dif = -dif;
            }
            val += dif;
        }
        track.setData(data);
        return track;
    }

    private NonContinuousRateTSTrack createNCRTrack(float[] range) {
        NonContinuousRateTSTrack track = new NonContinuousRateTSTrack("non-c", "nc test track");
        track.setRange(range);
        track.setColor(Color.GREEN);
        ArrayList<TimeValue> data = new ArrayList<TimeValue>(100);
        float ext = range[1] - range[0];
        int i = 0;
        int j = 0;
        while (i < 30000) {
            float v = range[0] + (float)(Math.random() * (double)ext);
            if (j % 10 != 0) {
                data.add(new TimeValue(i, v));
            } else {
                data.add(new TimeValueStart(i += 400, v));
            }
            i += (int)(Math.random() * 100.0);
            i += 200;
            ++j;
        }
        track.setData(data);
        return track;
    }

    public static void main(String[] args) {
        new TSTestFrame().setVisible(true);
    }
}

