/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TSConfigurationUI;
import mpi.eudico.client.annotator.timeseries.TSViewerPlayer;
import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeEvent;
import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeListener;
import mpi.eudico.client.annotator.timeseries.TimeSeriesTrack;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.io.TSConfigurationEncoder;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceRegistry;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TSTrackManager
implements TimeSeriesChangeListener {
    private TranscriptionImpl transcription;
    private ArrayList tracks;
    private HashMap trackSourceConfigs;
    private ArrayList listeners;
    private TSConfigurationEncoder encoder;
    private TSViewerPlayer syncPlayer;

    public TSTrackManager(Transcription transcription) {
        this.transcription = (TranscriptionImpl)transcription;
        this.tracks = new ArrayList();
        this.trackSourceConfigs = new HashMap();
        this.encoder = new TSConfigurationEncoder();
    }

    public ArrayList getRegisteredTracks() {
        return this.tracks;
    }

    public AbstractTSTrack getTrack(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.tracks.size(); ++i) {
            AbstractTSTrack tr = (AbstractTSTrack)this.tracks.get(i);
            if (!tr.getName().equals(name)) continue;
            return tr;
        }
        return null;
    }

    public Set getConfigKeySet() {
        return this.trackSourceConfigs.keySet();
    }

    public Collection getConfigs() {
        return this.trackSourceConfigs.values();
    }

    public String[] getCurrentSourceNames() {
        try {
            return this.getConfigKeySet().toArray(new String[0]);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public void setOffset(String source, int offset) {
        if (source == null) {
            return;
        }
        TSSourceConfiguration configuration = (TSSourceConfiguration)this.trackSourceConfigs.get(source);
        if (configuration != null) {
            configuration.setTimeOrigin(offset);
            Vector lfds = this.transcription.getLinkedFileDescriptors();
            for (int j = 0; j < lfds.size(); ++j) {
                LinkedFileDescriptor lfd = (LinkedFileDescriptor)lfds.get(j);
                if (!lfd.linkURL.equals(source)) continue;
                lfd.timeOrigin = offset;
                this.transcription.setChanged();
                break;
            }
            for (Object key : configuration.objectKeySet()) {
                Object o = configuration.getObject(key);
                if (o instanceof AbstractTSTrack) {
                    ((AbstractTSTrack)o).setTimeOffset(offset);
                    continue;
                }
                if (!(o instanceof TSTrackConfiguration)) continue;
                TSTrackConfiguration tstc = (TSTrackConfiguration)o;
                Object tr = tstc.getObject(tstc.getTrackName());
                if (tr instanceof AbstractTSTrack) {
                    ((AbstractTSTrack)tr).setTimeOffset(offset);
                    continue;
                }
                for (Object ke : tstc.objectKeySet()) {
                    Object oo = tstc.getObject(ke);
                    if (!(oo instanceof AbstractTSTrack)) continue;
                    ((AbstractTSTrack)oo).setTimeOffset(offset);
                }
            }
            this.notifyListeners(new TimeSeriesChangeEvent(configuration, 1, 100));
            this.encoder.encodeAndSave(this.transcription, this.trackSourceConfigs.values());
        }
    }

    public int getOffset(String source) {
        if (source == null) {
            return 0;
        }
        TSSourceConfiguration configuration = (TSSourceConfiguration)this.trackSourceConfigs.get(source);
        if (configuration != null) {
            return configuration.getTimeOrigin();
        }
        return 0;
    }

    public void configureTracks(Component parent) {
        TSServiceRegistry registry = TSServiceRegistry.getInstance();
        ArrayList<TSSourceConfiguration> configurables = new ArrayList<TSSourceConfiguration>(3);
        Iterator confIt = this.getConfigKeySet().iterator();
        while (confIt.hasNext()) {
            TSSourceConfiguration config = (TSSourceConfiguration)this.trackSourceConfigs.get(confIt.next());
            TSServiceProvider provider = config.getProviderClassName() != null ? registry.getProviderByClassName(config.getProviderClassName()) : registry.getProviderForFile(config.getSource());
            if (provider == null || !provider.isConfigurable()) continue;
            configurables.add(config);
        }
        TSConfigurationUI cui = new TSConfigurationUI();
        switch (configurables.size()) {
            case 0: {
                cui.showNoConfigMessage(parent);
                break;
            }
            case 1: {
                cui.showConfigDialog(parent, (TSSourceConfiguration)configurables.get(0), this);
                break;
            }
            default: {
                TSSourceConfiguration cfg = cui.selectConfigurableSource(parent, configurables);
                if (cfg == null) break;
                cui.showConfigDialog(parent, cfg, this);
            }
        }
    }

    public void addTrack(TSSourceConfiguration sourceConfig, TSTrackConfiguration trackConfig) {
        Object tr;
        if (sourceConfig == null || trackConfig == null) {
            return;
        }
        if (sourceConfig.getObject(trackConfig.getTrackName()) == null) {
            sourceConfig.putObject(trackConfig.getTrackName(), trackConfig);
        }
        if ((tr = trackConfig.getObject(trackConfig.getTrackName())) instanceof TimeSeriesTrack) {
            this.tracks.add(tr);
        } else {
            for (Object key : trackConfig.objectKeySet()) {
                Object oo = trackConfig.getObject(key);
                if (!(oo instanceof TimeSeriesTrack)) continue;
                this.tracks.add(oo);
            }
        }
        this.notifyListeners(new TimeSeriesChangeEvent(trackConfig, 0, 101));
    }

    public void addTrack(TimeSeriesTrack tr) {
        if (tr != null) {
            this.tracks.add(tr);
            this.notifyListeners(new TimeSeriesChangeEvent(tr, 0, 102));
        }
    }

    public void removeTrack(TimeSeriesTrack tr) {
        if (tr != null) {
            this.tracks.remove(tr);
            this.notifyListeners(new TimeSeriesChangeEvent(tr, 2, 102));
        }
    }

    public void removeTrack(TSSourceConfiguration sourceConfig, TSTrackConfiguration trackConfig) {
        Object tr;
        if (sourceConfig == null || trackConfig == null) {
            return;
        }
        if (sourceConfig.getObject(trackConfig.getTrackName()) != null) {
            sourceConfig.removeObject(trackConfig.getTrackName());
        }
        if ((tr = trackConfig.getObject(trackConfig.getTrackName())) instanceof TimeSeriesTrack) {
            this.tracks.remove(tr);
        } else {
            for (Object key : trackConfig.objectKeySet()) {
                Object oo = trackConfig.getObject(key);
                if (!(oo instanceof TimeSeriesTrack)) continue;
                this.tracks.remove(oo);
            }
        }
        this.notifyListeners(new TimeSeriesChangeEvent(trackConfig, 2, 101));
    }

    public void removeTrack(TSSourceConfiguration sourceConfig, TimeSeriesTrack track) {
        if (sourceConfig == null || track == null) {
            return;
        }
        if (sourceConfig.getObject(track.getName()) != null) {
            sourceConfig.removeObject(track.getName());
        }
        this.tracks.remove(track);
        this.notifyListeners(new TimeSeriesChangeEvent(track, 2, 101));
    }

    public void trackChanged(TSTrackConfiguration trackConfig) {
        if (trackConfig == null) {
            return;
        }
        AbstractTSTrack track = null;
        Object tr = trackConfig.getObject(trackConfig.getTrackName());
        if (tr instanceof AbstractTSTrack) {
            track = (AbstractTSTrack)tr;
            if (this.tracks.contains(track)) {
                this.notifyListeners(new TimeSeriesChangeEvent(track, 1, 101));
            }
        } else {
            for (Object key : trackConfig.objectKeySet()) {
                Object oo = trackConfig.getObject(key);
                if (!(oo instanceof AbstractTSTrack) || !this.tracks.contains(track = (AbstractTSTrack)oo)) continue;
                this.notifyListeners(new TimeSeriesChangeEvent(track, 1, 101));
            }
        }
    }

    public void trackChanged(TimeSeriesTrack track) {
        if (track == null) {
            return;
        }
        if (this.tracks.contains(track)) {
            this.notifyListeners(new TimeSeriesChangeEvent(track, 1, 101));
        }
    }

    public void tsSourceChanged(int type) {
        this.notifyListeners(new TimeSeriesChangeEvent(this, type, 100));
        this.encoder.encodeAndSave(this.transcription, this.trackSourceConfigs.values());
    }

    public void addTrackSource(TSSourceConfiguration configuration, boolean notifyAndSave) {
        if (configuration != null) {
            this.trackSourceConfigs.put(configuration.getSource(), configuration);
            for (Object key : configuration.objectKeySet()) {
                Object o = configuration.getObject(key);
                if (o instanceof TimeSeriesTrack) {
                    this.tracks.add(o);
                    continue;
                }
                if (!(o instanceof TSTrackConfiguration)) continue;
                TSTrackConfiguration tstc = (TSTrackConfiguration)o;
                Object tr = tstc.getObject(tstc.getTrackName());
                if (tr instanceof TimeSeriesTrack) {
                    this.tracks.add(tr);
                    continue;
                }
                for (Object ke : tstc.objectKeySet()) {
                    Object oo = tstc.getObject(ke);
                    if (!(oo instanceof TimeSeriesTrack)) continue;
                    this.tracks.add(oo);
                }
            }
            if (notifyAndSave) {
                this.notifyListeners(new TimeSeriesChangeEvent(configuration, 0, 100));
                this.encoder.encodeAndSave(this.transcription, this.trackSourceConfigs.values());
            }
        }
    }

    public void removeTrackSource(TSSourceConfiguration configuration) {
        if (configuration != null) {
            this.removeTrackSource(configuration.getSource());
        }
    }

    public void removeTrackSource(String source) {
        if (source != null) {
            TSSourceConfiguration configuration = (TSSourceConfiguration)this.trackSourceConfigs.remove(source);
            if (configuration != null) {
                for (Object key : configuration.objectKeySet()) {
                    Object o = configuration.getObject(key);
                    if (o instanceof TimeSeriesTrack) {
                        this.tracks.remove(o);
                    } else if (o instanceof TSTrackConfiguration) {
                        TSTrackConfiguration tstc = (TSTrackConfiguration)o;
                        Object tr = tstc.getObject(tstc.getTrackName());
                        if (tr instanceof TimeSeriesTrack) {
                            this.tracks.remove(tr);
                        } else {
                            for (Object ke : tstc.objectKeySet()) {
                                Object oo = tstc.getObject(ke);
                                if (!(oo instanceof TimeSeriesTrack)) continue;
                                this.tracks.remove(oo);
                            }
                        }
                    }
                    this.notifyListeners(new TimeSeriesChangeEvent(o, 2, 101));
                }
                this.notifyListeners(new TimeSeriesChangeEvent(configuration, 2, 100));
            }
            if (this.trackSourceConfigs.isEmpty()) {
                // empty if block
            }
        }
        this.encoder.encodeAndSave(this.transcription, this.trackSourceConfigs.values());
    }

    public void trackSourceChanged(TSSourceConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        if (this.trackSourceConfigs.get(configuration.getSource()) != null) {
            int origin = configuration.getTimeOrigin();
            AbstractTSTrack track = null;
            for (Object key : configuration.objectKeySet()) {
                Object o = configuration.getObject(key);
                if (o instanceof AbstractTSTrack) {
                    track = (AbstractTSTrack)o;
                    if (track.getTimeOffset() == origin) continue;
                    track.setTimeOffset(origin);
                    this.notifyListeners(new TimeSeriesChangeEvent(track, 1, 101));
                    continue;
                }
                if (!(o instanceof TSTrackConfiguration)) continue;
                TSTrackConfiguration tstc = (TSTrackConfiguration)o;
                Object tr = tstc.getObject(tstc.getTrackName());
                if (tr instanceof AbstractTSTrack) {
                    track = (AbstractTSTrack)tr;
                    if (track.getTimeOffset() == origin) continue;
                    track.setTimeOffset(origin);
                    this.notifyListeners(new TimeSeriesChangeEvent(track, 1, 101));
                    continue;
                }
                for (Object ke : tstc.objectKeySet()) {
                    Object oo = tstc.getObject(ke);
                    if (!(oo instanceof AbstractTSTrack) || (track = (AbstractTSTrack)oo).getTimeOffset() == origin) continue;
                    track.setTimeOffset(origin);
                    this.notifyListeners(new TimeSeriesChangeEvent(track, 1, 101));
                }
            }
            this.notifyListeners(new TimeSeriesChangeEvent(configuration, 1, 100));
            this.encoder.encodeAndSave(this.transcription, this.trackSourceConfigs.values());
        }
    }

    public void addTimeSeriesChangeListener(TimeSeriesChangeListener li) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(li);
    }

    public void removeTimeSeriesChangeListener(TimeSeriesChangeListener li) {
        if (this.listeners != null) {
            this.listeners.remove(li);
        }
    }

    private void notifyListeners(TimeSeriesChangeEvent event) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TimeSeriesChangeListener)this.listeners.get(i)).timeSeriesChanged(event);
            }
        }
    }

    public void timeSeriesChanged(TimeSeriesChangeEvent event) {
        if (event.getEditSourceType() == 101 && event.getSource() instanceof TSTrackConfiguration) {
            TSTrackConfiguration trc = (TSTrackConfiguration)event.getSource();
            Object tr = trc.getObject(trc.getTrackName());
            if (event.getEditType() == 0) {
                if (!this.tracks.contains(tr)) {
                    this.tracks.add(tr);
                }
            } else if (event.getEditType() == 2) {
                this.tracks.remove(tr);
            }
        }
        this.notifyListeners(event);
        this.encoder.encodeAndSave(this.transcription, this.trackSourceConfigs.values());
    }
}

