/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.io;

import java.io.IOException;
import java.util.ArrayList;
import mpi.eudico.client.annotator.timeseries.config.SamplePosition;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class TSConfigurationParser
implements ClientLogger {
    private final SAXParser saxParser = new SAXParser();

    public TSConfigurationParser() {
        try {
            this.saxParser.setFeature("http://xml.org/sax/features/validation", false);
            this.saxParser.setContentHandler((ContentHandler)new ConfigHandler());
        }
        catch (SAXNotRecognizedException e) {
            LOG.warning("Parser error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            LOG.warning("Parser error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public ArrayList parseSourceConfigs(String filePath) {
        try {
            this.saxParser.parse(filePath);
            return ((ConfigHandler)this.saxParser.getContentHandler()).getConfigurations();
        }
        catch (SAXException se) {
            LOG.warning("Could not parse file: " + filePath + ": " + se.getMessage());
            return null;
        }
        catch (IOException ioe) {
            LOG.warning("Could not parse file: " + filePath + ": " + ioe.getMessage());
            return null;
        }
    }

    private class ConfigHandler
    implements ContentHandler {
        private String content = "";
        private String curValue;
        private ArrayList configs = new ArrayList();
        private Object currentElement;
        private TSSourceConfiguration sourceConf;
        private TSTrackConfiguration trackConf;
        private SamplePosition spos;
        private ArrayList positions = new ArrayList();

        private ConfigHandler() {
        }

        public ArrayList getConfigurations() {
            return this.configs;
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content = this.content + new String(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endElement(String namespaceURI, String name, String qName) throws SAXException {
            if (name.equals("description")) {
                if (this.currentElement == this.spos) {
                    this.spos.setDescription(this.content);
                } else if (this.currentElement == this.trackConf) {
                    this.trackConf.setProperty("description", this.content);
                }
            } else if (name.equals("sample-position")) {
                int[] rows = new int[this.positions.size()];
                int[] cols = new int[this.positions.size()];
                for (int i = 0; i < this.positions.size(); ++i) {
                    int[] ps = (int[])this.positions.get(i);
                    rows[i] = ps[0];
                    cols[i] = ps[1];
                }
                SamplePosition nsp = new SamplePosition(rows, cols);
                nsp.setDescription(this.spos.getDescription());
                this.trackConf.setSamplePos(nsp);
                this.positions.clear();
                this.currentElement = this.trackConf;
            } else if (name.equals("units")) {
                this.trackConf.setProperty("units", this.content);
            } else if (name.equals("color")) {
                this.trackConf.setProperty("color", this.content);
            }
        }

        public void startElement(String namespaceURI, String name, String qName, Attributes atts) throws SAXException {
            this.content = "";
            if (name.equals("tracksource")) {
                this.curValue = atts.getValue("source-url");
                if (this.curValue != null) {
                    this.sourceConf = new TSSourceConfiguration(this.curValue);
                    this.configs.add(this.sourceConf);
                    this.currentElement = this.sourceConf;
                    this.curValue = atts.getValue("time-origin");
                    if (this.curValue != null) {
                        this.sourceConf.setTimeOrigin(this.parseInt(this.curValue));
                    }
                    this.curValue = atts.getValue("sample-type");
                    if (this.curValue != null) {
                        this.sourceConf.setSampleType(this.curValue);
                    }
                    this.curValue = atts.getValue("time-column");
                    if (this.curValue != null) {
                        this.sourceConf.setTimeColumn(this.parseInt(this.curValue, -1));
                    }
                }
            } else if (name.equals("property")) {
                String key = atts.getValue("key");
                this.curValue = atts.getValue("value");
                if (key != null && this.curValue != null) {
                    if (this.currentElement == this.sourceConf) {
                        if (key.equals("provider")) {
                            this.sourceConf.setProviderClassName(this.curValue);
                        } else {
                            this.sourceConf.setProperty(key, this.curValue);
                        }
                    } else if (this.currentElement == this.trackConf) {
                        this.trackConf.setProperty(key, this.curValue);
                    }
                }
            } else if (name.equals("track")) {
                this.curValue = atts.getValue("name");
                if (this.curValue != null) {
                    this.trackConf = new TSTrackConfiguration(this.curValue);
                    this.sourceConf.putObject(this.curValue, this.trackConf);
                    this.curValue = atts.getValue("derivative");
                    if (this.curValue != null) {
                        this.trackConf.setProperty("derivative", this.curValue);
                    }
                }
            } else if (name.equals("range")) {
                this.curValue = atts.getValue("min");
                if (this.curValue != null) {
                    this.trackConf.setProperty("min", this.curValue);
                }
                this.curValue = atts.getValue("max");
                if (this.curValue != null) {
                    this.trackConf.setProperty("max", this.curValue);
                }
            } else if (name.equals("sample-position")) {
                this.spos = new SamplePosition();
                this.currentElement = this.spos;
            } else if (name.equals("pos")) {
                int row = this.parseInt(atts.getValue("row"));
                int col = this.parseInt(atts.getValue("col"));
                this.positions.add(new int[]{row, col});
            }
        }

        private int parseInt(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }

        private int parseInt(String value, int defaultVal) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return defaultVal;
            }
        }
    }
}

