/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.HTMLViewer;
import mpi.eudico.client.annotator.layout.TranscriptionManager;
import mpi.eudico.client.annotator.transcriptionMode.SelectChildTiersDlg;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptionModeSettingsDlg
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private final String COLUMN_NO = ElanLocale.getString("TranscriptionModeSettingsDlg.Column.No");
    private final String COLUMN_TYPE = ElanLocale.getString("TranscriptionModeSettingsDlg.Column.SelectType");
    private final String DEFAULT_VALUE = ElanLocale.getString("TranscriptionModeSettingsDlg.DefaultValue");
    private Transcription transcription;
    private ElanLayoutManager layoutManager;
    private JComboBox fontSizeComboBox;
    private JSpinner spinner;
    private JTable table;
    private DefaultTableModel model;
    private JButton butSelectTiers;
    private JButton helpButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton addColButton;
    private JButton deleteColButton;
    private List<String> linkedTypes;
    private List<TierImpl> parentTierList;
    private List<String> columnTypeList;
    private List<String> lastUsedColumnTypeList;
    private List<String> hiddenTiersList;
    private HashMap<TierImpl, HashMap<String, Integer>> typeTierMap;
    private HashMap<TierImpl, List<TierImpl>> tierMap;
    private String refType;
    private boolean valueChanged = false;
    private boolean tierChanged = false;
    private final int TYPE_COL_INDEX = 1;

    public TranscriptionModeSettingsDlg(ElanLayoutManager layoutManager, List<String> columnTypes, HashMap<TierImpl, List<TierImpl>> hashMap, List<String> hiddenTiers, Integer size) {
        super(layoutManager.getElanFrame(), ElanLocale.getString("TranscriptionModeSettingsDlg.Title"), true);
        List<String> possibleTypes;
        this.transcription = layoutManager.getViewerManager().getTranscription();
        this.layoutManager = layoutManager;
        this.initComponents();
        this.tierMap = hashMap;
        this.hiddenTiersList = hiddenTiers;
        this.lastUsedColumnTypeList = columnTypes;
        if (size != null) {
            this.fontSizeComboBox.setSelectedItem(size);
        }
        if (columnTypes != null && columnTypes.size() >= 1 && (possibleTypes = this.getPossibleTypesForColumn(1)).contains(columnTypes.get(0))) {
            int column;
            this.columnTypeList.add(columnTypes.get(0));
            this.table.setValueAt(columnTypes.get(0), 0, 1);
            for (int i = 1; i < columnTypes.size() && (possibleTypes = this.getPossibleTypesForColumn(column = i + 1)).contains(columnTypes.get(i)); ++i) {
                this.columnTypeList.add(columnTypes.get(i));
                this.model.addRow(new Object[]{column, columnTypes.get(i)});
            }
            this.spinner.setValue(this.table.getRowCount());
        }
        this.enableOrDisableSeletTierButton();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.typeTierMap = new HashMap();
        this.tierMap = new HashMap();
        this.parentTierList = new ArrayList<TierImpl>();
        this.linkedTypes = new ArrayList<String>();
        this.columnTypeList = new ArrayList<String>();
        this.model = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                if (this.getColumnName(column).equals(TranscriptionModeSettingsDlg.this.COLUMN_NO)) {
                    return false;
                }
                if (TranscriptionModeSettingsDlg.this.table.getValueAt(row, column) == null) {
                    return false;
                }
                return !TranscriptionModeSettingsDlg.this.table.getValueAt(row, column).toString().equals(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE);
            }
        };
        this.model.setColumnIdentifiers(new String[]{this.COLUMN_NO, this.COLUMN_TYPE});
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING)) {
                    cell.setForeground(Color.GRAY);
                } else {
                    cell.setForeground(Color.BLACK);
                }
                return cell;
            }
        };
        this.table = new JTable(this.model){

            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (column == 0) {
                    return;
                }
                super.changeSelection(row, column, toggle, extend);
            }
        };
        this.table.setFont(Constants.DEFAULTFONT);
        this.table.setCellSelectionEnabled(true);
        this.table.setDefaultEditor(Object.class, new TableCellEditor());
        this.table.setDefaultRenderer(Object.class, render);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.BLACK);
        this.table.setSelectionBackground(Color.WHITE);
        this.table.setRowHeight(this.table.getRowHeight() + 5);
        this.table.getColumnModel().getColumn(0).setMinWidth(50);
        this.table.getColumnModel().getColumn(0).setMaxWidth(50);
        this.fontSizeComboBox = new JComboBox();
        for (int i = 10; i <= 20; ++i) {
            this.fontSizeComboBox.addItem(new Integer(i));
        }
        this.spinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.model.addRow(new Object[]{1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
        this.spinner.addChangeListener(this);
        this.butSelectTiers = new JButton(ElanLocale.getString("TranscriptionModeSettingsDlg.SelectTier"));
        this.butSelectTiers.setEnabled(false);
        this.helpButton = new JButton(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help24.gif")));
        this.helpButton.setPreferredSize(new Dimension(24, 24));
        this.addColButton = new JButton(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Plus16.gif")));
        this.addColButton.setPreferredSize(new Dimension(20, 20));
        this.deleteColButton = new JButton(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Minus16.gif")));
        this.deleteColButton.setPreferredSize(new Dimension(20, 20));
        this.applyButton = new JButton();
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.applyButton.setEnabled(false);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.butSelectTiers.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.addColButton.addActionListener(this);
        this.deleteColButton.addActionListener(this);
        JLabel fontSizeLabel = new JLabel(ElanLocale.getString("TranscriptionModeSettingsDlg.FontSize"));
        JLabel columnNoLabel = new JLabel(ElanLocale.getString("TranscriptionModeSettingsDlg.SelectColumns"));
        JScrollPane scroller = new JScrollPane(this.table);
        Insets inset = new Insets(5, 10, 5, 10);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = inset;
        buttonPanel.add((Component)this.applyButton, gbc);
        gbc.gridx = 1;
        buttonPanel.add((Component)this.cancelButton, gbc);
        JPanel columnPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        columnPanel.add((Component)this.spinner, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        columnPanel.add((Component)this.addColButton, gbc);
        gbc.gridx = 2;
        columnPanel.add((Component)this.deleteColButton, gbc);
        this.getContentPane().setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = inset;
        this.getContentPane().add((Component)this.helpButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)fontSizeLabel, gbc);
        gbc.gridx = 1;
        this.getContentPane().add((Component)this.fontSizeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.getContentPane().add((Component)columnNoLabel, gbc);
        gbc.gridx = 1;
        this.getContentPane().add((Component)columnPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)scroller, gbc);
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.butSelectTiers, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                TranscriptionModeSettingsDlg.this.doClose();
            }
        });
    }

    private HashMap<String, Integer> getTierTypeMap(TierImpl tier) {
        HashMap<String, Integer> tierTypeMap = new HashMap<String, Integer>();
        Vector childTiers = tier.getChildTiers();
        for (int x = 0; x < childTiers.size(); ++x) {
            TierImpl childTier = (TierImpl)childTiers.get(x);
            String typeName = null;
            if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
            Vector dependentTiers = childTier.getDependentTiers();
            for (int y = 0; y < dependentTiers.size(); ++y) {
                TierImpl dependantTier = (TierImpl)dependentTiers.get(y);
                typeName = dependantTier.getLinguisticType().getLinguisticTypeName();
                if (dependantTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
                if (tierTypeMap.containsKey(typeName)) {
                    tierTypeMap.put(typeName, tierTypeMap.get(typeName) + 1);
                } else {
                    tierTypeMap.put(typeName, 1);
                }
                if (this.linkedTypes.contains(dependantTier.getLinguisticType().getLinguisticTypeName())) continue;
                this.linkedTypes.add(dependantTier.getLinguisticType().getLinguisticTypeName());
            }
            typeName = childTier.getLinguisticType().getLinguisticTypeName();
            if (tierTypeMap.containsKey(typeName)) {
                tierTypeMap.put(typeName, tierTypeMap.get(typeName) + 1);
            } else {
                tierTypeMap.put(typeName, 1);
            }
            if (this.linkedTypes.contains(childTier.getLinguisticType().getLinguisticTypeName())) continue;
            this.linkedTypes.add(childTier.getLinguisticType().getLinguisticTypeName());
        }
        return tierTypeMap;
    }

    private void getLinkedTypes() {
        if (this.refType != null && this.refType.equals(this.table.getValueAt(0, 1).toString())) {
            return;
        }
        this.refType = this.table.getValueAt(0, 1).toString();
        this.linkedTypes.clear();
        this.parentTierList.clear();
        Vector tierList = this.transcription.getTiersWithLinguisticType(this.refType);
        ArrayList parentTiers = new ArrayList();
        for (int i = 0; i < tierList.size(); ++i) {
            TierImpl parentTier;
            TierImpl tier = (TierImpl)tierList.get(i);
            if (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 4) {
                if (this.parentTierList.contains(tier)) continue;
                this.parentTierList.add(tier);
                this.typeTierMap.put(tier, this.getTierTypeMap(tier));
                continue;
            }
            for (parentTier = (TierImpl)tier.getParentTier(); parentTier != null && parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4; parentTier = (TierImpl)parentTier.getParentTier()) {
            }
            if (this.parentTierList.contains(parentTier)) continue;
            this.parentTierList.add(parentTier);
            this.typeTierMap.put(parentTier, this.getTierTypeMap(parentTier));
        }
    }

    private List<String> getPossibleTypesForColumn(int column) {
        ArrayList<String> possibleTypes = new ArrayList<String>();
        if (column == 1) {
            Vector types = this.transcription.getLinguisticTypes();
            for (int i = 0; i < types.size(); ++i) {
                LinguisticType type = (LinguisticType)types.get(i);
                Vector tierList = this.transcription.getTiersWithLinguisticType(type.getLinguisticTypeName());
                if (tierList == null || tierList.size() <= 0) continue;
                possibleTypes.add(type.getLinguisticTypeName());
            }
            return possibleTypes;
        }
        if (column == 2) {
            this.getLinkedTypes();
        }
        for (int x = 0; x < this.parentTierList.size(); ++x) {
            HashMap<String, Integer> _map = this.typeTierMap.get(this.parentTierList.get(x));
            for (int i = 0; i < this.linkedTypes.size(); ++i) {
                String typeName = this.linkedTypes.get(i);
                if (!_map.containsKey(typeName)) continue;
                int noOfTiers = _map.get(typeName);
                if (noOfTiers > 0) {
                    for (int c = 0; c < this.columnTypeList.size() && c != column - 1; ++c) {
                        if (!typeName.equals(this.columnTypeList.get(c)) || --noOfTiers > 0) continue;
                        noOfTiers = 0;
                        break;
                    }
                }
                if (noOfTiers <= 0 || possibleTypes.contains(typeName)) continue;
                possibleTypes.add(typeName);
            }
        }
        return possibleTypes;
    }

    private void enableOrDisableSeletTierButton() {
        this.butSelectTiers.setEnabled(false);
        if (this.columnTypeList.size() >= 1) {
            this.butSelectTiers.setEnabled(true);
        }
    }

    public List<String> getColumnTypeList() {
        return this.columnTypeList;
    }

    public HashMap<TierImpl, List<TierImpl>> getTierMap() {
        return this.tierMap;
    }

    public List<String> getHiddenTiersList() {
        return this.hiddenTiersList;
    }

    public Integer getFontSize() {
        return (Integer)this.fontSizeComboBox.getSelectedItem();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.checkValueChanged();
            this.doClose();
        } else if (e.getSource() == this.cancelButton) {
            this.columnTypeList = this.lastUsedColumnTypeList;
            this.tierMap = null;
            this.valueChanged = false;
            this.doClose();
        } else if (e.getSource() == this.butSelectTiers) {
            SelectChildTiersDlg dialog = null;
            this.checkValueChanged();
            dialog = this.tierChanged ? new SelectChildTiersDlg(this.layoutManager, this.tierMap, this.hiddenTiersList, this.columnTypeList) : (this.valueChanged ? new SelectChildTiersDlg(this.layoutManager, null, this.hiddenTiersList, this.columnTypeList) : new SelectChildTiersDlg(this.layoutManager, this.tierMap, this.hiddenTiersList, this.columnTypeList));
            dialog.setVisible(true);
            this.tierMap = dialog.getTierMap();
            this.hiddenTiersList = dialog.getHiddenTiers();
            this.tierChanged = dialog.isValueChanged();
        } else if (e.getSource() == this.helpButton) {
            this.showHelpDialog();
        } else if (e.getSource() == this.addColButton) {
            int n = (Integer)this.spinner.getValue();
            this.spinner.setValue(++n);
        } else if (e.getSource() == this.deleteColButton) {
            int n = (Integer)this.spinner.getValue();
            this.spinner.setValue(--n);
        }
    }

    private void addRows() {
        int n = (Integer)this.spinner.getValue();
        Object value = null;
        while (this.table.getRowCount() < n) {
            value = this.table.getValueAt(this.table.getRowCount() - 1, 1);
            if (value == null || value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING) || value.equals(this.DEFAULT_VALUE)) {
                this.model.addRow(new Object[]{this.table.getRowCount() + 1, null});
                continue;
            }
            this.model.addRow(new Object[]{this.table.getRowCount() + 1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
        }
    }

    private void deleteRows() {
        int n = (Integer)this.spinner.getValue();
        while (this.table.getRowCount() > n) {
            this.model.removeRow(this.table.getRowCount() - 1);
        }
        for (int i = this.columnTypeList.size(); i > this.table.getRowCount(); --i) {
            this.columnTypeList.remove(i - 1);
        }
    }

    private void deleteValuesAfter(int row) {
        for (int i = row + 1; i < this.table.getRowCount(); ++i) {
            if (i == row + 1) {
                this.table.setValueAt(TranscriptionManager.COMBOBOX_DEFAULT_STRING, i, 1);
                continue;
            }
            this.table.setValueAt(null, i, 1);
        }
        while (this.columnTypeList.size() > row) {
            this.columnTypeList.remove(this.columnTypeList.size() - 1);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int n = (Integer)this.spinner.getValue();
        if (n == 1) {
            this.deleteColButton.setEnabled(false);
        } else {
            this.deleteColButton.setEnabled(true);
        }
        if (e.getSource() == this.spinner) {
            if (this.table.getRowCount() < n) {
                this.addRows();
            } else if (this.table.getRowCount() > n) {
                this.deleteRows();
            }
        }
        this.applyButton.setEnabled(true);
    }

    private void showHelpDialog() {
        try {
            HTMLViewer helpViewer = new HTMLViewer("/mpi/eudico/client/annotator/resources/transcriptionModeHelpDoc.html", false, ElanLocale.getString("TranscriptionModeSettingsDlg.Help"));
            JDialog dialog = helpViewer.createHTMLDialog(this);
            dialog.pack();
            dialog.setSize(500, 600);
            dialog.setVisible(true);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to load the Transcription mode help file " + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 2, null);
        }
    }

    private void checkValueChanged() {
        this.valueChanged = false;
        if (this.lastUsedColumnTypeList == null && this.columnTypeList.size() > 0) {
            this.valueChanged = true;
        } else if (this.lastUsedColumnTypeList.size() != this.columnTypeList.size()) {
            this.valueChanged = true;
        } else {
            for (int i = 0; i < this.columnTypeList.size(); ++i) {
                if (this.columnTypeList.get(i).equals(this.lastUsedColumnTypeList.get(i))) continue;
                this.valueChanged = true;
                break;
            }
        }
        if (this.tierChanged) {
            this.valueChanged = true;
        }
    }

    public boolean isValueChanged() {
        return this.valueChanged;
    }

    private class TableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private int row;
        private String value;

        public TableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.value = value.toString();
            List possibleTypes = TranscriptionModeSettingsDlg.this.getPossibleTypesForColumn(row + 1);
            this.comboBox = new JComboBox();
            if (possibleTypes.size() == 0) {
                table.setValueAt(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE, row, column);
                return null;
            }
            for (int i = 0; i < possibleTypes.size(); ++i) {
                this.comboBox.addItem(possibleTypes.get(i));
            }
            if (value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING)) {
                this.comboBox.setSelectedItem(null);
            } else if (possibleTypes.contains(value)) {
                this.comboBox.setSelectedItem(value);
            }
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.comboBox) {
                if (this.comboBox.getSelectedItem() != null) {
                    TranscriptionModeSettingsDlg.this.table.editingStopped(new ChangeEvent(this));
                    if (this.value.equals(this.comboBox.getSelectedItem())) {
                        return;
                    }
                    TranscriptionModeSettingsDlg.this.applyButton.setEnabled(true);
                    if (TranscriptionModeSettingsDlg.this.table.getRowCount() - 1 > this.row) {
                        if (TranscriptionModeSettingsDlg.this.table.getValueAt(this.row + 1, 1) == null || TranscriptionModeSettingsDlg.this.table.getValueAt(this.row + 1, 1).toString().equals(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE)) {
                            TranscriptionModeSettingsDlg.this.table.setValueAt(TranscriptionManager.COMBOBOX_DEFAULT_STRING, this.row + 1, 1);
                        } else {
                            Object value = TranscriptionModeSettingsDlg.this.table.getValueAt(this.row + 1, 1);
                            if (!value.equals(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE) && !value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING)) {
                                TranscriptionModeSettingsDlg.this.deleteValuesAfter(this.row);
                            }
                        }
                    } else if (this.row == TranscriptionModeSettingsDlg.this.table.getRowCount() - 1) {
                        ((DefaultTableModel)TranscriptionModeSettingsDlg.this.table.getModel()).addRow(new Object[]{TranscriptionModeSettingsDlg.this.table.getRowCount() + 1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
                        TranscriptionModeSettingsDlg.this.spinner.setValue(TranscriptionModeSettingsDlg.this.table.getRowCount());
                    }
                    if (this.row <= TranscriptionModeSettingsDlg.this.columnTypeList.size() - 1) {
                        TranscriptionModeSettingsDlg.this.columnTypeList.set(this.row, this.comboBox.getSelectedItem().toString());
                    } else {
                        TranscriptionModeSettingsDlg.this.columnTypeList.add(this.comboBox.getSelectedItem().toString());
                    }
                }
                TranscriptionModeSettingsDlg.this.enableOrDisableSeletTierButton();
            }
        }
    }
}

