/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableCellEditor;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableCellRenderer;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableModel;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.client.util.TableSubHeaderObject;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptionTable
extends JTable {
    private HashMap prefTierFontColors;
    private HashMap<String, Color> prefTierBrighterFontColors;
    private HashMap<String, Color> prefTierBrightestFontColors;
    private HashMap prefTierFonts;
    private List<String> nonEditableTiersList;
    private int width = -1;
    private final int rowHeight = this.getRowHeight() + 5;
    private int currentRowIndex = -1;
    private int currentColumnIndex = -1;
    private boolean moveViaColumn = false;
    private boolean scrollToCenter = false;
    private boolean storeColumnOrder = false;

    public TranscriptionTable() {
        this.prefTierFontColors = new HashMap();
        this.prefTierBrighterFontColors = new HashMap();
        this.prefTierBrightestFontColors = new HashMap();
        this.prefTierFonts = new HashMap();
        this.setFont(Constants.DEFAULTFONT);
        this.setCellSelectionEnabled(true);
        this.setAutoResizeMode(4);
        this.setShowGrid(true);
        this.setGridColor(Color.BLACK);
        this.setSurrendersFocusOnKeystroke(true);
        this.getTableHeader().setReorderingAllowed(true);
        this.setColumnModel(new DefaultTableColumnModel(){

            public void moveColumn(int columnIndex, int newIndex) {
                if (columnIndex == 0 || newIndex == 0) {
                    return;
                }
                String columnName = TranscriptionTable.this.getColumnName(TranscriptionTable.this.getCurrentColumn());
                super.moveColumn(columnIndex, newIndex);
                if (TranscriptionTable.this.storeColumnOrder) {
                    if (columnIndex == TranscriptionTable.this.getCurrentColumn() || newIndex == TranscriptionTable.this.getCurrentColumn()) {
                        TranscriptionTable.this.setCurrentColumn(TranscriptionTable.this.getColumnModel().getColumnIndex(columnName));
                    }
                    TranscriptionViewer viewer = (TranscriptionViewer)TranscriptionTable.this.getParent().getParent().getParent();
                    viewer.storeColumnOrder();
                    boolean playBack = viewer.isAutoPlayBack();
                    viewer.setAutoPlayBack(false);
                    TranscriptionTable.this.startEdit(null);
                    viewer.setAutoPlayBack(playBack);
                }
            }

            protected void fireColumnMarginChanged() {
                if (!TranscriptionTable.this.storeColumnOrder) {
                    return;
                }
                super.fireColumnMarginChanged();
                TranscriptionTable.this.reCalculateRowHeight();
            }
        });
        AbstractAction doNothing = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "doNothing");
        this.getActionMap().put("doNothing", doNothing);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        TableColumn resizingColumn = this.getTableHeader().getResizingColumn();
        if (resizingColumn != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        if ((TranscriptionTableCellEditor)this.getCellEditor() != null) {
            ((TranscriptionTableCellEditor)this.getCellEditor()).commitChanges();
        }
        this.resizeAndRepaint();
    }

    public void setNoneditableTiers(List<String> list) {
        this.nonEditableTiersList = list;
        ((TranscriptionTableCellRenderer)this.getDefaultRenderer(Object.class)).setNonEditableTiers(list);
        ((TranscriptionTableModel)this.getModel()).setNonEditableTiers(list);
        this.repaint();
    }

    public void setStoreColumnOrder(boolean store) {
        this.storeColumnOrder = store;
    }

    public boolean getStoreColumnOrder() {
        return this.storeColumnOrder;
    }

    public void moveViaColumn(boolean selected) {
        this.moveViaColumn = selected;
    }

    public void scrollActiveCellInCenter(boolean selected) {
        this.scrollToCenter = selected;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        int code = e.getKeyCode();
        if (code == 10 && condition == 0 && pressed) {
            if (!this.isEditing()) {
                int selectedColumn;
                int selectedRow = this.getSelectedRow();
                if (this.editCellAt(selectedRow, selectedColumn = this.getSelectedColumn())) {
                    this.setCurrentRow(selectedRow);
                    this.setCurrentColumn(selectedColumn);
                } else {
                    this.goToNextEditableCell();
                }
            }
            this.startEdit(e);
        }
        return false;
    }

    public String getTierName(int row, int column) {
        String tierName = null;
        Object val = this.getValueAt(row, column);
        if (val instanceof Annotation) {
            AbstractAnnotation ann = (AbstractAnnotation)val;
            tierName = ann.getTier().getName();
        } else if (val instanceof String) {
            String value = (String)this.getValueAt(row, column);
            String[] s = value.split(";");
            tierName = s[1];
        } else if (val instanceof TableSubHeaderObject) {
            tierName = val.toString();
        }
        return tierName;
    }

    public int getCurrentRow() {
        return this.currentRowIndex;
    }

    private void setCurrentRow(int newRow) {
        this.currentRowIndex = newRow;
    }

    public int getDefaultRowHeight() {
        return this.rowHeight;
    }

    public int getCurrentColumn() {
        return this.currentColumnIndex;
    }

    private void setCurrentColumn(int newColumn) {
        this.currentColumnIndex = newColumn;
    }

    public void goToEditableCellUp() {
        int rowBefore = this.getCurrentRow() - 1;
        while (true) {
            if (rowBefore < 0) {
                rowBefore = 0;
            }
            if (this.getValueAt(rowBefore, this.getCurrentColumn()) instanceof TableSubHeaderObject) {
                if (rowBefore == 0) {
                    rowBefore = this.getCurrentRow();
                    break;
                }
                --rowBefore;
            }
            if (this.getValueAt(rowBefore, this.getCurrentColumn()) == null) {
                if (rowBefore == 0) {
                    rowBefore = this.getCurrentRow();
                    break;
                }
                --rowBefore;
                continue;
            }
            String tierName = this.getTierName(rowBefore, this.getCurrentColumn());
            if (this.nonEditableTiersList == null || !this.nonEditableTiersList.contains(tierName)) break;
            if (rowBefore == 0) {
                rowBefore = this.getCurrentRow();
                break;
            }
            --rowBefore;
        }
        if (rowBefore != this.getCurrentRow()) {
            this.changeSelection(rowBefore, this.getCurrentColumn(), false, false);
            if (this.isEditing()) {
                this.editingStopped(null);
            }
            this.startEdit(null);
        }
    }

    public void goToEditableCellDown() {
        int rowNext = this.getCurrentRow() + 1;
        while (true) {
            if (rowNext >= this.getRowCount()) {
                rowNext = this.getCurrentRow();
            }
            if (this.getValueAt(rowNext, this.getCurrentColumn()) instanceof TableSubHeaderObject) {
                if (rowNext >= this.getRowCount()) {
                    rowNext = this.getCurrentRow();
                    break;
                }
                ++rowNext;
            }
            if (this.getValueAt(rowNext, this.getCurrentColumn()) == null) {
                if (rowNext >= this.getRowCount()) {
                    rowNext = this.getCurrentRow();
                    break;
                }
                ++rowNext;
                continue;
            }
            String tierName = this.getTierName(rowNext, this.getCurrentColumn());
            if (this.nonEditableTiersList == null || !this.nonEditableTiersList.contains(tierName)) break;
            if (rowNext >= this.getRowCount()) {
                rowNext = this.getCurrentRow();
                break;
            }
            ++rowNext;
        }
        if (rowNext != this.getCurrentRow()) {
            this.changeSelection(rowNext, this.getCurrentColumn(), false, false);
            if (this.isEditing()) {
                this.editingStopped(null);
            }
            this.startEdit(null);
        }
    }

    public void goToEditableCellLeft() {
        int leftColumn = this.getCurrentColumn() - 1;
        while (true) {
            if (leftColumn == 0) {
                leftColumn = this.getCurrentColumn();
                break;
            }
            if (this.getValueAt(this.getCurrentRow(), leftColumn) == null) {
                --leftColumn;
                continue;
            }
            String tierName = this.getTierName(this.getCurrentRow(), leftColumn);
            if (this.nonEditableTiersList == null || !this.nonEditableTiersList.contains(tierName)) break;
            --leftColumn;
        }
        if (leftColumn != this.getCurrentColumn()) {
            this.changeSelection(this.getCurrentRow(), leftColumn, false, false);
            if (this.isEditing()) {
                this.editingStopped(null);
            }
            this.startEdit(null);
        }
    }

    public void goToEditableCellRight() {
        int rightColumn = this.getCurrentColumn() + 1;
        while (true) {
            if (rightColumn > this.getColumnCount() - 1) {
                rightColumn = this.getCurrentColumn();
                break;
            }
            if (this.getValueAt(this.getCurrentRow(), rightColumn) == null) {
                ++rightColumn;
                continue;
            }
            String tierName = this.getTierName(this.getCurrentRow(), rightColumn);
            if (this.nonEditableTiersList == null || !this.nonEditableTiersList.contains(tierName)) break;
            ++rightColumn;
        }
        if (rightColumn != this.getCurrentColumn()) {
            this.changeSelection(this.getCurrentRow(), rightColumn, false, false);
            if (this.isEditing()) {
                this.editingStopped(null);
            }
            this.startEdit(null);
        }
    }

    public void goToNextEditableCell() {
        if (this.moveViaColumn) {
            int nextRow = this.getCurrentRow();
            int nextColumn = this.getCurrentColumn() + 1;
            while (true) {
                if (nextColumn > this.getColumnCount() - 1) {
                    nextColumn = 1;
                    if (++nextRow >= this.getRowCount()) {
                        nextRow = 0;
                    }
                }
                if (this.getValueAt(nextRow, nextColumn) instanceof TableSubHeaderObject) {
                    ++nextRow;
                }
                if (this.getValueAt(nextRow, nextColumn) == null) {
                    ++nextColumn;
                    continue;
                }
                String tierName = this.getTierName(nextRow, nextColumn);
                if (this.nonEditableTiersList == null || !this.nonEditableTiersList.contains(tierName)) break;
                ++nextColumn;
            }
            this.changeSelection(nextRow, nextColumn, false, false);
            if (this.isEditing()) {
                this.editingStopped(null);
            }
            this.startEdit(null);
        } else {
            int nextRow = this.getCurrentRow() + 1;
            int nextColumn = this.getCurrentColumn();
            while (true) {
                if (nextRow > this.getRowCount() - 1) {
                    nextRow = 0;
                    if (++nextColumn > this.getColumnCount() - 1) {
                        nextColumn = 1;
                    }
                }
                if (this.getValueAt(nextRow, nextColumn) instanceof TableSubHeaderObject) {
                    ++nextRow;
                }
                if (this.getValueAt(nextRow, nextColumn) == null) {
                    ++nextRow;
                    continue;
                }
                String tierName = this.getTierName(nextRow, nextColumn);
                if (this.nonEditableTiersList == null || !this.nonEditableTiersList.contains(tierName)) break;
                ++nextRow;
            }
            this.changeSelection(nextRow, nextColumn, false, false);
            if (this.isEditing()) {
                this.editingStopped(null);
            }
            this.startEdit(null);
        }
    }

    public void scrollIfNeeded() {
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(this.getCurrentRow(), this.getCurrentColumn(), true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
    }

    public void startEdit(KeyEvent e) {
        Component editorComponent;
        if (!this.isEditing()) {
            if (!this.editCellAt(this.getCurrentRow(), this.getCurrentColumn(), e)) {
                return;
            }
            String tierName = this.getTierName(this.getCurrentRow(), this.getCurrentColumn());
            if (tierName != null && this.nonEditableTiersList != null && this.nonEditableTiersList.contains(tierName)) {
                this.goToNextEditableCell();
                return;
            }
        }
        if ((editorComponent = this.getEditorComponent()) instanceof JComponent && this.getSurrendersFocusOnKeystroke()) {
            editorComponent.requestFocus();
        }
    }

    public void clearRows() {
        if (this.isEditing()) {
            TranscriptionTableCellEditor editor = (TranscriptionTableCellEditor)this.getCellEditor(this.getCurrentRow(), this.getCurrentColumn());
            editor.commitChanges();
        }
        while (this.getRowCount() > 0) {
            ((TranscriptionTableModel)this.getModel()).removeRow(0);
        }
        this.revalidate();
        this.setCurrentRow(0);
        this.setCurrentColumn(1);
    }

    @Override
    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        if (column == 0) {
            this.startEdit(null);
            return;
        }
        this.setCurrentRow(row);
        this.setCurrentColumn(column);
        if (this.scrollToCenter) {
            this.scrollIfNeeded();
        }
        super.changeSelection(row, column, toggle, extend);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if ((TranscriptionTableCellEditor)this.getCellEditor() != null) {
            ((TranscriptionTableCellEditor)this.getCellEditor()).commitChanges();
        }
        super.editingStopped(e);
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        super.editingCanceled(e);
        this.recalculateCurrentRowHeight();
    }

    public void setFontColorForTiers(HashMap fontColors) {
        if (fontColors != null) {
            this.prefTierFontColors.putAll(fontColors);
            for (Object key : fontColors.keySet()) {
                Object val = fontColors.get(key);
                if (!(val instanceof Color)) continue;
                this.prefTierBrighterFontColors.put((String)key, this.brighter((Color)val));
                this.prefTierBrightestFontColors.put((String)key, this.brightest((Color)val));
            }
        }
    }

    private Color brightest(Color orig) {
        double FACTOR = 0.16;
        return new Color((int)(255.0 - (double)(255 - orig.getRed()) * FACTOR), (int)(255.0 - (double)(255 - orig.getGreen()) * FACTOR), (int)(255.0 - (double)(255 - orig.getBlue()) * FACTOR));
    }

    private Color brighter(Color orig) {
        double FACTOR = 0.3;
        return new Color((int)(255.0 - (double)(255 - orig.getRed()) * FACTOR), (int)(255.0 - (double)(255 - orig.getGreen()) * FACTOR), (int)(255.0 - (double)(255 - orig.getBlue()) * FACTOR));
    }

    public Color getFontColorForTier(String tierName) {
        return (Color)this.prefTierFontColors.get(tierName);
    }

    public Color getBrighterFontColorForTier(String tierName) {
        return this.prefTierBrighterFontColors.get(tierName);
    }

    public Color getBrightestFontColorForTier(String tierName) {
        return this.prefTierBrightestFontColors.get(tierName);
    }

    public HashMap getFontColorTierMap() {
        return this.prefTierFontColors;
    }

    public void setFontsForTiers(HashMap fontNames) {
        this.prefTierFonts.clear();
        if (fontNames != null) {
            for (String key : fontNames.keySet()) {
                String fn = ((Font)fontNames.get(key)).getName();
                if (fn == null) continue;
                this.prefTierFonts.put(key, new Font(fn, 0, this.getFontSize()));
            }
        }
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public Font getFontForTier(String tierName) {
        return (Font)this.prefTierFonts.get(tierName);
    }

    private void recalculateCurrentRowHeight() {
        int fontHeight = 0;
        int rowHeightValue = 0;
        FontMetrics fm = null;
        Graphics g = this.getGraphics();
        for (int i = 1; i < this.getColumnCount(); ++i) {
            Annotation ann;
            String value = null;
            Object c = this.getValueAt(this.getCurrentRow(), i);
            if (!(c instanceof Annotation) || (value = (ann = (Annotation)c).getValue()) == null) continue;
            Font f = this.getFontForTier(ann.getTier().getName());
            if (f != null) {
                f = new Font(f.getFontName(), f.getStyle(), this.getFontSize());
                fm = this.getFontMetrics(f);
            } else {
                f = new Font(this.getFont().getFontName(), this.getFont().getStyle(), this.getFontSize());
                fm = this.getFontMetrics(f);
            }
            int height = fm.getAscent() + fm.getDescent() + 3;
            if (height > fontHeight) {
                fontHeight = height;
            }
            Rectangle2D r = fm.getStringBounds(value, g);
            Rectangle rt = r.getBounds();
            double width = rt.getWidth() + 10.0;
            int coulumnWidth = this.getColumnModel().getColumn(i).getWidth();
            int newRowHeight = 0;
            if (width > (double)coulumnWidth) {
                int y = (int)(width / (double)coulumnWidth);
                newRowHeight = (1 + y) * fontHeight;
            } else {
                newRowHeight = fontHeight;
            }
            if (newRowHeight > rowHeightValue) {
                rowHeightValue = newRowHeight;
            }
            if (rowHeightValue > this.rowHeight) {
                this.setRowHeight(this.getCurrentRow(), rowHeightValue + 10);
                continue;
            }
            this.setRowHeight(this.getCurrentRow(), this.rowHeight + 10);
        }
        this.revalidate();
    }

    public void reCalculateRowHeight() {
        FontMetrics fm = null;
        Graphics g = this.getGraphics();
        for (int x = 0; x < this.getRowCount(); ++x) {
            int fontHeight = 0;
            int rowHeightValue = 0;
            for (int i = 1; i < this.getColumnCount(); ++i) {
                String value = null;
                Object c = this.getValueAt(x, i);
                if (c instanceof Annotation) {
                    Annotation ann = (Annotation)c;
                    value = ann.getValue();
                    if (value == null) continue;
                    Font f = this.getFontForTier(ann.getTier().getName());
                    if (f != null) {
                        f = new Font(f.getFontName(), f.getStyle(), this.getFontSize());
                        fm = this.getFontMetrics(f);
                    } else {
                        f = new Font(this.getFont().getFontName(), this.getFont().getStyle(), this.getFontSize());
                        fm = this.getFontMetrics(f);
                    }
                    int height = fm.getAscent() + fm.getDescent() + 3;
                    if (height > fontHeight) {
                        fontHeight = height;
                    }
                    Rectangle2D r = fm.getStringBounds(value, g);
                    Rectangle rt = r.getBounds();
                    double width = rt.getWidth() + 10.0;
                    int coulumnWidth = this.getColumnModel().getColumn(i).getWidth();
                    int newRowHeight = 0;
                    if (width > (double)coulumnWidth) {
                        int y = (int)(width / (double)coulumnWidth);
                        newRowHeight = (1 + y) * fontHeight;
                    } else {
                        newRowHeight = fontHeight;
                    }
                    if (newRowHeight > rowHeightValue) {
                        rowHeightValue = newRowHeight;
                    }
                    if (rowHeightValue > this.rowHeight) {
                        this.setRowHeight(x, rowHeightValue + 10);
                        continue;
                    }
                    this.setRowHeight(x, this.rowHeight + 10);
                    continue;
                }
                if (c instanceof TableSubHeaderObject) {
                    fm = this.getFontMetrics(this.getFont());
                    int height = fm.getAscent() + fm.getDescent() + 3;
                    if (height > this.rowHeight) {
                        this.setRowHeight(x, height);
                        continue;
                    }
                    this.setRowHeight(x, this.rowHeight + 10);
                    continue;
                }
                if (rowHeightValue > this.rowHeight) {
                    this.setRowHeight(x, rowHeightValue + 10);
                    continue;
                }
                this.setRowHeight(x, this.rowHeight + 10);
            }
        }
    }
}

