/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTable;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableEditBox;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableModel;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.client.util.TableSubHeaderObject;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TranscriptionTableCellEditor
extends DefaultCellEditor {
    private static final String EMPTY = "";
    private Annotation annotation;
    private TranscriptionTableEditBox inlineEditBox;
    private TranscriptionViewer viewer;
    private int startEditInOneClick = 1;

    public TranscriptionTableCellEditor(TranscriptionViewer viewer) {
        super(new JTextField());
        this.getComponent().setEnabled(false);
        this.viewer = viewer;
        this.setClickCountToStart(this.startEditInOneClick);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.annotation = null;
        if (this.inlineEditBox == null) {
            this.inlineEditBox = new TranscriptionTableEditBox(this.viewer, (TranscriptionTable)table);
        }
        if (value instanceof Annotation) {
            this.annotation = (Annotation)value;
            this.configureEditBox(table, row, column);
            this.viewer.updateMedia(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
            if (this.viewer.isAutoPlayBack()) {
                this.viewer.playInterval(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary(), false);
            }
            this.inlineEditBox.startEdit();
            return this.inlineEditBox.getEditorComponent();
        }
        if (value instanceof String && value.toString().contains("create")) {
            try {
                this.annotation = this.createAnnotation(table, row, column);
                if (this.annotation != null) {
                    table.setValueAt(this.annotation, row, column);
                    this.configureEditBox(table, row, column);
                    this.viewer.updateMedia(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
                    if (this.viewer.isAutoPlayBack()) {
                        this.viewer.playInterval(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary(), false);
                    }
                    this.inlineEditBox.startEdit();
                    return this.inlineEditBox.getEditorComponent();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this.getComponent();
            }
        }
        return this.getComponent();
    }

    public TranscriptionTableEditBox getEditorComponent() {
        if (this.inlineEditBox != null) {
            return this.inlineEditBox;
        }
        return null;
    }

    private Annotation createAnnotation(JTable table, int row, int column) {
        String currentColumn = table.getColumnName(column);
        int columnNo = -1;
        for (int i = 1; i < table.getColumnCount(); ++i) {
            String columnName = TranscriptionTableModel.COLUMN_PREFIX + i;
            if (!currentColumn.startsWith(columnName)) continue;
            columnNo = i;
            break;
        }
        int columnIndexInMap = columnNo - 1;
        AbstractAnnotation ann = null;
        Annotation newAnnotation = null;
        TierImpl currentTier = null;
        long beginTime = 0L;
        long endTime = 0L;
        for (int i = 1; i < table.getColumnCount(); ++i) {
            Object val;
            if (i == column || !((val = table.getValueAt(row, i)) instanceof Annotation)) continue;
            ann = (AbstractAnnotation)val;
            break;
        }
        if (ann == null) {
            String value = (String)table.getValueAt(row, column);
            String[] s = value.split(";");
            String[] timeValue = s[2].split(":");
            if (timeValue != null) {
                int i;
                for (i = 0; i < timeValue.length; ++i) {
                    String time = timeValue[i];
                    try {
                        long t = Long.parseLong(time.trim());
                        if (i == 0) {
                            beginTime = t;
                            continue;
                        }
                        if (i != 1) continue;
                        endTime = t;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.out.println(e);
                    }
                }
                if (this.viewer.isTierNamesShown()) {
                    for (i = row - 1; i >= 0; --i) {
                        Object obj = table.getValueAt(i, column);
                        if (!(obj instanceof TableSubHeaderObject)) continue;
                        String name = obj.toString();
                        currentTier = (TierImpl)this.viewer.getViewerManager().getTranscription().getTierWithId(name);
                    }
                } else {
                    String tierName = s[1];
                    currentTier = (TierImpl)this.viewer.getViewerManager().getTranscription().getTierWithId(tierName);
                }
            }
        } else {
            beginTime = ann.getBeginTimeBoundary();
            endTime = ann.getEndTimeBoundary();
            TierImpl linkedTier = (TierImpl)ann.getTier();
            if (linkedTier.getLinguisticType().getConstraints() != null && linkedTier.getLinguisticType().getConstraints().getStereoType() == 4) {
                TierImpl parentTier = (TierImpl)linkedTier.getParentTier();
                while (parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4) {
                    parentTier = (TierImpl)parentTier.getParentTier();
                }
                currentTier = this.viewer.getTierMap().get(parentTier).get(columnIndexInMap);
            } else {
                currentTier = this.viewer.getTierMap().get(linkedTier).get(columnIndexInMap);
            }
        }
        if (currentTier != null) {
            if (currentTier.isTimeAlignable()) {
                newAnnotation = currentTier.createAnnotation(beginTime, endTime);
            } else {
                long time = (beginTime + endTime) / 2L;
                newAnnotation = currentTier.createAnnotation(time, time);
            }
        }
        return newAnnotation;
    }

    private void configureEditBox(JTable table, int row, int column) {
        this.inlineEditBox.setAnnotation(this.annotation);
        Font ff = null;
        if (table instanceof TranscriptionTable) {
            ff = ((TranscriptionTable)table).getFontForTier(((Annotation)table.getValueAt(row, column)).getTier().getName());
            if (ff == null) {
                ff = table.getFont();
            }
            ff = new Font(ff.getFontName(), ff.getStyle(), ((TranscriptionTable)table).getFontSize());
        }
        if (this.inlineEditBox.isUsingControlledVocabulary()) {
            this.inlineEditBox.configureEditor(JComboBox.class, ff, table.getCellRect(row, column, true).getSize());
        } else {
            this.inlineEditBox.configureEditor(JTextArea.class, ff, table.getCellRect(row, column, true).getSize());
        }
    }

    public Object getCellEditorValue() {
        if (this.annotation != null) {
            return this.annotation;
        }
        return EMPTY;
    }

    public void showPopUp(Component comp, int x, int y) {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.showPopUp(comp, x, y);
        }
    }

    public void updateLocale() {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.updateLocale();
        }
    }

    public void commitChanges() {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.commitChanges();
        }
    }

    public void cancelCellEditing() {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.cancelEdit();
        }
    }
}

