/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTable;
import mpi.eudico.client.util.TableSubHeaderObject;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptionTableCellRenderer
extends DefaultTableCellRenderer {
    JTextArea area;
    private boolean showTierNames = true;
    private boolean colorOnlyOnNoColumn = false;
    private Transcription transcription;
    public static final Color NO_ANN_BG = new Color(230, 230, 250);
    private final JLabel EMPTY_LABEL = new JLabel();
    private final Color DEF_LABEL_BG;
    private final Color DEF_AREA_BG;
    private List<String> nonEditableTiers;
    private final String TOOL_TIP_TEXT_PARTICIPANT = ElanLocale.getString("TranscriptionTable.ToolTipTextForParticipant");

    public TranscriptionTableCellRenderer(Transcription transcription) {
        this.transcription = transcription;
        this.EMPTY_LABEL.setOpaque(true);
        this.DEF_LABEL_BG = new Color(this.EMPTY_LABEL.getBackground().getRed(), this.EMPTY_LABEL.getBackground().getGreen(), this.EMPTY_LABEL.getBackground().getBlue());
        this.area = new JTextArea();
        this.DEF_AREA_BG = this.area.getBackground();
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        this.area.setMargin(new Insets(0, 3, 0, 3));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table.getColumnName(column).equals(ElanLocale.getString("TranscriptionTable.Column.No"))) {
            this.setForeground(Color.BLACK);
            this.setFont(table.getFont().deriveFont(0, table.getFont().getSize()));
            this.setText(value.toString());
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
            this.setOpaque(true);
            if (table.getSelectedRow() == row) {
                this.setBackground(Color.LIGHT_GRAY);
            } else {
                this.setBackground(this.DEF_LABEL_BG);
            }
            if (!this.showTierNames && this.colorOnlyOnNoColumn) {
                Object val;
                int i;
                TierImpl parentTier = null;
                for (i = 1; i < table.getColumnCount(); ++i) {
                    val = table.getValueAt(row, i);
                    if (!(val instanceof Annotation)) continue;
                    TierImpl tier = (TierImpl)((Annotation)val).getTier();
                    if (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 4) {
                        parentTier = tier;
                        break;
                    }
                    parentTier = (TierImpl)tier.getParentTier();
                    while (parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4) {
                        parentTier = (TierImpl)parentTier.getParentTier();
                    }
                    break;
                }
                if (parentTier == null) {
                    for (i = 1; i < table.getColumnCount(); ++i) {
                        String text;
                        String[] s;
                        String tierName;
                        TierImpl tier;
                        val = table.getValueAt(row, i);
                        if (!(val instanceof String) || (tier = (TierImpl)this.transcription.getTierWithId(tierName = (s = (text = val.toString()).split(";"))[1])) == null) continue;
                        if (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 4) {
                            parentTier = tier;
                            break;
                        }
                        parentTier = (TierImpl)tier.getParentTier();
                        while (parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4) {
                            parentTier = (TierImpl)parentTier.getParentTier();
                        }
                        break;
                    }
                }
                if (parentTier != null) {
                    this.setBackground(((TranscriptionTable)table).getBrightestFontColorForTier(parentTier.getName()));
                    if (parentTier.getParticipant() != null) {
                        this.setToolTipText(this.TOOL_TIP_TEXT_PARTICIPANT + " : " + parentTier.getParticipant());
                    }
                    if (table.getSelectedRow() == row) {
                        this.setBackground(((TranscriptionTable)table).getBrighterFontColorForTier(parentTier.getName()));
                    }
                }
            }
            return this;
        }
        if (value instanceof TableSubHeaderObject) {
            this.setFont(table.getFont().deriveFont(0, table.getFont().getSize() + 2));
            this.setText(value.toString());
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(this.EMPTY_LABEL.getVerticalAlignment());
            this.setOpaque(true);
            if (value.toString().trim().length() > 0) {
                Color c = ((TranscriptionTable)table).getFontColorForTier(value.toString());
                this.setForeground(c);
                this.setBackground(((TranscriptionTable)table).getBrightestFontColorForTier(value.toString()));
            } else {
                this.setBackground(this.DEF_LABEL_BG);
            }
            return this;
        }
        if (value == null) {
            return this.EMPTY_LABEL;
        }
        this.area.setText(this.getRenderedText(value));
        this.area.setToolTipText(this.getToolTipText(value));
        String tierName = ((TranscriptionTable)table).getTierName(row, column);
        if (tierName != null && this.nonEditableTiers != null && this.nonEditableTiers.contains(tierName)) {
            this.area.setBackground(this.DEF_LABEL_BG);
            return this.area;
        }
        this.area.setBackground(this.DEF_AREA_BG);
        if (value instanceof Annotation) {
            Font f = ((TranscriptionTable)table).getFontForTier(((Annotation)value).getTier().getName());
            if (f != null) {
                this.area.setFont(new Font(f.getFontName(), f.getStyle(), table.getFont().getSize()));
            } else {
                this.area.setFont(table.getFont());
            }
            if (!this.showTierNames && !this.colorOnlyOnNoColumn) {
                Color c = ((TranscriptionTable)table).getFontColorForTier(((Annotation)value).getTier().getName());
                this.area.setBackground(((TranscriptionTable)table).getBrightestFontColorForTier(((Annotation)value).getTier().getName()));
            }
        } else if (value instanceof String) {
            if (this.showTierNames) {
                this.area.setBackground(NO_ANN_BG);
            } else if (this.colorOnlyOnNoColumn) {
                this.area.setBackground(NO_ANN_BG);
            }
        }
        return this.area;
    }

    public void setShowTierNames(boolean bool) {
        this.showTierNames = bool;
    }

    public void setNonEditableTiers(List<String> tiers) {
        this.nonEditableTiers = tiers;
    }

    public void showColorOnlyOnNoColumn(boolean bool) {
        this.colorOnlyOnNoColumn = bool;
    }

    private String getRenderedText(Object value) {
        return value instanceof Annotation ? ((Annotation)value).getValue() : (value instanceof String ? "" : null);
    }

    private String getToolTipText(Object value) {
        String toolTipText = null;
        if (value instanceof Annotation) {
            if (!this.showTierNames) {
                String participant = ((TierImpl)((Annotation)value).getTier()).getParticipant();
                toolTipText = ((Annotation)value).getTier().getName();
                if (participant != null) {
                    toolTipText = toolTipText + " : " + participant;
                }
            } else {
                toolTipText = ((Annotation)value).getBeginTimeBoundary() + " - " + ((Annotation)value).getEndTimeBoundary();
            }
        } else if (value instanceof String) {
            if (!this.showTierNames) {
                String[] values = ((String)value).split(";");
                if (values.length >= 2) {
                    TierImpl tier = (TierImpl)this.transcription.getTierWithId(values[1]);
                    String participant = tier.getParticipant();
                    toolTipText = tier.getName();
                    if (participant != null) {
                        toolTipText = toolTipText + " : " + participant;
                    }
                }
            } else {
                long beginTime = -1L;
                long endTime = -1L;
                String[] values = ((String)value).split(";");
                if (values.length >= 3) {
                    String[] timeValue = values[2].split(":");
                    if (timeValue != null) {
                        for (int i = 0; i < timeValue.length; ++i) {
                            String time = timeValue[i];
                            try {
                                long t = Long.parseLong(time.trim());
                                if (i == 0) {
                                    beginTime = t;
                                    continue;
                                }
                                if (i != 1) continue;
                                endTime = t;
                                continue;
                            }
                            catch (NumberFormatException e) {
                                System.out.println(e);
                            }
                        }
                    }
                    if (beginTime > -1L && endTime > -1L) {
                        toolTipText = beginTime + " - " + endTime;
                    }
                }
            }
        } else {
            return null;
        }
        return toolTipText;
    }
}

