/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTable;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceGroup;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;

public class TranscriptionTableEditBox
extends JPanel
implements ActionListener,
MouseListener,
KeyListener,
ElanLocaleListener,
DocumentListener {
    private static final String EDIT_MENU_CMT = "Commit Changes";
    private static final String EDIT_MENU_CNL = "Cancel Changes";
    private static final String EDIT_IN_ANN_MODE = "Anno mode";
    private static final Logger LOG = Logger.getLogger(TranscriptionTableEditBox.class.getName());
    private JTextArea textArea = new JTextArea();
    private JPopupMenu popupMenu = new JPopupMenu();
    private String oldText;
    private Annotation annotation;
    private TranscriptionTable table = null;
    private TranscriptionViewer viewer;
    private boolean isUsingControlledVocabulary = false;
    private JMenuItem commitMI;
    private JMenuItem cancelMI;
    private JMenuItem mergeBeforeMI;
    private JMenuItem mergeNextMI;
    private JMenuItem deleteAnnotationMI;
    private JMenuItem editInAnnModeMI;
    private JMenuItem selectAllMI;
    private JMenuItem cutMI;
    private JMenuItem copyMI;
    private JMenuItem pasteMI;
    private JMenuItem nonEditableTierMI;
    private JMenuItem hideAllTiersMI;
    private JMenuItem showHideMoreMI;
    private CVEntryComponent cvEntryComp;
    private int caretPosition = -1;
    private int minRowHeight;
    private int maxHtForOtherColumn = 0;
    private boolean heightComputed = false;
    private JComponent editorComponent;
    private Font uniFont = Constants.DEFAULTFONT;
    private boolean isEditing = false;
    private final FocusListener intFocusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            if (!TranscriptionTableEditBox.this.isUsingControlledVocabulary) {
                TranscriptionTableEditBox.this.textArea.requestFocus();
                TranscriptionTableEditBox.this.textArea.getCaret().setVisible(true);
            } else if (TranscriptionTableEditBox.this.cvEntryComp != null) {
                TranscriptionTableEditBox.this.cvEntryComp.grabFocus();
            }
        }

        public void focusLost(FocusEvent e) {
            if (!TranscriptionTableEditBox.this.isEditing) {
                TranscriptionTableEditBox.this.transferFocusUpCycle();
            }
        }
    };

    public TranscriptionTableEditBox(TranscriptionViewer viewer, TranscriptionTable table) {
        this.table = table;
        this.viewer = viewer;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.textArea.addMouseListener(this);
        this.textArea.setLineWrap(true);
        this.textArea.setMargin(new Insets(0, 3, 0, 3));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setBorder(new CompoundBorder(new LineBorder(Color.black, 1), new LineBorder(Color.white, 2)));
        this.add((Component)this.textArea, "Center");
        this.textArea.getCaret().setVisible(true);
        this.textArea.addKeyListener(this);
        this.textArea.addFocusListener(this.intFocusListener);
        this.textArea.getDocument().addDocumentListener(this);
        this.createPopupMenu();
        AbstractAction doNothing = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "doNothing");
    }

    public void createPopupMenu() {
        this.commitMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
        this.commitMI.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.commitMI.setActionCommand(EDIT_MENU_CMT);
        this.commitMI.addActionListener(this);
        this.popupMenu.add(this.commitMI);
        this.cancelMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cancelMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.cancelMI.setActionCommand(EDIT_MENU_CNL);
        this.cancelMI.addActionListener(this);
        this.popupMenu.add(this.cancelMI);
        this.editInAnnModeMI = new JMenuItem(ElanLocale.getString("TranscriptionTableEditBox.EditInAnnotationMode"));
        this.editInAnnModeMI.setActionCommand(EDIT_IN_ANN_MODE);
        this.editInAnnModeMI.addActionListener(this);
        this.popupMenu.add(this.editInAnnModeMI);
        this.mergeBeforeMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.MergeWithBefore"));
        this.mergeBeforeMI.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.mergeBeforeMI.addActionListener(this);
        this.popupMenu.add(this.mergeBeforeMI);
        this.mergeNextMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.MergeWithNext"));
        this.mergeNextMI.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.mergeNextMI.addActionListener(this);
        this.popupMenu.add(this.mergeNextMI);
        this.deleteAnnotationMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
        this.deleteAnnotationMI.setAccelerator(KeyStroke.getKeyStroke(127, 1));
        this.deleteAnnotationMI.addActionListener(this);
        this.popupMenu.add(this.deleteAnnotationMI);
        this.popupMenu.addSeparator();
        this.cutMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.cutMI.setActionCommand("cut");
        this.cutMI.addActionListener(this);
        this.popupMenu.add(this.cutMI);
        this.copyMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.copyMI.setActionCommand("copy");
        this.copyMI.addActionListener(this);
        this.popupMenu.add(this.copyMI);
        this.pasteMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        this.pasteMI.setActionCommand("paste");
        this.pasteMI.addActionListener(this);
        this.popupMenu.add(this.pasteMI);
        this.selectAllMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.SelectAll"));
        this.selectAllMI.setActionCommand("selectAll");
        this.selectAllMI.addActionListener(this);
        this.popupMenu.add(this.selectAllMI);
        this.popupMenu.addSeparator();
        this.nonEditableTierMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.NonEditableTier"));
        this.nonEditableTierMI.addActionListener(this);
        this.hideAllTiersMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.HideLinkedTiers"));
        this.hideAllTiersMI.addActionListener(this);
        this.showHideMoreMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.ShoworHideTiers"));
        this.showHideMoreMI.addActionListener(this);
        this.popupMenu.add(this.nonEditableTierMI);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.hideAllTiersMI);
        this.popupMenu.add(this.showHideMoreMI);
    }

    public boolean isUsingControlledVocabulary() {
        return this.isUsingControlledVocabulary;
    }

    public void setFont(Font font) {
        this.uniFont = font;
        if (this.textArea != null) {
            this.textArea.setFont(font);
        }
    }

    public void setAnnotation(Annotation ann, boolean forceOpenCV) {
        this.annotation = ann;
        this.oldText = ann.getValue();
        this.textArea.setText(this.oldText);
        try {
            this.isUsingControlledVocabulary = forceOpenCV ? false : ((TierImpl)this.annotation.getTier()).getLinguisticType().isUsingControlledVocabulary();
        }
        catch (Exception e) {
            this.isUsingControlledVocabulary = false;
        }
        if (!this.isUsingControlledVocabulary) {
            this.textArea.setEditable(true);
            if (this.caretPosition > 0 && this.caretPosition <= this.textArea.getText().length()) {
                this.textArea.setCaretPosition(this.caretPosition);
            } else {
                this.textArea.setCaretPosition(this.textArea.getText().length());
                this.caretPosition = -1;
            }
        } else {
            this.textArea.setEditable(false);
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(JComboBox.class);
            }
            this.cvEntryComp.setAnnotation(this.annotation);
        }
    }

    public void setAnnotation(Annotation ann) {
        this.setAnnotation(ann, false);
    }

    public boolean annotationModified() {
        return !this.oldText.equals(this.textArea.getText());
    }

    public void cancelEdit() {
        this.isEditing = false;
        this.heightComputed = false;
        this.setVisible(false);
        if (this.table != null) {
            this.table.editingCanceled(new ChangeEvent(this));
        }
    }

    public void commitChanges() {
        if (!this.isEditing || this.annotation == null) {
            return;
        }
        Object extRef = null;
        if (this.isUsingControlledVocabulary && this.cvEntryComp != null && this.cvEntryComp.getSelectedEntry() != null) {
            this.textArea.setText(this.cvEntryComp.getSelectedEntryValue());
            extRef = this.cvEntryComp.getSelectedEntry().getExternalRef();
            if (this.cvEntryComp.getSelectedEntry() instanceof ExternalCVEntry) {
                String entryId = ((ExternalCVEntry)this.cvEntryComp.getSelectedEntry()).getId();
                ExternalReferenceImpl extRefCv = new ExternalReferenceImpl(entryId, 5);
                ExternalReferenceGroup tmpExtRefGrp = new ExternalReferenceGroup();
                tmpExtRefGrp.addReference(extRefCv);
                if (extRef != null) {
                    try {
                        Object clone = ((ExternalReference)extRef).clone();
                        if (clone instanceof ExternalReference) {
                            tmpExtRefGrp.addReference((ExternalReference)clone);
                        }
                        extRef = tmpExtRefGrp;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    extRef = tmpExtRefGrp;
                }
            }
        }
        if (extRef == null && ((AbstractAnnotation)this.annotation).getExtRef() != null) {
            extRef = new ExternalReferenceImpl(null, 5);
        }
        String newText = "";
        boolean modified = this.annotationModified();
        if (modified) {
            newText = this.textArea.getText();
            this.setVisible(false);
            Command c = ELANCommandFactory.createCommand((Transcription)this.annotation.getTier().getParent(), "Menu.Annotation.ModifyAnnotation");
            Object[] args = new Object[]{this.oldText, newText, extRef};
            c.execute(this.annotation, args);
        }
        if (this.table != null) {
            if (!(this.editorComponent instanceof JComboBox) && this.oldText.length() != this.textArea.getText().length()) {
                this.recalculateRowHeight();
            }
            this.isEditing = false;
            this.heightComputed = false;
            this.table.editingStopped(new ChangeEvent(this));
        }
    }

    private void doCut() {
        this.textArea.cut();
        this.recalculateRowHeight();
    }

    private void doCopy() {
        this.textArea.copy();
    }

    private void doPaste() {
        this.textArea.paste();
        this.recalculateRowHeight();
    }

    private void doSelectAll() {
        this.textArea.selectAll();
    }

    private void mergeWithAnnBefore() {
        if (this.mergeBeforeMI.isEnabled()) {
            Annotation ann = (Annotation)this.table.getValueAt(this.table.getCurrentRow() - 1, this.table.getCurrentColumn());
            this.caretPosition = ann.getValue().length() + this.textArea.getCaretPosition();
            this.commitChanges();
            if (((TierImpl)this.annotation.getTier()).hasParentTier()) {
                this.viewer.mergeBeforeAnn(this.annotation.getParentAnnotation());
            } else {
                this.viewer.mergeBeforeAnn(this.annotation);
            }
        }
    }

    private void mergeWithNextAnn() {
        if (this.mergeNextMI.isEnabled()) {
            this.caretPosition = this.textArea.getCaretPosition();
            this.commitChanges();
            if (((TierImpl)this.annotation.getTier()).hasParentTier()) {
                this.viewer.mergeNextAnn(this.annotation.getParentAnnotation());
            } else {
                this.viewer.mergeNextAnn(this.annotation);
            }
        }
    }

    private void deleteAnnotation() {
        this.commitChanges();
        this.viewer.deleteAnnotation(this.annotation);
    }

    private void updatePopup() {
        if (this.textArea.getSelectedText() == null || this.textArea.getSelectedText().length() == 0) {
            this.cutMI.setEnabled(false);
            this.copyMI.setEnabled(false);
        } else {
            this.cutMI.setEnabled(true);
            this.copyMI.setEnabled(true);
        }
        if (this.isTextOnClipboard()) {
            this.pasteMI.setEnabled(true);
        } else {
            this.pasteMI.setEnabled(false);
        }
        if (this.textArea.getText() == null || this.textArea.getText().length() == 0) {
            this.selectAllMI.setEnabled(false);
        } else {
            this.selectAllMI.setEnabled(true);
        }
        if (this.annotation == null) {
            this.editInAnnModeMI.setEnabled(false);
        } else {
            this.editInAnnModeMI.setEnabled(true);
        }
        if (this.viewer.getMerge()) {
            Object obj;
            int leadColumn = this.table.getCurrentColumn();
            int leadRow = this.table.getCurrentRow();
            if (leadRow != 0) {
                obj = this.table.getValueAt(leadRow - 1, leadColumn);
                if (obj instanceof Annotation) {
                    if (this.annotation.getTier().equals(((Annotation)obj).getTier())) {
                        this.mergeBeforeMI.setEnabled(true);
                    } else {
                        this.mergeBeforeMI.setEnabled(false);
                    }
                } else {
                    this.mergeBeforeMI.setEnabled(false);
                }
            } else {
                this.mergeBeforeMI.setEnabled(false);
            }
            if (leadRow < this.table.getRowCount() - 1) {
                obj = this.table.getValueAt(leadRow + 1, leadColumn);
                if (obj instanceof Annotation) {
                    if (this.annotation.getTier().equals(((Annotation)obj).getTier())) {
                        this.mergeNextMI.setEnabled(true);
                    } else {
                        this.mergeNextMI.setEnabled(false);
                    }
                } else {
                    this.mergeNextMI.setEnabled(false);
                }
            } else {
                this.mergeNextMI.setEnabled(false);
            }
        } else {
            this.mergeBeforeMI.setEnabled(false);
            this.mergeNextMI.setEnabled(false);
        }
    }

    public void showPopUp(Component obj, int x, int y) {
        this.updatePopup();
        this.popupMenu.show(obj, x, y);
        this.popupMenu.setVisible(true);
    }

    private boolean isTextOnClipboard() {
        DataFlavor[] flavors;
        DataFlavor best;
        Transferable contents = null;
        try {
            contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        }
        catch (IllegalStateException ise) {
            LOG.warning("Could not access the system clipboard.");
        }
        return contents != null && (best = DataFlavor.selectBestTextFlavor(flavors = contents.getTransferDataFlavors())) != null;
    }

    public JComponent getEditorComponent() {
        if (this.editorComponent == null) {
            return this;
        }
        return this.editorComponent;
    }

    public void configureEditor(Class preferredComponent, Font font, Dimension size) {
        if (preferredComponent == JTextArea.class) {
            if (font != null) {
                this.setFont(font);
            }
            if (size != null) {
                this.setSize(size);
            }
            this.editorComponent = this.textArea;
        } else if (preferredComponent == JComboBox.class && this.isUsingControlledVocabulary) {
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(preferredComponent);
                this.cvEntryComp.setAnnotation(this.annotation);
            }
            if (font != null) {
                this.cvEntryComp.setFont(font);
            }
            if (size != null) {
                this.cvEntryComp.getEditorComponent().setSize(size);
            }
            this.editorComponent = this.cvEntryComp.getEditorComponent();
        }
    }

    public void startEdit() {
        if (this.isEditing) {
            return;
        }
        this.isEditing = true;
        if (this.editorComponent == this) {
            this.setVisible(true);
            this.requestFocus();
        } else if (this.isUsingControlledVocabulary) {
            this.cvEntryComp.grabFocus();
        } else {
            this.editorComponent.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(EDIT_MENU_CNL) || command.equals("close")) {
            this.cancelEdit();
        } else if (command.equals(EDIT_MENU_CMT)) {
            this.commitChanges();
        } else if (command.equals(EDIT_IN_ANN_MODE)) {
            this.commitChanges();
            if (this.annotation != null) {
                this.viewer.getViewerManager().getMasterMediaPlayer().stop();
                this.viewer.editInAnnotationMode();
            }
        } else if (command.equals("cut")) {
            this.doCut();
        } else if (command.equals("copy")) {
            this.doCopy();
        } else if (command.equals("paste")) {
            this.doPaste();
        } else if (command.equals("selectAll")) {
            this.doSelectAll();
        } else if (e.getSource() == this.mergeBeforeMI) {
            this.mergeWithAnnBefore();
        } else if (e.getSource() == this.mergeNextMI) {
            this.mergeWithNextAnn();
        } else if (e.getSource() == this.deleteAnnotationMI) {
            this.deleteAnnotation();
        } else if (e.getSource() == this.nonEditableTierMI) {
            this.commitChanges();
            this.viewer.editOrNoneditableTier(this.annotation.getTier().getName());
        } else if (e.getSource() == this.hideAllTiersMI) {
            this.commitChanges();
            this.viewer.hideTiersLinkedWith(this.annotation.getTier().getName());
        } else if (e.getSource() == this.showHideMoreMI) {
            this.commitChanges();
            this.viewer.showHideMoreTiers();
        }
    }

    public void cvChanged(ControlledVocabulary cv) {
        if (this.cvEntryComp != null) {
            this.cvEntryComp.cvChanged(cv);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            this.showPopUp(this.textArea, e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.cancelEdit();
        } else if (e.getKeyCode() == 38 && e.getModifiers() == 8) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellUp();
        } else if (e.getKeyCode() == 40 && e.getModifiers() == 8) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellDown();
        } else if (e.getKeyCode() == 37 && e.getModifiers() == 8) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellLeft();
        } else if (e.getKeyCode() == 39 && e.getModifiers() == 8) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellRight();
        } else if (e.getModifiers() == 1 && e.getKeyCode() == 9) {
            e.consume();
            this.viewer.playIntervalFromBeginTime(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (e.getKeyCode() == 9) {
            e.consume();
            this.viewer.playInterval(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary(), true);
        } else if (e.getModifiers() == 1 && e.getKeyCode() == 127) {
            e.consume();
            this.deleteAnnotation();
        } else if (e.getKeyCode() == 66 && e.getModifiers() == 2) {
            e.consume();
            this.mergeWithAnnBefore();
        } else if (e.getKeyCode() == 65 && e.getModifiers() == 2) {
            e.consume();
            this.mergeWithNextAnn();
        } else if (e.getKeyCode() == 67 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.doCopy();
        } else if (e.getKeyCode() == 86 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.doPaste();
        } else if (e.getKeyCode() == 88 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.doCut();
        } else if (e.getKeyCode() == 10) {
            e.consume();
            this.commitChanges();
            this.table.goToNextEditableCell();
            this.table.startEdit(e);
        } else if (e.getKeyCode() == 32 && e.getModifiers() == 2) {
            e.consume();
            this.viewer.playInterval(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary(), true);
        } else if (e.getKeyCode() == 76 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.viewer.toggleLoopMode();
        } else if (e.getKeyCode() != 90 && e.getKeyCode() != 89 || (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void updateLocale() {
        this.commitMI.setText(ElanLocale.getString("InlineEditBox.Commit"));
        this.cancelMI.setText(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cutMI.setText(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.copyMI.setText(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.pasteMI.setText(ElanLocale.getString("InlineEditBox.Edit.Paste"));
    }

    private void calculateMaxHieghtForOtherCells() {
        int longestTextInOtherColumn = 0;
        this.minRowHeight = this.table.getDefaultRowHeight() + 10;
        this.maxHtForOtherColumn = 0;
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            int length;
            Annotation ann;
            String value;
            Object c;
            if (i == this.table.getCurrentColumn() || !((c = this.table.getValueAt(this.table.getCurrentRow(), i)) instanceof Annotation) || (value = (ann = (Annotation)c).getValue()) == null || (length = value.length()) <= longestTextInOtherColumn) continue;
            longestTextInOtherColumn = length;
            this.maxHtForOtherColumn = this.getHeightForthisCell(ann, i);
        }
    }

    private int getHeightForthisCell(Annotation ann, int column) {
        int fontHeight = 0;
        int rowHeightValue = 0;
        FontMetrics fm = null;
        Graphics g = this.getGraphics();
        String value = ann.getValue();
        Font f = this.table.getFontForTier(ann.getTier().getName());
        if (f != null) {
            f = new Font(f.getFontName(), f.getStyle(), this.table.getFontSize());
            fm = this.getFontMetrics(f);
        } else {
            f = new Font(this.table.getFont().getFontName(), this.table.getFont().getStyle(), this.table.getFontSize());
            fm = this.getFontMetrics(f);
        }
        int height = fm.getAscent() + fm.getDescent() + 3;
        if (height > fontHeight) {
            fontHeight = height;
        }
        Rectangle2D r = fm.getStringBounds(value, g);
        Rectangle rt = r.getBounds();
        double width = rt.getWidth() + 10.0;
        int coulumnWidth = this.table.getColumnModel().getColumn(column).getWidth();
        int newRowHeight = 0;
        if (width > (double)coulumnWidth) {
            int y = (int)(width / (double)coulumnWidth);
            newRowHeight = (1 + y) * fontHeight;
        } else {
            newRowHeight = fontHeight;
        }
        if (newRowHeight > rowHeightValue) {
            rowHeightValue = newRowHeight;
        }
        if (rowHeightValue > this.minRowHeight) {
            return rowHeightValue + 10;
        }
        return this.minRowHeight;
    }

    private void recalculateRowHeight() {
        if (this.isEditing) {
            int height;
            if (!this.heightComputed) {
                this.calculateMaxHieghtForOtherCells();
                this.heightComputed = true;
            }
            if (this.maxHtForOtherColumn <= (height = this.textArea.getPreferredSize().height)) {
                if (this.minRowHeight < height) {
                    this.table.setRowHeight(this.table.getEditingRow(), height + 10);
                } else if (height < this.minRowHeight) {
                    this.table.setRowHeight(this.table.getEditingRow(), this.minRowHeight);
                }
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.oldText.length() == this.textArea.getText().length() || this.editorComponent instanceof JComboBox) {
            return;
        }
        this.recalculateRowHeight();
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.oldText.length() == this.textArea.getText().length() || this.editorComponent instanceof JComboBox) {
            return;
        }
        this.recalculateRowHeight();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    class CVEntryComponent {
        private JComboBox box;
        private CVEntry[] entries;
        private Annotation annotation;
        private int maxEntryLength = 0;

        public CVEntryComponent(Class componentClass) {
            this.initComponents(componentClass);
        }

        public ControlledVocabulary cvChanged(ControlledVocabulary cv) {
            BasicControlledVocabulary currentCV = null;
            if (this.annotation != null) {
                TierImpl tier = (TierImpl)this.annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                currentCV = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            if (currentCV != null && currentCV.equals(cv)) {
                this.fillComboBox(true);
                TranscriptionTableEditBox.this.commitChanges();
                TranscriptionTableEditBox.this.table.startEdit(null);
            }
            return null;
        }

        public JComponent getEditorComponent() {
            return this.box;
        }

        private void initComponents(Class component) {
            if (component == JComboBox.class && this.box == null) {
                this.box = new JComboBox();
                KeyAdapter keyList = new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            if (CVEntryComponent.this.box.getSelectedItem() != null) {
                                TranscriptionTableEditBox.this.keyPressed(e);
                            } else {
                                TranscriptionTableEditBox.this.cancelEdit();
                                TranscriptionTableEditBox.this.table.goToNextEditableCell();
                            }
                        } else {
                            TranscriptionTableEditBox.this.keyPressed(e);
                        }
                    }
                };
                this.box.addKeyListener(keyList);
            }
        }

        public void setFont(Font f) {
            this.box.setFont(f);
        }

        public void setAnnotation(Annotation annotation) {
            ControlledVocabulary oldCV = null;
            if (this.annotation != null) {
                TierImpl tier = (TierImpl)this.annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                oldCV = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            this.annotation = annotation;
            BasicControlledVocabulary cv = null;
            if (annotation != null) {
                TierImpl tier = (TierImpl)annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                cv = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            if (cv != null) {
                if (cv != oldCV || !(cv instanceof ExternalCV)) {
                    this.entries = cv.getEntries();
                    if (this.box != null) {
                        this.box.removeAllItems();
                    }
                    this.fillComboBox(true);
                } else {
                    this.fillComboBox(false);
                }
            } else {
                this.entries = new CVEntry[0];
                if (this.box != null) {
                    this.box.removeAllItems();
                }
                this.fillComboBox(false);
            }
        }

        private void fillComboBox(boolean reload) {
            String value = null;
            if (this.annotation != null) {
                value = this.annotation.getValue();
            }
            if (reload) {
                for (int i = 0; i < this.entries.length; ++i) {
                    this.box.addItem(this.entries[i]);
                    if (this.entries[i].getValue() == null || this.entries[i].getValue().length() <= this.maxEntryLength) continue;
                    this.maxEntryLength = this.entries[i].getValue().length();
                }
            }
            this.box.setSelectedIndex(-1);
            if (value != null) {
                for (int i = 0; i < this.box.getItemCount(); ++i) {
                    CVEntry entry = (CVEntry)this.box.getItemAt(i);
                    if (!value.equals(entry.getValue())) continue;
                    this.box.setSelectedIndex(i);
                    break;
                }
            }
        }

        public void grabFocus() {
            this.box.requestFocus();
        }

        public String getSelectedEntryValue() {
            String value = null;
            value = this.box.getSelectedItem() != null ? ((CVEntry)this.box.getSelectedItem()).getValue() : this.annotation.getValue();
            return value;
        }

        public CVEntry getSelectedEntry() {
            CVEntry value = null;
            if (this.box.getSelectedItem() != null) {
                value = (CVEntry)this.box.getSelectedItem();
            }
            return value;
        }

        public int getMaxEntryLength() {
            return this.maxEntryLength;
        }
    }
}

