/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.util.FileExtension;

public class ElanFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    public static final int MPEG_TYPE = 0;
    public static final int WAV_TYPE = 1;
    public static final int MEDIA_TYPE = 2;
    public static final int EAF_TYPE = 3;
    public static final int TEMPLATE_TYPE = 4;
    public static final int CHAT_TYPE = 5;
    public static final int WAC_TYPE = 6;
    public static final int SHOEBOX_TEXT_TYPE = 7;
    public static final int SHOEBOX_TYP_TYPE = 8;
    public static final int SHOEBOX_MKR_TYPE = 9;
    public static final int IMAGE_TYPE = 10;
    public static final int TEXT_TYPE = 11;
    public static final int TRANSCRIBER_TYPE = 12;
    public static final int SMIL_TYPE = 13;
    public static final int TIGER_TYPE = 14;
    public static final int HTML_TYPE = 15;
    public static final int MP4_TYPE = 16;
    public static final int QT_TYPE = 17;
    public static final int PRAAT_TEXTGRID_TYPE = 18;
    public static final int ELAN_PREFS_TYPE = 19;
    public static final int CSV_TYPE = 20;
    public static final int SUBTITLE_TYPE = 21;
    public static final int IMDI_TYPE = 22;
    public static final int XML_TYPE = 23;
    public static final int TOOLBOX_TEXT_TYPE = 24;
    public static final int ECV_TYPE = 25;
    public static final int EAQ_TYPE = 26;
    private List<String> filterList = new ArrayList<String>(5);
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ElanFileFilter() {
    }

    public ElanFileFilter(String extension) {
        this(extension, null);
    }

    public ElanFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public ElanFileFilter(String[] filters) {
        this(filters, null);
    }

    public ElanFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filterList.contains(extension)) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filterList == null) {
            this.filterList = new ArrayList<String>(5);
        }
        this.filterList.add(extension.toLowerCase());
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                String string = this.fullDescription = this.description == null ? "(" : this.description + " (";
                if (this.filterList != null && !this.filterList.isEmpty()) {
                    this.fullDescription = this.fullDescription + "*." + this.filterList.get(0);
                    if (this.filterList.size() > 1) {
                        for (int i = 1; i < this.filterList.size(); ++i) {
                            this.fullDescription = this.fullDescription + ", *." + this.filterList.get(i);
                        }
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public static FileFilter createFileFilter(int filterType) {
        ElanFileFilter eff = null;
        switch (filterType) {
            case 0: {
                eff = new ElanFileFilter(FileExtension.MPEG_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.MPEG"));
                break;
            }
            case 1: {
                eff = new ElanFileFilter(FileExtension.WAV_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.WAV"));
                break;
            }
            case 2: {
                eff = new ElanFileFilter(FileExtension.MEDIA_EXT, ElanLocale.getString("Frame.ElanFrame.NewDialog.MediaFilterDescription"));
                break;
            }
            case 3: {
                eff = new ElanFileFilter(FileExtension.EAF_EXT, ElanLocale.getString("Frame.ElanFrame.OpenDialog.FileDescription"));
                break;
            }
            case 4: {
                eff = new ElanFileFilter(FileExtension.TEMPLATE_EXT, ElanLocale.getString("Frame.ElanFrame.NewDialog.TemplateFilterDescription"));
                break;
            }
            case 5: {
                eff = new ElanFileFilter(FileExtension.CHAT_EXT, ElanLocale.getString("Frame.ElanFrame.OpenDialog.CHATFileDescription"));
                break;
            }
            case 6: {
                eff = new ElanFileFilter(FileExtension.WAC_EXT, ElanLocale.getString("ImportDialog.FileDescription.WAC"));
                break;
            }
            case 7: {
                eff = new ElanFileFilter(FileExtension.SHOEBOX_TEXT_EXT, ElanLocale.getString("ImportDialog.FileDescription.Shoebox"));
                break;
            }
            case 24: {
                eff = new ElanFileFilter(FileExtension.TOOLBOX_TEXT_EXT, ElanLocale.getString("ImportDialog.FileDescription.Toolbox"));
                break;
            }
            case 8: {
                eff = new ElanFileFilter(FileExtension.SHOEBOX_TYP_EXT, ElanLocale.getString("ImportDialog.FileDescription.ShoeboxType"));
                break;
            }
            case 9: {
                eff = new ElanFileFilter(FileExtension.SHOEBOX_MKR_EXT, ElanLocale.getString("ShoeboxMarkerDialog.FileDescription.ShoeboxMarker"));
                break;
            }
            case 12: {
                eff = new ElanFileFilter(FileExtension.TRANSCRIBER_EXT, ElanLocale.getString("ImportDialog.FileDescription.Transcriber"));
                break;
            }
            case 10: {
                eff = new ElanFileFilter(FileExtension.IMAGE_EXT, "");
                break;
            }
            case 11: {
                eff = new ElanFileFilter(FileExtension.TEXT_EXT, ElanLocale.getString("ExportDialog.FileDescription"));
                break;
            }
            case 14: {
                eff = new ElanFileFilter(FileExtension.TIGER_EXT, ElanLocale.getString("ExportDialog.FileDescription"));
                break;
            }
            case 13: {
                eff = new ElanFileFilter(FileExtension.SMIL_EXT, "");
                break;
            }
            case 15: {
                eff = new ElanFileFilter(FileExtension.HTML_EXT, ElanLocale.getString("ExportDialog.FileDescription.Html"));
                break;
            }
            case 16: {
                eff = new ElanFileFilter(FileExtension.MPEG4_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.MP4"));
                break;
            }
            case 17: {
                eff = new ElanFileFilter(FileExtension.QT_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.QT"));
                break;
            }
            case 18: {
                eff = new ElanFileFilter(FileExtension.PRAAT_TEXTGRID_EXT, ElanLocale.getString("ImportDialog.FileDesription.Praat.TG"));
                break;
            }
            case 19: {
                eff = new ElanFileFilter(FileExtension.ELAN_XML_PREFS_EXT, ElanLocale.getString("ImportDialog.FileDesription.ELANPref"));
                break;
            }
            case 20: {
                eff = new ElanFileFilter(FileExtension.CSV_EXT, ElanLocale.getString("ImportDialog.FileDesription.CSV"));
                break;
            }
            case 21: {
                eff = new ElanFileFilter(FileExtension.SUBTITLE_EXT, ElanLocale.getString("ExportDialog.FileDescription.Subtitle"));
                break;
            }
            case 22: {
                eff = new ElanFileFilter(FileExtension.IMDI_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.IMDI"));
                break;
            }
            case 23: {
                eff = new ElanFileFilter(FileExtension.XML_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.XML"));
                break;
            }
            case 25: {
                eff = new ElanFileFilter(FileExtension.ECV_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.ECV"));
                break;
            }
            case 26: {
                eff = new ElanFileFilter(FileExtension.EAQ_EXT, ElanLocale.getString("Frame.ElanFrame.FileDescription.EAQ"));
            }
        }
        return eff;
    }
}

