/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import mpi.eudico.client.annotator.util.AnnotationDataFlavor;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;

public class TransferableAnnotation
implements Transferable,
ClipboardOwner {
    private AnnotationDataRecord record;
    private static final DataFlavor[] flavors;
    private static final int STRING = 0;
    private static final int ANNOTATION = 1;

    public TransferableAnnotation(AnnotationDataRecord record) {
        if (record == null) {
            throw new NullPointerException("AnnotationDataRecord is null.");
        }
        this.record = record;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavors.length > 1 && flavor.equals(flavors[1])) {
            return this.record;
        }
        if (flavor.equals(flavors[0])) {
            return this.recordParamString();
        }
        return null;
    }

    private String recordParamString() {
        if (this.record != null) {
            return this.record.getValue() + ",T=" + this.record.getTierName() + ",B=" + this.record.getBeginTime() + ",E=" + this.record.getEndTime();
        }
        return "null";
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.record = null;
    }

    static {
        AnnotationDataFlavor flav = AnnotationDataFlavor.getInstance();
        flavors = flav == null ? new DataFlavor[]{DataFlavor.stringFlavor} : new DataFlavor[]{DataFlavor.stringFlavor, flav};
    }
}

