/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.TierOrder;
import mpi.eudico.client.annotator.TierOrderListener;
import mpi.eudico.client.annotator.gui.MenuScroller;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class AnnotationDensityViewer
extends AbstractViewer
implements ACMEditListener,
MouseListener,
ActionListener {
    private static Dimension SLIDERDIMENSION = new Dimension(600, 30);
    private final int imageHeight = 5;
    private int imageWidth;
    private Transcription transcription;
    private BufferedImage bi;
    private Graphics2D big2d;
    private BufferedImage displayImage;
    private JPopupMenu popup;
    private JMenu tierSubMenu;
    private List<JCheckBoxMenuItem> tierCheckBoxes;
    private JMenu annotatorSubMenu;
    private List<JCheckBoxMenuItem> annotatorCheckBoxes;
    private JMenu participantSubMenu;
    private List<JCheckBoxMenuItem> participantCheckBoxes;
    private JMenu linguisticTypeSubMenu;
    private List<JCheckBoxMenuItem> linguisticTypeCheckBoxes;
    private JRadioButtonMenuItem allAnnotationsRB;
    private ViewMode viewMode = ViewMode.SHOW_ALL;
    private List<String> viewModeKeywords = new ArrayList<String>();
    private TierOrder tierOrder;

    public AnnotationDensityViewer(Transcription transcription) {
        this.transcription = transcription;
        this.setPreferredSize(SLIDERDIMENSION);
        this.paintBuffer();
    }

    public void setTierOrderObject(TierOrder tierOrder) {
        this.tierOrder = tierOrder;
        tierOrder.addTierOrderListener(new TierOrderListener(){

            public void updateTierOrder(List tierOrder) {
                AnnotationDensityViewer.this.createPopupMenu();
            }
        });
    }

    public Dimension getMinimumSize() {
        return SLIDERDIMENSION;
    }

    public Dimension getPreferredSize() {
        return SLIDERDIMENSION;
    }

    private void paintBuffer() {
        this.imageWidth = this.getWidth() > 0 ? this.getWidth() : AnnotationDensityViewer.SLIDERDIMENSION.width;
        if (this.bi == null || this.bi.getWidth() != this.imageWidth || this.bi.getHeight() != 5) {
            this.bi = new BufferedImage(this.imageWidth, 5, 1);
            this.big2d = this.bi.createGraphics();
        }
        this.big2d.setColor(Color.lightGray);
        this.big2d.fillRect(0, 0, this.imageWidth, 5);
        this.big2d.setColor(Color.white);
        this.big2d.fillRect(0, 0, this.imageWidth, 1);
        this.big2d.drawLine(0, 0, 0, 5);
        this.big2d.setColor(Color.darkGray);
        this.big2d.fillRect(0, 4, this.imageWidth, 1);
        this.big2d.setColor(Color.darkGray.brighter());
        int duration = (int)this.getMediaDuration();
        if (duration == 0) {
            this.displayImage = this.bi;
            this.repaint();
            return;
        }
        this.updateAnnotationFilter();
        this.displayImage = this.bi;
        this.repaint();
    }

    private void updateAnnotationFilter() {
        Vector<Annotation> filtered_annotations = new Vector<Annotation>();
        Vector allTiers = this.transcription.getTiers();
        switch (this.viewMode) {
            case SHOW_BY_TIER: {
                for (String tierName : this.viewModeKeywords) {
                    TierImpl tier = (TierImpl)this.transcription.getTierWithId(tierName);
                    if (tier != null) {
                        Vector annos = tier.getAnnotations();
                        for (Object a : annos) {
                            filtered_annotations.add((Annotation)a);
                        }
                        continue;
                    }
                    this.viewModeKeywords.remove(tierName);
                }
                break;
            }
            case SHOW_BY_ANNOTATOR: {
                Vector annos;
                for (TierImpl t : allTiers) {
                    if (this.viewModeKeywords.contains(t.getAnnotator())) {
                        annos = t.getAnnotations();
                        for (Object a : annos) {
                            filtered_annotations.add((Annotation)a);
                        }
                        continue;
                    }
                    this.viewModeKeywords.remove(t.getAnnotator());
                }
                break;
            }
            case SHOW_BY_PARTICIPANT: {
                Vector annos;
                for (TierImpl t : allTiers) {
                    if (this.viewModeKeywords.contains(t.getParticipant())) {
                        annos = t.getAnnotations();
                        for (Object a : annos) {
                            filtered_annotations.add((Annotation)a);
                        }
                        continue;
                    }
                    this.viewModeKeywords.remove(t.getParticipant());
                }
                break;
            }
            case SHOW_BY_TYPE: {
                Vector annos;
                for (TierImpl t : allTiers) {
                    if (this.viewModeKeywords.contains(t.getLinguisticType().getLinguisticTypeName())) {
                        annos = t.getAnnotations();
                        for (Object a : annos) {
                            filtered_annotations.add((Annotation)a);
                        }
                        continue;
                    }
                    this.viewModeKeywords.remove(t.getLinguisticType());
                }
                break;
            }
            default: {
                Vector annos;
                for (TierImpl t : allTiers) {
                    annos = t.getAnnotations();
                    for (Object a : annos) {
                        filtered_annotations.add((Annotation)a);
                    }
                }
            }
        }
        for (Annotation annotation : filtered_annotations) {
            int begintime = (int)annotation.getBeginTimeBoundary();
            int endtime = (int)annotation.getEndTimeBoundary();
            int midtime = (begintime + endtime) / 2;
            int intx = (int)((float)this.imageWidth * ((float)midtime / (float)this.getMediaDuration()));
            this.big2d.drawLine(intx, 0, intx, 5);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getWidth() != this.imageWidth) {
            this.paintBuffer();
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.displayImage != null) {
            g2d.drawImage((Image)this.displayImage, 0, 15, this);
        }
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu("Density");
        this.allAnnotationsRB = new JRadioButtonMenuItem(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        this.allAnnotationsRB.setSelected(true);
        this.allAnnotationsRB.addActionListener(this);
        this.popup.add(this.allAnnotationsRB);
        this.popup.addSeparator();
        this.tierSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuTier"));
        this.annotatorSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuAnnotator"));
        this.participantSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuParticipant"));
        this.linguisticTypeSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuLinguisticType"));
        MenuScroller.setScrollerFor(this.tierSubMenu);
        MenuScroller.setScrollerFor(this.linguisticTypeSubMenu);
        if (this.transcription != null) {
            AbstractList allTiers;
            if (this.tierOrder != null && this.tierOrder.getTierOrder() != null) {
                List tierOrderList = this.tierOrder.getTierOrder();
                allTiers = new ArrayList();
                for (int i = 0; i < tierOrderList.size(); ++i) {
                    TierImpl t = (TierImpl)this.transcription.getTierWithId((String)tierOrderList.get(i));
                    if (t == null || allTiers.contains(t)) continue;
                    allTiers.add(t);
                }
            } else {
                allTiers = this.transcription.getTiers();
            }
            this.tierCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            this.annotatorCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            HashSet<String> annotators = new HashSet<String>();
            this.participantCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            HashSet<String> participants = new HashSet<String>();
            this.linguisticTypeCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            for (TierImpl tier : allTiers) {
                String name = tier.getName();
                JCheckBoxMenuItem tierCheckBoxItem = new JCheckBoxMenuItem(name);
                tierCheckBoxItem.setActionCommand("TIER_" + name);
                tierCheckBoxItem.addActionListener(this);
                this.tierCheckBoxes.add(tierCheckBoxItem);
                this.tierSubMenu.add(tierCheckBoxItem);
                if (tier.getAnnotator().length() != 0) {
                    annotators.add(tier.getAnnotator());
                } else {
                    annotators.add("-");
                }
                if (tier.getParticipant().length() != 0) {
                    participants.add(tier.getParticipant());
                    continue;
                }
                participants.add("-");
            }
            for (String annotator : annotators) {
                JCheckBoxMenuItem annotatorCheckBoxItem = new JCheckBoxMenuItem(annotator);
                annotatorCheckBoxItem.setActionCommand("ANNO_" + annotator);
                annotatorCheckBoxItem.addActionListener(this);
                this.annotatorCheckBoxes.add(annotatorCheckBoxItem);
                this.annotatorSubMenu.add(annotatorCheckBoxItem);
            }
            for (String participant : participants) {
                JCheckBoxMenuItem participantCheckBoxItem = new JCheckBoxMenuItem(participant);
                participantCheckBoxItem.setActionCommand("PART_" + participant);
                participantCheckBoxItem.addActionListener(this);
                this.participantCheckBoxes.add(participantCheckBoxItem);
                this.participantSubMenu.add(participantCheckBoxItem);
            }
            Vector linguisticTypes = this.transcription.getLinguisticTypes();
            for (LinguisticType linguisticType : linguisticTypes) {
                JCheckBoxMenuItem linguisticTypeCheckboxItem = new JCheckBoxMenuItem(linguisticType.getLinguisticTypeName());
                linguisticTypeCheckboxItem.setActionCommand("TYPE_" + linguisticType.getLinguisticTypeName());
                linguisticTypeCheckboxItem.addActionListener(this);
                this.linguisticTypeCheckBoxes.add(linguisticTypeCheckboxItem);
                this.linguisticTypeSubMenu.add(linguisticTypeCheckboxItem);
            }
        }
        this.popup.add(this.tierSubMenu);
        this.popup.add(this.participantSubMenu);
        this.popup.add(this.annotatorSubMenu);
        this.popup.add(this.linguisticTypeSubMenu);
    }

    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                this.createPopupMenu();
                this.updateAnnotationFilter();
            }
        }
        this.paintBuffer();
    }

    public void updateLocale() {
        if (this.allAnnotationsRB != null) {
            this.allAnnotationsRB.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        }
        if (this.tierSubMenu != null) {
            this.tierSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuTier"));
        }
        if (this.annotatorSubMenu != null) {
            this.annotatorSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuAnnotator"));
        }
        if (this.participantSubMenu != null) {
            this.participantSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuParticipant"));
        }
        if (this.linguisticTypeSubMenu != null) {
            this.linguisticTypeSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuLinguisticType"));
        }
    }

    public void updateActiveAnnotation() {
    }

    public void updateSelection() {
    }

    public void controllerUpdate(ControllerEvent event) {
    }

    public void preferencesChanged() {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.popup.show(this, e.getPoint().x, e.getPoint().y);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void deselectTiers() {
        this.viewModeKeywords.clear();
        for (JCheckBoxMenuItem tierCheckBox : this.tierCheckBoxes) {
            tierCheckBox.setSelected(false);
        }
    }

    private void deselectAnnotators() {
        this.viewModeKeywords.clear();
        for (JCheckBoxMenuItem annotatorCheckbox : this.annotatorCheckBoxes) {
            annotatorCheckbox.setSelected(false);
        }
    }

    private void deselectParticipants() {
        this.viewModeKeywords.clear();
        for (JCheckBoxMenuItem participantCheckBox : this.participantCheckBoxes) {
            participantCheckBox.setSelected(false);
        }
    }

    private void deselectLinguisticTypes() {
        this.viewModeKeywords.clear();
        for (JCheckBoxMenuItem linguisticTypeCheckBox : this.linguisticTypeCheckBoxes) {
            linguisticTypeCheckBox.setSelected(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        ViewMode old_viewMode = this.viewMode;
        if (e.getSource() == this.allAnnotationsRB) {
            this.viewMode = ViewMode.SHOW_ALL;
            this.deselectLinguisticTypes();
            this.deselectAnnotators();
            this.deselectParticipants();
            this.deselectTiers();
            this.viewModeKeywords.clear();
        } else {
            String keyword = e.getActionCommand().substring(5);
            String filterType = e.getActionCommand().substring(0, 5);
            if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                this.allAnnotationsRB.setSelected(false);
                if (filterType.equals("TIER_")) {
                    this.viewMode = ViewMode.SHOW_BY_TIER;
                }
                if (filterType.equals("ANNO_")) {
                    this.viewMode = ViewMode.SHOW_BY_ANNOTATOR;
                }
                if (filterType.equals("PART_")) {
                    this.viewMode = ViewMode.SHOW_BY_PARTICIPANT;
                }
                if (filterType.equals("TYPE_")) {
                    this.viewMode = ViewMode.SHOW_BY_TYPE;
                }
                if (old_viewMode != this.viewMode) {
                    switch (this.viewMode) {
                        case SHOW_BY_TIER: {
                            this.deselectLinguisticTypes();
                            this.deselectAnnotators();
                            this.deselectParticipants();
                            break;
                        }
                        case SHOW_BY_ANNOTATOR: {
                            this.deselectLinguisticTypes();
                            this.deselectParticipants();
                            this.deselectTiers();
                            break;
                        }
                        case SHOW_BY_PARTICIPANT: {
                            this.deselectLinguisticTypes();
                            this.deselectAnnotators();
                            this.deselectTiers();
                            break;
                        }
                        case SHOW_BY_TYPE: {
                            this.deselectAnnotators();
                            this.deselectParticipants();
                            this.deselectTiers();
                            break;
                        }
                    }
                }
                if ("-".equals(keyword)) {
                    this.viewModeKeywords.add("");
                } else {
                    this.viewModeKeywords.add(keyword);
                }
            } else {
                if ("-".equals(keyword)) {
                    this.viewModeKeywords.remove("");
                } else {
                    this.viewModeKeywords.remove(keyword);
                }
                if (this.viewModeKeywords.size() == 0) {
                    this.viewMode = ViewMode.SHOW_ALL;
                    this.allAnnotationsRB.setSelected(true);
                }
            }
        }
        this.paintBuffer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ViewMode {
        SHOW_ALL,
        SHOW_BY_TIER,
        SHOW_BY_TYPE,
        SHOW_BY_ANNOTATOR,
        SHOW_BY_PARTICIPANT;

    }
}

