/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.annotator.viewer.TimeScaleBasedViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.util.TimeFormatter;

public class DefaultTimeScaleBasedViewer
extends TimeScaleBasedViewer
implements ComponentListener,
ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    public final int DEFAULT_MS_PER_PIXEL = 10;
    public final int SCROLL_OFFSET = 16;
    protected BufferedImage bi;
    protected Graphics2D big2d;
    protected int imageWidth;
    protected int imageHeight;
    protected int intervalWidth;
    protected Font font;
    protected FontMetrics metrics;
    protected int rulerHeight;
    protected TimeRuler ruler;
    protected int vertRulerWidth;
    protected AffineTransform identity;
    protected long crossHairTime;
    protected int crossHairPos;
    protected long intervalBeginTime;
    protected long intervalEndTime;
    protected long selectionBeginTime;
    protected long selectionEndTime;
    protected int selectionBeginPos;
    protected int selectionEndPos;
    protected long dragStartTime;
    protected Point dragStartPoint;
    protected Point dragEndPoint;
    protected AlphaComposite alpha04;
    protected AlphaComposite alpha05;
    protected AlphaComposite alpha07;
    protected float msPerPixel;
    protected boolean timeScaleConnected;
    protected boolean panMode;
    protected boolean timeRulerVisible;
    protected boolean attached;
    protected JPopupMenu popup;
    protected ButtonGroup zoomBG;
    protected JMenu zoomMI;
    protected JCheckBoxMenuItem timeScaleConMI;
    protected JRadioButtonMenuItem customZoomMI;
    protected JMenuItem zoomSelectionMI;
    protected JCheckBoxMenuItem timeRulerVisMI;
    protected long mediaTimeOffset;

    public DefaultTimeScaleBasedViewer() {
        this.initViewer();
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    protected void initViewer() {
        this.setLayout(null);
        this.font = Constants.DEFAULTFONT;
        this.setFont(this.font);
        this.metrics = this.getFontMetrics(this.font);
        this.ruler = new TimeRuler(this.font, TimeFormatter.toString(0L));
        this.rulerHeight = this.ruler.getHeight();
        this.timeRulerVisible = true;
        this.vertRulerWidth = 43;
        this.msPerPixel = 10.0f;
        this.crossHairTime = 0L;
        this.crossHairPos = 0;
        this.selectionBeginTime = 0L;
        this.selectionEndTime = 0L;
        this.selectionBeginPos = 0;
        this.selectionEndPos = 0;
        this.dragStartTime = 0L;
        this.alpha04 = AlphaComposite.getInstance(3, 0.4f);
        this.alpha05 = AlphaComposite.getInstance(3, 0.5f);
        this.alpha07 = AlphaComposite.getInstance(3, 0.7f);
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.intervalWidth = 0;
        this.mediaTimeOffset = 0L;
        this.identity = new AffineTransform();
    }

    public int getLeftMargin() {
        return 0;
    }

    public int getRightMargin() {
        return 0;
    }

    protected void createPopupMenu() {
        this.popup = new JPopupMenu("TimeScaleBasedViewer");
        this.zoomMI = new JMenu(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
        this.zoomBG = new ButtonGroup();
        this.zoomSelectionMI = new JMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Selection"));
        this.zoomSelectionMI.addActionListener(this);
        this.zoomSelectionMI.setActionCommand("zoomSel");
        this.zoomMI.add(this.zoomSelectionMI);
        this.customZoomMI = new JRadioButtonMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        this.customZoomMI.setEnabled(false);
        this.zoomBG.add(this.customZoomMI);
        this.zoomMI.add(this.customZoomMI);
        this.zoomMI.addSeparator();
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            JRadioButtonMenuItem zoomRB = new JRadioButtonMenuItem(this.ZOOMLEVELS[i] + "%");
            zoomRB.setActionCommand(String.valueOf(this.ZOOMLEVELS[i]));
            zoomRB.addActionListener(this);
            this.zoomBG.add(zoomRB);
            this.zoomMI.add(zoomRB);
            if (this.ZOOMLEVELS[i] != 100) continue;
            zoomRB.setSelected(true);
        }
        this.popup.add(this.zoomMI);
        this.timeRulerVisMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.TimeRuler.Visible"));
        this.timeRulerVisMI.setSelected(this.timeRulerVisible);
        this.timeRulerVisMI.addActionListener(this);
        this.popup.add(this.timeRulerVisMI);
        this.timeScaleConMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Connected"), this.timeScaleConnected);
        this.timeScaleConMI.setActionCommand("connect");
        this.timeScaleConMI.addActionListener(this);
        this.popup.add(this.timeScaleConMI);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        int zoom = (int)(100.0f * (10.0f / this.msPerPixel));
        if (zoom <= 0) {
            zoom = 100;
        }
        this.updateZoomPopup(zoom);
    }

    protected void updatePopup(Point p) {
    }

    protected void updateZoomPopup(int zoom) {
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom - this.ZOOMLEVELS[i] < -1 || zoom - this.ZOOMLEVELS[i] > 1) continue;
            zoomMenuIndex = i;
            break;
        }
        if (this.popup != null) {
            Enumeration<AbstractButton> en = this.zoomBG.getElements();
            int counter = 0;
            while (en.hasMoreElements()) {
                JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
                if (counter == zoomMenuIndex + 1) {
                    rbmi.setSelected(true);
                    break;
                }
                rbmi.setSelected(false);
                ++counter;
            }
            if (zoomMenuIndex == -1) {
                this.customZoomMI.setSelected(true);
                this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom") + " - " + zoom + "%");
            } else {
                this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
            }
        }
    }

    protected void zoomIn() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        int zoomMenuIndex = -1;
        int diff = Integer.MAX_VALUE;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            int d = Math.abs(this.ZOOMLEVELS[i] - (int)zoom);
            if (d >= diff) continue;
            diff = d;
            zoomMenuIndex = i;
        }
        if (zoomMenuIndex > -1 && zoomMenuIndex < this.ZOOMLEVELS.length - 1) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex + 1];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    protected void zoomOut() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        int zoomMenuIndex = -1;
        int diff = Integer.MAX_VALUE;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            int d = Math.abs(this.ZOOMLEVELS[i] - (int)zoom);
            if (d >= diff) continue;
            diff = d;
            zoomMenuIndex = i;
        }
        if (zoomMenuIndex > 0) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex - 1];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    protected void zoomToSelection() {
    }

    public int xAt(long t) {
        return (int)((float)(t - this.intervalBeginTime) / this.msPerPixel);
    }

    public long timeAt(int x) {
        return this.intervalBeginTime + (long)((int)((float)x * this.msPerPixel));
    }

    protected int timeToPixels(long theTime) {
        return (int)((float)theTime / this.msPerPixel);
    }

    protected long pixelToTime(int x) {
        return (long)((float)x * this.msPerPixel);
    }

    public long getMediaTimeOffset() {
        return this.mediaTimeOffset;
    }

    public void setMediaTimeOffset(long offset) {
        this.mediaTimeOffset = offset;
    }

    protected boolean pointInHorizontalRuler(int yPos) {
        return yPos < this.rulerHeight;
    }

    public void updateTimeScale() {
        if (this.timeScaleConnected) {
            if (this.getGlobalTimeScaleMsPerPixel() != this.msPerPixel) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            } else if (this.getGlobalTimeScaleIntervalBeginTime() != this.intervalBeginTime) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public void setTimeScaleConnected(boolean connected) {
        this.timeScaleConnected = connected;
        if (this.timeScaleConnected) {
            if (this.msPerPixel != this.getGlobalTimeScaleMsPerPixel()) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            }
            if (this.intervalBeginTime != this.getGlobalTimeScaleIntervalBeginTime()) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public boolean getTimeScaleConnected() {
        return this.timeScaleConnected;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
        if (this.timeScaleConMI != null) {
            this.timeScaleConMI.setEnabled(attached);
            this.timeScaleConMI.setSelected(attached);
        }
        this.setTimeScaleConnected(attached);
    }

    public long getIntervalBeginTime() {
        return this.intervalBeginTime;
    }

    public long getIntervalEndTime() {
        return this.intervalEndTime;
    }

    public void setIntervalBeginTime(long begin) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(begin);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleIntervalBeginTime(begin);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void recalculateInterval(long mediaTime) {
        long newBeginTime = this.intervalBeginTime;
        long newEndTime = this.intervalEndTime;
        if (this.playerIsPlaying()) {
            if (mediaTime > this.intervalEndTime) {
                newBeginTime = this.intervalEndTime;
                newEndTime = newBeginTime + (long)((int)((float)this.intervalWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime + ((float)this.intervalWidth + this.msPerPixel))) < mediaTime) {
                    newBeginTime = (long)((float)newBeginTime + (float)this.intervalWidth * this.msPerPixel);
                }
            } else {
                if (mediaTime >= this.intervalBeginTime) return;
                newEndTime = this.intervalBeginTime;
                newBeginTime = newEndTime - (long)((int)((float)this.intervalWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime - (float)this.intervalWidth * this.msPerPixel)) > mediaTime) {
                    newBeginTime = (long)((float)newBeginTime - (float)this.intervalWidth * this.msPerPixel);
                }
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                    newEndTime = (long)((float)this.intervalWidth * this.msPerPixel);
                }
            }
        } else {
            if (mediaTime <= this.intervalBeginTime) {
                newBeginTime = mediaTime - (long)((int)(16.0f * this.msPerPixel));
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                }
                newEndTime = newBeginTime + (long)((int)((float)this.intervalWidth * this.msPerPixel));
            } else if (mediaTime >= this.intervalEndTime && (newBeginTime = (newEndTime = mediaTime + (long)((int)(16.0f * this.msPerPixel))) - (long)((int)((float)this.intervalWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.intervalWidth * this.msPerPixel));
            }
            if (newBeginTime == this.getSelectionBeginTime() && (float)newBeginTime > 16.0f * this.msPerPixel) {
                newBeginTime = (long)((float)newBeginTime - 16.0f * this.msPerPixel);
                newEndTime = newBeginTime + (long)((int)((float)this.intervalWidth * this.msPerPixel));
            }
            if (newEndTime == this.getSelectionEndTime() && (newBeginTime = (newEndTime = (long)((float)newEndTime + 16.0f * this.msPerPixel)) - (long)((int)((float)this.intervalWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.intervalWidth * this.msPerPixel));
            }
        }
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(newBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(newEndTime);
            return;
        } else {
            this.setLocalTimeScaleIntervalBeginTime(newBeginTime);
        }
    }

    protected void setLocalTimeScaleIntervalBeginTime(long begin) {
    }

    protected void setLocalTimeScaleMsPerPixel(float step) {
    }

    protected void setTimeRulerVisible(boolean visible) {
        this.timeRulerVisible = visible;
        this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
    }

    public void setMsPerPixel(float mspp) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleMsPerPixel(mspp);
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleMsPerPixel(mspp);
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.crossHairTime = this.getMediaTime();
            if (!this.playerIsPlaying()) {
                this.recalculateInterval(this.crossHairTime);
                this.crossHairPos = this.xAt(this.crossHairTime);
                this.repaint();
            } else if (this.crossHairTime < this.intervalBeginTime || this.crossHairTime > this.intervalEndTime) {
                this.recalculateInterval(this.crossHairTime);
            } else {
                int oldPos = this.crossHairPos;
                this.crossHairPos = this.xAt(this.crossHairTime);
                int newPos = this.crossHairPos;
                if (newPos >= oldPos) {
                    this.repaint(oldPos - 2, 0, newPos - oldPos + 4, this.getHeight());
                } else {
                    this.repaint(newPos - 2, 0, oldPos - newPos + 4, this.getHeight());
                }
            }
        }
    }

    public void updateSelection() {
        this.selectionBeginPos = (int)((float)this.getSelectionBeginTime() / this.msPerPixel);
        this.selectionEndPos = (int)((float)this.getSelectionEndTime() / this.msPerPixel);
    }

    public void updateActiveAnnotation() {
    }

    public void updateLocale() {
        if (this.popup != null) {
            this.zoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
            this.timeScaleConMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Connected"));
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.zoomSelectionMI) {
            this.zoomToSelection();
        } else if (e.getActionCommand().equals("connect")) {
            boolean connected = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.setTimeScaleConnected(connected);
        } else if (e.getSource() == this.timeRulerVisMI) {
            this.setTimeRulerVisible(this.timeRulerVisMI.isSelected());
        } else {
            String zoomString = e.getActionCommand();
            int zoom = 100;
            try {
                zoom = Integer.parseInt(zoomString);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing the zoom level");
                return;
            }
            float newMsPerPixel = 100.0f / (float)zoom * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        if (e.getClickCount() == 1 && e.isShiftDown()) {
            if (this.getSelectionBeginTime() != this.getSelectionEndTime()) {
                long clickTime = this.timeAt(e.getPoint().x);
                if (clickTime > this.getSelectionEndTime()) {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                } else if (clickTime < this.getSelectionBeginTime()) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else if (clickTime - this.getSelectionBeginTime() < this.getSelectionEndTime() - clickTime) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                }
            } else {
                long medTime;
                long clickTime = this.timeAt(e.getPoint().x);
                if (clickTime > (medTime = this.getMediaTime())) {
                    this.setSelection(medTime, clickTime);
                } else if (clickTime < medTime) {
                    this.setSelection(clickTime, medTime);
                }
            }
        } else {
            this.setMediaTime(this.timeAt(e.getPoint().x));
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Point pp = e.getPoint();
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.updatePopup(pp);
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
            return;
        }
        if (this.playerIsPlaying()) {
            this.stopPlayer();
        }
        this.dragStartPoint = e.getPoint();
        this.dragStartTime = this.timeAt(this.dragStartPoint.x);
        if (e.isAltDown() && this.pointInHorizontalRuler(this.dragStartPoint.y)) {
            this.dragStartTime = this.timeAt(this.dragStartPoint.x);
            this.panMode = true;
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.panMode = false;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        if (this.panMode) {
            this.panMode = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.dragEndPoint = e.getPoint();
        if (this.panMode) {
            int scrolldiff = this.dragEndPoint.x - this.dragStartPoint.x;
            long newTime = this.intervalBeginTime - (long)((int)((float)scrolldiff * this.msPerPixel));
            if (this.intervalBeginTime < 0L && newTime < this.intervalBeginTime) {
                newTime = this.intervalBeginTime;
            }
            this.setIntervalBeginTime(newTime);
            this.dragStartPoint = this.dragEndPoint;
            return;
        }
        if (this.timeAt(this.dragEndPoint.x) > this.dragStartTime) {
            this.selectionEndTime = this.timeAt(this.dragEndPoint.x);
            if (this.selectionEndTime > this.getMediaDuration()) {
                this.selectionEndTime = this.getMediaDuration();
            }
            this.selectionBeginTime = this.dragStartTime;
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionEndTime);
        } else {
            this.selectionBeginTime = this.timeAt(this.dragEndPoint.x);
            if (this.selectionBeginTime > this.getMediaDuration()) {
                this.selectionBeginTime = this.getMediaDuration();
            }
            this.selectionEndTime = this.dragStartTime;
            if (this.selectionEndTime > this.getMediaDuration()) {
                this.selectionEndTime = this.getMediaDuration();
            }
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
        }
        this.setSelection(this.selectionBeginTime, this.selectionEndTime);
        this.updateSelection();
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            if (e.getUnitsToScroll() > 0) {
                this.zoomOut();
            } else {
                this.zoomIn();
            }
            return;
        }
    }

    public void preferencesChanged() {
    }
}

