/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.md.DefaultMDViewerComponent;
import mpi.eudico.client.annotator.md.MDConfigurationDialog;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;
import mpi.eudico.client.annotator.md.spi.MDServiceRegistry;
import mpi.eudico.client.annotator.md.spi.MDViewerComponent;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.viewer.Viewer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MetadataViewer
extends JPanel
implements PreferencesUser,
ElanLocaleListener,
Viewer,
ActionListener {
    private ViewerManager2 viewerManager;
    private String metadataPath;
    private MDServiceProvider mdProvider;
    private MDViewerComponent viewerPanel;
    private JButton selectMDButton;
    private JButton configureMDButton;
    private JLabel mdPathLabel;
    private JPanel viewerContainer;
    public final String MD_SOURCE = "MetadataSource";
    public final String MD_KEYS = "MetadataKeys";

    public MetadataViewer(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.selectMDButton = new JButton();
        this.mdPathLabel = new JLabel();
        this.mdPathLabel.setFont(this.mdPathLabel.getFont().deriveFont(10.0f));
        this.configureMDButton = new JButton();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 18;
        this.add((Component)this.selectMDButton, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.mdPathLabel, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.anchor = 12;
        this.add((Component)this.configureMDButton, gbc);
        this.updateLocale();
        this.selectMDButton.addActionListener(this);
        this.configureMDButton.addActionListener(this);
        this.configureMDButton.setEnabled(false);
        this.mdPathLabel.setText(ElanLocale.getString("MetadataViewer.NoMetadataSource"));
        this.viewerContainer = new JPanel(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.viewerContainer, gbc);
    }

    private void selectMDSource() {
        File selected;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(ElanFileFilter.createFileFilter(22));
        String dir = (String)Preferences.get("MetadataFileDir", this.viewerManager.getTranscription());
        if (dir == null) {
            String eafPath = ((TranscriptionImpl)this.viewerManager.getTranscription()).getFullPath();
            if (eafPath != null && eafPath.indexOf("aishug294879ryshfda9763afo8947a5gf") == -1) {
                int lastSep;
                if (eafPath.startsWith("file:")) {
                    eafPath = eafPath.substring(5);
                }
                if ((lastSep = eafPath.lastIndexOf(File.separator)) > 0) {
                    eafPath = eafPath.substring(0, lastSep);
                }
                dir = eafPath;
            } else {
                dir = System.getProperty("user.dir");
            }
        }
        chooser.setCurrentDirectory(new File(dir));
        chooser.setDialogTitle(ElanLocale.getString("Button.Select"));
        chooser.setApproveButtonText(ElanLocale.getString("Button.Select"));
        int option = chooser.showOpenDialog(this);
        if (option == 0 && (selected = chooser.getSelectedFile()) != null && selected.exists()) {
            String selectedFilePath = selected.getAbsolutePath();
            String mdDir = selected.getParent();
            this.setPreference("MetadataFileDir", mdDir, this.viewerManager.getTranscription());
            this.mdPathLabel.setText(selectedFilePath);
            if (!selectedFilePath.equals(this.metadataPath)) {
                this.metadataPath = selectedFilePath;
                this.setPreference("MetadataSource", this.metadataPath, this.viewerManager.getTranscription());
                this.mdProvider = MDServiceRegistry.getInstance().getProviderForMDFile(this.metadataPath);
                if (this.mdProvider != null) {
                    Object val;
                    this.configureMDButton.setEnabled(true);
                    MDViewerComponent oldPanel = this.viewerPanel;
                    this.viewerPanel = this.mdProvider.getMDViewerComponent();
                    if (this.viewerPanel == null) {
                        this.viewerPanel = new DefaultMDViewerComponent(this.mdProvider);
                    }
                    if (oldPanel instanceof Component) {
                        this.viewerContainer.remove((Component)((Object)oldPanel));
                    }
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.anchor = 18;
                    gbc.fill = 1;
                    gbc.weightx = 1.0;
                    gbc.weighty = 1.0;
                    this.viewerContainer.add((Component)((Object)this.viewerPanel), gbc);
                    if ("IMDI".equals(this.mdProvider.getMDFormatDescription()) && (val = Preferences.get("Metadata.IMDI.Defaults", null)) instanceof List) {
                        List prefKeys = (List)val;
                        this.mdProvider.setSelectedKeys(prefKeys);
                        Map allSelKeysVals = this.mdProvider.getSelectedKeysAndValues();
                        if (allSelKeysVals != null && this.viewerPanel != null) {
                            this.viewerPanel.setSelectedKeysAndValues(allSelKeysVals);
                        }
                    }
                }
            }
        }
    }

    private void configureMD() {
        if (this.mdProvider == null) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("MetadataViewer.NoMetadataSource"), ElanLocale.getString("Message.Error"), 0);
        }
        MDConfigurationDialog dialog = new MDConfigurationDialog((Frame)ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), this.mdProvider.getConfigurationPanel());
        dialog.setVisible(true);
        List selKeys = this.mdProvider.getSelectedKeys();
        if (selKeys == null || selKeys.size() == 0) {
            return;
        }
        this.setPreference("MetadataKeys", selKeys, this.viewerManager.getTranscription());
        Map allSelKeysVals = this.mdProvider.getSelectedKeysAndValues();
        if (allSelKeysVals != null && this.viewerPanel != null) {
            this.viewerPanel.setSelectedKeysAndValues(allSelKeysVals);
        }
    }

    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    public void preferencesChanged() {
        Object pref = Preferences.get("MetadataSource", this.viewerManager.getTranscription());
        if (pref != null) {
            this.metadataPath = (String)pref;
            if (this.metadataPath.startsWith(".")) {
                this.metadataPath = this.metadataPath.replace("\\", "/");
                String eafPath = ((TranscriptionImpl)this.viewerManager.getTranscription()).getFullPath();
                if (eafPath.startsWith("file:")) {
                    eafPath = eafPath.substring(5);
                }
                eafPath = eafPath.replace("\\", "/");
                ClientLogger.LOG.info(eafPath);
                ClientLogger.LOG.info(this.metadataPath);
                this.metadataPath = FileUtility.getAbsolutePath(eafPath, this.metadataPath);
            }
            if (this.mdProvider == null || !this.metadataPath.equals(this.mdProvider.getMetadataFile())) {
                this.mdProvider = MDServiceRegistry.getInstance().getProviderForMDFile(this.metadataPath);
                if (this.mdProvider == null) {
                    return;
                }
                MDViewerComponent oldPanel = this.viewerPanel;
                this.configureMDButton.setEnabled(true);
                this.mdPathLabel.setText(this.metadataPath);
                this.viewerPanel = this.mdProvider.getMDViewerComponent();
                if (this.viewerPanel == null) {
                    this.viewerPanel = new DefaultMDViewerComponent(this.mdProvider);
                }
                if (oldPanel instanceof Component) {
                    this.viewerContainer.remove((Component)((Object)oldPanel));
                }
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 18;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                this.viewerContainer.add((Component)((Object)this.viewerPanel), gbc);
            }
            if ((pref = Preferences.get("MetadataKeys", this.viewerManager.getTranscription())) == null) {
                pref = Preferences.get("Metadata.IMDI.Defaults", null);
            }
            if (pref instanceof List) {
                this.mdProvider.setSelectedKeys(new ArrayList((List)pref));
                Map allSelKeysVals = this.mdProvider.getSelectedKeysAndValues();
                if (allSelKeysVals != null && this.viewerPanel != null) {
                    this.viewerPanel.setSelectedKeysAndValues(allSelKeysVals);
                }
            }
        }
    }

    public void updateLocale() {
        this.selectMDButton.setText(ElanLocale.getString("MetadataViewer.SelectSource"));
        this.configureMDButton.setText(ElanLocale.getString("MetadataViewer.Configure"));
    }

    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    public void setViewerManager(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectMDButton) {
            this.selectMDSource();
        } else if (e.getSource() == this.configureMDButton) {
            this.configureMD();
        }
    }
}

