/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Font;
import java.awt.Graphics2D;
import mpi.eudico.util.TimeFormatter;

public class TimeRuler {
    private Font font;
    private int minorTickSpacing;
    private int majorTickSpacing;
    private int avgLabelWidth;
    private String defLabel;
    private int height;
    private float majorTick;
    private float minorTick;
    private int step;
    private float lastUsedMspp = -1.0f;
    private final int[] stepbase = new int[]{10, 20, 50};
    private final int power = 4;

    public TimeRuler(Font font, String defLabel) {
        this.font = font;
        this.defLabel = defLabel;
        this.minorTickSpacing = 10;
        this.majorTickSpacing = 100;
        this.height = font.getSize() + 4 + 4;
        this.majorTick = this.majorTickSpacing;
        this.minorTick = this.minorTickSpacing;
    }

    public void paintAtFixedInterval(Graphics2D g2d, long beginTime, int width, float msPerPixel, int position) {
        g2d.setFont(this.font);
        this.avgLabelWidth = g2d.getFontMetrics(this.font).stringWidth(this.defLabel);
        int step = (int)((float)this.majorTickSpacing * msPerPixel);
        long firstMarker = (long)step * (beginTime / (long)step);
        int firstLine = (int)((float)firstMarker / msPerPixel);
        int extent = firstLine + width + this.majorTickSpacing;
        block8: for (int i = firstLine; i <= extent; i += this.minorTickSpacing) {
            switch (position) {
                case 1: {
                    g2d.drawLine(i, 0, i, 2);
                    continue block8;
                }
                case 3: {
                    g2d.drawLine(i, this.height - 2, i, this.height);
                    continue block8;
                }
            }
        }
        for (int j = firstLine; j <= extent; j += this.majorTickSpacing) {
            switch (position) {
                case 1: {
                    g2d.drawLine(j, 0, j, 5);
                    g2d.drawString(TimeFormatter.toString(firstMarker), j - this.avgLabelWidth / 2, this.height - 2);
                    break;
                }
                case 3: {
                    g2d.drawString(TimeFormatter.toString(firstMarker), j - this.avgLabelWidth / 2, this.font.getSize() + 2);
                    g2d.drawLine(j, this.height - 5, j, this.height);
                    break;
                }
            }
            firstMarker += (long)step;
        }
    }

    public void paint(Graphics2D g2d, long beginTime, int width, float msPerPixel, int position) {
        int x;
        g2d.setFont(this.font);
        this.avgLabelWidth = g2d.getFontMetrics(this.font).stringWidth(this.defLabel);
        if (msPerPixel != this.lastUsedMspp) {
            int oldStep = (int)((float)this.majorTickSpacing * msPerPixel);
            this.step = this.getRoundedStep(oldStep);
            if (this.step == 0) {
                this.step = 1;
            }
            this.majorTick = (float)this.majorTickSpacing * ((float)this.step / (float)oldStep);
            this.minorTick = this.majorTick / ((float)this.majorTickSpacing / (float)this.minorTickSpacing);
            this.lastUsedMspp = msPerPixel;
        }
        long firstMarker = (long)this.step * (beginTime / (long)this.step);
        int firstLine = (int)((float)firstMarker / msPerPixel);
        int extent = firstLine + width + (int)this.majorTick;
        int i = firstLine;
        int j = 0;
        while (i <= extent) {
            x = firstLine + (int)((float)j * this.minorTick);
            switch (position) {
                case 1: {
                    g2d.drawLine(x, 0, x, 2);
                    break;
                }
                case 3: {
                    g2d.drawLine(x, this.height - 2, x, this.height);
                    break;
                }
            }
            i = x;
            ++j;
        }
        int j2 = firstLine;
        int i2 = 0;
        while (j2 <= extent) {
            x = firstLine + (int)((float)i2 * this.majorTick);
            switch (position) {
                case 1: {
                    g2d.drawLine(x, 0, x, 5);
                    g2d.drawString(TimeFormatter.toString(firstMarker), x - this.avgLabelWidth / 2, this.height - 2);
                    break;
                }
                case 3: {
                    g2d.drawString(TimeFormatter.toString(firstMarker), x - this.avgLabelWidth / 2, this.font.getSize() + 2);
                    g2d.drawLine(x, this.height - 5, x, this.height);
                    break;
                }
            }
            firstMarker += (long)this.step;
            j2 = x;
            ++i2;
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.height = font.getSize() + 4 + 4;
    }

    public Font getFont() {
        return this.font;
    }

    private int getRoundedStep(int inStep) {
        int step = inStep;
        for (int i = 1; i <= 4; ++i) {
            int one = (int)((double)this.stepbase[0] * Math.pow(10.0, i));
            int two = (int)((double)this.stepbase[1] * Math.pow(10.0, i));
            int five = (int)((double)this.stepbase[2] * Math.pow(10.0, i));
            if (step == one || step == two || step == five) break;
            if (step < one) {
                if (i != 0) continue;
                step = one;
                break;
            }
            if (step > five) {
                if (i == 4) {
                    step = five;
                    break;
                }
                if (step >= (int)((double)this.stepbase[0] * Math.pow(10.0, i + 1))) continue;
                step = (int)((double)this.stepbase[0] * Math.pow(10.0, i + 1));
                break;
            }
            if (step > one && step < two) {
                step = two;
                break;
            }
            if (step <= two || step >= five) continue;
            step = five;
            break;
        }
        return step;
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMajorTickSpacing(int spacing) {
        this.majorTickSpacing = spacing;
        this.lastUsedMspp = -1.0f;
    }

    public void setMinorTickSpacing(int spacing) {
        this.minorTickSpacing = spacing;
        this.lastUsedMspp = -1.0f;
    }

    public int getHeight() {
        return this.height;
    }
}

