/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.mediacontrol;

import java.util.Vector;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.mediacontrol.Controller;
import mpi.eudico.client.mediacontrol.EventPostingBase;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TimeLineController
extends EventPostingBase
implements Controller,
Runnable {
    private final int STARTED = 0;
    private final int STOPPED = 1;
    private Tier tier;
    private ElanMediaPlayer controllingPlayer;
    private long mediaDuration;
    private float rate;
    private Thread thread;
    private volatile int state;
    private TimeEvent timeEvent;
    private StartEvent startEvent;
    private StopEvent stopEvent;
    private long[] timeLine;
    private int nextEventIndex;

    public TimeLineController(Tier tier, ElanMediaPlayer controllingPlayer) {
        this.tier = tier;
        this.controllingPlayer = controllingPlayer;
        this.mediaDuration = controllingPlayer.getMediaDuration();
        this.rate = 1.0f;
        this.state = 1;
        this.timeEvent = new TimeEvent(this);
        this.startEvent = new StartEvent(this);
        this.stopEvent = new StopEvent(this);
    }

    public void run() {
        this.state = 0;
        while (this.nextEventIndex < this.timeLine.length && this.state == 0) {
            long now = this.controllingPlayer.getMediaTime();
            long sleepTime = (long)((float)(this.timeLine[this.nextEventIndex] - now) / this.rate);
            if (sleepTime > 0L) {
                if (Thread.currentThread().isInterrupted()) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {}
                continue;
            }
            this.postEvent(this.timeEvent);
            ++this.nextEventIndex;
        }
        this.state = 1;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setStopTime(long time) {
    }

    public void setMediaTime(long time) {
        this.postEvent(this.timeEvent);
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void stop() {
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.postEvent(this.stopEvent);
        this.postEvent(this.timeEvent);
    }

    public void start() {
        if (this.state == 0) {
            return;
        }
        try {
            int i;
            Vector annotations = ((TierImpl)this.tier).getAnnotations();
            long[] uniqueTimes = new long[2 * annotations.size()];
            int timeIndex = 0;
            long previousEnd = -1L;
            for (i = 0; i < annotations.size(); ++i) {
                long begin = ((Annotation)annotations.elementAt(i)).getBeginTimeBoundary();
                long end = ((Annotation)annotations.elementAt(i)).getEndTimeBoundary();
                if (begin != previousEnd) {
                    uniqueTimes[timeIndex++] = begin;
                }
                uniqueTimes[timeIndex++] = end;
                previousEnd = end;
            }
            this.timeLine = new long[timeIndex];
            for (i = 0; i < this.timeLine.length; ++i) {
                this.timeLine[i] = uniqueTimes[i];
            }
            long now = this.controllingPlayer.getMediaTime();
            this.nextEventIndex = 0;
            while (this.nextEventIndex < this.timeLine.length && this.timeLine[this.nextEventIndex] <= now) {
                ++this.nextEventIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.postEvent(this.startEvent);
        this.thread = new Thread((Runnable)this, "TimeLineController");
        this.thread.start();
    }
}

