/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.MutableInt;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transcription2WordList
implements ClientLogger {
    private final String NEWLINE = "\n";
    private String delimiters = " \t\n\r\f.,!?\"'";

    public void exportWords(Transcription transcription, List<String> tierNames, File exportFile, String charEncoding, String delimiters, boolean countOccurrences) throws IOException {
        if (countOccurrences) {
            this.exportWordsAndCount(transcription, tierNames, exportFile, charEncoding, delimiters);
            return;
        }
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (transcription == null) {
            LOG.severe("No transcription specified for wordlist");
            return;
        }
        if (tierNames == null) {
            LOG.warning("No tiers specified for the wordlist: using all tiers");
            tierNames = new ArrayList<String>(transcription.getTiers().size());
            for (int i = 0; i < transcription.getTiers().size(); ++i) {
                tierNames.add(((TierImpl)transcription.getTiers().get(i)).getName());
            }
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        ArrayList uniqueWords = this.getUniqueWords(transcription, tierNames);
        Collections.sort(uniqueWords);
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        for (int i = 0; i < uniqueWords.size(); ++i) {
            writer.write((String)uniqueWords.get(i));
            writer.write("\n");
        }
        writer.close();
    }

    public void exportWords(List<File> files, List<String> tierNames, File exportFile, String charEncoding, String delimiters, boolean countOccurrences) throws IOException {
        if (countOccurrences) {
            this.exportWordsAndCount(files, tierNames, exportFile, charEncoding, delimiters);
            return;
        }
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (files == null || files.size() == 0) {
            LOG.warning("No files specified for export");
            throw new IOException("No files specified for export");
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        ArrayList uniqueWords = new ArrayList();
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            if (file == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                ArrayList transWords = this.getUniqueWords(trans, tierNames);
                for (int j = 0; j < transWords.size(); ++j) {
                    Object wo = transWords.get(j);
                    if (uniqueWords.contains(wo)) continue;
                    uniqueWords.add(wo);
                }
                continue;
            }
            catch (Exception ex) {
                LOG.severe("Could not handle file: " + file.getAbsolutePath());
                LOG.severe(ex.getMessage());
            }
        }
        Collections.sort(uniqueWords);
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        for (int i = 0; i < uniqueWords.size(); ++i) {
            writer.write((String)uniqueWords.get(i));
            writer.write("\n");
        }
        writer.close();
    }

    private ArrayList getUniqueWords(Transcription transcription, List tierNames) {
        TierImpl t;
        int i;
        ArrayList<String> uniqueWords = new ArrayList<String>();
        if (transcription == null) {
            LOG.severe("No transcription specified to extract words from");
            return uniqueWords;
        }
        ArrayList annos = new ArrayList();
        if (tierNames != null) {
            for (i = 0; i < tierNames.size(); ++i) {
                t = (TierImpl)transcription.getTierWithId((String)tierNames.get(i));
                if (t != null) {
                    annos.addAll(t.getAnnotations());
                    continue;
                }
                LOG.warning("No tier with name: " + tierNames.get(i));
            }
        } else {
            Vector tiers = transcription.getTiers();
            for (int i2 = 0; i2 < tiers.size(); ++i2) {
                t = (TierImpl)tiers.get(i2);
                if (t != null) {
                    annos.addAll(t.getAnnotations());
                    continue;
                }
                LOG.warning("No tier with name: " + tierNames.get(i2));
            }
        }
        for (i = 0; i < annos.size(); ++i) {
            Annotation ann = (Annotation)annos.get(i);
            if (ann != null) {
                if (ann.getValue().length() <= 0) continue;
                if (this.delimiters.length() > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(ann.getValue(), this.delimiters);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (uniqueWords.contains(token)) continue;
                        uniqueWords.add(token);
                    }
                    continue;
                }
                if (uniqueWords.contains(ann.getValue())) continue;
                uniqueWords.add(ann.getValue());
                continue;
            }
            LOG.warning("Annotation is null");
        }
        return uniqueWords;
    }

    public void exportWordsAndCount(Transcription transcription, List<String> tierNames, File exportFile, String charEncoding, String delimiters) throws IOException {
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (transcription == null) {
            LOG.severe("No transcription specified for wordlist");
            return;
        }
        if (tierNames == null) {
            LOG.warning("No tiers specified for the wordlist: using all tiers");
            tierNames = new ArrayList<String>(transcription.getTiers().size());
            for (int i = 0; i < transcription.getTiers().size(); ++i) {
                tierNames.add(((TierImpl)transcription.getTiers().get(i)).getName());
            }
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        TreeMap<String, MutableInt> uniqueWords = new TreeMap<String, MutableInt>();
        this.addUniqueWordsAndCount(uniqueWords, transcription, tierNames);
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        Iterator keyIt = uniqueWords.keySet().iterator();
        String key = null;
        while (keyIt.hasNext()) {
            key = (String)keyIt.next();
            writer.write(key);
            writer.write("\t" + ((MutableInt)uniqueWords.get((Object)key)).intValue);
            writer.write("\n");
        }
        writer.close();
    }

    public void exportWordsAndCount(List<File> files, List<String> tierNames, File exportFile, String charEncoding, String delimiters) throws IOException {
        if (exportFile == null) {
            LOG.warning("No destination file specified for export");
            throw new IOException("No destination file specified for export");
        }
        if (files == null || files.size() == 0) {
            LOG.warning("No files specified for export");
            throw new IOException("No files specified for export");
        }
        if (delimiters != null) {
            this.delimiters = delimiters;
        }
        TreeMap<String, MutableInt> uniqueWords = new TreeMap<String, MutableInt>();
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            if (file == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                this.addUniqueWordsAndCount(uniqueWords, trans, tierNames);
                continue;
            }
            catch (Exception ex) {
                LOG.severe("Could not handle file: " + file.getAbsolutePath());
                LOG.severe(ex.getMessage());
            }
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        Iterator keyIt = uniqueWords.keySet().iterator();
        String key = null;
        while (keyIt.hasNext()) {
            key = (String)keyIt.next();
            writer.write(key);
            writer.write("\t" + ((MutableInt)uniqueWords.get((Object)key)).intValue);
            writer.write("\n");
        }
        writer.close();
    }

    private void addUniqueWordsAndCount(Map<String, MutableInt> uniqueWords, Transcription transcription, List<String> tierNames) {
        TierImpl t;
        if (transcription == null) {
            LOG.severe("No transcription specified to extract words from");
            return;
        }
        List<Object> actTierNames = null;
        if (tierNames == null || tierNames.size() == 0) {
            actTierNames = new ArrayList();
            Vector tiers = transcription.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                t = (TierImpl)tiers.get(i);
                if (t != null) {
                    actTierNames.add(t.getName());
                    continue;
                }
                LOG.warning("Tier is null: " + i);
            }
        } else {
            actTierNames = tierNames;
        }
        if (actTierNames.size() > 0) {
            for (int j = 0; j < actTierNames.size(); ++j) {
                t = (TierImpl)transcription.getTierWithId((String)actTierNames.get(j));
                if (t != null) {
                    Vector annos = t.getAnnotations();
                    int numAnnos = annos.size();
                    for (int i = 0; i < numAnnos; ++i) {
                        Annotation ann = (Annotation)annos.get(i);
                        if (ann != null) {
                            if (ann.getValue().length() <= 0) continue;
                            if (this.delimiters.length() > 0) {
                                StringTokenizer tokenizer = new StringTokenizer(ann.getValue(), this.delimiters);
                                while (tokenizer.hasMoreTokens()) {
                                    String token = tokenizer.nextToken();
                                    if (!uniqueWords.containsKey(token)) {
                                        uniqueWords.put(token, new MutableInt(1));
                                        continue;
                                    }
                                    ++uniqueWords.get((Object)token).intValue;
                                }
                                continue;
                            }
                            if (!uniqueWords.containsKey(ann.getValue())) {
                                uniqueWords.put(ann.getValue(), new MutableInt(1));
                                continue;
                            }
                            ++uniqueWords.get((Object)ann.getValue()).intValue;
                            continue;
                        }
                        LOG.warning("Annotation is null");
                    }
                    continue;
                }
                LOG.warning("No tier with name: " + (String)actTierNames.get(j));
            }
        }
    }
}

