/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceGroup;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ParentAnnotationListener;
import mpi.eudico.server.corpora.util.ACMEditableObject;

public abstract class AbstractAnnotation
implements Annotation {
    private Tier tier;
    private String value = "";
    private String id = null;
    private boolean markedDeleted = false;
    private ArrayList parentAnnotListeners = new ArrayList();
    private Object extRef;
    private String cvEntryId;

    public abstract long getBeginTimeBoundary();

    public abstract long getEndTimeBoundary();

    public String getValue() {
        return this.value;
    }

    public void setValue(String theValue) {
        this.value = theValue;
        this.modified(8, null);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public Object getExtRef() {
        return this.extRef;
    }

    public void setExtRef(Object extRef) {
        this.extRef = extRef;
        this.modified(15, extRef);
    }

    public String getCVEntryId() {
        return this.getExtRefValue(5);
    }

    public void setCVEntryId(String cVEntryId) {
        this.cvEntryId = cVEntryId;
    }

    public String getExtRefValue(int type) {
        if (this.extRef instanceof ExternalReference) {
            String value = null;
            ExternalReference ef = (ExternalReference)this.extRef;
            ArrayList<ExternalReference> extRefList = new ArrayList<ExternalReference>();
            extRefList.add(ef);
            for (int i = 0; i < extRefList.size(); ++i) {
                if (((ExternalReference)extRefList.get(i)).getReferenceType() == type) {
                    value = ((ExternalReference)extRefList.get(i)).getValue();
                    break;
                }
                if (((ExternalReference)extRefList.get(i)).getReferenceType() != 1) continue;
                extRefList.addAll(((ExternalReferenceGroup)extRefList.get(i)).getAllReferences());
            }
            return value;
        }
        if (this.extRef instanceof String) {
            return (String)this.extRef;
        }
        return null;
    }

    public void removeExtRef(ExternalReferenceImpl er) {
        if (this.extRef instanceof ExternalReference) {
            if (this.extRef instanceof ExternalReference && ((ExternalReference)this.extRef).equals(er)) {
                this.extRef = null;
            } else if (this.extRef instanceof ExternalReferenceGroup) {
                this.removeExtRefFromGroup((ExternalReferenceGroup)this.extRef, er);
            }
        }
        this.modified(15, this.extRef);
    }

    private void removeExtRefFromGroup(ExternalReferenceGroup extRefGrp, ExternalReference er) {
        List extRefList = extRefGrp.getAllReferences();
        for (int i = 0; i < extRefList.size(); ++i) {
            if (extRefList.get(i) instanceof ExternalReferenceGroup) {
                this.removeExtRefFromGroup((ExternalReferenceGroup)extRefList.get(i), er);
                continue;
            }
            if (!(extRefList.get(i) instanceof ExternalReference) || !((ExternalReference)extRefList.get(i)).equals(er)) continue;
            extRefGrp.removeReference(er);
        }
    }

    public void addExtRef(ExternalReferenceImpl er) {
        if (this.extRef == null) {
            this.extRef = er;
        } else if (this.extRef instanceof ExternalReference) {
            if (this.extRef instanceof ExternalReferenceGroup) {
                ((ExternalReferenceGroup)this.extRef).addReference(er);
            } else {
                ExternalReferenceGroup tmpExtRefGrp = new ExternalReferenceGroup();
                try {
                    Object clone = ((ExternalReference)this.extRef).clone();
                    if (clone instanceof ExternalReference) {
                        tmpExtRefGrp.addReference((ExternalReference)clone);
                    }
                    tmpExtRefGrp.addReference(er);
                    this.extRef = tmpExtRefGrp;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.modified(15, this.extRef);
    }

    public List getExtRefs() {
        ArrayList<Object> extRefs = new ArrayList<Object>();
        if (this.extRef instanceof ExternalReference) {
            if (this.extRef instanceof ExternalReferenceGroup) {
                this.addExtRefToList((ExternalReferenceGroup)this.extRef, extRefs);
            } else {
                extRefs.add(this.extRef);
            }
        }
        return extRefs;
    }

    private void addExtRefToList(ExternalReferenceGroup extRefGrp, ArrayList extRefs) {
        for (Object er : extRefGrp.getAllReferences()) {
            if (!(er instanceof ExternalReference)) continue;
            if (er instanceof ExternalReferenceGroup) {
                this.addExtRefToList((ExternalReferenceGroup)er, extRefs);
                continue;
            }
            extRefs.add(er);
        }
    }

    public void updateValue(String theValue) {
        this.value = theValue;
        this.modified(8, null);
    }

    public Tier getTier() {
        return this.tier;
    }

    protected void setTier(Tier theTier) {
        this.tier = theTier;
    }

    public void markDeleted(boolean deleted) {
        this.markedDeleted = deleted;
        this.notifyParentListeners();
        this.unregisterWithParent();
    }

    public boolean isMarkedDeleted() {
        return this.markedDeleted;
    }

    public void unregisterWithParent() {
        Annotation p;
        if (this.hasParentAnnotation() && (p = this.getParentAnnotation()) != null) {
            p.removeParentAnnotationListener(this);
        }
    }

    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    public void handleModification(ACMEditableObject source, int operation, Object modification) {
        if (this.tier != null) {
            this.tier.handleModification(source, operation, modification);
        }
    }

    public void addParentAnnotationListener(ParentAnnotationListener l) {
        if (!this.parentAnnotListeners.contains(l)) {
            this.parentAnnotListeners.add(l);
        }
    }

    public void removeParentAnnotationListener(ParentAnnotationListener l) {
        this.parentAnnotListeners.remove(l);
    }

    public void notifyParentListeners() {
        ArrayList copiedList = new ArrayList(this.parentAnnotListeners);
        for (ParentAnnotationListener listener : copiedList) {
            listener.parentAnnotationChanged(new EventObject(this));
        }
    }

    public ArrayList getParentListeners() {
        return this.parentAnnotListeners;
    }

    public final Vector getChildrenOnTier(Tier tier) {
        Vector<Annotation> children = new Vector<Annotation>();
        Annotation annotation2 = null;
        for (Annotation annotation2 : this.parentAnnotListeners) {
            if (annotation2.getTier() != tier) continue;
            children.add(annotation2);
        }
        return children;
    }

    public int compareTo(Object obj) {
        int ret = 0;
        AbstractAnnotation a1 = this;
        Annotation a2 = (Annotation)obj;
        if (a1.isMarkedDeleted() || a2.isMarkedDeleted()) {
            return this.compareOtherwise(a1, a2);
        }
        int numOfRefAnnotations = 0;
        if (this instanceof RefAnnotation) {
            ++numOfRefAnnotations;
            a1 = ((RefAnnotation)this).getFirstAlignableRoot();
        }
        if (obj instanceof RefAnnotation) {
            ++numOfRefAnnotations;
            a2 = ((RefAnnotation)obj).getFirstAlignableRoot();
        }
        if (a1 != a2) {
            ret = ((AlignableAnnotation)a1).getBegin().compareTo(((AlignableAnnotation)a2).getBegin());
            if (ret == 0) {
                ret = -1;
            }
        } else if (numOfRefAnnotations == 1) {
            ret = this instanceof AlignableAnnotation ? -1 : 1;
        } else if (numOfRefAnnotations == 2) {
            ret = this.compareRefAnnotations((RefAnnotation)this, (RefAnnotation)obj);
        }
        return ret;
    }

    private int compareOtherwise(Annotation a1, Annotation a2) {
        Tier t2;
        if (a1.equals(a2)) {
            return 0;
        }
        Tier t1 = a1.getTier();
        if (t1 == (t2 = a2.getTier())) {
            Vector v = null;
            v = ((TierImpl)t1).getAnnotations();
            if (v.indexOf(a1) < v.indexOf(a2)) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public int compareRefAnnotations(RefAnnotation a1, RefAnnotation a2) {
        int ret = 0;
        if (a1.getTier() == a2.getTier() && a1.getReferences().firstElement() == a2.getReferences().firstElement()) {
            ret = this.compareUsingRefChain(a1, a2);
        } else {
            Annotation parent = (Annotation)a1.getReferences().firstElement();
            if (parent instanceof RefAnnotation) {
                ret = this.compareRefAnnotations((RefAnnotation)parent, a2);
            }
            if (ret == 0 && (parent = (Annotation)a2.getReferences().firstElement()) instanceof RefAnnotation) {
                ret = this.compareRefAnnotations(a1, (RefAnnotation)parent);
            }
        }
        return ret;
    }

    public int compareUsingRefChain(RefAnnotation a1, RefAnnotation a2) {
        int ret = 1;
        if (a1 == a2) {
            ret = 0;
        } else {
            for (RefAnnotation nextR = a1.getNext(); nextR != null; nextR = nextR.getNext()) {
                if (nextR != a2) continue;
                ret = -1;
                break;
            }
        }
        return ret;
    }
}

