/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.Manager;
import javax.media.Player;
import javax.media.protocol.DataSource;
import javax.media.protocol.URLDataSource;
import mpi.eudico.server.corpora.clom.LanguageResource;
import mpi.eudico.server.corpora.clom.MediaObject;
import mpi.eudico.server.corpora.event.DurationUnknownException;
import mpi.eudico.server.corpora.event.NoAudioSampleDataException;
import mpi.eudico.server.corpora.event.NoMediaFileException;
import nl.mpi.util.OurURL;

public class MediaObjectImpl
implements MediaObject {
    private String mediaFileName;
    private String audioFileName;
    private double mediaSampleRate;
    private long duration;
    private String url;

    public MediaObjectImpl(String theMediaFile, int theMediaType, String theAudioFile, String thisURL) {
        this.mediaFileName = theMediaFile;
        this.audioFileName = theAudioFile;
        this.url = thisURL;
    }

    private void logln(String s) {
        System.out.println(" log: " + s);
    }

    public String getMediaFile() throws NoMediaFileException {
        if (this.mediaFileName == null) {
            throw new NoMediaFileException();
        }
        String rep1 = this.mediaFileName.replace(' ', '_');
        String rep2 = rep1.replace('/', '_');
        if (rep2.endsWith(".wav")) {
            return rep2;
        }
        if (rep2.endsWith(".mpg")) {
            return rep2;
        }
        if (rep2.endsWith(".mov")) {
            return rep2;
        }
        return rep2 + ".mpg";
    }

    public URL getMediaURL() {
        OurURL mediaURL = null;
        try {
            mediaURL = new OurURL(this.url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return mediaURL.toURL();
    }

    public String getAudioSampleData() throws NoAudioSampleDataException {
        if (this.audioFileName == null) {
            throw new NoAudioSampleDataException();
        }
        return this.audioFileName;
    }

    public long getDuration() throws DurationUnknownException {
        if (this.duration == 0L) {
            OurURL mediaURL = null;
            try {
                mediaURL = new OurURL(this.url);
                System.out.println("MediaObject: creating Player " + mediaURL.toString());
                URLDataSource ds = new URLDataSource(mediaURL.toURL());
                ds.connect();
                Player player = Manager.createPlayer((DataSource)ds);
                player.realize();
                while (player.getState() != 300) {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                this.duration = player.getDuration().getNanoseconds() / 1000000L;
            }
            catch (IOException ioe) {
                System.err.println("MediaObjectImpl: error creating player for: " + mediaURL);
                ioe.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.duration;
    }

    public double getMediaSampleRate() {
        return 0.0;
    }

    public LanguageResource[] getLanguageResources() {
        return null;
    }

    public boolean hasLanguageResources() {
        return false;
    }

    public String getTag() {
        return this.mediaFileName;
    }

    public String getDescription() {
        return "media description";
    }

    public String getInfo() {
        return "media info";
    }

    public void setFormat(String fmt) {
    }

    public String getFormat() {
        return "some media format";
    }

    public String getNodeName() {
        return this.getTag();
    }

    public boolean isTreeViewableLeaf() {
        return true;
    }

    public Vector getChildren() {
        return new Vector();
    }

    public String getFullPath() {
        return this.url;
    }

    public String getContentType() {
        String type = this.url.endsWith(".wav") ? "audio/wav" : (this.url.endsWith(".aif") ? "audio/aif" : (this.url.endsWith(".sd") ? "audio/x-esps" : (this.url.endsWith(".au") ? "audio/au" : "")));
        return type;
    }

    public InputStream getContentStream() {
        InputStream is = null;
        if (this.url != null) {
            try {
                is = new OurURL(this.url).openStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                is = null;
            }
        }
        return is;
    }
}

