/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.delimitedtext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextReader;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TimeSlotRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TimeSlotRecordComparator;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.TimeFormatter;

public class DelimitedTextParser
extends Parser
implements ServerLogger {
    private DelimitedTextDecoderInfo decoderInfo;
    private DelimitedTextReader reader;
    private String lastParsedFile;
    private final String TS_ID_PREFIX = "ts";
    private final String ANN_PREFIX = "a";
    private ArrayList lingTypeRecords = new ArrayList();
    private ArrayList tierNames = new ArrayList();
    private ArrayList timeOrder = new ArrayList();
    private ArrayList timeSlots = new ArrayList();
    private HashMap recordsPerTier = new HashMap();

    public DelimitedTextParser() {
    }

    public DelimitedTextParser(DelimitedTextDecoderInfo decoderInfo) {
        this.decoderInfo = decoderInfo;
        this.parse(decoderInfo.getSourceFilePath());
    }

    public void parse(String fileName) {
        if (fileName == null || fileName.equals(this.lastParsedFile)) {
            return;
        }
        this.lingTypeRecords.clear();
        this.tierNames.clear();
        this.timeOrder.clear();
        this.timeSlots.clear();
        this.recordsPerTier.clear();
        try {
            this.reader = new DelimitedTextReader(fileName);
            if (this.decoderInfo != null) {
                this.reader.setDelimiter(this.decoderInfo.getDelimiter());
                if (this.decoderInfo.isSingleAnnotationPerRow()) {
                    this.parseSingleAnnColumn();
                    this.sortTimeSlots();
                } else {
                    this.parseMultiAnnColumns();
                    this.sortTimeSlots();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.warning("The file is not found: " + fileName);
            return;
        }
        this.lastParsedFile = fileName;
    }

    private void parseSingleAnnColumn() {
        List records2;
        int[] annColumn = this.decoderInfo.getAnnotationColumns();
        int annIndex = -1;
        if (annColumn != null && annColumn.length >= 1) {
            annIndex = annColumn[0];
        }
        int tierIndex = this.decoderInfo.getTierColumnIndex();
        int btIndex = this.decoderInfo.getBeginTimeColumn();
        int etIndex = this.decoderInfo.getEndTimeColumn();
        int durIndex = this.decoderInfo.getDurationColumn();
        int[] inclColumns = this.decoderInfo.getIncludedColumns();
        Map colToTierName = this.decoderInfo.getColumnsWithTierNames();
        String defTier = "Tier-1";
        if (annIndex > -1 && colToTierName != null) {
            for (Integer keyInt : colToTierName.keySet()) {
                Object tName;
                if (keyInt != annIndex || !((tName = colToTierName.get(keyInt)) instanceof String)) continue;
                defTier = (String)tName;
            }
        }
        for (int i = 0; i < inclColumns.length; ++i) {
            if (inclColumns[i] == annIndex) {
                annIndex = i;
                continue;
            }
            if (inclColumns[i] == tierIndex) {
                tierIndex = i;
                continue;
            }
            if (inclColumns[i] == btIndex) {
                btIndex = i;
                continue;
            }
            if (inclColumns[i] == etIndex) {
                etIndex = i;
                continue;
            }
            if (inclColumns[i] != durIndex) continue;
            durIndex = i;
        }
        try {
            List<String[]> rows = this.reader.getRowDataForColumns(this.decoderInfo.getFirstRowIndex(), inclColumns);
            String[] row = null;
            String curTier = defTier;
            int tsCount = 1;
            int annCount = 1;
            for (int i = 0; i < rows.size(); ++i) {
                long dur;
                row = rows.get(i);
                long bt = btIndex > -1 && btIndex < row.length ? TimeFormatter.toMilliSeconds(row[btIndex]) : -1L;
                long et = etIndex > -1 && etIndex < row.length ? TimeFormatter.toMilliSeconds(row[etIndex]) : (durIndex > -1 && durIndex < row.length ? ((dur = TimeFormatter.toMilliSeconds(row[durIndex])) == -1L || bt == -1L ? -1L : bt + dur) : -1L);
                String ann = annIndex > -1 && annIndex < row.length ? row[annIndex] : "";
                if (tierIndex > -1 && tierIndex < row.length) {
                    curTier = row[tierIndex];
                    if (curTier.length() == 0) {
                        curTier = defTier;
                    }
                } else {
                    curTier = defTier;
                }
                if (!this.tierNames.contains(curTier)) {
                    this.tierNames.add(curTier);
                    this.recordsPerTier.put(curTier, new ArrayList());
                }
                AnnotationRecord annRec = new AnnotationRecord();
                annRec.setAnnotationType("alignable");
                annRec.setValue(ann);
                annRec.setAnnotationId("a" + annCount++);
                TimeSlotRecord tsRec = new TimeSlotRecord(tsCount++, bt);
                annRec.setBeginTimeSlotRecord(tsRec);
                this.timeSlots.add(tsRec);
                tsRec = new TimeSlotRecord(tsCount++, et);
                annRec.setEndTimeSlotRecord(tsRec);
                this.timeSlots.add(tsRec);
                ((List)this.recordsPerTier.get(curTier)).add(annRec);
            }
        }
        catch (IOException ioe) {
            LOG.severe("Error retrieving rowdata: " + ioe.getMessage());
        }
        Iterator valIt = this.recordsPerTier.values().iterator();
        AnnRecordComparator comp = new AnnRecordComparator();
        while (valIt.hasNext()) {
            records2 = (List)valIt.next();
            Collections.sort(records2, comp);
        }
        for (String tierName : this.recordsPerTier.keySet()) {
            records2 = (List)this.recordsPerTier.get(tierName);
            this.calculateUnalignedSlots(records2);
        }
        for (List records2 : this.recordsPerTier.values()) {
            this.correctOverlaps(records2);
        }
    }

    private void parseMultiAnnColumns() {
        int[] inclColumns = this.decoderInfo.getIncludedColumns();
        Map orgColsToTierName = this.decoderInfo.getColumnsWithTierNames();
        HashMap<Integer, String> colsToTierName = new HashMap<Integer, String>(orgColsToTierName.size());
        int btIndex = this.decoderInfo.getBeginTimeColumn();
        int etIndex = this.decoderInfo.getEndTimeColumn();
        int durIndex = this.decoderInfo.getDurationColumn();
        for (Integer colIndex : orgColsToTierName.keySet()) {
            for (int i = 0; i < inclColumns.length; ++i) {
                if (inclColumns[i] != colIndex) continue;
                String tierName = (String)orgColsToTierName.get(colIndex);
                colsToTierName.put(new Integer(i), tierName);
                if (this.tierNames.contains(tierName)) continue;
                this.tierNames.add(tierName);
                this.recordsPerTier.put(tierName, new ArrayList());
            }
        }
        Integer[] tierCols = new Integer[colsToTierName.size()];
        Iterator colIter = colsToTierName.keySet().iterator();
        int z = 0;
        while (colIter.hasNext()) {
            tierCols[z] = (Integer)colIter.next();
            ++z;
        }
        for (int i = 0; i < inclColumns.length; ++i) {
            if (inclColumns[i] == btIndex) {
                btIndex = i;
                continue;
            }
            if (inclColumns[i] == etIndex) {
                etIndex = i;
                continue;
            }
            if (inclColumns[i] != durIndex) continue;
            durIndex = i;
        }
        HashMap slotToSlots = new HashMap();
        String refTier = null;
        try {
            List<String[]> rows = this.reader.getRowDataForColumns(this.decoderInfo.getFirstRowIndex(), inclColumns);
            String[] row = null;
            int tsCount = 1;
            int annCount = 1;
            for (int i = 0; i < rows.size(); ++i) {
                long dur;
                TimeSlotRecord curRefBTTS = null;
                TimeSlotRecord curRefETTS = null;
                row = rows.get(i);
                long bt = btIndex > -1 && btIndex < row.length ? TimeFormatter.toMilliSeconds(row[btIndex]) : -1L;
                long et = etIndex > -1 && etIndex < row.length ? TimeFormatter.toMilliSeconds(row[etIndex]) : (durIndex > -1 && durIndex < row.length ? ((dur = TimeFormatter.toMilliSeconds(row[durIndex])) == -1L || bt == -1L ? -1L : bt + dur) : -1L);
                for (int j = 0; j < tierCols.length; ++j) {
                    String ann = tierCols[j] > -1 && tierCols[j] < row.length ? row[tierCols[j]] : "";
                    String curTier = (String)colsToTierName.get(tierCols[j]);
                    if (j == 0 && refTier == null) {
                        refTier = curTier;
                    }
                    AnnotationRecord annRec = new AnnotationRecord();
                    annRec.setAnnotationType("alignable");
                    annRec.setValue(ann);
                    annRec.setAnnotationId("a" + annCount++);
                    TimeSlotRecord tsRec = new TimeSlotRecord(tsCount++, bt);
                    annRec.setBeginTimeSlotRecord(tsRec);
                    this.timeSlots.add(tsRec);
                    tsRec = new TimeSlotRecord(tsCount++, et);
                    annRec.setEndTimeSlotRecord(tsRec);
                    this.timeSlots.add(tsRec);
                    ((List)this.recordsPerTier.get(curTier)).add(annRec);
                    if (j == 0) {
                        curRefBTTS = annRec.getBeginTimeSlotRecord();
                        curRefETTS = annRec.getEndTimeSlotRecord();
                        slotToSlots.put(curRefBTTS, new ArrayList(5));
                        slotToSlots.put(curRefETTS, new ArrayList(5));
                        continue;
                    }
                    ((ArrayList)slotToSlots.get(curRefBTTS)).add(annRec.getBeginTimeSlotRecord());
                    ((ArrayList)slotToSlots.get(curRefETTS)).add(annRec.getEndTimeSlotRecord());
                }
            }
        }
        catch (IOException ioe) {
            LOG.severe("Error retrieving rowdata: " + ioe.getMessage());
        }
        List records = (List)this.recordsPerTier.get(refTier);
        Collections.sort(records, new AnnRecordComparator());
        this.calculateUnalignedSlots(records);
        this.correctOverlaps(records);
        for (TimeSlotRecord keyRec : slotToSlots.keySet()) {
            ArrayList refSlots = (ArrayList)slotToSlots.get(keyRec);
            for (int i = 0; i < refSlots.size(); ++i) {
                TimeSlotRecord valRec = (TimeSlotRecord)refSlots.get(i);
                valRec.setValue(keyRec.getValue());
            }
        }
    }

    private void sortTimeSlots() {
        if (this.timeSlots != null && this.timeSlots.size() > 1) {
            Collections.sort(this.timeSlots, new TimeSlotRecordComparator());
            for (int i = 0; i < this.timeSlots.size(); ++i) {
                TimeSlotRecord tsr = (TimeSlotRecord)this.timeSlots.get(i);
                tsr.setId(i + 1);
            }
        }
    }

    private void calculateUnalignedSlots(List records) {
        if (records == null || records.size() == 0) {
            return;
        }
        long curAdv = 0L;
        long avgDur = this.decoderInfo.getDefaultDuration();
        for (int i = 0; i < records.size(); ++i) {
            AnnotationRecord annRec = (AnnotationRecord)records.get(i);
            TimeSlotRecord tsBRec = annRec.getBeginTimeSlotRecord();
            TimeSlotRecord tsERec = annRec.getEndTimeSlotRecord();
            if (tsBRec.getValue() < 0L) {
                if (i > 0) {
                    if (tsERec.getValue() < 0L) {
                        tsBRec.setValue(curAdv);
                    } else {
                        tsBRec.setValue(Math.max(curAdv, tsERec.getValue() - this.decoderInfo.getDefaultDuration()));
                    }
                } else {
                    tsBRec.setValue(0L);
                }
            } else {
                curAdv = Math.max(curAdv, tsBRec.getValue());
            }
            if (tsERec.getValue() < 0L) {
                AnnotationRecord nextRec;
                int j;
                int numUnalignedSlots = 1;
                long nextTime = 0L;
                for (j = i + 1; j < records.size(); ++j) {
                    nextRec = (AnnotationRecord)records.get(j);
                    if (nextRec.getBeginTimeSlotRecord().getValue() >= 0L) {
                        nextTime = nextRec.getBeginTimeSlotRecord().getValue();
                        break;
                    }
                    if (nextRec.getEndTimeSlotRecord().getValue() < 0L) {
                        ++numUnalignedSlots;
                        continue;
                    }
                    nextTime = nextRec.getEndTimeSlotRecord().getValue();
                    break;
                }
                if (numUnalignedSlots > 0) {
                    if (nextTime == 0L) {
                        nextTime = curAdv + (long)numUnalignedSlots * this.decoderInfo.getDefaultDuration();
                    }
                    avgDur = (nextTime - curAdv) / (long)numUnalignedSlots;
                    avgDur = Math.min(avgDur, this.decoderInfo.getDefaultDuration());
                    j = i;
                    for (int k = 0; j < records.size() && k < numUnalignedSlots; ++j, ++k) {
                        nextRec = (AnnotationRecord)records.get(j);
                        if (k == 0) {
                            nextRec.getEndTimeSlotRecord().setValue(curAdv + avgDur);
                            continue;
                        }
                        if (nextRec.getBeginTimeSlotRecord().getValue() < 0L) {
                            nextRec.getBeginTimeSlotRecord().setValue(curAdv + avgDur * (long)k);
                        }
                        if (nextRec.getEndTimeSlotRecord().getValue() >= 0L) continue;
                        nextRec.getEndTimeSlotRecord().setValue(curAdv + avgDur * (long)(k + 1));
                    }
                    curAdv = nextTime;
                    i = j - 1;
                    continue;
                }
                tsERec.setValue(Math.min(nextTime, curAdv + this.decoderInfo.getDefaultDuration()));
                curAdv = tsERec.getValue();
                continue;
            }
            curAdv = tsERec.getValue();
        }
    }

    private void correctOverlaps(List annRecords) {
        for (int i = 0; i < annRecords.size() - 1; ++i) {
            AnnotationRecord annRec = (AnnotationRecord)annRecords.get(i);
            AnnotationRecord nextRec = (AnnotationRecord)annRecords.get(i + 1);
            TimeSlotRecord tsERec = annRec.getEndTimeSlotRecord();
            TimeSlotRecord tsBRec = nextRec.getBeginTimeSlotRecord();
            if (tsERec.getValue() <= tsBRec.getValue()) continue;
            tsERec.setValue(tsBRec.getValue());
        }
    }

    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return new ArrayList();
    }

    public ArrayList getLinguisticTypes(String fileName) {
        this.parse(fileName);
        if (this.lingTypeRecords.size() == 0) {
            LingTypeRecord lt = new LingTypeRecord();
            lt.setLingTypeId("default");
            lt.setTimeAlignable("true");
            lt.setGraphicReferences("false");
            this.lingTypeRecords.add(lt);
        }
        return this.lingTypeRecords;
    }

    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        this.timeOrder.clear();
        for (int i = 0; i < this.timeSlots.size(); ++i) {
            TimeSlotRecord tsr = (TimeSlotRecord)this.timeSlots.get(i);
            this.timeOrder.add("ts" + tsr.getId());
        }
        return this.timeOrder;
    }

    public HashMap getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> tsMap = new HashMap<String, String>(this.timeSlots.size());
        for (int i = 0; i < this.timeSlots.size(); ++i) {
            TimeSlotRecord tsr = (TimeSlotRecord)this.timeSlots.get(i);
            tsMap.put("ts" + tsr.getId(), Long.toString(tsr.getValue()));
        }
        return tsMap;
    }

    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        return "default";
    }

    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList records = (ArrayList)this.recordsPerTier.get(tierName);
        if (records != null) {
            return records;
        }
        return new ArrayList();
    }

    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof DelimitedTextDecoderInfo) {
            this.decoderInfo = (DelimitedTextDecoderInfo)decoderInfo;
        }
    }

    private class AnnRecordComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            AnnotationRecord ar1 = (AnnotationRecord)o1;
            AnnotationRecord ar2 = (AnnotationRecord)o2;
            if (ar1.getBeginTimeSlotRecord().getValue() > -1L && ar2.getBeginTimeSlotRecord().getValue() > -1L && ar1.getBeginTimeSlotRecord().getValue() < ar2.getBeginTimeSlotRecord().getValue()) {
                return -1;
            }
            if (ar1.getBeginTimeSlotRecord().getValue() > -1L && ar2.getBeginTimeSlotRecord().getValue() > -1L && ar1.getBeginTimeSlotRecord().getValue() > ar2.getBeginTimeSlotRecord().getValue()) {
                return 1;
            }
            if (ar1.getEndTimeSlotRecord().getValue() > -1L && ar2.getEndTimeSlotRecord().getValue() > -1L && ar1.getEndTimeSlotRecord().getValue() < ar2.getEndTimeSlotRecord().getValue()) {
                return -1;
            }
            if (ar1.getEndTimeSlotRecord().getValue() > -1L && ar2.getEndTimeSlotRecord().getValue() > -1L && ar1.getEndTimeSlotRecord().getValue() > ar2.getEndTimeSlotRecord().getValue()) {
                return 1;
            }
            try {
                Long l1 = Long.valueOf(ar1.getAnnotationId().substring(1));
                Long l2 = Long.valueOf(ar2.getAnnotationId().substring(1));
                if (l1 < l2) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
            }
            catch (NumberFormatException nfe) {
                ServerLogger.LOG.warning("Invalid id of annotation record");
            }
            return 0;
        }
    }
}

