/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.delimitedtext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mpi.eudico.server.corpora.util.ServerLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedTextReader
implements ServerLogger {
    private final String TAB = "\t";
    private final String SC = ";";
    private final String COMMA = ",";
    private File sourceFile;
    private String delimiter = "\t";
    private int numColumns = 1;
    private int firstRowIndex = 0;

    public DelimitedTextReader(File sourceFile) throws FileNotFoundException {
        this.sourceFile = sourceFile;
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("Input file does not exist");
        }
        try {
            this.delimiter = this.detectDelimiter();
        }
        catch (IOException ioe) {
            LOG.warning("Unable to detect the delimiter");
        }
        try {
            this.numColumns = this.detectNumColumns();
        }
        catch (IOException ioe) {
            LOG.warning("Unable to detect the delimiter");
        }
    }

    public DelimitedTextReader(String fileName) throws FileNotFoundException {
        if (fileName == null) {
            throw new NullPointerException("The file name is null");
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring(5);
        }
        this.sourceFile = new File(fileName);
        if (!this.sourceFile.exists()) {
            throw new FileNotFoundException("Input file does not exist");
        }
        try {
            this.delimiter = this.detectDelimiter();
        }
        catch (IOException ioe) {
            LOG.warning("Unable to detect the delimiter");
        }
        try {
            this.numColumns = this.detectNumColumns();
        }
        catch (IOException ioe) {
            LOG.warning("Unable to detect the number of columns");
        }
    }

    public String detectDelimiter() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        int maxNumLines = 10;
        int numLines = 0;
        int numTabs = 0;
        int numCommas = 0;
        int numSemiCol = 0;
        String line = null;
        Pattern pat = null;
        while ((line = bufRead.readLine()) != null && numLines < maxNumLines) {
            if (line.length() == 0) continue;
            ++numLines;
            pat = Pattern.compile("\t");
            numTabs += pat.split(line).length - 1;
            pat = Pattern.compile(";");
            numSemiCol += pat.split(line).length - 1;
            pat = Pattern.compile(",");
            numCommas += pat.split(line).length - 1;
        }
        try {
            bufRead.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        String del = null;
        if (numTabs > numSemiCol && numTabs > numCommas) {
            del = "\t";
        } else if (numSemiCol > numTabs && numSemiCol > numCommas) {
            del = ";";
        } else if (numCommas > numTabs && numCommas > numSemiCol) {
            del = ",";
        }
        if (del == null) {
            del = "\t";
        }
        this.delimiter = del;
        return del;
    }

    public int detectNumColumns() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        int maxNumLines = 10;
        int numLines = 0;
        int numCols = 0;
        String line = null;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = bufRead.readLine()) != null && numLines < maxNumLines) {
            if (line.length() == 0) continue;
            ++numLines;
            String[] nextRow = pat.split(line);
            numCols += nextRow.length;
        }
        try {
            bufRead.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (numLines > 0 && numCols > 0) {
            this.numColumns = Math.round((float)numCols / (float)numLines);
            return this.numColumns;
        }
        return 1;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter != null) {
            this.delimiter = delimiter;
        }
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public List getRowDataForColumns(int[] columns) throws IOException {
        return this.getRowDataForColumns(this.firstRowIndex, columns);
    }

    public List<String[]> getRowDataForColumns(int firstRow, int[] columns) throws IOException {
        if (this.sourceFile == null || columns == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String line = null;
        int rowCount = 0;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = bufRead.readLine()) != null) {
            if (line.length() == 0 || rowCount < firstRow) {
                ++rowCount;
                continue;
            }
            String[] nextRow = pat.split(line);
            String[] row = new String[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                row[i] = columns[i] < nextRow.length ? nextRow[columns[i]] : "";
            }
            rows.add(row);
            ++rowCount;
        }
        try {
            bufRead.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return rows;
    }

    public List<String[]> getSamples(int rowCount) throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String line = null;
        int count = 0;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = bufRead.readLine()) != null && count < rowCount) {
            if (line.length() == 0) continue;
            String[] nextRow = pat.split(line);
            rows.add(nextRow);
            ++count;
        }
        try {
            bufRead.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return rows;
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int firstRow) {
        this.firstRowIndex = firstRow;
    }
}

