/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF20;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF20Parser;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF20TranscriptionStore
implements TranscriptionStore {
    public File fileToWriteXMLinto = null;

    public PrintWriter addPrintln(File f) {
        try {
            FileWriter fileWriter1 = new FileWriter(f);
            return new PrintWriter((Writer)fileWriter1, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, int format) {
        if (theTranscription instanceof TranscriptionImpl) {
            String pathName = ((TranscriptionImpl)theTranscription).getPathName();
            if (!pathName.substring(pathName.length() - 4, pathName.length() - 3).equals(".")) {
                pathName = pathName + ".eaf";
            } else {
                pathName = pathName.substring(0, pathName.length() - 3);
                pathName = pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, tierOrder, pathName);
        }
    }

    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String pathName, int format) {
        if (theTranscription instanceof TranscriptionImpl) {
            if (!pathName.substring(pathName.length() - 4, pathName.length() - 3).equals(".")) {
                pathName = pathName + ".eaf";
            } else {
                pathName = pathName.substring(0, pathName.length() - 3);
                pathName = pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, tierOrder, pathName);
        }
    }

    public void storeTranscriptionIn(Transcription theTranscription, List tierOrder, String path) {
        Element documentElement = EAF20TranscriptionStore.createDOM(theTranscription, tierOrder);
        if (this.fileToWriteXMLinto != null) {
            EAF20TranscriptionStore.save(documentElement, this.fileToWriteXMLinto.getAbsolutePath(), true);
        } else {
            EAF20TranscriptionStore.save(documentElement, path, false);
        }
    }

    private static void save(Element documentElement, String path, boolean backup) {
        System.out.println(path + " <----XML output\n");
        try {
            if (("" + documentElement).length() == 0) {
                String txt = "Sorry: unable to save this file (zero length).";
                JOptionPane.showMessageDialog(null, txt, txt, 0);
                return;
            }
            IoUtil.writeEncodedFile("UTF-8", path, documentElement);
            if (!backup) {
                JOptionPane.showMessageDialog(null, "Your file has been written to " + path);
            }
        }
        catch (Exception eee) {
            String txt = "Sorry: unable to save this file. (" + eee.getMessage() + ")";
            JOptionPane.showMessageDialog(null, txt, txt, 0);
        }
    }

    public static Element createDOM(Transcription theTranscription, List tierOrder) {
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<TimeSlot, String> timeSlotIds = new Hashtable<TimeSlot, String>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            System.out.println("[[ASSERTION FAILED]] EAF20TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF20 eafFactory = null;
        try {
            eafFactory = new EAF20();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm z");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        String version = "2.0";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, version);
        eafFactory.appendChild(annotDocument);
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Enumeration tsElements = timeOrder.elements();
        while (tsElements.hasMoreElements()) {
            TimeSlot ts = (TimeSlot)tsElements.nextElement();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, tsId);
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        int annIndex = 1;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String string = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(string, participant, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                annotationIds.put(ann, "a" + annIndex);
                ++annIndex;
            }
        }
        for (TierImpl tierImpl : storeOrder) {
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                Element annElement = eafFactory.newAnnotation();
                ((Element)tierElements.get(tierImpl.getName())).appendChild(annElement);
                Node annSubElement = null;
                String annId = (String)annotationIds.get(ann);
                if (ann instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getBegin());
                    String endTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getEnd());
                    annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId);
                } else if (ann instanceof RefAnnotation) {
                    String refId = null;
                    String prevId = null;
                    Vector refs = ((RefAnnotation)ann).getReferences();
                    RefAnnotation prev = ((RefAnnotation)ann).getPrevious();
                    if (refs.size() > 0) {
                        refId = (String)annotationIds.get((Annotation)refs.firstElement());
                    }
                    if (prev != null) {
                        prevId = (String)annotationIds.get(prev);
                    }
                    annSubElement = eafFactory.newRefAnnotation(annId, refId, prevId);
                }
                annElement.appendChild(annSubElement);
                Element valueElement = eafFactory.newAnnotationValue(ann.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        Vector vector = attisTr.getLinguisticTypes();
        if (vector != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype);
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        return eafFactory.getDocumentElement();
    }

    public void storeTranscriptionAsTemplateIn(Transcription theTranscription, List tierOrder, String path) {
        Element documentElement = EAF20TranscriptionStore.createTemplateDOM(theTranscription, tierOrder);
        if (this.fileToWriteXMLinto != null) {
            EAF20TranscriptionStore.save(documentElement, this.fileToWriteXMLinto.getAbsolutePath(), true);
        } else {
            EAF20TranscriptionStore.save(documentElement, path, false);
        }
    }

    public static Element createTemplateDOM(Transcription theTranscription, List tierOrder) {
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            System.out.println("[[ASSERTION FAILED]] EAF20TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF20 eafFactory = null;
        try {
            eafFactory = new EAF20();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm z");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        String author = attisTr.getAuthor();
        author = "";
        String version = "2.0";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, version);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        int annIndex = 1;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String id = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                annotationIds.put(ann, "a" + annIndex);
                ++annIndex;
            }
        }
        Vector vector = attisTr.getLinguisticTypes();
        if (vector != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype);
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        return eafFactory.getDocumentElement();
    }

    public void loadTranscription(Transcription theTranscription) {
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        String mediaFileName = EAF20Parser.Instance().getMediaFile(attisTr.getPathName());
        if (mediaFileName.startsWith("file:")) {
            mediaFileName = mediaFileName.substring(5);
        }
        attisTr.setMainMediaFile(mediaFileName);
        String svgFile = EAF20Parser.Instance().getSVGFile(attisTr.getPathName());
        if (svgFile != null) {
            if (!svgFile.startsWith("file:")) {
                svgFile = "file:" + mediaFileName;
            }
            attisTr.setSVGFile(svgFile);
        }
        String author = EAF20Parser.Instance().getAuthor(attisTr.getPathName());
        if (attisTr.getAuthor().equals("")) {
            attisTr.setAuthor(author);
        }
        Vector linguisticTypes = EAF20Parser.Instance().getLinguisticTypes(attisTr.getPathName());
        Vector typesCopy = new Vector(linguisticTypes.size());
        for (int i = 0; i < linguisticTypes.size(); ++i) {
            typesCopy.add(i, linguisticTypes.get(i));
        }
        attisTr.setLinguisticTypes(typesCopy);
        TimeOrder timeOrder = attisTr.getTimeOrder();
        Vector order = EAF20Parser.Instance().getTimeOrder(attisTr.getPathName());
        Hashtable slots = EAF20Parser.Instance().getTimeSlots(attisTr.getPathName());
        Hashtable<String, TimeSlotImpl> timeSlothash = new Hashtable<String, TimeSlotImpl>();
        Iterator orderedIter = order.iterator();
        while (orderedIter.hasNext()) {
            TimeSlotImpl ts = null;
            String key = (String)orderedIter.next();
            long time = Long.parseLong((String)slots.get(key));
            ts = time != -1L ? new TimeSlotImpl(time, timeOrder) : new TimeSlotImpl(timeOrder);
            timeOrder.insertTimeSlot(ts);
            timeSlothash.put(key, ts);
        }
        Hashtable<TierImpl, String> parentHash = new Hashtable<TierImpl, String>();
        if (!attisTr.isLoaded()) {
            Iterator iter = EAF20Parser.Instance().getTierNames(attisTr.getPathName()).iterator();
            attisTr.setLoaded(true);
            while (iter.hasNext()) {
                String parentId;
                String tierName = (String)iter.next();
                TierImpl tier = new TierImpl(null, tierName, null, attisTr, null);
                String participant = EAF20Parser.Instance().getParticipantOf(tierName, attisTr.getPathName());
                LinguisticType linguisticType = EAF20Parser.Instance().getLinguisticTypeOf(tierName, attisTr.getPathName());
                Locale defaultLanguage = EAF20Parser.Instance().getDefaultLanguageOf(tierName, attisTr.getPathName());
                tier.setMetadata("PARTICIPANT", participant);
                tier.setLinguisticType(linguisticType);
                if (defaultLanguage != null) {
                    tier.setMetadata("DEFAULT_LOCALE", defaultLanguage);
                }
                if ((parentId = EAF20Parser.Instance().getParentNameOf(tierName, attisTr.getPathName())) != null) {
                    parentHash.put(tier, parentId);
                }
                attisTr.addTier(tier);
            }
        }
        for (TierImpl t : parentHash.keySet()) {
            t.setParentTier(attisTr.getTierWithId((String)parentHash.get(t)));
        }
        Vector tiers = attisTr.getTiers();
        Hashtable<String, AlignableAnnotation> idToAnnotation = new Hashtable<String, AlignableAnnotation>();
        Hashtable<String, String> references = new Hashtable<String, String>();
        Hashtable<String, String> referenceChains = new Hashtable<String, String>();
        Hashtable tempAnnotationsForTiers = new Hashtable();
        for (Tier tier : tiers) {
            Vector annotationRecords = EAF20Parser.Instance().getAnnotationsOf(tier.getName(), attisTr.getPathName());
            Vector<AlignableAnnotation> tempAnnotations = new Vector<AlignableAnnotation>();
            Iterator it1 = annotationRecords.iterator();
            while (it1.hasNext()) {
                AbstractAnnotation annotation = null;
                Vector annotationRecord = (Vector)it1.next();
                Iterator it2 = annotationRecord.iterator();
                int index = 0;
                String id = null;
                String annotType = null;
                String timeSlotId1 = null;
                String timeSlotId2 = null;
                String annotRefId = null;
                String annotValue = null;
                String prevRefId = null;
                String svg_ref = null;
                while (it2.hasNext()) {
                    if (index == 0) {
                        id = (String)it2.next();
                    } else if (index == 1) {
                        annotType = (String)it2.next();
                    } else if (index == 2) {
                        if (annotType.equals("alignable") || annotType.equals("alignable_svg")) {
                            timeSlotId1 = (String)it2.next();
                        } else if (annotType.equals("reference")) {
                            annotRefId = (String)it2.next();
                        }
                    } else if (index == 3) {
                        if (annotType.equals("alignable") || annotType.equals("alignable_svg")) {
                            timeSlotId2 = (String)it2.next();
                        } else if (annotType.equals("reference")) {
                            prevRefId = (String)it2.next();
                        }
                    } else if (index == 4) {
                        if (annotType.equals("alignable")) {
                            annotValue = (String)it2.next();
                        } else if (annotType.equals("alignable_svg")) {
                            svg_ref = (String)it2.next();
                        } else if (annotType.equals("reference")) {
                            annotValue = (String)it2.next();
                        }
                    } else if (index == 5 && annotType.equals("alignable_svg")) {
                        annotValue = (String)it2.next();
                    }
                    ++index;
                }
                if (annotType.equals("alignable")) {
                    annotation = new AlignableAnnotation((TimeSlot)timeSlothash.get(timeSlotId1), (TimeSlot)timeSlothash.get(timeSlotId2), tier);
                } else if (annotType.equals("alignable_svg")) {
                    annotation = new SVGAlignableAnnotation((TimeSlot)timeSlothash.get(timeSlotId1), (TimeSlot)timeSlothash.get(timeSlotId2), tier, svg_ref);
                } else if (annotType.equals("reference")) {
                    annotation = new RefAnnotation(null, tier);
                    references.put(id, annotRefId);
                    if (!prevRefId.equals("")) {
                        referenceChains.put(id, prevRefId);
                    }
                }
                if (annotValue != null) {
                    annotation.setValue(annotValue);
                }
                idToAnnotation.put(id, (AlignableAnnotation)annotation);
                tempAnnotations.add((AlignableAnnotation)annotation);
            }
            tempAnnotationsForTiers.put(tier, tempAnnotations);
        }
        for (String key : references.keySet()) {
            Annotation referedAnnotation = (Annotation)idToAnnotation.get(references.get(key));
            RefAnnotation refAnnotation = null;
            try {
                refAnnotation = (RefAnnotation)idToAnnotation.get(key);
                refAnnotation.addReference(referedAnnotation);
            }
            catch (Exception ex) {
                Object o = idToAnnotation.get(key);
                System.out.println("failed to add a refanno to  (" + referedAnnotation.getTier().getName() + ", " + referedAnnotation.getBeginTimeBoundary() + ", " + referedAnnotation.getEndTimeBoundary() + ") " + referedAnnotation.getValue());
                if (o instanceof AlignableAnnotation) {
                    Annotation a = (AlignableAnnotation)o;
                    System.out.println("  found AlignableAnnotation (" + ((AbstractAnnotation)a).getTier().getName() + ", " + ((AlignableAnnotation)a).getBeginTimeBoundary() + ", " + ((AlignableAnnotation)a).getEndTimeBoundary() + ") " + ((AbstractAnnotation)a).getValue());
                    continue;
                }
                System.out.println("  found " + o);
            }
        }
        for (String key : referenceChains.keySet()) {
            RefAnnotation previous = (RefAnnotation)idToAnnotation.get(referenceChains.get(key));
            RefAnnotation a = (RefAnnotation)idToAnnotation.get(key);
            if (previous == null) continue;
            previous.setNext(a);
        }
        for (TierImpl t : tempAnnotationsForTiers.keySet()) {
            Vector annots = (Vector)tempAnnotationsForTiers.get(t);
            Iterator aIter = annots.iterator();
            while (aIter.hasNext()) {
                t.insertAnnotation((Annotation)aIter.next());
            }
        }
        for (TierImpl t : tiers) {
            if (!t.isTimeAlignable() || !t.hasParentTier()) continue;
            for (Annotation a : t.getAnnotations()) {
                if (!(a instanceof AlignableAnnotation)) continue;
                ((AlignableAnnotation)a).registerWithParent();
            }
        }
    }

    public void loadTranscription(Transcription theTranscription, DecoderInfo decoderInfo) {
        this.loadTranscription(theTranscription);
    }

    public void storeTranscriptionIn(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path, int format) throws IOException {
        this.storeTranscriptionIn(theTranscription, tierOrder, path);
    }
}

