/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EAF25Parser
extends Parser {
    private boolean verbose = false;
    private XMLReader reader;
    private final HashMap tierMap = new HashMap();
    private final HashMap tiers = new HashMap();
    private final ArrayList tierNames = new ArrayList();
    private final ArrayList linguisticTypes = new ArrayList();
    private final ArrayList locales = new ArrayList();
    private final HashMap timeSlots = new HashMap();
    private final HashMap controlledVocabularies = new HashMap();
    private final ArrayList docProperties = new ArrayList();
    private final ArrayList timeOrder = new ArrayList();
    private String mediaFile;
    private ArrayList mediaDescriptors = new ArrayList();
    private ArrayList linkedFileDescriptors = new ArrayList();
    private String svgFile;
    private String author;
    private String currentTierId;
    private String currentAnnotationId;
    private AnnotationRecord currentAnnRecord;
    private String currentCVId;
    private CVEntryRecord currentEntryRecord;
    private String content = "";
    private String lastParsed = "";
    private String currentFileName;
    private PropertyImpl currentProperty;
    private boolean parseError;

    public EAF25Parser() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResource("/mpi/eudico/resources/EAFv2.5.xsd").openStream());
            this.reader.setContentHandler(new EAFContentHandler());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return this.mediaFile;
    }

    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.mediaDescriptors;
    }

    public ArrayList getLinkedFileDescriptors(String fileName) {
        this.parse(fileName);
        return this.linkedFileDescriptors;
    }

    public String getSVGFile(String fileName) {
        this.parse(fileName);
        return this.svgFile;
    }

    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.author;
    }

    public ArrayList getTranscriptionProperties(String fileName) {
        this.parse(fileName);
        return this.docProperties;
    }

    public ArrayList getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    public HashMap getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlots;
    }

    public HashMap getControlledVocabularies(String fileName) {
        this.parse(fileName);
        return this.controlledVocabularies;
    }

    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && ((TierRecord)this.tierMap.get(tierName)).getParticipant() != null) {
            return ((TierRecord)this.tierMap.get(tierName)).getParticipant();
        }
        return "";
    }

    public String getAnnotatorOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && ((TierRecord)this.tierMap.get(tierName)).getAnnotator() != null) {
            return ((TierRecord)this.tierMap.get(tierName)).getAnnotator();
        }
        return "";
    }

    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && ((TierRecord)this.tierMap.get(tierName)).getLinguisticType() != null) {
            return ((TierRecord)this.tierMap.get(tierName)).getLinguisticType();
        }
        return "";
    }

    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        Locale resultLoc = null;
        String localeId = null;
        if (this.tierMap.get(tierName) != null) {
            localeId = ((TierRecord)this.tierMap.get(tierName)).getDefaultLocale();
        }
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null) {
            return ((TierRecord)this.tierMap.get(tierName)).getParentTier();
        }
        return null;
    }

    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        return (ArrayList)this.tiers.get(tierName);
    }

    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.tiers.clear();
        this.tierNames.clear();
        this.mediaFile = "";
        this.linguisticTypes.clear();
        this.locales.clear();
        this.timeSlots.clear();
        this.timeOrder.clear();
        this.mediaDescriptors.clear();
        this.linkedFileDescriptors.clear();
        this.controlledVocabularies.clear();
        this.lastParsed = fileName;
        this.currentFileName = fileName;
        try {
            this.reader.parse(fileName);
        }
        catch (SAXException e) {
            System.out.println("Parsing error: " + e.getMessage());
            File f = new File(fileName);
            if (f.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.reader.parse(source);
                }
                catch (Exception ee) {
                    System.out.println("Parsing retry error: " + ee.getMessage());
                }
            }
        }
        catch (IOException e) {
            System.out.println("IO error: " + e.getMessage());
            File f = new File(fileName);
            if (f.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.reader.parse(source);
                }
                catch (Exception ee) {
                    System.out.println("Parsing retry error: " + ee.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage());
        }
    }

    private void println(String s) {
        if (this.verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
        System.out.println("Tier id " + this.currentTierId);
        System.out.println("Annotation id " + this.currentAnnotationId);
    }

    class EAFContentHandler
    implements ContentHandler {
        private Locator locator;

        EAFContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startDocument() throws SAXException {
            EAF25Parser.this.parseError = false;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAF25Parser.this.content = "";
            if (name.equals("ANNOTATION_DOCUMENT")) {
                EAF25Parser.this.author = attributes.getValue("AUTHOR");
            } else if (name.equals("HEADER")) {
                EAF25Parser.this.mediaFile = attributes.getValue("MEDIA_FILE");
                EAF25Parser.this.svgFile = attributes.getValue("SVG_FILE");
            } else if (name.equals("MEDIA_DESCRIPTOR")) {
                String relURL;
                String mediaURL = attributes.getValue("MEDIA_URL");
                String mimeType = attributes.getValue("MIME_TYPE");
                MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
                long timeOrigin = 0L;
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    md.timeOrigin = timeOrigin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                }
                String extractedFrom = "";
                if (attributes.getValue("EXTRACTED_FROM") != null) {
                    md.extractedFrom = extractedFrom = attributes.getValue("EXTRACTED_FROM");
                }
                if ((relURL = attributes.getValue("RELATIVE_MEDIA_URL")) != null) {
                    md.relativeMediaURL = relURL;
                }
                EAF25Parser.this.mediaDescriptors.add(md);
            } else if (name.equals("LINKED_FILE_DESCRIPTOR")) {
                String relURL;
                String assoc;
                String linkURL = attributes.getValue("LINK_URL");
                String mime = attributes.getValue("MIME_TYPE");
                LinkedFileDescriptor lfd = new LinkedFileDescriptor(linkURL, mime);
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    try {
                        long origin;
                        lfd.timeOrigin = origin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Could not parse the time origin: " + nfe.getMessage());
                    }
                }
                if ((assoc = attributes.getValue("ASSOCIATED_WITH")) != null) {
                    lfd.associatedWith = assoc;
                }
                if ((relURL = attributes.getValue("RELATIVE_LINK_URL")) != null) {
                    lfd.relativeLinkURL = relURL;
                }
                EAF25Parser.this.linkedFileDescriptors.add(lfd);
            } else if (name.equals("PROPERTY")) {
                EAF25Parser.this.currentProperty = new PropertyImpl();
                if (attributes.getValue("NAME") != null) {
                    EAF25Parser.this.currentProperty.setName(attributes.getValue("NAME"));
                }
                EAF25Parser.this.docProperties.add(EAF25Parser.this.currentProperty);
            } else if (!name.equals("TIME_ORDER")) {
                if (name.equals("TIME_SLOT")) {
                    String timeValue = String.valueOf(-1);
                    if (attributes.getValue("TIME_VALUE") != null) {
                        timeValue = attributes.getValue("TIME_VALUE");
                    }
                    EAF25Parser.this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                    EAF25Parser.this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
                } else if (name.equals("TIER")) {
                    EAF25Parser.this.currentTierId = attributes.getValue("TIER_ID");
                    if (!EAF25Parser.this.tiers.containsKey(EAF25Parser.this.currentTierId)) {
                        TierRecord tr = new TierRecord();
                        tr.setName(EAF25Parser.this.currentTierId);
                        EAF25Parser.this.tierMap.put(EAF25Parser.this.currentTierId, tr);
                        tr.setParticipant(attributes.getValue("PARTICIPANT"));
                        tr.setAnnotator(attributes.getValue("ANNOTATOR"));
                        tr.setLinguisticType(attributes.getValue("LINGUISTIC_TYPE_REF"));
                        tr.setDefaultLocale(attributes.getValue("DEFAULT_LOCALE"));
                        tr.setParentTier(attributes.getValue("PARENT_REF"));
                        EAF25Parser.this.tiers.put(EAF25Parser.this.currentTierId, new ArrayList());
                        EAF25Parser.this.tierNames.add(EAF25Parser.this.currentTierId);
                    }
                } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                    EAF25Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    EAF25Parser.this.currentAnnRecord = new AnnotationRecord();
                    EAF25Parser.this.currentAnnRecord.setAnnotationId(EAF25Parser.this.currentAnnotationId);
                    String svg_ref = attributes.getValue("SVG_REF");
                    if (svg_ref != null) {
                        EAF25Parser.this.currentAnnRecord.setAnnotationType("alignable_svg");
                        EAF25Parser.this.currentAnnRecord.setSvgReference(svg_ref);
                    } else {
                        EAF25Parser.this.currentAnnRecord.setAnnotationType("alignable");
                    }
                    EAF25Parser.this.currentAnnRecord.setBeginTimeSlotId(attributes.getValue("TIME_SLOT_REF1"));
                    EAF25Parser.this.currentAnnRecord.setEndTimeSlotId(attributes.getValue("TIME_SLOT_REF2"));
                    ((ArrayList)EAF25Parser.this.tiers.get(EAF25Parser.this.currentTierId)).add(EAF25Parser.this.currentAnnRecord);
                } else if (name.equals("REF_ANNOTATION")) {
                    EAF25Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    EAF25Parser.this.currentAnnRecord = new AnnotationRecord();
                    EAF25Parser.this.currentAnnRecord.setAnnotationId(EAF25Parser.this.currentAnnotationId);
                    EAF25Parser.this.currentAnnRecord.setAnnotationType("reference");
                    EAF25Parser.this.currentAnnRecord.setReferredAnnotId(attributes.getValue("ANNOTATION_REF"));
                    if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                        EAF25Parser.this.currentAnnRecord.setPreviousAnnotId(attributes.getValue("PREVIOUS_ANNOTATION"));
                    } else {
                        EAF25Parser.this.currentAnnRecord.setPreviousAnnotId("");
                    }
                    ((ArrayList)EAF25Parser.this.tiers.get(EAF25Parser.this.currentTierId)).add(EAF25Parser.this.currentAnnRecord);
                } else if (name.equals("LINGUISTIC_TYPE")) {
                    LingTypeRecord ltr = new LingTypeRecord();
                    ltr.setLingTypeId(attributes.getValue("LINGUISTIC_TYPE_ID"));
                    String timeAlignable = "true";
                    if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                        timeAlignable = "false";
                    }
                    ltr.setTimeAlignable(timeAlignable);
                    String graphicReferences = "false";
                    if (attributes.getValue("GRAPHIC_REFERENCES") != null && attributes.getValue("GRAPHIC_REFERENCES").equals("true")) {
                        graphicReferences = "true";
                    }
                    ltr.setGraphicReferences(graphicReferences);
                    String stereotype = attributes.getValue("CONSTRAINTS");
                    ltr.setStereoType(stereotype);
                    ltr.setControlledVocabulary(attributes.getValue("CONTROLLED_VOCABULARY_REF"));
                    EAF25Parser.this.linguisticTypes.add(ltr);
                } else if (name.equals("LOCALE")) {
                    String variant;
                    String langCode = attributes.getValue("LANGUAGE_CODE");
                    String countryCode = attributes.getValue("COUNTRY_CODE");
                    if (countryCode == null) {
                        countryCode = "";
                    }
                    if ((variant = attributes.getValue("VARIANT")) == null) {
                        variant = "";
                    }
                    Locale l = new Locale(langCode, countryCode, variant);
                    EAF25Parser.this.locales.add(l);
                } else if (name.equals("CONTROLLED_VOCABULARY")) {
                    EAF25Parser.this.currentCVId = attributes.getValue("CV_ID");
                    ArrayList<String> cv = new ArrayList<String>();
                    String desc = attributes.getValue("DESCRIPTION");
                    if (desc != null) {
                        cv.add(desc);
                    }
                    EAF25Parser.this.controlledVocabularies.put(EAF25Parser.this.currentCVId, cv);
                } else if (name.equals("CV_ENTRY")) {
                    EAF25Parser.this.currentEntryRecord = new CVEntryRecord();
                    EAF25Parser.this.currentEntryRecord.setDescription(attributes.getValue("DESCRIPTION"));
                    ((ArrayList)EAF25Parser.this.controlledVocabularies.get(EAF25Parser.this.currentCVId)).add(EAF25Parser.this.currentEntryRecord);
                }
            }
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("ANNOTATION_VALUE")) {
                EAF25Parser.this.currentAnnRecord.setValue(EAF25Parser.this.content);
            } else if (name.equals("CV_ENTRY")) {
                EAF25Parser.this.currentEntryRecord.setValue(EAF25Parser.this.content);
            } else if (name.equals("PROPERTY") && EAF25Parser.this.content.length() > 0) {
                EAF25Parser.this.currentProperty.setValue(EAF25Parser.this.content);
            }
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            EAF25Parser.this.content = EAF25Parser.this.content + new String(ch, start, end);
        }
    }

    class EAFErrorHandler
    implements ErrorHandler {
        EAFErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("System id" + exception.getSystemId());
            System.out.println("Public id" + exception.getPublicId());
            System.out.println("Line: " + exception.getLineNumber());
            System.out.println("Column: " + exception.getColumnNumber());
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
        }

        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }
}

