/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF26 {
    public static final String TIME_UNIT_MILLISEC = "milliseconds";
    public static final String TIME_UNIT_NTSC = "NTSC-frames";
    public static final String TIME_UNIT_PAL = "PAL-frames";
    protected Document doc;

    public Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    public Node appendChild(Node e) {
        return this.doc.appendChild(e);
    }

    public Element newAnnotationDocument(String creationDate, String author, String version) {
        if (creationDate == null) {
            throw new RuntimeException("EAF");
        }
        if (author == null) {
            throw new RuntimeException("EAF");
        }
        if (version == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ANNOTATION_DOCUMENT");
        result.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        result.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.mpi.nl/tools/elan/EAFv2.6.xsd");
        result.setAttribute("DATE", creationDate);
        result.setAttribute("AUTHOR", author);
        result.setAttribute("VERSION", version);
        result.setAttribute("FORMAT", "2.6");
        return result;
    }

    public Element newHeader(String mediaFile, String timeUnits) {
        if (mediaFile == null) {
            throw new RuntimeException("EAF");
        }
        if (timeUnits == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("HEADER");
        result.setAttribute("MEDIA_FILE", mediaFile);
        result.setAttribute("TIME_UNITS", timeUnits);
        return result;
    }

    public Element newHeader(String mediaFile) {
        if (mediaFile == null) {
            throw new RuntimeException("EAF");
        }
        return this.newHeader(mediaFile, TIME_UNIT_MILLISEC);
    }

    public Element newMediaDescriptor(String mediaURL, String relMediaURL, String mimeType, String timeOrigin, String extractedFrom) {
        if (mediaURL == null) {
            throw new RuntimeException("EAF");
        }
        if (mimeType == null) {
            throw new RuntimeException("EAF");
        }
        Element mdElement = this.doc.createElement("MEDIA_DESCRIPTOR");
        mdElement.setAttribute("MEDIA_URL", mediaURL);
        mdElement.setAttribute("MIME_TYPE", mimeType);
        if (relMediaURL != null && relMediaURL.length() != 0) {
            mdElement.setAttribute("RELATIVE_MEDIA_URL", relMediaURL);
        }
        if (timeOrigin != null) {
            mdElement.setAttribute("TIME_ORIGIN", String.valueOf(timeOrigin));
        }
        if (extractedFrom != null) {
            mdElement.setAttribute("EXTRACTED_FROM", extractedFrom);
        }
        return mdElement;
    }

    public Element newLinkedFileDescriptor(String linkURL, String relLinkURL, String mimeType, String origin, String associatedWith) {
        if (linkURL == null) {
            throw new RuntimeException("EAF");
        }
        Element lfdElement = this.doc.createElement("LINKED_FILE_DESCRIPTOR");
        lfdElement.setAttribute("LINK_URL", linkURL);
        if (mimeType == null) {
            lfdElement.setAttribute("MIME_TYPE", "unknown");
        } else {
            lfdElement.setAttribute("MIME_TYPE", mimeType);
        }
        if (relLinkURL != null && relLinkURL.length() != 0) {
            lfdElement.setAttribute("RELATIVE_LINK_URL", relLinkURL);
        }
        if (origin != null) {
            lfdElement.setAttribute("TIME_ORIGIN", origin);
        }
        if (associatedWith != null) {
            lfdElement.setAttribute("ASSOCIATED_WITH", associatedWith);
        }
        return lfdElement;
    }

    public Element newProperty(String name, String value) {
        Element propElement = this.doc.createElement("PROPERTY");
        if (name != null && name.length() > 0) {
            propElement.setAttribute("NAME", name);
        }
        if (value != null && value.length() > 0) {
            propElement.appendChild(this.doc.createTextNode(value));
        }
        return propElement;
    }

    public Element newTimeOrder() {
        Element result = this.doc.createElement("TIME_ORDER");
        return result;
    }

    public Element newTimeSlot(String id, long time) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        result.setAttribute("TIME_VALUE", time + "");
        return result;
    }

    public Element newTimeSlot(String id) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        return result;
    }

    public Element newTier(String id, String participant, String annotator, String typeRef, Locale language, String parent) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        if (typeRef == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIER");
        result.setAttribute("TIER_ID", id);
        if (participant != null && participant.length() > 0) {
            result.setAttribute("PARTICIPANT", participant);
        }
        if (annotator != null && annotator.length() > 0) {
            result.setAttribute("ANNOTATOR", annotator);
        }
        result.setAttribute("LINGUISTIC_TYPE_REF", typeRef);
        if (language != null) {
            result.setAttribute("DEFAULT_LOCALE", language.getLanguage());
        }
        if (parent != null) {
            result.setAttribute("PARENT_REF", parent);
        }
        return result;
    }

    public Element newAnnotation() {
        Element result = this.doc.createElement("ANNOTATION");
        return result;
    }

    public Element newAlignableAnnotation(String id, String beginTimeSlot, String endTimeSlot, String svgId, String extRefId) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ALIGNABLE_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("TIME_SLOT_REF1", beginTimeSlot);
        result.setAttribute("TIME_SLOT_REF2", endTimeSlot);
        if (svgId != null) {
            result.setAttribute("SVG_REF", svgId);
        }
        if (extRefId != null) {
            result.setAttribute("EXT_REF", extRefId);
        }
        return result;
    }

    public Element newRefAnnotation(String id, String annotationRef, String previousAnnotation, String extRefId) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        if (annotationRef == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("REF_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("ANNOTATION_REF", annotationRef);
        if (previousAnnotation != null) {
            result.setAttribute("PREVIOUS_ANNOTATION", previousAnnotation);
        }
        if (extRefId != null) {
            result.setAttribute("EXT_REF", extRefId);
        }
        return result;
    }

    public Element newAnnotationValue(String value) {
        if (value == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ANNOTATION_VALUE");
        result.appendChild(this.doc.createTextNode(value));
        return result;
    }

    public Element newLinguisticType(String id, boolean timeAlignable, boolean graphicReferences, String constraint, String controlledVocabularyName, String extRefId) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LINGUISTIC_TYPE");
        result.setAttribute("LINGUISTIC_TYPE_ID", id);
        result.setAttribute("TIME_ALIGNABLE", timeAlignable ? "true" : "false");
        result.setAttribute("GRAPHIC_REFERENCES", graphicReferences ? "true" : "false");
        if (constraint != null) {
            result.setAttribute("CONSTRAINTS", constraint);
        }
        if (controlledVocabularyName != null) {
            result.setAttribute("CONTROLLED_VOCABULARY_REF", controlledVocabularyName);
        }
        if (extRefId != null) {
            result.setAttribute("EXT_REF", extRefId);
        }
        return result;
    }

    public Element newConstraint(String stereotype, String description) {
        if (stereotype == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CONSTRAINT");
        result.setAttribute("STEREOTYPE", stereotype);
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    public Element newLocale(Locale l) {
        if (l == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LOCALE");
        result.setAttribute("LANGUAGE_CODE", l.getLanguage());
        if (!l.getCountry().equals("")) {
            result.setAttribute("COUNTRY_CODE", l.getCountry());
        }
        if (!l.getVariant().equals("")) {
            result.setAttribute("VARIANT", l.getVariant());
        }
        return result;
    }

    public Element newControlledVocabulary(String conVocId, String description) {
        if (conVocId == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CONTROLLED_VOCABULARY");
        result.setAttribute("CV_ID", conVocId);
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    public Element newCVEntry(String value, String description, String extRef) {
        if (value == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CV_ENTRY");
        result.appendChild(this.doc.createTextNode(value));
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        if (extRef != null) {
            result.setAttribute("EXT_REF", extRef);
        }
        return result;
    }

    public Element newExternalReference(String id, String type, String value) {
        if (id == null || type == null || value == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("EXTERNAL_REF");
        result.setAttribute("EXT_REF_ID", id);
        result.setAttribute("TYPE", type);
        result.setAttribute("VALUE", value);
        return result;
    }

    public EAF26() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
    }
}

