/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF26;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF26Encoder
implements AnnotationDocEncoder,
ServerLogger {
    public static final String VERSION = "2.6";
    public static boolean debug = false;

    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path) throws IOException {
        Element documentElement = EAF26Encoder.createDOM(theTranscription, tierOrder);
        EAF26Encoder.save(documentElement, path);
    }

    public void encodeAsTemplateAndSave(Transcription theTranscription, List tierOrder, String path) throws IOException {
        Element documentElement = EAF26Encoder.createTemplateDOM(theTranscription, tierOrder);
        EAF26Encoder.save(documentElement, path);
    }

    public static Element createDOM(Transcription theTranscription, List tierOrder) {
        Vector lTypes;
        long beginTime = System.currentTimeMillis();
        if (debug) {
            System.out.println("Encoder creating DOM...");
        }
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<TimeSlot, String> timeSlotIds = new Hashtable<TimeSlot, String>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        HashMap<String, Object> extRefIds = new HashMap<String, Object>();
        ArrayList<String> extRefList = new ArrayList<String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF26 eafFactory = null;
        try {
            eafFactory = new EAF26();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF26Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        for (MediaDescriptor md : attisTr.getMediaDescriptors()) {
            String origin = null;
            if (md.timeOrigin != 0L) {
                origin = String.valueOf(md.timeOrigin);
            }
            String extrFrom = null;
            if (md.extractedFrom != null && md.extractedFrom != "") {
                extrFrom = md.extractedFrom;
            }
            Element mdElement = eafFactory.newMediaDescriptor(md.mediaURL, md.relativeMediaURL, md.mimeType, origin, extrFrom);
            header.appendChild(mdElement);
        }
        for (LinkedFileDescriptor lfd : attisTr.getLinkedFileDescriptors()) {
            String origin = null;
            if (lfd.timeOrigin != 0L) {
                origin = String.valueOf(lfd.timeOrigin);
            }
            Element lfdElement = eafFactory.newLinkedFileDescriptor(lfd.linkURL, lfd.relativeLinkURL, lfd.mimeType, origin, lfd.associatedWith);
            header.appendChild(lfdElement);
        }
        int lastUsedAnnId = 0;
        ArrayList props = attisTr.getDocProperties();
        if (props.size() > 0) {
            for (int i = 0; i < props.size(); ++i) {
                PropertyImpl prop = (PropertyImpl)props.get(i);
                if (prop == null || prop.getName() == null && prop.getValue() == null) continue;
                if (prop.getName().equals("lastUsedAnnotationId")) {
                    if (prop.getValue() == null) continue;
                    try {
                        lastUsedAnnId = Integer.parseInt((String)prop.getValue());
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Could not retrieve the last used annotation id.");
                    }
                    continue;
                }
                if (prop.getValue() != null) {
                    header.appendChild(eafFactory.newProperty(prop.getName(), prop.getValue().toString()));
                    continue;
                }
                header.appendChild(eafFactory.newProperty(prop.getName(), null));
            }
        }
        if (debug) {
            System.out.println("Header creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Enumeration tsElements = timeOrder.elements();
        while (tsElements.hasMoreElements()) {
            TimeSlot ts = (TimeSlot)tsElements.nextElement();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, tsId);
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        if (debug) {
            System.out.println("TimeSlots creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Vector storeOrder = new Vector(attisTr.getTiers());
        int svgIndex = 1;
        int extRefIndex = 1;
        int annIndex = lastUsedAnnId;
        for (TierImpl t : storeOrder) {
            Locale lang;
            String id = t.getName();
            String participant = (String)t.getMetadataValue("PARTICIPANT");
            String annotator = (String)t.getMetadataValue("ANNOTATOR");
            String lingType = t.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = t.getDefaultLocale()) != null && !usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (t.getParentTier() != null) {
                parentName = t.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, annotator, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(t.getName(), tierElement);
            Vector annotations = t.getAnnotations();
            for (Annotation ann : annotations) {
                if (ann.getId() != null && !ann.getId().equals("")) {
                    annotationIds.put(ann, ann.getId());
                    continue;
                }
                annotationIds.put(ann, "a" + ++annIndex);
            }
        }
        header.appendChild(eafFactory.newProperty("lastUsedAnnotationId", String.valueOf(annIndex)));
        for (TierImpl t : storeOrder) {
            Vector annotations = t.getAnnotations();
            for (Annotation ann : annotations) {
                String extRefId = null;
                if (ann instanceof AbstractAnnotation && ((AbstractAnnotation)ann).getExtRef() != null) {
                    if (!extRefIds.containsValue(((AbstractAnnotation)ann).getExtRef())) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put(extRefId, ((AbstractAnnotation)ann).getExtRef());
                        extRefList.add(extRefId);
                    } else {
                        for (int i = 0; i < extRefList.size(); ++i) {
                            if (!((AbstractAnnotation)ann).getExtRef().equals(extRefIds.get(extRefList.get(i)))) continue;
                            extRefId = (String)extRefList.get(i);
                            break;
                        }
                    }
                }
                Element annElement = eafFactory.newAnnotation();
                ((Element)tierElements.get(t.getName())).appendChild(annElement);
                Node annSubElement = null;
                String annId = (String)annotationIds.get(ann);
                if (ann instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getBegin());
                    String endTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getEnd());
                    if (ann instanceof SVGAlignableAnnotation) {
                        if (((SVGAlignableAnnotation)ann).getShape() != null) {
                            String svgId = "ga" + svgIndex;
                            ((SVGAlignableAnnotation)ann).setSVGElementID(svgId);
                            ++svgIndex;
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, svgId, extRefId);
                        } else {
                            ((SVGAlignableAnnotation)ann).setSVGElementID(null);
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null, extRefId);
                        }
                    } else {
                        annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null, extRefId);
                    }
                } else if (ann instanceof RefAnnotation) {
                    String refId = null;
                    String prevId = null;
                    Vector refs = ((RefAnnotation)ann).getReferences();
                    RefAnnotation prev = ((RefAnnotation)ann).getPrevious();
                    if (refs.size() > 0) {
                        refId = (String)annotationIds.get((Annotation)refs.firstElement());
                    }
                    if (prev != null) {
                        prevId = (String)annotationIds.get(prev);
                    }
                    annSubElement = eafFactory.newRefAnnotation(annId, refId, prevId, extRefId);
                }
                annElement.appendChild(annSubElement);
                Element valueElement = eafFactory.newAnnotationValue(ann.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        if (debug) {
            System.out.println("Tiers and Annotations creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((lTypes = attisTr.getLinguisticTypes()) != null) {
            for (LinguisticType lt : lTypes) {
                String extRefId = null;
                if (lt.getDataCategory() != null && lt.getDataCategory().length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(lt.getDataCategory(), 2);
                    if (!extRefIds.containsValue(eri)) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put(extRefId, eri);
                        extRefList.add(extRefId);
                    } else {
                        for (int i = 0; i < extRefList.size(); ++i) {
                            if (!eri.equals(extRefIds.get(extRefList.get(i)))) continue;
                            extRefId = (String)extRefList.get(i);
                            break;
                        }
                    }
                }
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype, lt.getControlledVocabylaryName(), extRefId);
                annotDocument.appendChild(typeElement);
            }
        }
        if (debug) {
            System.out.println("Linguistic Types creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        Vector conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            String extRefId = null;
            for (int i = 0; i < conVocs.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)conVocs.get(i);
                Element cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    if (entry.getExternalRef() != null) {
                        if (entry.getExternalRef() instanceof String && ((String)entry.getExternalRef()).length() == 0) {
                            extRefId = null;
                        } else if (!extRefIds.containsValue(entry.getExternalRef())) {
                            extRefId = "er" + extRefIndex++;
                            extRefIds.put(extRefId, entry.getExternalRef());
                            extRefList.add(extRefId);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId = null;
                    }
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription(), extRefId);
                    cvElement.appendChild(entryElement);
                }
                annotDocument.appendChild(cvElement);
            }
        }
        if (debug) {
            System.out.println("Constraints and CV's creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        String type = "iso12620";
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = eafFactory.newExternalReference(id, type, eri.getValue());
            annotDocument.appendChild(erElement);
        }
        return eafFactory.getDocumentElement();
    }

    public static Element createTemplateDOM(Transcription theTranscription, List tierOrder) {
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        HashMap<String, Object> extRefIds = new HashMap<String, Object>();
        ArrayList<String> extRefList = new ArrayList<String>();
        int extRefIndex = 1;
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF26 eafFactory = null;
        try {
            eafFactory = new EAF26();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF26Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        author = "";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        Vector storeOrder = new Vector(attisTr.getTiers());
        for (TierImpl t : storeOrder) {
            Locale lang;
            String id = t.getName();
            String participant = (String)t.getMetadataValue("PARTICIPANT");
            String annotator = (String)t.getMetadataValue("ANNOTATOR");
            String lingType = t.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = t.getDefaultLocale()) != null && !usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (t.getParentTier() != null) {
                parentName = t.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, annotator, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(t.getName(), tierElement);
        }
        Vector lTypes = attisTr.getLinguisticTypes();
        if (lTypes != null) {
            for (LinguisticType lt : lTypes) {
                String extRefId = null;
                if (lt.getDataCategory() != null && lt.getDataCategory().length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(lt.getDataCategory(), 2);
                    if (!extRefIds.containsValue(eri)) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put(extRefId, eri);
                        extRefList.add(extRefId);
                    } else {
                        for (int i = 0; i < extRefList.size(); ++i) {
                            if (!eri.equals(extRefIds.get(extRefList.get(i)))) continue;
                            extRefId = (String)extRefList.get(i);
                            break;
                        }
                    }
                }
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype, lt.getControlledVocabylaryName(), extRefId);
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        Vector conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            String extRefId = null;
            for (int i = 0; i < conVocs.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)conVocs.get(i);
                Element cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    if (entry.getExternalRef() != null) {
                        if (entry.getExternalRef() instanceof String && ((String)entry.getExternalRef()).length() == 0) {
                            extRefId = null;
                        } else if (!extRefIds.containsValue(entry.getExternalRef())) {
                            extRefId = "er" + extRefIndex++;
                            extRefIds.put(extRefId, entry.getExternalRef());
                            extRefList.add(extRefId);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId = null;
                    }
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription(), extRefId);
                    cvElement.appendChild(entryElement);
                }
                annotDocument.appendChild(cvElement);
            }
        }
        String type = "iso12620";
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = eafFactory.newExternalReference(id, type, eri.getValue());
            annotDocument.appendChild(erElement);
        }
        return eafFactory.getDocumentElement();
    }

    private static String correctDate(String strIn) {
        String strResult = new String(strIn);
        try {
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            String strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = strOffset + "0";
            }
            strOffset = strOffset + offsetGMT + ":00";
            int indexSpace = (strResult = strResult + strOffset).indexOf(" ");
            if (indexSpace != -1) {
                String strEnd = strResult.substring(indexSpace + 1);
                strResult = strResult.substring(0, indexSpace);
                strResult = strResult + "T";
                strResult = strResult + strEnd;
            }
            strResult = strResult.replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }

    private static void save(Element documentElement, String path) throws IOException {
        LOG.info(path + " <----XML output\n");
        try {
            if (("" + documentElement).length() == 0) {
                throw new IOException("Unable to save this file (zero length).");
            }
            long beginTime = System.currentTimeMillis();
            IoUtil.writeEncodedEAFFile("UTF-8", path, documentElement);
            if (debug) {
                System.out.println("Saving file took: " + (System.currentTimeMillis() - beginTime) + " ms");
            }
        }
        catch (Exception eee) {
            throw new IOException("Unable to save this file: " + eee.getMessage());
        }
    }
}

