/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EAFSkeletonParser {
    private XMLReader reader;
    private final String version = "2.7";
    private String fileName;
    private final HashMap tierMap = new HashMap();
    private ArrayList tiers;
    private ArrayList tierOrder = new ArrayList();
    private final ArrayList lingTypeRecords = new ArrayList();
    private ArrayList linguisticTypes;
    private final ArrayList locales = new ArrayList();
    private final ArrayList cvList = new ArrayList();
    private final HashMap extReferences = new HashMap();
    private final HashMap cvEntryExtRef = new HashMap();
    private String currentTierId;
    private String currentCVId;
    private ControlledVocabulary currentCV;
    private String currentEntryDesc;
    private String currentEntryExtRef;
    private String content = "";

    public EAFSkeletonParser(String fileName) throws ParseException {
        this(fileName, false);
    }

    public EAFSkeletonParser(String fileName, boolean strict) throws ParseException {
        if (fileName == null) {
            throw new NullPointerException();
        }
        this.fileName = fileName;
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResource(ACMTranscriptionStore.getCurrentEAFSchemaLocal()).openStream());
            this.reader.setContentHandler(new EAFSkeletonHandler());
            if (strict) {
                this.reader.setErrorHandler(new EAFErrorHandler());
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new ParseException(se.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new ParseException(ioe.getMessage());
        }
    }

    public ArrayList getLinguisticTypes() {
        return this.linguisticTypes;
    }

    public ArrayList getTiers() {
        return this.tiers;
    }

    public ArrayList getTierOrder() {
        return this.tierOrder;
    }

    public ArrayList getControlledVocabularies() {
        return this.cvList;
    }

    public String getVersion() {
        return "2.7";
    }

    public void parse() throws ParseException {
        block8: {
            try {
                this.reader.parse(this.fileName);
                this.createObjects();
            }
            catch (SAXException sax) {
                System.out.println("Parsing error: " + sax.getMessage());
                File f = new File(this.fileName);
                if (!f.exists()) break block8;
                try {
                    FileInputStream fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.reader.parse(source);
                    this.createObjects();
                }
                catch (Exception ee) {
                    System.out.println("Parsing retry error: " + ee.getMessage());
                    throw new ParseException(ee.getMessage(), ee.getCause());
                }
            }
            catch (IOException ioe) {
                System.out.println("IO error: " + ioe.getMessage());
                File f = new File(this.fileName);
                if (!f.exists()) break block8;
                try {
                    FileInputStream fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.reader.parse(source);
                    this.createObjects();
                }
                catch (Exception ee) {
                    System.out.println("Parsing retry error: " + ee.getMessage());
                    throw new ParseException(ee.getMessage(), ee.getCause());
                }
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage(), e.getCause());
            }
        }
    }

    private void createObjects() {
        this.linguisticTypes = new ArrayList(this.lingTypeRecords.size());
        for (int i = 0; i < this.lingTypeRecords.size(); ++i) {
            ExternalReferenceImpl eri;
            LingTypeRecord ltr = (LingTypeRecord)this.lingTypeRecords.get(i);
            LinguisticType lt = new LinguisticType(ltr.getLingTypeId());
            boolean timeAlignable = true;
            if (ltr.getTimeAlignable().equals("false")) {
                timeAlignable = false;
            }
            lt.setTimeAlignable(timeAlignable);
            boolean graphicReferences = false;
            if (ltr.getGraphicReferences().equals("true")) {
                graphicReferences = true;
            }
            lt.setGraphicReferences(graphicReferences);
            String stereotype = ltr.getStereoType();
            ConstraintImpl c = null;
            if (stereotype != null) {
                if ((stereotype = stereotype.replace('_', ' ')).equals(Constraint.stereoTypes[0])) {
                    c = new TimeSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[3])) {
                    c = new SymbolicSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[4])) {
                    c = new SymbolicAssociation();
                } else if (stereotype.equals(Constraint.stereoTypes[1])) {
                    c = new IncludedIn();
                }
            }
            if (c != null) {
                lt.addConstraint(c);
            }
            lt.setControlledVocabularyName(ltr.getControlledVocabulary());
            if (ltr.getExtRefId() != null && (eri = (ExternalReferenceImpl)this.extReferences.get(ltr.getExtRefId())) != null) {
                lt.setDataCategory(eri.getValue());
            }
            this.linguisticTypes.add(lt);
        }
        this.tiers = new ArrayList(this.tierMap.size());
        HashMap<TierImpl, String> parentHash = new HashMap<TierImpl, String>();
        Iterator tierIt = this.tierMap.values().iterator();
        while (tierIt.hasNext()) {
            TierImpl tier = null;
            LinguisticType type = null;
            TierRecord rec = (TierRecord)tierIt.next();
            tier = new TierImpl(null, rec.getName(), rec.getParticipant(), null, null);
            for (LinguisticType lt : this.linguisticTypes) {
                if (!lt.getLinguisticTypeName().equals(rec.getLinguisticType())) continue;
                type = lt;
                break;
            }
            if (type == null) continue;
            tier.setLinguisticType(type);
            if (rec.getDefaultLocale() == null) {
                tier.setDefaultLocale(new Locale("en", "", ""));
            } else {
                for (Locale loc : this.locales) {
                    if (!loc.getLanguage().equals(rec.getDefaultLocale())) continue;
                    tier.setDefaultLocale(loc);
                    break;
                }
            }
            if (rec.getParentTier() != null) {
                parentHash.put(tier, rec.getParentTier());
            }
            if (rec.getAnnotator() != null) {
                tier.setAnnotator(rec.getAnnotator());
            }
            this.tiers.add(tier);
        }
        block6: for (TierImpl t : parentHash.keySet()) {
            String parent = (String)parentHash.get(t);
            for (TierImpl pt : this.tiers) {
                if (!pt.getName().equals(parent)) continue;
                t.setParentTier(pt);
                continue block6;
            }
        }
        if (this.cvEntryExtRef.size() > 0) {
            for (CVEntry entry : this.cvEntryExtRef.keySet()) {
                String erId = (String)this.cvEntryExtRef.get(entry);
                ExternalReferenceImpl eri = (ExternalReferenceImpl)this.extReferences.get(erId);
                if (eri == null) continue;
                try {
                    entry.setExternalRef(eri.clone());
                }
                catch (CloneNotSupportedException cnse) {
                    System.out.println("Could not set the external reference: " + cnse.getMessage());
                }
            }
        }
    }

    class EAFSkeletonHandler
    implements ContentHandler {
        EAFSkeletonHandler() {
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            EAFSkeletonParser.this.content = EAFSkeletonParser.this.content + new String(ch, start, end);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAFSkeletonParser.this.content = "";
            if (name.equals("TIER")) {
                EAFSkeletonParser.this.currentTierId = attributes.getValue("TIER_ID");
                if (!EAFSkeletonParser.this.tierMap.containsKey(EAFSkeletonParser.this.currentTierId)) {
                    TierRecord tr = new TierRecord();
                    tr.setName(EAFSkeletonParser.this.currentTierId);
                    EAFSkeletonParser.this.tierMap.put(EAFSkeletonParser.this.currentTierId, tr);
                    EAFSkeletonParser.this.tierOrder.add(EAFSkeletonParser.this.currentTierId);
                    tr.setParticipant(attributes.getValue("PARTICIPANT"));
                    tr.setAnnotator(attributes.getValue("ANNOTATOR"));
                    tr.setLinguisticType(attributes.getValue("LINGUISTIC_TYPE_REF"));
                    tr.setDefaultLocale(attributes.getValue("DEFAULT_LOCALE"));
                    tr.setParentTier(attributes.getValue("PARENT_REF"));
                }
            } else if (name.equals("LINGUISTIC_TYPE")) {
                LingTypeRecord ltr = new LingTypeRecord();
                ltr.setLingTypeId(attributes.getValue("LINGUISTIC_TYPE_ID"));
                String timeAlignable = "true";
                if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                    timeAlignable = "false";
                }
                ltr.setTimeAlignable(timeAlignable);
                String graphicReferences = "false";
                if (attributes.getValue("GRAPHIC_REFERENCES") != null && attributes.getValue("GRAPHIC_REFERENCES").equals("true")) {
                    graphicReferences = "true";
                }
                ltr.setGraphicReferences(graphicReferences);
                String stereotype = attributes.getValue("CONSTRAINTS");
                ltr.setStereoType(stereotype);
                if (stereotype != null && stereotype.startsWith("Symbolic")) {
                    ltr.setTimeAlignable("false");
                }
                ltr.setControlledVocabulary(attributes.getValue("CONTROLLED_VOCABULARY_REF"));
                ltr.setExtRefId(attributes.getValue("EXT_REF"));
                ltr.setLexiconReference(attributes.getValue("LEXICON_REF"));
                EAFSkeletonParser.this.lingTypeRecords.add(ltr);
            } else if (name.equals("LOCALE")) {
                String variant;
                String langCode = attributes.getValue("LANGUAGE_CODE");
                String countryCode = attributes.getValue("COUNTRY_CODE");
                if (countryCode == null) {
                    countryCode = "";
                }
                if ((variant = attributes.getValue("VARIANT")) == null) {
                    variant = "";
                }
                Locale l = new Locale(langCode, countryCode, variant);
                EAFSkeletonParser.this.locales.add(l);
            } else if (name.equals("CONTROLLED_VOCABULARY")) {
                String extRefId;
                EAFSkeletonParser.this.currentCVId = attributes.getValue("CV_ID");
                EAFSkeletonParser.this.currentCV = new ControlledVocabulary(EAFSkeletonParser.this.currentCVId);
                String desc = attributes.getValue("DESCRIPTION");
                if (desc != null) {
                    EAFSkeletonParser.this.currentCV.setDescription(desc);
                }
                if ((extRefId = attributes.getValue("EXT_REF")) != null) {
                    EAFSkeletonParser.this.currentCV = new ExternalCV(EAFSkeletonParser.this.currentCV);
                    ExternalReferenceImpl eri = (ExternalReferenceImpl)EAFSkeletonParser.this.extReferences.get(extRefId);
                    if (eri != null) {
                        try {
                            ((ExternalCV)EAFSkeletonParser.this.currentCV).setExternalRef(eri.clone());
                        }
                        catch (CloneNotSupportedException cnse) {
                            // empty catch block
                        }
                    }
                }
                EAFSkeletonParser.this.cvList.add(EAFSkeletonParser.this.currentCV);
            } else if (name.equals("CV_ENTRY")) {
                EAFSkeletonParser.this.currentEntryDesc = attributes.getValue("DESCRIPTION");
                EAFSkeletonParser.this.currentEntryExtRef = attributes.getValue("EXT_REF");
            } else if (name.equals("EXTERNAL_REF")) {
                String value = attributes.getValue("VALUE");
                String type = attributes.getValue("TYPE");
                String dcId = attributes.getValue("EXT_REF_ID");
                if (value != null && value.length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(value, 0);
                    if (type != null) {
                        if (type.equals("iso12620")) {
                            eri.setReferenceType(2);
                        } else if (type.equals("resource_url")) {
                            eri.setReferenceType(3);
                        } else if (type.equals("ecv")) {
                            eri.setReferenceType(4);
                        } else if (type.equals("cve_id")) {
                            eri.setReferenceType(5);
                        } else if (type.equals("lexen_id")) {
                            eri.setReferenceType(6);
                        }
                    }
                    EAFSkeletonParser.this.extReferences.put(dcId, eri);
                }
            }
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("CV_ENTRY")) {
                CVEntry entry = new CVEntry(EAFSkeletonParser.this.content, EAFSkeletonParser.this.currentEntryDesc);
                EAFSkeletonParser.this.currentCV.addEntry(entry);
                if (EAFSkeletonParser.this.currentEntryExtRef != null) {
                    EAFSkeletonParser.this.cvEntryExtRef.put(entry, EAFSkeletonParser.this.currentEntryExtRef);
                }
            }
        }
    }

    class EAFErrorHandler
    implements ErrorHandler {
        EAFErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("System id: " + exception.getSystemId());
            System.out.println("Public id: " + exception.getPublicId());
            System.out.println("Line: " + exception.getLineNumber());
            System.out.println("Column: " + exception.getColumnNumber());
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }
}

