/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.flex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import mpi.eudico.server.corpora.clomimpl.flex.ContainerElem;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.flex.Item;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FlexParser
extends Parser {
    private boolean parsed = false;
    private XMLReader reader;
    private ContainerElem topElement;
    private List<String> languages;
    private FlexDecoderInfo decoder;
    private final HashMap<String, TierRecord> tierMap = new HashMap();
    private HashMap<String, LingTypeRecord> lingTypeRecords = new HashMap();
    private TreeSet<String> tierNameSet = new TreeSet();
    private ArrayList<long[]> timeOrder = new ArrayList();
    private ArrayList<long[]> timeSlots = new ArrayList();
    private ArrayList<AnnotationRecord> annotationRecords = new ArrayList();
    private HashMap<AnnotationRecord, String> annotRecordToTierMap = new HashMap();
    private HashMap<String, ArrayList<AnnotationRecord>> tierNameToAnnRecordMap = new HashMap();
    private HashMap<String, String> parentPerLevel = new HashMap(8);
    private HashMap<String, LinkedHashSet<String>> typeLangPerLevel = new HashMap(8);
    private List<String> unitLevels;
    private HashMap<String, String> guidIdMap = new HashMap();
    private int parCount = 0;
    private int phraseCount = 0;
    private int wordCount = 0;
    private int morphCount = 0;
    private int itDur = 0;
    private int parDur = 0;
    private int phraseDur = 0;
    private int wordDur = 0;
    private int morphDur = 0;
    private int unitDur = 1;
    private int annotId = 1;
    private int tsId = 1;
    private static final String ANN_ID_PREFIX = "ann";
    private static final String TS_ID_PREFIX = "ts";
    private final String DEL = "-";

    public FlexParser() {
        this.unitLevels = new ArrayList<String>(5);
        this.unitLevels.add("morph");
        this.unitLevels.add("word");
        this.unitLevels.add("phrase");
        this.unitLevels.add("paragraph");
        this.unitLevels.add("interlinear-text");
        this.languages = new ArrayList<String>(5);
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setContentHandler(new FlexContentHandler());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof FlexDecoderInfo) {
            this.decoder = (FlexDecoderInfo)decoderInfo;
            if (!this.decoder.totalDurationSpecified) {
                this.calculateDurations();
            }
            if (this.decoder.smallestWithTimeAlignment == "interlinear-text" && !this.decoder.inclITElement) {
                this.decoder.smallestWithTimeAlignment = this.decoder.inclParagraphElement ? "paragraph" : "phrase";
            }
            if (this.decoder.smallestWithTimeAlignment == "paragraph" && !this.decoder.inclParagraphElement) {
                this.decoder.smallestWithTimeAlignment = "phrase";
            }
        }
    }

    public ArrayList getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> records = this.tierNameToAnnRecordMap.get(tierName);
        if (records == null) {
            records = new ArrayList(0);
        }
        return records;
    }

    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getLinguisticType();
        }
        return null;
    }

    public ArrayList getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return new ArrayList<LingTypeRecord>(this.lingTypeRecords.values());
    }

    public ArrayList getMediaDescriptors(String fileName) {
        this.parse(fileName);
        if (this.decoder.getMediaDescriptors() instanceof ArrayList) {
            return (ArrayList)this.decoder.getMediaDescriptors();
        }
        if (this.decoder.getMediaDescriptors() != null) {
            return new ArrayList<MediaDescriptor>(this.decoder.getMediaDescriptors());
        }
        return new ArrayList(0);
    }

    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getParentTier();
        }
        return null;
    }

    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    public ArrayList getTierNames(String fileName) {
        this.parse(fileName);
        return new ArrayList<String>(this.tierNameSet);
    }

    public ArrayList getTimeOrder(String fileName) {
        this.parse(fileName);
        ArrayList<String> resultTimeOrder = new ArrayList<String>();
        for (int i = 0; i < this.timeOrder.size(); ++i) {
            resultTimeOrder.add(TS_ID_PREFIX + this.timeOrder.get(i)[0]);
        }
        return resultTimeOrder;
    }

    public HashMap getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> resultSlots = new HashMap<String, String>();
        for (long[] timeSlot : this.timeSlots) {
            String tsId = TS_ID_PREFIX + timeSlot[0];
            String timeValue = Long.toString(timeSlot[1]);
            resultSlots.put(tsId, timeValue);
        }
        return resultSlots;
    }

    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null && tr.getDefaultLocale() != null) {
            return new Locale(tr.getDefaultLocale());
        }
        return new Locale("en");
    }

    private void parse(String fileName) {
        if (this.parsed) {
            return;
        }
        if (this.decoder == null) {
            this.setDecoderInfo(new FlexDecoderInfo());
        }
        this.languages.clear();
        this.topElement = null;
        this.parentPerLevel.clear();
        try {
            this.reader.parse(fileName);
            this.parsed = true;
            this.createLingTypes();
            if (this.decoder.totalDurationSpecified) {
                this.calculateDurations();
                this.updateElementTimes(this.topElement);
            }
            if (this.decoder.getStoredAlignment() != null) {
                this.restoreAlignment(this.topElement);
                this.resolveAlignmentConflicts(this.topElement);
            }
            this.checkParentPerLevel();
            this.preprocessRecords(this.topElement);
            this.createRecords();
        }
        catch (SAXException e) {
            System.out.println("Parsing error: " + e.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("IO error: " + ioe.getMessage());
        }
    }

    private void checkParentPerLevel() {
        for (String key : this.typeLangPerLevel.keySet()) {
            String first = null;
            String txtstart = key + "-" + "txt";
            LinkedHashSet<String> values = this.typeLangPerLevel.get(key);
            boolean found = false;
            int count = 0;
            for (String combi : values) {
                if (count == 0) {
                    first = combi;
                    ++count;
                }
                if (!combi.startsWith(txtstart)) continue;
                this.parentPerLevel.put(key, combi);
                found = true;
                break;
            }
            if (found) continue;
            this.parentPerLevel.put(key, first);
        }
        if (!this.parentPerLevel.containsKey("interlinear-text")) {
            this.parentPerLevel.put("interlinear-text", "interlinear-text");
        }
        if (!this.parentPerLevel.containsKey("paragraph")) {
            this.parentPerLevel.put("paragraph", "paragraph");
        }
        if (!this.parentPerLevel.containsKey("phrase")) {
            this.parentPerLevel.put("phrase", "phrase");
        }
        if (!this.parentPerLevel.containsKey("word")) {
            this.parentPerLevel.put("word", "word");
        }
        if (!this.parentPerLevel.containsKey("morph")) {
            this.parentPerLevel.put("morph", "morph");
        }
    }

    private void preprocessRecords(ContainerElem elem) {
        if (elem == null) {
            return;
        }
        boolean parentFound = false;
        if (elem.getItems() != null && elem.getItems().size() != 0) {
            for (int i = 0; i < elem.getItems().size(); ++i) {
                Item item = elem.getItems().get(i);
                if (item.tierName == null || !item.tierName.equals(this.parentPerLevel.get(elem.flexType))) continue;
                parentFound = true;
                if (i == 0) break;
                elem.getItems().add(0, elem.getItems().remove(i));
                break;
            }
            if (!parentFound) {
                Item empty = new Item();
                empty.tierName = this.parentPerLevel.get(elem.flexType);
                elem.getItems().add(0, empty);
            }
        } else {
            String ppl = this.parentPerLevel.get(elem.flexType);
            if (ppl == null) {
                ppl = elem.flexType;
                this.parentPerLevel.put(elem.flexType, ppl);
            }
            Item empty = new Item();
            empty.tierName = ppl;
            elem.addItem(empty);
        }
        if (elem.getChildElems() != null && elem.getChildElems().size() > 0) {
            for (ContainerElem celem : elem.getChildElems()) {
                this.preprocessRecords(celem);
            }
        }
    }

    private void createRecords() {
        if (this.topElement == null) {
            return;
        }
        AnnotationRecord par = null;
        String topLevelTierName = null;
        if (this.decoder.inclITElement) {
            par = null;
            if (this.topElement.getItems() != null && this.topElement.getItems().size() > 0) {
                for (int i = 0; i < this.topElement.getItems().size(); ++i) {
                    Item item = this.topElement.getItems().get(i);
                    String tName = item.tierName;
                    this.tierNameSet.add(tName);
                    TierRecord tr = new TierRecord();
                    tr.setName(tName);
                    tr.setDefaultLocale(item.lang);
                    this.tierMap.put(tName, tr);
                    if (i == 0) {
                        tr.setLinguisticType("txt");
                        topLevelTierName = tName;
                        par = this.createAnnotationRecord(tName, null, null, this.topElement.bt, this.topElement.et);
                        par.setValue(item.value);
                        if (this.topElement.id == null) continue;
                        this.guidIdMap.put(this.topElement.id, par.getAnnotationId());
                        par.setAnnotationId("a_" + this.topElement.id);
                        continue;
                    }
                    tr.setLinguisticType("gloss");
                    tr.setParentTier(topLevelTierName);
                    AnnotationRecord child = this.createRefAnnotationRecord(tName, par, null);
                    child.setValue(item.value);
                }
            } else {
                this.tierNameSet.add("interlinear-text");
                TierRecord tr = new TierRecord();
                tr.setLinguisticType("txt");
                tr.setName("interlinear-text");
                this.tierMap.put("interlinear-text", tr);
                par = this.createAnnotationRecord("interlinear-text", null, null, this.topElement.bt, this.topElement.et);
            }
            this.createChildRecords(this.topElement, par);
        } else {
            List<ContainerElem> childElems = this.topElement.getChildElems();
            if (childElems != null && childElems.size() > 0) {
                par = null;
                for (int i = 0; i < childElems.size(); ++i) {
                    String tName;
                    ContainerElem elem = childElems.get(i);
                    if (elem.getItems() != null && elem.getItems().size() > 0) {
                        for (int j = 0; j < elem.getItems().size(); ++j) {
                            Item item = elem.getItems().get(j);
                            tName = item.tierName;
                            this.tierNameSet.add(tName);
                            if (this.tierMap.get(tName) == null) {
                                TierRecord tr = new TierRecord();
                                tr.setName(tName);
                                tr.setDefaultLocale(item.lang);
                                this.tierMap.put(tName, tr);
                                if (j == 0) {
                                    tr.setLinguisticType("txt");
                                } else {
                                    tr.setLinguisticType("gloss");
                                    tr.setParentTier(topLevelTierName);
                                }
                            }
                            if (j == 0) {
                                topLevelTierName = tName;
                                par = this.createAnnotationRecord(tName, null, null, elem.bt, elem.et);
                                par.setValue(item.value);
                                if (elem.id == null) continue;
                                this.guidIdMap.put(elem.id, par.getAnnotationId());
                                par.setAnnotationId("a_" + elem.id);
                                continue;
                            }
                            AnnotationRecord child = this.createRefAnnotationRecord(tName, par, null);
                            child.setValue(item.value);
                        }
                    } else {
                        tName = elem.flexType;
                        this.tierNameSet.add(tName);
                        if (this.tierMap.get(tName) == null) {
                            TierRecord tr = new TierRecord();
                            tr.setLinguisticType("txt");
                            tr.setName(tName);
                            this.tierMap.put(tName, tr);
                        }
                        par = this.createAnnotationRecord(tName, null, null, elem.bt, elem.et);
                        if (elem.id != null) {
                            this.guidIdMap.put(elem.id, par.getAnnotationId());
                            par.setAnnotationId("a_" + elem.id);
                        }
                    }
                    this.createChildRecords(elem, par);
                }
            }
        }
    }

    private void createChildRecords(ContainerElem parElem, AnnotationRecord parentAnn) {
        if (parElem.getChildElems() == null || parElem.getChildElems().size() == 0) {
            return;
        }
        AnnotationRecord nextPar = null;
        AnnotationRecord prevAnn = null;
        String firstItemTierName = null;
        boolean recordCreated = false;
        for (int i = 0; i < parElem.getChildElems().size(); ++i) {
            TierRecord tr;
            ContainerElem elem = parElem.getChildElems().get(i);
            if (elem.getItems() != null && elem.getItems().size() > 0) {
                for (int j = 0; j < elem.getItems().size(); ++j) {
                    recordCreated = false;
                    Item item = elem.getItems().get(j);
                    String tName = item.tierName;
                    if (j == 0) {
                        firstItemTierName = tName;
                        if (!this.tierNameSet.contains(tName)) {
                            this.tierNameSet.add(tName);
                            tr = new TierRecord();
                            tr.setLinguisticType(elem.flexType);
                            tr.setName(tName);
                            tr.setParentTier(this.annotRecordToTierMap.get(parentAnn));
                            this.tierMap.put(tName, tr);
                        }
                        if (this.isAlignable(elem.flexType)) {
                            nextPar = this.createAnnotationRecord(tName, parentAnn, prevAnn, elem.bt, elem.et);
                            if (elem.id != null) {
                                this.guidIdMap.put(elem.id, nextPar.getAnnotationId());
                                nextPar.setAnnotationId("a_" + elem.id);
                            }
                        } else {
                            nextPar = this.createRefAnnotationRecord(tName, parentAnn, prevAnn);
                        }
                        nextPar.setValue(item.value);
                        recordCreated = true;
                        prevAnn = nextPar;
                        continue;
                    }
                    if (!this.tierNameSet.contains(tName)) {
                        this.tierNameSet.add(tName);
                        tr = new TierRecord();
                        tr.setName(tName);
                        tr.setDefaultLocale(item.lang);
                        tr.setLinguisticType("gloss");
                        tr.setParentTier(firstItemTierName);
                        this.tierMap.put(tName, tr);
                    }
                    AnnotationRecord child = this.createRefAnnotationRecord(tName, nextPar, null);
                    child.setValue(item.value);
                }
            } else {
                String nextTierName;
                if (!this.parentPerLevel.containsKey(elem.flexType)) {
                    // empty if block
                }
                if (!this.tierNameSet.contains(nextTierName = this.parentPerLevel.get(elem.flexType))) {
                    this.tierNameSet.add(nextTierName);
                    tr = new TierRecord();
                    tr.setLinguisticType(elem.flexType);
                    tr.setName(nextTierName);
                    tr.setParentTier(this.annotRecordToTierMap.get(parentAnn));
                    this.tierMap.put(nextTierName, tr);
                }
                if (this.isAlignable(elem.flexType)) {
                    nextPar = this.createAnnotationRecord(nextTierName, parentAnn, prevAnn, elem.bt, elem.et);
                    if (elem.id != null) {
                        this.guidIdMap.put(elem.id, nextPar.getAnnotationId());
                        nextPar.setAnnotationId("a_" + elem.id);
                    }
                } else {
                    nextPar = this.createRefAnnotationRecord(nextTierName, parentAnn, prevAnn);
                }
                prevAnn = nextPar;
            }
            if (nextPar == null) continue;
            this.createChildRecords(elem, nextPar);
        }
    }

    private int getIndexOfPreferredTopLevelItem() {
        return 0;
    }

    private void createLingTypes() {
        LingTypeRecord lt = new LingTypeRecord();
        lt.setLingTypeId("txt");
        lt.setTimeAlignable("true");
        lt.setGraphicReferences("false");
        lt.setStereoType(null);
        this.lingTypeRecords.put("txt", lt);
        if (this.decoder.inclParagraphElement) {
            lt = new LingTypeRecord();
            lt.setLingTypeId("paragraph");
            if (this.isAlignable("paragraph")) {
                lt.setTimeAlignable("true");
                if (this.decoder.inclITElement) {
                    lt.setStereoType(Constraint.stereoTypes[0]);
                } else {
                    lt.setStereoType(null);
                }
            } else {
                lt.setTimeAlignable("false");
                lt.setStereoType(Constraint.stereoTypes[3]);
            }
            lt.setGraphicReferences("false");
            this.lingTypeRecords.put("paragraph", lt);
        }
        lt = new LingTypeRecord();
        lt.setLingTypeId("phrase");
        lt.setGraphicReferences("false");
        if (this.isAlignable("phrase")) {
            lt.setTimeAlignable("true");
            if (!this.decoder.inclITElement && !this.decoder.inclParagraphElement) {
                lt.setStereoType(null);
            } else {
                lt.setStereoType(Constraint.stereoTypes[0]);
            }
        } else {
            lt.setTimeAlignable("false");
            lt.setStereoType(Constraint.stereoTypes[3]);
        }
        this.lingTypeRecords.put("phrase", lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId("word");
        lt.setGraphicReferences("false");
        if (this.isAlignable("word")) {
            lt.setTimeAlignable("true");
            lt.setStereoType(Constraint.stereoTypes[0]);
        } else {
            lt.setTimeAlignable("false");
            lt.setStereoType(Constraint.stereoTypes[3]);
        }
        this.lingTypeRecords.put("word", lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId("morph");
        lt.setGraphicReferences("false");
        if (this.isAlignable("morph")) {
            lt.setTimeAlignable("true");
            lt.setStereoType(Constraint.stereoTypes[0]);
        } else {
            lt.setTimeAlignable("false");
            lt.setStereoType(Constraint.stereoTypes[3]);
        }
        this.lingTypeRecords.put("morph", lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId("gloss");
        lt.setGraphicReferences("false");
        lt.setTimeAlignable("false");
        lt.setStereoType(Constraint.stereoTypes[4]);
        this.lingTypeRecords.put("gloss", lt);
    }

    private AnnotationRecord createAnnotationRecord(String tierName, AnnotationRecord par, AnnotationRecord prev, long bt, long et) {
        AnnotationRecord ar = new AnnotationRecord();
        ar.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        ar.setAnnotationType("alignable");
        if (par != null) {
            if (prev != null) {
                String oldEndTSId = prev.getEndTimeSlotId();
                ar.setEndTimeSlotId(prev.getEndTimeSlotId());
                int beginTSId = this.tsId++;
                String nextId = TS_ID_PREFIX + beginTSId;
                ar.setBeginTimeSlotId(nextId);
                prev.setEndTimeSlotId(nextId);
                this.updateAnnRecordEndTS(oldEndTSId, nextId, prev.getAnnotationId());
                long[] ts = new long[]{beginTSId, bt};
                this.timeSlots.add(ts);
                this.timeOrder.add(ts);
            } else {
                ar.setBeginTimeSlotId(par.getBeginTimeSlotId());
                ar.setEndTimeSlotId(par.getEndTimeSlotId());
            }
        } else {
            int beginTSId = this.tsId++;
            int endTSId = this.tsId++;
            ar.setBeginTimeSlotId(TS_ID_PREFIX + beginTSId);
            ar.setEndTimeSlotId(TS_ID_PREFIX + endTSId);
            long[] begin = new long[]{beginTSId, bt};
            long[] end = new long[]{endTSId, et};
            this.timeSlots.add(begin);
            this.timeSlots.add(end);
            this.timeOrder.add(begin);
            this.timeOrder.add(end);
        }
        this.annotationRecords.add(ar);
        this.addRecordToTierMap(ar, tierName);
        return ar;
    }

    private AnnotationRecord createRefAnnotationRecord(String tierName, AnnotationRecord par, AnnotationRecord prev) {
        AnnotationRecord ar = new AnnotationRecord();
        ar.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        ar.setAnnotationType("reference");
        if (par != null) {
            ar.setReferredAnnotId(par.getAnnotationId());
        } else {
            System.out.println("Error: null as parent! " + tierName);
        }
        if (prev != null && prev.getAnnotationType() == "reference") {
            ar.setPreviousAnnotId(prev.getAnnotationId());
        }
        this.annotationRecords.add(ar);
        this.addRecordToTierMap(ar, tierName);
        return ar;
    }

    private void addRecordToTierMap(AnnotationRecord annRec, String tierName) {
        this.annotRecordToTierMap.put(annRec, tierName);
        if (this.tierNameToAnnRecordMap.containsKey(tierName)) {
            this.tierNameToAnnRecordMap.get(tierName).add(annRec);
        } else {
            ArrayList<AnnotationRecord> ar = new ArrayList<AnnotationRecord>();
            ar.add(annRec);
            this.tierNameToAnnRecordMap.put(tierName, ar);
        }
    }

    private void updateAnnRecordEndTS(String oldEndTSId, String nextId, String annotId) {
        try {
            int refId = 0;
            refId = annotId.startsWith("a_") ? Integer.parseInt(this.guidIdMap.get(annotId.substring("a_".length())).substring(ANN_ID_PREFIX.length())) : Integer.parseInt(annotId.substring(ANN_ID_PREFIX.length()));
            int depId = 0;
            for (AnnotationRecord record : this.annotationRecords) {
                if (record.getAnnotationType() != "alignable" || record.getEndTimeSlotId() != oldEndTSId) continue;
                try {
                    depId = record.getAnnotationId().startsWith("a_") ? Integer.parseInt(this.guidIdMap.get(record.getAnnotationId().substring("a_".length())).substring(ANN_ID_PREFIX.length())) : Integer.parseInt(record.getAnnotationId().substring(ANN_ID_PREFIX.length()));
                    if (depId <= refId) continue;
                    record.setEndTimeSlotId(nextId);
                }
                catch (Exception ex) {
                    System.out.println("Cannot update depending annotation record: " + record.getAnnotationId());
                }
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("Cannot update depending annotation records of: " + annotId);
        }
    }

    private boolean isAlignable(String tierLevel) {
        return this.unitLevels.indexOf(tierLevel) >= this.unitLevels.indexOf(this.decoder.smallestWithTimeAlignment);
    }

    private void calculateDurations() {
        if (this.decoder.totalDurationSpecified) {
            this.itDur = (int)this.decoder.totalDuration;
            if ("morph".equals(this.decoder.smallestWithTimeAlignment)) {
                if (this.morphCount != 0) {
                    this.unitDur = this.itDur / this.morphCount;
                } else if (this.wordCount != 0) {
                    this.unitDur = this.itDur / this.wordCount;
                } else if (this.phraseCount != 0) {
                    this.unitDur = this.itDur / this.phraseCount;
                } else if (this.parCount != 0) {
                    this.unitDur = this.itDur / this.parCount;
                }
            } else if ("word".equals(this.decoder.smallestWithTimeAlignment)) {
                if (this.wordCount != 0) {
                    this.unitDur = this.itDur / this.wordCount;
                } else if (this.phraseCount != 0) {
                    this.unitDur = this.itDur / this.phraseCount;
                } else if (this.parCount != 0) {
                    this.unitDur = this.itDur / this.parCount;
                }
            } else if ("phrase".equals(this.decoder.smallestWithTimeAlignment)) {
                if (this.phraseCount != 0) {
                    this.unitDur = this.itDur / this.phraseCount;
                } else if (this.parCount != 0) {
                    this.unitDur = this.itDur / this.parCount;
                }
            } else if ("paragraph".equals(this.decoder.smallestWithTimeAlignment) && this.parCount != 0) {
                this.unitDur = this.itDur / this.parCount;
            }
        } else if ("morph".equals(this.decoder.smallestWithTimeAlignment)) {
            this.unitDur = (int)this.decoder.perElementDuration;
            this.itDur = this.morphDur * this.morphCount;
        } else if ("word".equals(this.decoder.smallestWithTimeAlignment)) {
            this.unitDur = (int)this.decoder.perElementDuration;
            this.itDur = this.wordDur * this.wordCount;
        } else if ("phrase".equals(this.decoder.smallestWithTimeAlignment)) {
            this.unitDur = (int)this.decoder.perElementDuration;
            this.itDur = this.phraseDur * this.phraseCount;
        } else if ("paragraph".equals(this.decoder.smallestWithTimeAlignment)) {
            this.unitDur = (int)this.decoder.perElementDuration;
            this.itDur = this.parDur * this.parCount;
        }
    }

    private void updateElementTimes(ContainerElem elem) {
        if (elem == null) {
            return;
        }
        elem.bt *= (long)this.unitDur;
        elem.et *= (long)this.unitDur;
        if (elem.getChildElems() != null) {
            for (ContainerElem child : elem.getChildElems()) {
                this.updateElementTimes(child);
            }
        }
    }

    private void restoreAlignment(ContainerElem elem) {
        if (elem == null || this.decoder.getStoredAlignment() == null) {
            return;
        }
        long[] stored = this.decoder.getStoredAlignment().get(elem.id);
        if (stored == null) {
            return;
        }
        elem.bt = stored[0];
        elem.et = stored[1];
        if (elem.getChildElems() != null) {
            for (int i = 0; i < elem.getChildElems().size(); ++i) {
                ContainerElem child = elem.getChildElems().get(i);
                this.restoreAlignment(child);
            }
        }
    }

    private void resolveAlignmentConflicts(ContainerElem parElem) {
        if (parElem == null || this.decoder.getStoredAlignment() == null) {
            return;
        }
        if (parElem.getChildElems() != null) {
            int i;
            ContainerElem child = null;
            ContainerElem prevChild = null;
            if (parElem == this.topElement) {
                for (i = 0; i < parElem.getChildElems().size(); ++i) {
                    child = parElem.getChildElems().get(i);
                    long[] stored = this.decoder.getStoredAlignment().get(child.id);
                    if (stored == null) {
                        if (prevChild != null) {
                            if (child.bt < prevChild.et) {
                                long diff = prevChild.et - child.bt;
                                child.bt = prevChild.et;
                                child.et += diff;
                            }
                        } else if (child.bt < parElem.bt) {
                            child.bt = parElem.bt;
                        }
                    }
                    prevChild = child;
                }
                if (child != null && child.et > parElem.et) {
                    parElem.et = child.et;
                }
            } else {
                long diff = 0L;
                for (int i2 = 0; i2 < parElem.getChildElems().size(); ++i2) {
                    child = parElem.getChildElems().get(i2);
                    if (i2 == 0) {
                        if (child.bt < parElem.bt) {
                            diff = parElem.bt - child.bt;
                            child.bt += diff;
                            child.et += diff;
                        }
                        if (child.et > parElem.et) {
                            child.et = parElem.et;
                        }
                    }
                    if (prevChild != null) {
                        if (prevChild.et >= parElem.et) {
                            int num = parElem.getChildElems().size() - i2;
                            child.bt = prevChild.et = parElem.et - (long)(num * 80);
                            child.et = child.bt + 80L;
                        } else if (child.bt != prevChild.et) {
                            child.bt = prevChild.et;
                            if (child.et > parElem.et) {
                                child.et = parElem.et;
                            }
                        }
                    }
                    if (i2 == parElem.getChildElems().size() - 1 && child.et != parElem.et) {
                        child.et = parElem.et;
                    }
                    prevChild = child;
                }
            }
            for (i = 0; i < parElem.getChildElems().size(); ++i) {
                this.resolveAlignmentConflicts(parElem.getChildElems().get(i));
            }
        } else {
            return;
        }
    }

    private class FlexContentHandler
    implements ContentHandler {
        private ContainerElem curElem;
        private ContainerElem nextElem;
        private Item nextItem;
        private String lang;
        private String type;
        private StringBuilder content = new StringBuilder();
        private long curTime = 0L;

        private FlexContentHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("document".equals(qName)) {
                return;
            }
            if ("interlinear-text".equals(qName)) {
                FlexParser.this.topElement = new ContainerElem("interlinear-text");
                this.curElem = FlexParser.this.topElement;
                this.curElem.bt = this.curTime;
                this.curElem.id = "1";
                return;
            }
            if (((FlexParser)FlexParser.this).decoder.inclParagraphElement && "paragraph".equals(qName)) {
                FlexParser.this.parCount++;
                this.nextElem = new ContainerElem("paragraph");
                this.nextElem.bt = this.curTime;
                this.nextElem.id = atts.getValue("guid");
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else if ("phrase".equals(qName)) {
                FlexParser.this.phraseCount++;
                this.nextElem = new ContainerElem("phrase");
                this.nextElem.bt = this.curTime;
                this.nextElem.id = atts.getValue("guid");
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else if ("word".equals(qName)) {
                FlexParser.this.wordCount++;
                this.nextElem = new ContainerElem("word");
                this.nextElem.bt = this.curTime;
                this.nextElem.id = atts.getValue("guid");
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else if ("morph".equals(qName)) {
                FlexParser.this.morphCount++;
                this.nextElem = new ContainerElem("morph");
                this.nextElem.bt = this.curTime;
                String typeVal = atts.getValue("type");
                if (typeVal != null && typeVal.length() > 0) {
                    this.nextItem = new Item();
                    this.nextItem.type = "type";
                    this.nextItem.value = typeVal;
                    this.nextElem.addItem(this.nextItem);
                    this.nextItem.tierName = this.nextElem.flexType + "-" + this.nextItem.type;
                    if (FlexParser.this.typeLangPerLevel.get(this.nextElem.flexType) == null) {
                        FlexParser.this.typeLangPerLevel.put(this.nextElem.flexType, new LinkedHashSet(10));
                    }
                    ((LinkedHashSet)FlexParser.this.typeLangPerLevel.get(this.nextElem.flexType)).add(this.nextItem.tierName);
                }
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else {
                if ("item".equals(qName)) {
                    this.type = atts.getValue("type");
                    if (this.type != null && this.type.length() > 0) {
                        this.nextItem = new Item();
                        this.nextItem.type = "txt".equals(this.type) || "punct".equals(this.type) ? "txt" : this.type;
                        this.nextItem.lang = atts.getValue("lang");
                        if (this.nextItem.lang != null && !FlexParser.this.languages.contains(this.nextItem.lang)) {
                            FlexParser.this.languages.add(this.nextItem.lang);
                        }
                        String tierName = null;
                        tierName = this.nextItem.lang == null ? this.curElem.flexType + "-" + this.nextItem.type : this.curElem.flexType + "-" + this.nextItem.type + "-" + this.nextItem.lang;
                        this.nextItem.tierName = tierName;
                        if (FlexParser.this.typeLangPerLevel.get(this.curElem.flexType) == null) {
                            FlexParser.this.typeLangPerLevel.put(this.curElem.flexType, new LinkedHashSet(10));
                        }
                        ((LinkedHashSet)FlexParser.this.typeLangPerLevel.get(this.curElem.flexType)).add(tierName);
                    }
                    return;
                }
                if ("language".equals(qName)) {
                    this.lang = atts.getValue("lang");
                    if (!FlexParser.this.languages.contains(this.lang)) {
                        FlexParser.this.languages.add(this.lang);
                    }
                    return;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("interlinear-text".equals(qName)) {
                this.curElem.et = this.curTime;
                return;
            }
            if (((FlexParser)FlexParser.this).decoder.inclParagraphElement && "paragraph".equals(qName) || "phrase".equals(qName) || "word".equals(qName) || "morph".equals(qName)) {
                if (((FlexParser)FlexParser.this).decoder.smallestWithTimeAlignment.equals(qName)) {
                    this.curTime += (long)FlexParser.this.unitDur;
                }
                if (FlexParser.this.unitLevels.indexOf(qName) > FlexParser.this.unitLevels.indexOf(((FlexParser)FlexParser.this).decoder.smallestWithTimeAlignment) && (this.curElem.getChildElems() == null || this.curElem.getChildElems().size() == 0) && this.curElem.getItems() != null && this.curElem.getItems().size() > 0) {
                    this.curTime += (long)FlexParser.this.unitDur;
                }
                this.curElem.et = this.curTime;
                this.curElem = this.curElem.parent;
            } else if ("item".equals(qName)) {
                this.nextItem.value = this.content.toString().trim();
                this.content.delete(0, this.content.length());
                this.curElem.addItem(this.nextItem);
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

