/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.ByteRenderer;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.ImageRenderer;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Metrics;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Positioner;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.SizeCalculator;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class Interlinearizer {
    public static final int CM = 0;
    public static final int INCH = 1;
    public static final int PIXEL = 2;
    public static final int EACH_BLOCK = 0;
    public static final int BLOCK_BOUNDARY = 1;
    public static final int WITHIN_BLOCKS = 2;
    public static final int NO_WRAP = 3;
    public static final int HHMMSSMS = 0;
    public static final int SSMS = 1;
    public static final String UNALIGNED_HHMMSSMS = "??:??:??:???";
    public static final String UNALIGNED_SSMS = "?.???";
    public static final int PIXELS = 0;
    public static final int BYTES = 1;
    public static Font DEFAULTFONT = new Font("MS Arial Unicode", 0, 12);
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int TIMECODE_FONT_SIZE = 10;
    public static final int TEMPLATE = 0;
    public static final int HIDE_EMPTY_LINES = 1;
    public static final int EXTERNALLY_SPECIFIED = 0;
    public static final int TIER_HIERARCHY = 1;
    public static final int BY_LINGUISTIC_TYPE = 2;
    public static final int BY_PARTICIPANT = 3;
    public static final int UTF8 = 0;
    public static final int ISOLATIN = 1;
    public static final int SIL = 2;
    public static double SCALE = 4.166666666666667;
    private TimeCodedTranscription transcription = null;
    private int width;
    private int height;
    private String[] visibleTiers;
    private boolean tierLabelsShown;
    private long[] visibleTimeInterval;
    private int blockWrapStyle;
    private int lineWrapStyle;
    private boolean timeCodeShown;
    private int timeCodeType;
    private Hashtable fonts;
    private Hashtable fontSizes;
    private boolean emptySlotsShown;
    private int lineSpacing;
    private int blockSpacing = -1;
    private Annotation activeAnnotation;
    private long[] selection;
    private long mediaTime;
    private int alignmentUnit;
    private int emptyLineStyle;
    private int sortingStyle;
    private Hashtable charEncodings;
    private Metrics metrics;
    private boolean forPrinting = false;
    private boolean renderingFirstPage = true;
    private int pageHeight = 0;
    private boolean sorted = false;
    private boolean correctAnnotationTimes = false;

    public Interlinearizer(TimeCodedTranscription tr) {
        this.transcription = tr;
        this.metrics = new Metrics(tr, this);
        this.setDefaultValues();
    }

    private void resetMetrics() {
        this.metrics.reset();
    }

    private void setDefaultValues() {
        this.tierLabelsShown = true;
        this.blockWrapStyle = 3;
        this.lineWrapStyle = 3;
        this.timeCodeShown = false;
        this.timeCodeType = 0;
        this.emptySlotsShown = false;
        this.alignmentUnit = 0;
        this.emptyLineStyle = 1;
        this.sortingStyle = 0;
        if (this.transcription != null) {
            Vector tiers = this.transcription.getTiers();
            this.visibleTiers = new String[tiers.size()];
            for (int i = 0; i < tiers.size(); ++i) {
                String tName;
                this.visibleTiers[i] = tName = ((Tier)tiers.elementAt(i)).getName();
            }
        }
        this.fonts = new Hashtable();
        this.fontSizes = new Hashtable();
        this.charEncodings = new Hashtable();
    }

    public void renderView(BufferedImage bi) {
        if (this.isTimeCodeShown()) {
            this.transcription.prepareTimeCodeRendering(this.getTimeCodeType(), this.correctAnnotationTimes);
            this.addTimeCodeTiers(false);
        }
        this.calculateMetrics(bi.getGraphics());
    }

    public String[] renderAsText() {
        if (this.isTimeCodeShown()) {
            this.transcription.prepareTimeCodeRendering(this.getTimeCodeType(), this.correctAnnotationTimes);
            this.addTimeCodeTiers(true);
        }
        this.calculateMetrics();
        return ByteRenderer.render(this.metrics);
    }

    public boolean renderPage(Graphics g, int pageWidth, int pageHeight, int pageIndex) {
        boolean pageExists = false;
        this.setWidth(pageWidth);
        this.setHeight(pageHeight);
        if (this.renderingFirstPage) {
            if (this.isTimeCodeShown()) {
                this.transcription.prepareTimeCodeRendering(this.getTimeCodeType(), this.correctAnnotationTimes);
                this.addTimeCodeTiers(false);
            }
            this.calculateMetrics(g);
            this.renderingFirstPage = false;
        }
        if (!(pageExists = this.drawPage(g, pageIndex)) && this.isTimeCodeShown()) {
            this.transcription.cleanupTimeCodeTiers();
            this.removeTimeCodeTiers();
        }
        return pageExists;
    }

    private void addTimeCodeTiers(boolean atTopOfBlock) {
        this.removeTimeCodeTiers();
        Vector tcTiers = this.transcription.getTimeCodeTiers();
        Vector<String> vTierVector = new Vector<String>(Arrays.asList(this.visibleTiers));
        for (int j = 0; j < tcTiers.size(); ++j) {
            Tier tcTier = (Tier)tcTiers.elementAt(j);
            int minSize = 10;
            for (int i = 0; i < vTierVector.size(); ++i) {
                int sz = this.getFontSize(vTierVector.elementAt(i));
                if (sz >= minSize) continue;
                minSize = sz;
            }
            this.setFontSize(tcTier.getName(), minSize);
            TierImpl rootTier = this.transcription.getRootTier(tcTier);
            int lastIndex = -1;
            int firstIndex = -1;
            int index = 0;
            for (String visTierName : vTierVector) {
                Tier visTier = this.transcription.getTranscription().getTierWithId(visTierName);
                TierImpl rootOfVisTier = this.transcription.getRootTier(visTier);
                if (rootOfVisTier != null && rootTier == rootOfVisTier) {
                    lastIndex = index;
                    if (firstIndex == -1) {
                        firstIndex = index;
                    }
                }
                ++index;
            }
            if (atTopOfBlock && firstIndex >= 0) {
                vTierVector.add(firstIndex + 1, tcTier.getName());
                continue;
            }
            if (lastIndex < 0) continue;
            vTierVector.add(lastIndex + 1, tcTier.getName());
        }
        int counter = 0;
        String[] newVisTiers = new String[vTierVector.size()];
        Iterator<String> vIter = vTierVector.iterator();
        while (vIter.hasNext()) {
            String newTierName;
            newVisTiers[counter] = newTierName = vIter.next();
            ++counter;
        }
        this.setVisibleTiers(newVisTiers);
    }

    private void removeTimeCodeTiers() {
        Vector<String> newVTierVector = new Vector<String>();
        for (int i = 0; i < this.visibleTiers.length; ++i) {
            String vTierName = this.visibleTiers[i];
            if (!vTierName.startsWith("TC-")) {
                newVTierVector.add(vTierName);
                continue;
            }
            if (!this.fontSizes.contains(vTierName)) continue;
            this.fontSizes.remove(vTierName);
        }
        String[] newVisTiers = new String[newVTierVector.size()];
        for (int i = 0; i < newVTierVector.size(); ++i) {
            newVisTiers[i] = (String)newVTierVector.elementAt(i);
        }
        this.setVisibleTiers(newVisTiers);
    }

    private void calculateMetrics(Graphics graphics) {
        this.resetMetrics();
        SizeCalculator.calculateSizes(this.metrics, graphics);
        SizeCalculator.calculateUsedWidths(this.metrics);
        Positioner.calcHorizontalPositions(this.metrics);
        if (this.lineWrapStyle != 3 || this.blockWrapStyle != 3) {
            Positioner.wrap(this.metrics);
        }
        if (this.emptyLineStyle == 1) {
            Positioner.hideEmptyLines(this.metrics);
        }
    }

    private void calculateMetrics() {
        this.resetMetrics();
        SizeCalculator.calculateSizes(this.metrics);
        SizeCalculator.calculateUsedWidths(this.metrics);
        Positioner.calcHorizontalPositions(this.metrics);
        if (this.lineWrapStyle != 3 || this.blockWrapStyle != 3) {
            Positioner.wrap(this.metrics);
        }
        if (this.emptyLineStyle == 1) {
            Positioner.hideEmptyLines(this.metrics);
        }
    }

    public void drawViewOnImage(BufferedImage bi, int[] offset) {
        if (this.alignmentUnit == 0) {
            ImageRenderer.render(this.metrics, bi, offset);
        }
    }

    private boolean drawPage(Graphics g, int pageIndex) {
        boolean pageExists = true;
        if (this.alignmentUnit == 0) {
            pageExists = ImageRenderer.render(this.metrics, g, pageIndex);
        }
        return pageExists;
    }

    public Annotation getActiveAnnotation() {
        return this.activeAnnotation;
    }

    public int getAlignmentUnit() {
        return this.alignmentUnit;
    }

    public int getBlockWrapStyle() {
        return this.blockWrapStyle;
    }

    public boolean isEmptySlotsShown() {
        return this.emptySlotsShown;
    }

    public Font getFont(String tierName) {
        Font f = (Font)this.fonts.get(tierName);
        if (f == null) {
            f = DEFAULTFONT;
        }
        return f;
    }

    public int getFontSize(String tierName) {
        int size = 0;
        Integer sizeInt = (Integer)this.fontSizes.get(tierName);
        size = sizeInt != null ? sizeInt : 12;
        return size;
    }

    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        return this.metrics.getMaxVerticalPosition();
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getBlockSpacing() {
        if (this.blockSpacing < 0) {
            return 20 + 3 * this.getLineSpacing();
        }
        return this.blockSpacing;
    }

    public void setBlockSpacing(int blockSpacing) {
        this.blockSpacing = blockSpacing;
    }

    public int getLineWrapStyle() {
        return this.lineWrapStyle;
    }

    public long getMediaTime() {
        return this.mediaTime;
    }

    public long[] getSelection() {
        return this.selection;
    }

    public boolean isTierLabelsShown() {
        return this.tierLabelsShown;
    }

    public boolean isTimeCodeShown() {
        return this.timeCodeShown;
    }

    public int getTimeCodeType() {
        return this.timeCodeType;
    }

    public String[] getVisibleTiers() {
        if (this.sorted) {
            return this.visibleTiers;
        }
        if (this.sortingStyle == 1) {
            this.visibleTiers = this.sortByHierarchy(this.visibleTiers);
        } else if (this.sortingStyle == 2) {
            this.visibleTiers = this.sortByLinguisticType(this.visibleTiers);
        } else if (this.sortingStyle == 3) {
            this.visibleTiers = this.sortByParticipant(this.visibleTiers);
        }
        this.sorted = true;
        return this.visibleTiers;
    }

    private String[] sortByHierarchy(String[] visibleTiers) {
        Vector sortedTiers = new Vector();
        String[] sortedTierNames = new String[visibleTiers.length];
        List<String> vTierList = Arrays.asList(visibleTiers);
        Vector topTiers = ((TranscriptionImpl)this.transcription.getTranscription()).getTopTiers();
        for (int i = 0; i < topTiers.size(); ++i) {
            TierImpl topTier = (TierImpl)topTiers.elementAt(i);
            sortedTiers.addAll(this.transcription.getTierTree(topTier));
        }
        int arrayIndex = 0;
        for (int j = 0; j < sortedTiers.size(); ++j) {
            TierImpl t = (TierImpl)sortedTiers.elementAt(j);
            if (!vTierList.contains(t.getName())) continue;
            sortedTierNames[arrayIndex++] = t.getName();
        }
        return sortedTierNames;
    }

    private String[] sortByLinguisticType(String[] visibleTiers) {
        Hashtable<LinguisticType, Vector<String>> typesHash = new Hashtable<LinguisticType, Vector<String>>();
        LinguisticType notSpecifiedLT = new LinguisticType("NOT_SPECIFIED");
        LinguisticType tcLT = new LinguisticType("12nov2004_temp$LING$type");
        for (int i = 0; i < visibleTiers.length; ++i) {
            Vector<String> tiersOfType;
            String tierName = visibleTiers[i];
            LinguisticType lt = notSpecifiedLT;
            TierImpl tier = (TierImpl)this.transcription.getTranscription().getTierWithId(tierName);
            if (tier != null) {
                lt = tier.getLinguisticType();
                if (lt == null) {
                    lt = notSpecifiedLT;
                }
            } else if (tierName.startsWith("TC-")) {
                lt = tcLT;
            }
            if ((tiersOfType = (Vector<String>)typesHash.get(lt)) == null) {
                tiersOfType = new Vector<String>();
                typesHash.put(lt, tiersOfType);
            }
            tiersOfType.add(tierName);
        }
        Vector sortedTierNames = new Vector();
        Enumeration typeEnum = typesHash.keys();
        while (typeEnum.hasMoreElements()) {
            LinguisticType type = (LinguisticType)typeEnum.nextElement();
            sortedTierNames.addAll((Vector)typesHash.get(type));
        }
        String[] sortedNameStrings = new String[visibleTiers.length];
        for (int j = 0; j < sortedTierNames.size(); ++j) {
            sortedNameStrings[j] = (String)sortedTierNames.elementAt(j);
        }
        return sortedNameStrings;
    }

    private String[] sortByParticipant(String[] visibleTiers) {
        Hashtable<String, Vector<String>> participantHash = new Hashtable<String, Vector<String>>();
        String notSpecifiedParticipant = "NOT_SPECIFIED";
        for (int i = 0; i < visibleTiers.length; ++i) {
            Vector<String> tiersOfParticipant;
            String tierName = visibleTiers[i];
            String participant = notSpecifiedParticipant;
            TierImpl tier = (TierImpl)this.transcription.getTranscription().getTierWithId(tierName);
            if (tier != null && (participant = tier.getParticipant()) == null) {
                participant = notSpecifiedParticipant;
            }
            if ((tiersOfParticipant = (Vector<String>)participantHash.get(participant)) == null) {
                tiersOfParticipant = new Vector<String>();
                participantHash.put(participant, tiersOfParticipant);
            }
            tiersOfParticipant.add(tierName);
        }
        Vector sortedTierNames = new Vector();
        Enumeration participantEnum = participantHash.keys();
        while (participantEnum.hasMoreElements()) {
            String part = (String)participantEnum.nextElement();
            sortedTierNames.addAll((Vector)participantHash.get(part));
        }
        String[] sortedNameStrings = new String[visibleTiers.length];
        for (int j = 0; j < sortedTierNames.size(); ++j) {
            sortedNameStrings[j] = (String)sortedTierNames.elementAt(j);
        }
        return sortedNameStrings;
    }

    public long[] getVisibleTimeInterval() {
        return this.visibleTimeInterval;
    }

    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        return this.metrics.getMaxHorizontallyUsedWidth();
    }

    public void setActiveAnnotation(Annotation annotation) {
        this.activeAnnotation = annotation;
    }

    public void setAlignmentUnit(int i) {
        this.alignmentUnit = i;
    }

    public void setBlockWrapStyle(int i) {
        this.blockWrapStyle = i;
    }

    public void setEmptySlotsShown(boolean b) {
        this.emptySlotsShown = b;
    }

    public void setHeight(int i) {
        this.height = i;
    }

    public void setLineSpacing(int i) {
        this.lineSpacing = i;
    }

    public void setLineWrapStyle(int i) {
        this.lineWrapStyle = i;
    }

    public void setMediaTime(long l) {
        this.mediaTime = l;
    }

    public void setSelection(long[] ls) {
        this.selection = ls;
    }

    public void setTierLabelsShown(boolean show) {
        this.tierLabelsShown = show;
        this.metrics.showLeftMargin(show);
    }

    public void setTimeCodeShown(boolean b) {
        this.timeCodeShown = b;
    }

    public void setTimeCodeType(int i) {
        this.timeCodeType = i;
    }

    public void setVisibleTiers(String[] strings) {
        this.visibleTiers = strings;
    }

    public void setVisibleTimeInterval(long[] ls) {
        this.visibleTimeInterval = ls;
    }

    public void setWidth(int i) {
        this.width = i;
    }

    public void setFont(String tierName, Font f) {
        int fontSize = this.getFontSize(tierName);
        f = f.deriveFont((float)fontSize);
        this.fonts.put(tierName, f);
    }

    public void setFontSize(String tierName, int size) {
        this.fontSizes.put(tierName, new Integer(size));
        this.fonts.put(tierName, this.getFont(tierName).deriveFont((float)size));
    }

    public int getEmptyLineStyle() {
        return this.emptyLineStyle;
    }

    public void setEmptyLineStyle(int i) {
        this.emptyLineStyle = i;
    }

    public int getSortingStyle() {
        return this.sortingStyle;
    }

    public void setSortingStyle(int i) {
        this.sortingStyle = i;
        this.sorted = false;
    }

    public TimeCodedTranscription getTranscription() {
        return this.transcription;
    }

    public boolean forPrinting() {
        return this.forPrinting;
    }

    public void setForPrinting(boolean forPrinting) {
        this.forPrinting = forPrinting;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int height) {
        this.pageHeight = height;
    }

    public int getCharEncoding(String tierName) {
        int encoding = 0;
        if (tierName == null) {
            return encoding;
        }
        if (!this.charEncodings.containsKey(tierName)) {
            return encoding;
        }
        Integer encodingInt = (Integer)this.charEncodings.get(tierName);
        if (encodingInt != null) {
            encoding = encodingInt;
        }
        return encoding;
    }

    public void setCharEncoding(String tierName, int charEncoding) {
        this.charEncodings.put(tierName, new Integer(charEncoding));
    }

    public int getEmptySpace() {
        int emptySpace = 10;
        if (this.getAlignmentUnit() == 1) {
            emptySpace = 1;
        }
        return emptySpace;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public boolean getCorrectAnnotationTimes() {
        return this.correctAnnotationTimes;
    }

    public void setCorrectAnnotationTimes(boolean correctAnnotationTimes) {
        this.correctAnnotationTimes = correctAnnotationTimes;
    }
}

