/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Metrics;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;

public class Positioner {
    public static void calcHorizontalPositions(Metrics metrics) {
        TimeCodedTranscription tr = metrics.getTranscription();
        String[] visibleTiers = metrics.getInterlinearizer().getVisibleTiers();
        List<String> vTierList = Arrays.asList(visibleTiers);
        Vector rootAnnotations = new Vector();
        Hashtable positionPerTier = new Hashtable();
        int hBlockOffset = 0;
        Vector topTiers = ((TranscriptionImpl)tr.getTranscription()).getTopTiers();
        for (TierImpl t : topTiers) {
            Vector annots = t.getAnnotations();
            rootAnnotations.addAll(annots);
        }
        Collections.sort(rootAnnotations);
        for (Annotation a : rootAnnotations) {
            Positioner.positionAnnotation(a, hBlockOffset, vTierList, metrics, positionPerTier);
            hBlockOffset += metrics.getUsedWidth(a) + metrics.getInterlinearizer().getEmptySpace();
            positionPerTier.clear();
        }
    }

    private static void positionAnnotation(Annotation a, int blockOffset, List vTierList, Metrics metrics, Hashtable posPerTier) {
        int parentHPos;
        Annotation parentAnn;
        Integer hPosInteger;
        int hPosition = 0;
        boolean annVisible = true;
        annVisible = vTierList.contains(a.getTier().getName());
        if (annVisible) {
            metrics.setVerticalPosition(a);
        }
        if ((hPosInteger = (Integer)posPerTier.get(a.getTier())) != null) {
            hPosition = hPosInteger;
        }
        if ((parentAnn = a.getParentAnnotation()) != null && (parentHPos = metrics.getHorizontalPosition(parentAnn)) > hPosition + blockOffset) {
            hPosition = parentHPos - blockOffset;
        }
        metrics.setHorizontalPosition(a, blockOffset + hPosition);
        posPerTier.put(a.getTier(), new Integer(hPosition += metrics.getUsedWidth(a) + metrics.getInterlinearizer().getEmptySpace()));
        TimeCodedTranscription tr = metrics.getTranscription();
        Vector childAnnots = null;
        childAnnots = tr.getChildAnnotationsOf(a);
        Collections.sort(childAnnots);
        for (Annotation child : childAnnots) {
            Positioner.positionAnnotation(child, blockOffset, vTierList, metrics, posPerTier);
        }
    }

    public static void wrap(Metrics metrics) {
        int horWrap = 0;
        int vertWrap = 0;
        int lastBlockStart = 0;
        int lastBlockIndex = 0;
        Vector topTiers = ((TranscriptionImpl)metrics.getTranscription().getTranscription()).getTopTiers();
        boolean wrap = false;
        Vector orderedAnnots = metrics.getBlockWiseOrdered();
        for (int i = 0; i < orderedAnnots.size(); ++i) {
            Annotation a = (Annotation)orderedAnnots.elementAt(i);
            TierImpl t = (TierImpl)a.getTier();
            wrap = false;
            if (topTiers.contains(t)) {
                lastBlockStart = metrics.getHorizontalPosition(a);
                lastBlockIndex = i;
                if (metrics.getInterlinearizer().getBlockWrapStyle() == 0 && i > 0) {
                    wrap = true;
                } else if (metrics.getInterlinearizer().getBlockWrapStyle() == 1 && metrics.getHorizontalPosition(a) + metrics.getUsedWidth(a) > metrics.getInterlinearizer().getWidth() - metrics.getLeftMargin()) {
                    if (i > 0) {
                        wrap = true;
                    }
                } else if (metrics.getHorizontalPosition(a) + metrics.getSize(a) <= metrics.getInterlinearizer().getWidth() - metrics.getLeftMargin()) continue;
            }
            if (t.hasParentTier() && topTiers.contains(t.getParentTier()) && t.getLinguisticType().getConstraints().getStereoType() == 4 || !Positioner.crossesPageWidth(a, metrics) && !wrap) continue;
            horWrap = -metrics.getHorizontalPosition(a);
            vertWrap = metrics.getCumulativeTierHeights() + metrics.getInterlinearizer().getBlockSpacing();
            int startAt = i;
            if (metrics.getHorizontalPosition(a) == lastBlockStart) {
                startAt = lastBlockIndex;
            }
            Positioner.wrap(metrics, horWrap, vertWrap, startAt);
            wrap = false;
        }
    }

    private static boolean crossesPageWidth(Annotation a, Metrics metrics) {
        return metrics.getHorizontalPosition(a) + metrics.getUsedWidth(a) > metrics.getInterlinearizer().getWidth() - metrics.getLeftMargin();
    }

    private static void wrap(Metrics metrics, int hWrap, int vWrap, int startingIndex) {
        Vector orderedAnnots = metrics.getBlockWiseOrdered();
        for (int i = startingIndex; i < orderedAnnots.size(); ++i) {
            Annotation a = (Annotation)orderedAnnots.elementAt(i);
            metrics.setHorizontalPosition(a, metrics.getHorizontalPosition(a) + hWrap);
            metrics.setVerticalPosition(a, metrics.getVerticalPosition(a) + vWrap);
        }
    }

    public static void hideEmptyLines(Metrics metrics) {
        int currentVPos = 0;
        int currentVBlockBegin = 0;
        Vector<Integer> emptyLines = new Vector<Integer>();
        Vector<Integer> emptyLineHeights = new Vector<Integer>();
        int[] vPositionsInTemplate = metrics.getVPositionsInTemplate();
        int maxVerticalPosition = metrics.getMaxVerticalPosition();
        Vector annotPositions = metrics.getPositionsOfNonEmptyTiers();
        while (currentVPos < maxVerticalPosition) {
            for (int i = 0; i < vPositionsInTemplate.length; ++i) {
                currentVPos = currentVBlockBegin + vPositionsInTemplate[i];
                Integer currentVPosInt = new Integer(currentVPos);
                if (annotPositions.contains(currentVPosInt)) continue;
                emptyLines.add(currentVPosInt);
                int previousPos = 0;
                if (i > 0) {
                    previousPos = vPositionsInTemplate[i - 1];
                }
                emptyLineHeights.add(new Integer(vPositionsInTemplate[i] - previousPos));
            }
            currentVBlockBegin = currentVPos + metrics.getInterlinearizer().getBlockSpacing() + metrics.getInterlinearizer().getLineSpacing();
        }
        if (emptyLines.size() == 0) {
            return;
        }
        Iterator emptyLineIter = emptyLines.iterator();
        Iterator lineHeightIter = emptyLineHeights.iterator();
        int nextEmptyLine = 0;
        if (emptyLineIter.hasNext()) {
            nextEmptyLine = (Integer)emptyLineIter.next();
        }
        int nextLineHeight = 0;
        if (lineHeightIter.hasNext()) {
            nextLineHeight = (Integer)lineHeightIter.next();
        }
        int correction = 0;
        Vector sortedAnnots = metrics.getVerticallyOrdered();
        for (Annotation a : sortedAnnots) {
            int vPos = metrics.getVerticalPosition(a);
            if (vPos > nextEmptyLine) {
                while (emptyLineIter.hasNext()) {
                    correction += nextLineHeight;
                    nextEmptyLine = (Integer)emptyLineIter.next();
                    nextLineHeight = (Integer)lineHeightIter.next();
                    if (vPos >= nextEmptyLine) continue;
                }
            }
            if (correction <= 0) continue;
            metrics.setVerticalPosition(a, vPos - correction);
        }
    }
}

