/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Metrics;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;

public class SizeCalculator {
    public static void calculateSizes(Metrics metrics, Graphics g) {
        TimeCodedTranscription tr = metrics.getTranscription();
        String[] visibleTiers = metrics.getInterlinearizer().getVisibleTiers();
        int size = 0;
        int maxTierLabelWidth = 0;
        List<String> vTierList = Arrays.asList(visibleTiers);
        for (TierImpl t : tr.getTiers()) {
            if (!vTierList.contains(t.getName())) continue;
            Font font = metrics.getInterlinearizer().getFont(t.getName());
            FontMetrics fontMetrics = g.getFontMetrics(font);
            int tierHeight = fontMetrics.getHeight();
            metrics.setTierHeight(t.getName(), tierHeight);
            for (Annotation a : t.getAnnotations()) {
                size = fontMetrics.stringWidth(a.getValue().trim());
                metrics.setSize(a, size);
            }
            if (fontMetrics.stringWidth(t.getName()) <= maxTierLabelWidth) continue;
            maxTierLabelWidth = fontMetrics.stringWidth(t.getName());
        }
        metrics.setLeftMargin(maxTierLabelWidth + 10);
    }

    public static void calculateSizes(Metrics metrics) {
        TimeCodedTranscription tr = metrics.getTranscription();
        String[] visibleTiers = metrics.getInterlinearizer().getVisibleTiers();
        int size = 0;
        boolean maxTierLabelWidth = false;
        List<String> vTierList = Arrays.asList(visibleTiers);
        for (TierImpl t : tr.getTiers()) {
            if (!vTierList.contains(t.getName())) continue;
            int charEncoding = metrics.getInterlinearizer().getCharEncoding(t.getName());
            metrics.setTierHeight(t.getName(), 1);
            for (Annotation a : t.getAnnotations()) {
                size = charEncoding == 0 ? SizeCalculator.getNumOfBytes(a.getValue()) : a.getValue().length();
                metrics.setSize(a, size);
            }
        }
    }

    public static int getNumOfBytes(String utf8String) {
        int numOfBytes = 0;
        char[] chars = new char[utf8String.length()];
        utf8String.getChars(0, utf8String.length(), chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == '\u0000' || ch >= '\u0080' && ch <= '\u07ff') {
                numOfBytes += 2;
                continue;
            }
            if (ch >= '\u0800' && ch <= '\uffff') {
                numOfBytes += 3;
                continue;
            }
            ++numOfBytes;
        }
        return numOfBytes;
    }

    public static void calculateUsedWidths(Metrics metrics) {
        Vector rootAnnotations = new Vector();
        TimeCodedTranscription tr = metrics.getTranscription();
        int alignmentUnit = metrics.getInterlinearizer().getAlignmentUnit();
        boolean usedWidht = false;
        Vector topTiers = ((TranscriptionImpl)tr.getTranscription()).getTopTiers();
        for (TierImpl t : topTiers) {
            Vector annots = t.getAnnotations();
            rootAnnotations.addAll(annots);
        }
        for (Annotation ann : rootAnnotations) {
            SizeCalculator.determineUsedWidth(ann, metrics);
        }
    }

    private static int determineUsedWidth(Annotation ann, Metrics metrics) {
        int maxUsedWidth;
        TimeCodedTranscription tr = metrics.getTranscription();
        int annWidth = maxUsedWidth = metrics.getSize(ann);
        int usedWidth = 0;
        Hashtable<Tier, Integer> usedPerTier = new Hashtable<Tier, Integer>();
        Hashtable<Tier, Annotation> lastChildPerTier = new Hashtable<Tier, Annotation>();
        Vector childAnnots = tr.getChildAnnotationsOf(ann);
        for (Annotation child : childAnnots) {
            usedWidth = SizeCalculator.determineUsedWidth(child, metrics);
            Integer currWidthForTier = (Integer)usedPerTier.get(child.getTier());
            if (currWidthForTier != null) {
                usedPerTier.put(child.getTier(), new Integer(currWidthForTier + usedWidth + metrics.getInterlinearizer().getEmptySpace()));
            } else {
                usedPerTier.put(child.getTier(), new Integer(usedWidth));
            }
            Annotation lastOnTier = (Annotation)lastChildPerTier.get(child.getTier());
            if (lastOnTier != null) {
                if (child.compareTo(lastOnTier) <= 0) continue;
                lastChildPerTier.put(child.getTier(), child);
                continue;
            }
            lastChildPerTier.put(child.getTier(), child);
        }
        Collection sizes = usedPerTier.values();
        Iterator sizePerTierIter = sizes.iterator();
        while (sizePerTierIter.hasNext()) {
            int sizePerTier = (Integer)sizePerTierIter.next();
            if (sizePerTier <= maxUsedWidth) continue;
            maxUsedWidth = sizePerTier;
        }
        if (maxUsedWidth == annWidth) {
            Enumeration tierEnum = usedPerTier.keys();
            while (tierEnum.hasMoreElements()) {
                Tier t = (Tier)tierEnum.nextElement();
                int widthToBeAdded = maxUsedWidth - (Integer)usedPerTier.get(t);
                if (widthToBeAdded <= 0) continue;
                Annotation lastAnn = (Annotation)lastChildPerTier.get(t);
                metrics.setUsedWidth(lastAnn, metrics.getUsedWidth(lastAnn) + widthToBeAdded);
            }
        }
        metrics.setUsedWidth(ann, maxUsedWidth);
        return maxUsedWidth;
    }
}

