/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;

public class IncludedIn
extends ConstraintImpl {
    public void forceTimes(long[] segment, Tier forTier) {
        if (forTier != null) {
            Annotation annAtBegin = ((TierImpl)forTier).getAnnotationAtTime(segment[0]);
            Annotation annAtEnd = ((TierImpl)forTier).getAnnotationAtTime(segment[1]);
            if (annAtBegin != null && annAtEnd == null) {
                segment[1] = annAtBegin.getEndTimeBoundary();
            } else if (annAtBegin == null && annAtEnd != null) {
                segment[0] = annAtEnd.getBeginTimeBoundary();
            } else if (annAtBegin != null && annAtEnd != null && annAtBegin != annAtEnd) {
                segment[0] = annAtEnd.getBeginTimeBoundary();
            } else if (annAtBegin == null && annAtEnd == null) {
                Vector annotsInBetween = ((TierImpl)forTier).getOverlappingAnnotations(segment[0], segment[1]);
                if (annotsInBetween.size() > 0) {
                    AlignableAnnotation a = (AlignableAnnotation)annotsInBetween.elementAt(0);
                    segment[0] = a.getBegin().getTime();
                    segment[1] = a.getEnd().getTime();
                } else {
                    segment[0] = segment[1];
                }
            }
        }
    }

    public int getStereoType() {
        return 1;
    }

    public boolean supportsInsertion() {
        return false;
    }

    public void detachAnnotation(Annotation theAnn, Tier theTier) {
    }

    public void enforceOnWholeTier(Tier theTier) {
        System.out.println("IncludedIn: enforce...");
    }

    public Vector getTimeSlotsForNewAnnotation(long begin, long end, Tier forTier) {
        Vector<TimeSlotImpl> slots = new Vector<TimeSlotImpl>(2);
        TierImpl parentTier = (TierImpl)((TierImpl)forTier).getParentTier();
        AlignableAnnotation parentAnn = null;
        Vector overlappingParentAnns = parentTier.getOverlappingAnnotations(begin, end);
        if (overlappingParentAnns.size() == 0) {
            return slots;
        }
        if (overlappingParentAnns.size() >= 1) {
            parentAnn = (AlignableAnnotation)overlappingParentAnns.get(0);
        }
        if (!parentAnn.getBegin().isTimeAligned() || !parentAnn.getEnd().isTimeAligned()) {
            return slots;
        }
        if (parentAnn.getBegin().getTime() > begin) {
            begin = parentAnn.getBegin().getTime();
        }
        if (parentAnn.getEnd().getTime() < end) {
            end = parentAnn.getEnd().getTime();
        }
        Vector overlappingAnnots = ((TierImpl)forTier).getOverlappingAnnotations(begin, end);
        TimeOrder timeOrder = ((TranscriptionImpl)forTier.getParent()).getTimeOrder();
        TimeSlotImpl bts = new TimeSlotImpl(begin, timeOrder);
        TimeSlotImpl ets = new TimeSlotImpl(end, timeOrder);
        timeOrder.insertTimeSlot(bts);
        timeOrder.insertTimeSlot(ets);
        slots.add(bts);
        slots.add(ets);
        Iterator anIt = overlappingAnnots.iterator();
        AlignableAnnotation curAnn = null;
        while (anIt.hasNext()) {
            curAnn = (AlignableAnnotation)anIt.next();
            if (curAnn.getBegin().getTime() >= begin) {
                if (curAnn.getEnd().getTime() > end) {
                    curAnn.getBegin().setTime(end);
                    continue;
                }
                curAnn.setBegin(curAnn.getEnd());
                continue;
            }
            if (curAnn.getEnd().getTime() <= begin) continue;
            curAnn.getEnd().setTime(begin);
        }
        return slots;
    }
}

