/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import mpi.eudico.server.corpora.util.ACMEditableObject;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;

public class ControlledVocabulary
extends BasicControlledVocabulary {
    private final List undoableEditListeners = new ArrayList();
    private boolean changed = false;
    private ACMEditableObject acmEditableObj;

    public ControlledVocabulary(String name) {
        super(name);
    }

    public ControlledVocabulary(String name, String description) {
        super(name, description);
    }

    public boolean addEntry(CVEntry entry) {
        boolean b = super.addEntry(entry);
        if (b) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, new UndoableCVEntryAdd(entry)));
        }
        return b;
    }

    public boolean replaceEntry(CVEntry oldEntry, CVEntry newEntry) {
        boolean b = super.replaceEntry(oldEntry, newEntry);
        if (b) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, new UndoableCVEntryReplace(oldEntry, newEntry)));
        }
        return b;
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        if (!this.undoableEditListeners.contains(l)) {
            this.undoableEditListeners.add(l);
        }
    }

    public void moveEntries(CVEntry[] entriesToBeMoved, int moveType) {
        CVEntry[] oldEntries = this.getEntries();
        super.moveEntries(entriesToBeMoved, moveType);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new UndoableCVGlobalChange(oldEntries, "Move entries")));
    }

    public CVEntry[] getEntriesSortedByAlphabet() {
        CVEntry[] oldEntries = this.getEntries();
        CVEntry[] sortedEntries = super.getEntriesSortedByAlphabet();
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new UndoableCVGlobalChange(oldEntries, "Sort entries")));
        return sortedEntries;
    }

    public CVEntry[] getEntriesSortedByReverseAlphabetOrder() {
        CVEntry[] oldEntries = this.getEntries();
        CVEntry[] sortedEntries = super.getEntriesSortedByReverseAlphabetOrder();
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new UndoableCVGlobalChange(oldEntries, "Sort entries")));
        return sortedEntries;
    }

    public boolean removeEntries(CVEntry[] entriesToBeRemoved) {
        CVEntry[] oldEntries = this.getEntries();
        boolean b = super.removeEntries(entriesToBeRemoved);
        if (b) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, new UndoableCVGlobalChange(oldEntries, "Delete entries")));
        }
        return b;
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        if (this.undoableEditListeners.contains(l)) {
            this.undoableEditListeners.remove(l);
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        for (int i = this.undoableEditListeners.size() - 1; i >= 0; --i) {
            ((UndoableEditListener)this.undoableEditListeners.get(i)).undoableEditHappened(e);
        }
    }

    protected void handleModified() {
        this.changed = true;
        if (this.acmEditableObj != null) {
            this.acmEditableObj.modified(13, this);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setACMEditableObject(ACMEditableObject obj) {
        this.acmEditableObj = obj;
    }

    public void removeACMEditableObject() {
        this.acmEditableObj = null;
    }

    class UndoableCVGlobalChange
    extends AbstractUndoableEdit {
        private final CVEntry[] oldEntries;
        private String representationName;
        private CVEntry[] newEntries;

        UndoableCVGlobalChange(CVEntry[] entries, String representationName) {
            this.oldEntries = entries;
            this.representationName = representationName;
        }

        public String getRepresentationName() {
            return this.representationName;
        }

        public void redo() {
            super.redo();
            ControlledVocabulary.this.entries.clear();
            for (int i = 0; i < this.newEntries.length; ++i) {
                ControlledVocabulary.this.entries.add(this.newEntries[i]);
            }
        }

        public void undo() {
            super.undo();
            this.newEntries = ControlledVocabulary.this.getEntries();
            ControlledVocabulary.this.entries.clear();
            for (int i = 0; i < this.oldEntries.length; ++i) {
                ControlledVocabulary.this.entries.add(this.oldEntries[i]);
            }
        }
    }

    class UndoableCVEntryReplace
    extends AbstractUndoableEdit {
        private final CVEntry oldEntry;
        private CVEntry newEntry;

        UndoableCVEntryReplace(CVEntry oldEntry, CVEntry newEntry) {
            this.oldEntry = oldEntry;
            this.newEntry = newEntry;
        }

        public String getRepresentationName() {
            return "change Entry";
        }

        public void redo() {
            super.redo();
            int index = ControlledVocabulary.this.entries.indexOf(this.oldEntry);
            ControlledVocabulary.this.entries.remove(index);
            ControlledVocabulary.this.entries.add(index, this.newEntry);
        }

        public void undo() {
            super.undo();
            int index = ControlledVocabulary.this.entries.indexOf(this.newEntry);
            ControlledVocabulary.this.entries.remove(index);
            ControlledVocabulary.this.entries.add(index, this.oldEntry);
        }
    }

    class UndoableCVEntryAdd
    extends AbstractUndoableEdit {
        private final CVEntry entry;

        UndoableCVEntryAdd(CVEntry entry) {
            this.entry = entry;
        }

        public String getRepresentationName() {
            return "add Entry";
        }

        public void redo() {
            super.redo();
            ControlledVocabulary.this.entries.add(this.entry);
        }

        public void undo() {
            super.undo();
            ControlledVocabulary.this.entries.remove(this.entry);
        }
    }
}

