/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class ErrOutLogFileHandler
extends StreamHandler {
    public static final String DEFAULT_LOG_FILE_PATTERN = "%h/mpitools%u.log";
    protected static final int MAX_UNIQUE_FILES = 30;
    protected LogManager manager = LogManager.getLogManager();
    protected String pattern;
    protected Formatter formatter;
    protected Level level;
    protected PrintStream origOut;
    protected PrintStream origErr;
    protected FileOutputStream outStream;
    protected File file;
    private RandomAccessFile raf;
    private FileInputStream inStream;
    private FileChannel rfc;
    protected PrintStream printStream;

    public ErrOutLogFileHandler() throws IOException, SecurityException {
        this.checkLogAccess();
        this.readConfiguration();
        this.initHandler();
    }

    public ErrOutLogFileHandler(String pattern) throws IOException, SecurityException {
        this.checkLogAccess();
        this.readConfiguration();
        if (pattern != null && pattern.length() > 0) {
            this.pattern = pattern;
        }
        this.initHandler();
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
    }

    public synchronized void close() throws SecurityException {
        super.close();
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.origOut != null) {
                System.setOut(this.origOut);
            }
            if (this.origErr != null) {
                System.setErr(this.origErr);
            }
        }
    }

    public void flush() {
        super.flush();
    }

    public String getCurrentContent() throws IOException, SecurityException {
        if (this.file != null) {
            StringBuilder builder = new StringBuilder();
            FileChannel inChannel = this.rfc;
            inChannel.position(0L);
            int size = 256;
            ByteBuffer buf = ByteBuffer.allocate(size);
            Charset chSet = Charset.forName("UTF-8");
            while (inChannel.read(buf) != -1) {
                buf.flip();
                builder.append(chSet.decode(buf));
                buf.clear();
            }
            return builder.toString();
        }
        return null;
    }

    protected void initHandler() throws IOException, SecurityException {
        if (this.formatter != null) {
            this.setFormatter(this.formatter);
        }
        if (this.level != null) {
            this.setLevel(this.level);
        }
        this.openFile();
        if (this.file != null && this.outStream != null) {
            this.origOut = System.out;
            this.origErr = System.err;
            BufferedOutputStream bout = new BufferedOutputStream(this.outStream);
            this.printStream = new PrintStream(bout, true);
            System.setErr(this.printStream);
            System.setOut(this.printStream);
            this.setOutputStream(this.printStream);
        }
    }

    protected void checkLogAccess() throws SecurityException {
        this.manager.checkAccess();
    }

    protected void readConfiguration() {
        String levelString;
        String className = ErrOutLogFileHandler.class.getName();
        this.pattern = this.manager.getProperty(className + ".pattern");
        this.pattern = this.pattern == null ? DEFAULT_LOG_FILE_PATTERN : this.pattern.trim();
        String formatString = this.manager.getProperty(className + ".formatter");
        if (formatString != null) {
            try {
                Class<?> formClass = ClassLoader.getSystemClassLoader().loadClass(formatString.trim());
                this.formatter = (Formatter)formClass.newInstance();
            }
            catch (Exception e) {
                this.formatter = new SimpleFormatter();
            }
        }
        if ((levelString = this.manager.getProperty(className + ".level")) != null) {
            try {
                this.level = Level.parse(levelString.trim());
            }
            catch (Exception e) {
                this.level = null;
            }
        }
    }

    protected File generate(String pattern, int unique) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'u') {
                    word = word + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (unique > 0 && !sawu) {
            word = word + "." + unique;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    protected void openFile() throws IOException {
        for (int i = 0; i < 30; ++i) {
            RandomAccessFile r;
            File f = null;
            try {
                f = this.generate(this.pattern, i);
                r = new RandomAccessFile(f, "rw");
                this.outStream = new FileOutputStream(r.getFD());
                this.inStream = new FileInputStream(r.getFD());
                this.rfc = r.getChannel();
                FileLock lock = this.rfc.tryLock();
                if (lock == null) {
                    continue;
                }
            }
            catch (IOException ioe) {
                if (i != 29) continue;
                throw ioe;
            }
            if (f == null) continue;
            this.file = f;
            this.raf = r;
            break;
        }
    }
}

