/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class ExtClassLoader
extends URLClassLoader {
    public static final String EXTENSIONS_DIR;
    private static String extFolder;
    private static Logger LOG;
    private static ExtClassLoader loader;
    private static HashMap<String, List<Class>> loadedClasses;
    private static HashMap<String, List<URL>> resourceURLS;

    private ExtClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        loadedClasses = new HashMap();
        resourceURLS = new HashMap();
        File plDir = new File(extFolder);
        if (plDir.exists() && plDir.isDirectory()) {
            File[] plfs = plDir.listFiles();
            try {
                for (int i = 0; i < plfs.length; ++i) {
                    super.addURL(plfs[i].toURL());
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.loadClasses();
    }

    public static ExtClassLoader getInstance() {
        if (loader == null) {
            loader = new ExtClassLoader(ClassLoader.getSystemClassLoader());
        }
        return loader;
    }

    public static void setExtensionsDirectory(String directoryPath) {
        if (directoryPath != null && !directoryPath.equals(extFolder)) {
            File folder = new File(directoryPath);
            if (folder.exists() && folder.isDirectory()) {
                extFolder = directoryPath;
                loader = null;
            } else {
                LOG.warning("The specified folder does not exist: " + directoryPath);
            }
        } else {
            LOG.warning("The folder path is null or equal to current path");
        }
    }

    private void loadClasses() {
        block15: {
            try {
                File plDir = new File(extFolder);
                LOG.info("Extensions dir: " + plDir.getAbsolutePath());
                if (!plDir.exists() || !plDir.isDirectory()) break block15;
                File[] plfs = plDir.listFiles();
                for (int i = 0; i < plfs.length; ++i) {
                    String jarUrlPref;
                    JarFile jf;
                    try {
                        jf = new JarFile(plfs[i].getAbsolutePath());
                        jarUrlPref = "jar:file:/" + plfs[i].getAbsolutePath().replace('\\', '/') + "!/";
                    }
                    catch (IOException ioe) {
                        LOG.warning("Error loading jar: " + ioe.getMessage());
                        continue;
                    }
                    catch (SecurityException se) {
                        LOG.warning("Error loading jar: " + se.getMessage());
                        continue;
                    }
                    Enumeration<JarEntry> clEnum = jf.entries();
                    ArrayList foundClasses = new ArrayList();
                    ArrayList<URL> foundRes = new ArrayList<URL>();
                    while (clEnum.hasMoreElements()) {
                        JarEntry jae = clEnum.nextElement();
                        if (jae.getName().endsWith(".class") || jae.getName().endsWith(".CLASS")) {
                            try {
                                InputStream jis = jf.getInputStream(jae);
                                byte[] cbs = new byte[(int)jae.getSize()];
                                jis.read(cbs, 0, cbs.length);
                                try {
                                    Class<?> nextClass = super.loadClass(jae.getName().replace('/', '.').substring(0, jae.getName().lastIndexOf(46)));
                                    if (nextClass == null) continue;
                                    foundClasses.add(nextClass);
                                }
                                catch (IndexOutOfBoundsException ioox) {
                                    LOG.warning("Cannot create class: " + ioox.getMessage());
                                }
                                catch (SecurityException se) {
                                    LOG.warning("Cannot create class: " + se.getMessage());
                                }
                            }
                            catch (IOException ioe) {
                                LOG.warning("Cannot read class file from jar: " + ioe.getMessage());
                            }
                            continue;
                        }
                        try {
                            foundRes.add(new URL(jarUrlPref + jae.getName()));
                        }
                        catch (MalformedURLException mue) {
                            LOG.warning("Could not create url for: " + jae.getName());
                        }
                    }
                    loadedClasses.put(jf.getName().replace('\\', '/'), foundClasses);
                    resourceURLS.put(jf.getName().replace('\\', '/'), foundRes);
                }
            }
            catch (Exception ex) {
                LOG.warning("Could not load extension classes: " + ex.getMessage());
            }
        }
    }

    public Class[] getImplementingClasses(String name) {
        if (name == null) {
            return null;
        }
        Class<?> superClass = null;
        try {
            superClass = Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return null;
        }
        return this.getImplementingClasses(superClass);
    }

    public Class[] getImplementingClasses(Class superClass) {
        if (superClass == null) {
            return null;
        }
        ArrayList<Class> cList = new ArrayList<Class>();
        for (String name : loadedClasses.keySet()) {
            List<Class> li = loadedClasses.get(name);
            if (li == null) continue;
            for (int i = 0; i < li.size(); ++i) {
                Class cl = li.get(i);
                if (!superClass.isAssignableFrom(cl)) continue;
                cList.add(cl);
            }
        }
        return cList.toArray(new Class[0]);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("No class found for null");
        }
        return super.findClass(name);
    }

    public URL findResource(String name) {
        if (name == null) {
            return null;
        }
        name = !name.startsWith("/") ? name.replace('.', '/') : name.substring(1);
        for (String key : resourceURLS.keySet()) {
            List<URL> li = resourceURLS.get(key);
            if (li == null) continue;
            for (int i = 0; i < li.size(); ++i) {
                String res;
                int index;
                URL url = li.get(i);
                if (url == null || (index = (res = url.toString()).indexOf("!/")) <= -1 || index >= res.length() - 2 || !name.equals(res = res.substring(index + 2))) continue;
                return url;
            }
        }
        return null;
    }

    static {
        extFolder = EXTENSIONS_DIR = System.getProperty("user.dir") + File.separator + "extensions";
        LOG = Logger.getLogger(ExtClassLoader.class.getName());
    }
}

