/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import mpi.eudico.server.corpora.clom.AnnotationCore;

public class TimeRelation {
    public static final boolean isAfterRightDistance(AnnotationCore annotationCore, long intervalEnd, long distance) {
        return annotationCore.getBeginTimeBoundary() > intervalEnd + distance;
    }

    public static final boolean isBeforeLeftDistance(AnnotationCore annotationCore, long intervalBegin, long distance) {
        return annotationCore.getEndTimeBoundary() < intervalBegin - distance;
    }

    public static final boolean isInside(AnnotationCore annotationCore, long intervalBegin, long intervalEnd) {
        return annotationCore.getBeginTimeBoundary() >= intervalBegin && annotationCore.getEndTimeBoundary() <= intervalEnd;
    }

    public static final boolean isNotInside(AnnotationCore annotationCore, long intervalBegin, long intervalEnd) {
        return !TimeRelation.isInside(annotationCore, intervalBegin, intervalEnd);
    }

    public static final boolean isWithinDistance(AnnotationCore annotationCore, long intervalBegin, long intervalEnd, long distance) {
        return distance == Long.MAX_VALUE || annotationCore.getBeginTimeBoundary() > intervalBegin - distance && annotationCore.getEndTimeBoundary() <= intervalEnd + distance;
    }

    public static final boolean isWithinLeftDistance(AnnotationCore annotationCore, long intervalBegin, long distance) {
        return distance == Long.MAX_VALUE || annotationCore.getBeginTimeBoundary() > intervalBegin - distance && annotationCore.getEndTimeBoundary() <= intervalBegin + distance;
    }

    public static final boolean isWithinRightDistance(AnnotationCore annotationCore, long intervalEnd, long distance) {
        return distance == Long.MAX_VALUE || annotationCore.getBeginTimeBoundary() > intervalEnd - distance && annotationCore.getEndTimeBoundary() <= intervalEnd + distance;
    }

    public static final boolean doesNotOverlap(AnnotationCore annotationCore, long intervalBegin, long intervalEnd) {
        return annotationCore.getEndTimeBoundary() <= intervalBegin || annotationCore.getBeginTimeBoundary() >= intervalEnd;
    }

    public static final boolean overlaps(AnnotationCore annotationCore, long intervalBegin, long intervalEnd) {
        return !TimeRelation.doesNotOverlap(annotationCore, intervalBegin, intervalEnd);
    }

    public static final boolean overlapsOnLeftSide(AnnotationCore annotationCore, long intervalBegin, long intervalEnd) {
        return annotationCore.getBeginTimeBoundary() < intervalBegin && intervalBegin < annotationCore.getEndTimeBoundary() && annotationCore.getEndTimeBoundary() < intervalEnd;
    }

    public static final boolean overlapsOnRightSide(AnnotationCore annotationCore, long intervalBegin, long intervalEnd) {
        return intervalBegin < annotationCore.getBeginTimeBoundary() && annotationCore.getBeginTimeBoundary() < intervalEnd && intervalEnd < annotationCore.getEndTimeBoundary();
    }
}

