/*
 * Decompiled with CFR 0.152.
 */
package mpi.search;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SearchLocale {
    private static Locale locale;
    private static ResourceBundle resourcebundle;

    public static final Locale getLocale() {
        return locale;
    }

    public static final void setLocale(Locale locale_in) {
        if (locale != null && locale.equals(locale_in)) {
            return;
        }
        locale = locale_in;
        try {
            resourcebundle = ResourceBundle.getBundle("mpi.search.resources.SearchLanguage", locale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourcebundle == null) {
            System.out.println("WARNING: no language resources for " + locale.getDisplayLanguage());
        }
    }

    public static final void setResourceBundle(ResourceBundle resBundle) {
        if (resBundle != null) {
            resourcebundle = resBundle;
        }
    }

    public static final String getString(String str) {
        if (locale == null) {
            SearchLocale.setLocale(Locale.getDefault());
        }
        if (resourcebundle != null) {
            try {
                return resourcebundle.getString(str);
            }
            catch (MissingResourceException ex) {
                System.out.println("Warning: no localization for " + str + " found in language " + locale.getDisplayCountry());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    static {
        SearchLocale.setLocale(Locale.getDefault());
    }
}

