/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.model;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.search.content.query.model.Constraint;

public abstract class AbstractConstraint
implements Constraint {
    protected String mode = "Search.Constraint.Temporal";
    protected String quantifier = "Search.Constraint.Any";
    protected String[] tierNames = new String[0];
    private Constraint parent = null;
    private HashMap attributes;
    private String patternString = "";
    private String unit;
    private Vector children = new Vector();
    private boolean isCaseSensitive = false;
    private boolean isRegEx = false;
    private long lowerBoundary = Long.MIN_VALUE;
    private long upperBoundary = Long.MAX_VALUE;

    public AbstractConstraint() {
    }

    public AbstractConstraint(String[] tierNames, String patternString, long lowerBoundary, long upperBoundary, String unit, boolean isRegEx, boolean isCaseSensitive, HashMap attributes) {
        this.tierNames = tierNames;
        this.patternString = patternString;
        this.lowerBoundary = lowerBoundary;
        this.upperBoundary = upperBoundary;
        this.unit = unit;
        this.isRegEx = isRegEx;
        this.isCaseSensitive = isCaseSensitive;
        this.attributes = attributes;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public void setAttributes(HashMap h) {
        this.attributes = h;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public void setCaseSensitive(boolean b) {
        this.isCaseSensitive = b;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public TreeNode getChildAt(int i) {
        return (MutableTreeNode)this.children.get(i);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean isEditable() {
        return true;
    }

    public String getId() {
        return this.parent != null ? this.parent.getId() + "." + this.parent.getIndex(this) : "C";
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void setLowerBoundary(long l) {
        this.lowerBoundary = l;
    }

    public long getLowerBoundary() {
        return this.lowerBoundary;
    }

    public String getLowerBoundaryAsString() {
        return this.lowerBoundary == Long.MIN_VALUE ? "-X" : "" + this.lowerBoundary;
    }

    public String getMode() {
        return this.mode;
    }

    public void setParent(MutableTreeNode parent) {
        this.parent = (Constraint)parent;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setPattern(String s) {
        this.patternString = s;
    }

    public String getPattern() {
        return this.patternString;
    }

    public String getQuantifier() {
        return this.quantifier;
    }

    public void setRegEx(boolean b) {
        this.isRegEx = b;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public void setTierName(String s) {
        this.tierNames = new String[]{s};
    }

    public String getTierName() {
        return this.tierNames.length > 0 ? this.tierNames[0] : null;
    }

    public void setTierNames(String[] s) {
        this.tierNames = s;
    }

    public String[] getTierNames() {
        return this.tierNames;
    }

    public void setUnit(String s) {
        this.unit = s;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUpperBoundary(long l) {
        this.upperBoundary = l;
    }

    public long getUpperBoundary() {
        return this.upperBoundary;
    }

    public String getUpperBoundaryAsString() {
        return this.upperBoundary == Long.MAX_VALUE ? "+X" : "" + this.upperBoundary;
    }

    public void setUserObject(Object object) {
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public Object clone() {
        AbstractConstraint newConstraint = null;
        try {
            newConstraint = (AbstractConstraint)super.clone();
            newConstraint.setTierNames(this.getTierNames());
            newConstraint.setPattern(this.getPattern());
            newConstraint.setCaseSensitive(this.isCaseSensitive());
            newConstraint.setRegEx(this.isRegEx());
            newConstraint.setUnit(this.getUnit());
            newConstraint.setLowerBoundary(this.getLowerBoundary());
            newConstraint.setUpperBoundary(this.getUpperBoundary());
            newConstraint.setAttributes(this.getAttributes());
            newConstraint.children = new Vector();
            newConstraint.parent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newConstraint;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractConstraint)) {
            return false;
        }
        AbstractConstraint constraint = (AbstractConstraint)object;
        if (constraint.isCaseSensitive() != this.isCaseSensitive()) {
            return false;
        }
        if (constraint.isRegEx() != this.isRegEx()) {
            return false;
        }
        if (!constraint.getPattern().equals(this.getPattern())) {
            return false;
        }
        if (constraint.getLowerBoundary() != this.getLowerBoundary()) {
            return false;
        }
        if (constraint.getUpperBoundary() != this.getUpperBoundary()) {
            return false;
        }
        if (constraint.getUnit() == null && this.getUnit() != null || constraint.getUnit() != null && !constraint.getUnit().equals(this.getUnit())) {
            return false;
        }
        return (constraint.getAttributes() != null || constraint.getAttributes() == null) && (constraint.getAttributes() == null || constraint.getAttributes().equals(this.getAttributes()));
    }

    public void insert(MutableTreeNode child, int index) {
        this.children.insertElementAt(child, index);
        child.setParent(this);
    }

    public void remove(int index) {
        MutableTreeNode child = (MutableTreeNode)this.children.get(index);
        this.children.remove(index);
        child.setParent(null);
    }

    public void remove(MutableTreeNode node) {
        this.children.remove(node);
        node.setParent(null);
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Quantifier:\t" + this.quantifier + "\n");
        for (int i = 0; i < this.tierNames.length; ++i) {
            sb.append("Tier name:\t" + this.tierNames[i] + "\n");
        }
        sb.append("Pattern:\t" + this.patternString + "\n");
        sb.append("Unit:\t" + this.unit + "\n");
        sb.append("Lower boundary:\t" + this.lowerBoundary + "\n");
        sb.append("Upper boundary:\t" + this.upperBoundary + "\n");
        return sb.toString();
    }
}

