/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.tree.DefaultTreeModel;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.DependentConstraint;
import mpi.search.content.query.viewer.AbstractConstraintPanel;
import mpi.search.content.query.viewer.LocalizeListCellRenderer;

public class DependentConstraintPanel
extends AbstractConstraintPanel {
    protected final JComboBox modeComboBox = new JComboBox<String>(Constraint.MODES);

    public DependentConstraintPanel(DependentConstraint constraint, DefaultTreeModel treeModel, CorpusType type, Action startAction) {
        super(constraint, treeModel, type, startAction);
        this.titleComponent.add(new JLabel(SearchLocale.getString("Search.Query.With").toUpperCase()));
        if (type.allowsTemporalConstraints()) {
            this.titleComponent.add(this.modeComboBox);
        }
        this.titleComponent.add(new JLabel(SearchLocale.getString("Search.Query.Constraint")));
        this.modeComboBox.setRenderer(new LocalizeListCellRenderer());
        this.modeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DependentConstraintPanel.this.updateMode();
                }
            }
        });
        this.tierComboBox = new JComboBox(){

            public Dimension getPreferredSize() {
                return new Dimension(AbstractConstraintPanel.tierComboBoxWidth, super.getPreferredSize().height);
            }
        };
        this.makeLayout();
        this.setConstraint(constraint);
        this.updateMode();
    }

    public void setConstraint(DependentConstraint c) {
        try {
            this.setMode(c.getMode());
            this.patternPanel.setQuantifier(c.getQuantifier());
            this.setTierName(c.getTierName());
            super.setConstraint(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getSource() == this.tierComboBox) {
            this.updateUnitComboBox();
        }
        super.itemStateChanged(e);
    }

    protected void setMode(String mode) {
        this.modeComboBox.setSelectedItem(mode);
        this.updateMode();
    }

    protected String getMode() {
        return (String)this.modeComboBox.getSelectedItem();
    }

    protected void update() {
        if ("Search.Constraint.AllTiers".equals(this.getTierNamesOfParent()[0]) || this.getTierNamesOfParent().length > 1) {
            this.modeComboBox.setSelectedItem("Search.Constraint.Temporal");
            this.modeComboBox.setEnabled(false);
        } else {
            this.modeComboBox.setEnabled(true);
        }
        this.updateTierComboBox();
    }

    protected void updateMode() {
        this.update();
        this.relationPanel.setDistanceMode((String)this.modeComboBox.getSelectedItem());
    }

    protected void updateNode() {
        super.updateNode();
        ((DependentConstraint)this.constraint).setMode(this.getMode());
        ((DependentConstraint)this.constraint).setQuantifier(this.patternPanel.getQuantifier());
    }

    protected void updateTierComboBox() {
        if ("Search.Constraint.Temporal".equals(this.getMode())) {
            DependentConstraintPanel.updateComboBox(this.tierComboBox, this.type.getTierNames());
        } else {
            DependentConstraintPanel.updateComboBox(this.tierComboBox, this.type.getRelatedTiers(this.getTierNamesOfParent()[0]));
            this.updateUnitComboBox();
        }
    }

    protected void updateUnitComboBox() {
        if ("Search.Constraint.Structural".equals(this.getMode())) {
            String[] possibleUnits = this.type.getPossibleUnitsFor((String)this.tierComboBox.getSelectedItem(), this.getTierNamesOfParent()[0]);
            DependentConstraintPanel.updateComboBox(this.relationPanel.getUnitComboBox(), possibleUnits);
        }
    }

    private String[] getTierNamesOfParent() {
        return ((Constraint)this.constraint.getParent()).getTierNames();
    }
}

