/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.util.HashMap;
import mpi.search.SearchLocale;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.model.DependentConstraint;
import mpi.search.content.query.model.RestrictedAnchorConstraint;

public class Query2HTML {
    public static final String bodyStyle = "body { font-weight:normal; margin-top: 5px; }\n";
    public static final String constraintStyle = ".constraint { border-width:1px; border-style:solid; border-color:gray; padding:10px;font-size:medium;}\n";
    public static final String patternStyle = ".pattern { background:#FFFFFF; white-space:pre; font-weight:bold;}\n";
    static final String css = "<style type=\"text/css\">body { font-weight:normal; margin-top: 5px; }\n.constraint { border-width:1px; border-style:solid; border-color:gray; padding:10px;font-size:medium;}\n.pattern { background:#FFFFFF; white-space:pre; font-weight:bold;}\n<style>";

    public static void appendConstraint(StringBuffer sb, Constraint constraint) {
        if (constraint instanceof DependentConstraint) {
            sb.append(SearchLocale.getString("Search.Query.With").toUpperCase() + " " + SearchLocale.getString("Search.Query.Constraint"));
        } else {
            sb.append(SearchLocale.getString("Search.Query.Find").toUpperCase());
        }
        sb.append("<BR><div class=\"constraint\">");
        if (constraint instanceof RestrictedAnchorConstraint) {
            sb.append(((RestrictedAnchorConstraint)constraint).getComment());
        } else {
            sb.append(SearchLocale.getString(constraint.getQuantifier()));
            sb.append(" " + SearchLocale.getString("Search.Annotation_SG") + " ");
            String[] tierNames = constraint.getTierNames();
            if (tierNames.length > 0 && !tierNames[0].equals("Search.Constraint.AllTiers")) {
                sb.append(SearchLocale.getString("Search.Constraint.OnTier") + " ");
                for (int j = 0; j < tierNames.length; ++j) {
                    sb.append("<b>" + tierNames[j] + " </b>");
                }
            }
            if (!constraint.getPattern().equals("")) {
                if (constraint instanceof AnchorConstraint) {
                    sb.append(SearchLocale.getString("Search.Constraint.That") + " ");
                }
                sb.append(SearchLocale.getString("Search.Constraint.Matches") + " ");
                if (constraint.isCaseSensitive()) {
                    sb.append(SearchLocale.getString("Search.Constraint.CaseSensitive") + " ");
                }
                sb.append(constraint.isRegEx() ? SearchLocale.getString("Search.Constraint.RegularExpression") + " " : SearchLocale.getString("Search.Constraint.String") + " ");
                sb.append("<span class=\"pattern\" style=\"white-space:pre;\"><b> " + constraint.getPattern() + " </b></span>");
            }
            sb.append("<BR>");
            if (constraint instanceof AnchorConstraint) {
                if (constraint.getLowerBoundary() > Long.MIN_VALUE || constraint.getUpperBoundary() < Long.MAX_VALUE) {
                    if (constraint.getPattern().equals("")) {
                        sb.append(SearchLocale.getString("Search.Constraint.That"));
                    } else {
                        sb.append(SearchLocale.getString("Search.And"));
                    }
                    sb.append(" " + SearchLocale.getString(constraint.getUnit()) + " " + SearchLocale.getString("Search.Interval") + " [" + constraint.getLowerBoundary() + " ms ; " + constraint.getUpperBoundaryAsString() + " ms]\n");
                }
            } else {
                if (constraint.getMode().equals("Search.Constraint.Structural")) {
                    sb.append(SearchLocale.getString("Search.Constraint.Distance") + " " + constraint.getLowerBoundaryAsString() + " " + SearchLocale.getString("Search.To") + " " + constraint.getUpperBoundaryAsString() + " " + constraint.getUnit() + " ");
                } else {
                    boolean constraintWithDistance;
                    if (constraint.getPattern().equals("")) {
                        sb.append(SearchLocale.getString("Search.Constraint.That") + " ");
                    } else {
                        sb.append(SearchLocale.getString("Search.And") + " ");
                    }
                    String unit = SearchLocale.getString(constraint.getUnit());
                    boolean bl = constraintWithDistance = "Search.Constraint.WithinOverallDistance".equals(constraint.getUnit()) || "Search.Constraint.WithinLeftDistance".equals(constraint.getUnit()) || "Search.Constraint.WithinRightDistance".equals(constraint.getUnit()) || "Search.Constraint.BeforeLeftDistance".equals(constraint.getUnit()) || "Search.Constraint.AfterRightDistance".equals(constraint.getUnit());
                    if (constraintWithDistance) {
                        unit = unit.replaceFirst("\\.\\.\\.", constraint.getUpperBoundaryAsString() + " ms");
                    }
                    sb.append(unit);
                }
                sb.append("\n");
            }
            sb.append("\n");
            HashMap attributes = constraint.getAttributes();
            if (attributes != null) {
                for (String key : attributes.keySet()) {
                    String attributeValue = (String)attributes.get(key);
                    if (attributeValue.equals("*") || attributeValue.equals("") || attributeValue.equals("ANY")) continue;
                    sb.append(" " + key + "=");
                    if (attributeValue.equals(">0")) {
                        sb.append("[^0]");
                        continue;
                    }
                    if (attributeValue.equals(">1")) {
                        sb.append("[^01]");
                        continue;
                    }
                    sb.append(attributeValue);
                }
            }
        }
        sb.append("</div>\n");
    }

    public static void appendQuery(StringBuffer sb, ContentQuery query) {
        AnchorConstraint anchorConstraint = query.getAnchorConstraint();
        Query2HTML.appendConstraint(sb, anchorConstraint);
        Query2HTML.appendDescendantConstraints(sb, anchorConstraint);
    }

    public static String translate(ContentQuery query) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><style type=\"text/css\">body { font-weight:normal; margin-top: 5px; }\n.constraint { border-width:1px; border-style:solid; border-color:gray; padding:10px;font-size:medium;}\n.pattern { background:#FFFFFF; white-space:pre; font-weight:bold;}\n<style></head><body>");
        Query2HTML.appendQuery(sb, query);
        sb.append("</body></html>");
        return sb.toString();
    }

    public static String translate(Constraint constraint) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><style type=\"text/css\">body { font-weight:normal; margin-top: 5px; }\n.constraint { border-width:1px; border-style:solid; border-color:gray; padding:10px;font-size:medium;}\n.pattern { background:#FFFFFF; white-space:pre; font-weight:bold;}\n<style></head><body>");
        Query2HTML.appendConstraint(sb, constraint);
        sb.append("</body></html>");
        return sb.toString();
    }

    private static void appendDescendantConstraints(StringBuffer sb, Constraint parentConstraint) {
        if (parentConstraint.getChildCount() > 0) {
            sb.append("<ul>");
            for (int i = 0; i < parentConstraint.getChildCount(); ++i) {
                Constraint childConstraint = (Constraint)parentConstraint.getChildAt(i);
                sb.append("<li>");
                Query2HTML.appendConstraint(sb, childConstraint);
                Query2HTML.appendDescendantConstraints(sb, childConstraint);
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
    }
}

