/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.viewer;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;
import mpi.search.SearchLocale;
import mpi.search.model.ProgressListener;

public class ProgressViewer
extends JProgressBar
implements ProgressListener {
    private static final String INTERRUPTED = "Search.Interrupted";
    private static final String COMPLETE = "Search.Complete";
    private static final String MODIFIED = "Search.Modified";

    public ProgressViewer() {
        this.setBorder(new LineBorder(Color.lightGray));
        this.setStringPainted(true);
        this.setProgress(0);
        this.setVisible(false);
    }

    public void setProgress(int procent) {
        this.setVisible(true);
        this.setValue(procent);
        if (procent == 0) {
            this.setString(" ");
        } else {
            this.setString(procent < 100 ? procent + "%" : SearchLocale.getString(COMPLETE));
        }
    }

    public void setStatus(int status) {
        this.setVisible(true);
        switch (status) {
            case 1: {
                this.setValue(100);
                this.setString(SearchLocale.getString(COMPLETE));
                break;
            }
            case -1: {
                this.setValue(0);
                this.setString(SearchLocale.getString(INTERRUPTED));
                break;
            }
            case 2: {
                this.setValue(0);
                this.setString(SearchLocale.getString(MODIFIED));
            }
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

