/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.recognizer.remote.maus;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;

public class MausWsClient
implements Recognizer {
    protected RecognizerHost host;
    private String name = "MAUS web service client";
    private String baseUrl = "http://webapp.phonetik.uni-muenchen.de/BASWebServices/services/";
    private String baseServiceId = "runMAUSBasicGerman";
    private String signalParamValue = "";
    private String textParamName = "TEXT";
    private String signalParamName = "SIGNAL";
    private String currentMediaFile = null;
    private String currentMediaName = null;
    private String currentTextFile = null;
    private String currentTextName = null;
    private String outputFile = null;
    private Map<String, String> parameters;
    private float progress = 0.0f;
    private boolean isRunning = false;
    private boolean interrupted = false;
    private StringBuilder reportBuilder = null;
    private long startTime;
    private List<Segmentation> segmentations;
    private ArrayList<RSelection> tierSelectionObjects;
    private final String eq = "=";
    private final String tierSpec = "IntervalTier";
    private final String nm = "name";
    private final String min = "xmin";
    private final String max = "xmax";
    private final String tx = "text";

    public boolean canCombineMultipleFiles() {
        return false;
    }

    public boolean canHandleMedia(String mediaFilePath) {
        if (mediaFilePath == null) {
            return false;
        }
        String lower = mediaFilePath.toLowerCase();
        return lower.endsWith(".wav") || lower.endsWith(".wave");
    }

    public void dispose() {
    }

    public JPanel getControlPanel() {
        return null;
    }

    public int getExamplesSupport() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public Object getParameterValue(String param) {
        return null;
    }

    public int getRecognizerType() {
        return 0;
    }

    public String getReport() {
        if (this.reportBuilder != null) {
            return this.reportBuilder.toString();
        }
        return null;
    }

    private void setMedia(String mediaFilePath) {
        if (mediaFilePath != null) {
            int slashIndex;
            this.currentMediaFile = mediaFilePath;
            if (this.currentMediaFile.startsWith("file:")) {
                this.currentMediaFile = this.currentMediaFile.substring(5);
            }
            if (this.currentMediaFile.startsWith("///")) {
                this.currentMediaFile = this.currentMediaFile.substring(2);
            }
            if ((slashIndex = this.currentMediaFile.lastIndexOf("/") + 1) > 0) {
                this.currentMediaName = this.currentMediaFile.substring(slashIndex);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void validateParameters() throws RecognizerConfigurationException {
        if ((this.tierSelectionObjects == null || this.tierSelectionObjects.size() == 0) && this.currentTextFile == null) {
            throw new RecognizerConfigurationException("Selections are required: either select an input file or tier or add selections to the list.");
        }
    }

    public void setParameterValue(String param, String value) {
        if (param == null || param.length() == 0 || value == null || value.length() == 0) {
            return;
        }
        if (param.equals("SignalUrl")) {
            this.setMedia(value);
        } else if (param.equals("base_url")) {
            this.baseUrl = value;
        } else if (param.equals("TextUrl")) {
            this.currentTextFile = value;
            int slashIndex = this.currentTextFile.lastIndexOf("/") + 1;
            if (slashIndex > 0) {
                this.currentTextName = this.currentTextFile.substring(slashIndex);
            }
        } else if (param.equals("TierUrl")) {
            File file = new File(value);
            if (file.exists() && file.canRead()) {
                List segm = null;
                XmlTierIO xio = new XmlTierIO(file);
                try {
                    segm = xio.parse();
                }
                catch (Exception exe) {
                    JOptionPane.showMessageDialog(null, exe.getMessage(), "Error", 0);
                }
                if (this.tierSelectionObjects == null) {
                    this.tierSelectionObjects = new ArrayList();
                } else {
                    this.tierSelectionObjects.clear();
                }
                for (Segmentation seg : segm) {
                    if (seg.getSegments() == null) continue;
                    this.tierSelectionObjects.addAll(seg.getSegments());
                }
            }
        } else if (param.equals("TextParamName")) {
            this.textParamName = value;
        } else if (param.equals("SignalParamName")) {
            this.signalParamName = value;
        } else if (param.equals("ServiceName")) {
            this.baseServiceId = value;
        } else {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>(2);
            }
            this.parameters.put(param, value);
        }
    }

    public void setParameterValue(String param, float value) {
    }

    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        if (this.currentMediaFile == null) {
            this.host.errorOccurred("There is no audio file.");
            return;
        }
        this.interrupted = false;
        this.progress = 0.0f;
        if (this.reportBuilder != null) {
            this.reportBuilder.delete(0, this.reportBuilder.length());
        }
        this.reportBuilder = new StringBuilder();
        this.startTime = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
        this.reportBuilder.append("Starting process at " + df.format(new Date(this.startTime)) + "\n");
        this.reportBuilder.append("Server url:\t" + this.baseUrl + this.baseServiceId + "\n");
        this.reportBuilder.append("Media file:\t" + this.currentMediaFile + "\n");
        this.reportBuilder.append("Text file:\t" + this.currentTextFile + "\n");
        this.host.setProgress(this.progress, "Retrieving project ID");
        this.progress = 0.05f;
        this.host.setProgress(this.progress, "Project exists or is created");
        if (this.interrupted) {
            this.host.setProgress(this.progress, "Process canceled.");
            this.reportBuilder.append("The process has been canceled after: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
            return;
        }
        int uploadStatus = this.uploadAllFiles();
        if (uploadStatus != 200) {
            this.host.errorOccurred("Processing files failed.");
            this.reportBuilder.append("Unable to process the files: " + uploadStatus + "\n");
            return;
        }
        this.host.setProgress(this.progress, "Files processed");
        if (this.segmentations != null) {
            this.reportBuilder.append("Number of tiers created: " + this.segmentations.size() + "\n");
            for (Segmentation s : this.segmentations) {
                this.host.addSegmentation(s);
            }
        } else {
            this.reportBuilder.append("Number of tiers created: 0\n");
        }
        this.reportBuilder.append("Process finished after: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
        this.host.setProgress(1.0f, "Process finished.");
    }

    public void stop() {
        this.interrupted = true;
    }

    public void updateLocale(Locale locale) {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int uploadAllFiles() {
        if (this.currentMediaFile == null) {
            this.reportBuilder.append("There is no audio file url.\n");
            return 400;
        }
        if ((this.tierSelectionObjects == null || this.tierSelectionObjects.size() == 0) && this.currentTextFile == null) {
            this.reportBuilder.append("There is no text input, neither from a selected tier nor from file url.\n");
            return 400;
        }
        this.host.setProgress(this.progress, "Uploading wav and text file");
        URL url = null;
        if (this.parameters == null || this.parameters.size() == 0) {
            try {
                url = new URL(String.valueOf(this.baseUrl) + this.baseServiceId);
            }
            catch (MalformedURLException mue) {
                this.reportBuilder.append("Could not create the input service url: " + mue.getMessage() + "\n");
                return 400;
            }
        }
        StringBuilder builder = new StringBuilder(this.baseUrl);
        builder.append(this.baseServiceId);
        builder.append('?');
        Iterator<String> paramIter = this.parameters.keySet().iterator();
        String key = null;
        String val = null;
        int i = 0;
        while (paramIter.hasNext()) {
            key = paramIter.next();
            val = this.parameters.get(key);
            if (key != null && val != null) {
                if (i > 0) {
                    builder.append('&');
                }
                builder.append(key);
                builder.append('=');
                builder.append(val);
            }
            ++i;
        }
        try {
            url = new URL(builder.toString());
        }
        catch (MalformedURLException mue) {
            this.reportBuilder.append("Could not create the input service url: " + mue.getMessage() + "\n");
            return 400;
        }
        if (url == null) {
            this.reportBuilder.append("Could not create the input service url.\n");
            return 400;
        }
        String boundary = "DaDa0x";
        String nl = "\r\n";
        long totalLength = 0L;
        StringBuilder preFileString = new StringBuilder("--DaDa0x\r\n");
        preFileString.append("content-disposition: form-data; name=\"" + this.signalParamName + "\";" + " filename=\"" + this.currentMediaName + "\"" + "\r\n");
        preFileString.append("\r\n");
        byte[] preBytes = preFileString.toString().getBytes();
        totalLength += (long)preBytes.length;
        File f = new File(this.currentMediaFile);
        long fileLength = 0L;
        if (f.exists() && !f.isDirectory()) {
            fileLength = f.length();
            totalLength += f.length();
        } else {
            this.reportBuilder.append("Error: the wav file does not exist\n");
            return 400;
        }
        byte[] inputText = null;
        File tf = null;
        StringBuilder subFileString = null;
        if (this.tierSelectionObjects != null && this.tierSelectionObjects.size() > 0 && (inputText = this.convertToString(this.tierSelectionObjects)) != null) {
            totalLength += (long)inputText.length;
            fileLength += (long)inputText.length;
            subFileString = new StringBuilder("\r\n--DaDa0x\r\n");
            subFileString.append("content-disposition: form-data; name=\"" + this.textParamName + "\";" + " filename=\"" + "tierText.txt" + "\"" + "\r\n");
            subFileString.append("\r\n");
        }
        if (inputText == null) {
            tf = new File(this.currentTextFile);
            if (tf.exists() && !tf.isDirectory()) {
                totalLength += tf.length();
                fileLength += tf.length();
                subFileString = new StringBuilder("\r\n--DaDa0x\r\n");
                subFileString.append("content-disposition: form-data; name=\"" + this.textParamName + "\";" + " filename=\"" + this.currentTextName + "\"" + "\r\n");
                subFileString.append("\r\n");
            } else {
                this.reportBuilder.append("Error: the text file does not exist\n");
                return 400;
            }
        }
        byte[] subBytes = subFileString.toString().getBytes();
        totalLength += (long)subBytes.length;
        byte[] postBytes = "\r\n--DaDa0x--\r\n".getBytes();
        totalLength += (long)postBytes.length;
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setInstanceFollowRedirects(false);
            httpConn.setFixedLengthStreamingMode((int)totalLength);
            httpConn.setRequestProperty("User-Agent", "ELAN");
            httpConn.setRequestProperty("Connection", "Keep-Alive");
            httpConn.setRequestProperty("Content-Type", "multipart/form-data;boundary=DaDa0x");
            FileInputStream fis = null;
            FileInputStream fis2 = null;
            DataOutputStream dos = null;
            float startProg = this.progress;
            float progPart = 0.5f;
            try {
                int numBytesRead;
                fis = new FileInputStream(f);
                dos = new DataOutputStream(httpConn.getOutputStream());
                dos.write(preBytes);
                int totalBytesRead = 0;
                byte[] chunk = new byte[0x100000];
                while ((numBytesRead = fis.read(chunk, 0, chunk.length)) != -1 && !this.interrupted) {
                    dos.write(chunk, 0, numBytesRead);
                    dos.flush();
                    totalBytesRead += numBytesRead;
                    if (fileLength <= 0L) continue;
                    this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                    this.host.setProgress(this.progress);
                }
                if (this.interrupted) {
                    this.reportBuilder.append("The process has been canceled, uploading has been stopped...\n");
                    return 400;
                }
                try {
                    block41: {
                        block39: {
                            block40: {
                                dos.write(subBytes);
                                if (inputText == null) break block39;
                                numBytesRead = 0;
                                if (inputText.length > chunk.length) break block40;
                                dos.write(inputText);
                                dos.flush();
                                totalBytesRead += inputText.length;
                                if (fileLength > 0L) {
                                    this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                                    this.host.setProgress(this.progress);
                                }
                                break block41;
                            }
                            int count = inputText.length / chunk.length;
                            int i2 = 0;
                            while (i2 < count) {
                                dos.write(inputText, i2 * chunk.length, chunk.length);
                                dos.flush();
                                totalBytesRead += chunk.length;
                                numBytesRead += chunk.length;
                                if (fileLength > 0L) {
                                    this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                                    this.host.setProgress(this.progress);
                                }
                                ++i2;
                            }
                            if (numBytesRead >= inputText.length) break block41;
                            dos.write(inputText, numBytesRead, inputText.length - numBytesRead);
                            dos.flush();
                            break block41;
                        }
                        fis2 = new FileInputStream(tf);
                        numBytesRead = 0;
                        while ((numBytesRead = fis2.read(chunk, 0, chunk.length)) != -1 && !this.interrupted) {
                            dos.write(chunk, 0, numBytesRead);
                            dos.flush();
                            totalBytesRead += numBytesRead;
                            if (fileLength <= 0L) continue;
                            this.progress = startProg + progPart * ((float)totalBytesRead / (float)fileLength);
                            this.host.setProgress(this.progress);
                        }
                    }
                    this.progress = startProg + progPart;
                    this.host.setProgress(this.progress);
                    dos.write(postBytes);
                    dos.flush();
                    this.host.setProgress(this.progress, "Files uploaded, waiting for server response.");
                    this.reportBuilder.append("Uploading of files took: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
                }
                catch (IOException ioe) {
                    this.reportBuilder.append("An error occurred while uploading the audio file or text file: " + ioe.getMessage() + "\n");
                    return 400;
                }
            }
            finally {
                if (dos != null) {
                    dos.flush();
                    dos.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            if (this.interrupted) {
                return 400;
            }
            this.host.setProgress(-1.0f, "Waiting for results...");
            int responseCode = httpConn.getResponseCode();
            if (responseCode != 200) {
                this.reportBuilder.append("An error occurred while uploading the audio file or text file: " + responseCode + "\n");
            } else {
                BufferedReader procReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), "UTF-8"));
                int parseCode = this.parseResults(procReader);
                if (parseCode != 200) {
                    responseCode = parseCode;
                }
            }
            return responseCode;
        }
        catch (ProtocolException pe) {
            this.reportBuilder.append("Could not contact the server: " + pe.getMessage() + "\n");
        }
        catch (IOException ioe) {
            this.reportBuilder.append("Could not contact the server: " + ioe.getMessage() + "\n");
        }
        return 400;
    }

    private byte[] convertToString(ArrayList<RSelection> tierSelectionObjects) {
        StringBuilder sb = new StringBuilder();
        String label = null;
        for (RSelection rsel : tierSelectionObjects) {
            if (!(rsel instanceof Segment) || (label = ((Segment)rsel).label) == null) continue;
            sb.append(label);
            sb.append(" ");
        }
        return sb.toString().getBytes();
    }

    private int parseResults(BufferedReader reader) throws IOException {
        if (reader == null) {
            return 204;
        }
        this.reportBuilder.append("Parsing results started after: " + (float)(System.currentTimeMillis() - this.startTime) / 1000.0f + " sec\n");
        this.host.setProgress(0.9f, "Parsing results");
        this.segmentations = new ArrayList<Segmentation>(6);
        String line = null;
        boolean startNewTier = false;
        boolean inTier = false;
        long begin = -1L;
        long end = -1L;
        ArrayList<Segment> segments = null;
        Segmentation curSegmentation = null;
        while ((line = reader.readLine()) != null) {
            int eqIndex;
            int index = -1;
            if (line.indexOf("IntervalTier") > -1) {
                startNewTier = true;
                inTier = false;
                continue;
            }
            index = line.indexOf("name");
            if (startNewTier && index > -1) {
                eqIndex = line.indexOf("=");
                if (eqIndex > index && eqIndex + 1 < line.length()) {
                    String tier = this.removeQuotes(line.substring(eqIndex + 1).trim());
                    segments = new ArrayList<Segment>();
                    curSegmentation = new Segmentation(tier, segments, this.currentMediaFile);
                    this.segmentations.add(curSegmentation);
                    inTier = true;
                }
                startNewTier = false;
                continue;
            }
            if (!inTier) continue;
            index = line.indexOf("xmin");
            if (index > -1) {
                eqIndex = line.indexOf("=");
                if (eqIndex <= index || eqIndex + 1 >= line.length()) continue;
                begin = this.extractLong(line, eqIndex);
                continue;
            }
            index = line.indexOf("xmax");
            if (index > -1) {
                eqIndex = line.indexOf("=");
                if (eqIndex <= index || eqIndex + 1 >= line.length()) continue;
                end = this.extractLong(line, eqIndex);
                continue;
            }
            index = line.indexOf("text");
            if (index <= -1 || (eqIndex = line.indexOf("=")) <= index || eqIndex + 1 >= line.length()) continue;
            String label = this.removeQuotes(line.substring(eqIndex + 1).trim());
            if (begin <= -1L || end <= begin) continue;
            Segment seg = new Segment(begin, end, label);
            if (segments == null) continue;
            segments.add(seg);
        }
        return 200;
    }

    private long extractLong(String value, int eqPos) {
        if (value.length() > eqPos + 1) {
            String v = value.substring(eqPos + 1).trim();
            long l = -1L;
            try {
                Double d = new Double(v);
                l = Math.round(d * 1000.0);
            }
            catch (NumberFormatException nfe) {
                this.reportBuilder.append("Not a valid numeric value: " + value + "\n");
            }
            return l;
        }
        return -1L;
    }

    private String removeQuotes(String value) {
        if (value.charAt(0) == '\"') {
            if (value.charAt(value.length() - 1) == '\"' && value.length() > 1) {
                return value.substring(1, value.length() - 1);
            }
            return value.substring(1);
        }
        if (value.charAt(value.length() - 1) == '\"') {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    public boolean setMedia(List<String> mediaFiles) {
        return false;
    }
}

